package neutrino.options;

import neutrino.TextEditorWindow;
import javax.swing.*;
import java.awt.*;
import java.io.Serializable;

/**
 * Contains window options for persisting using object stream
 * Date: 9/11/15
 * Time: 4:12 PM
 * @author Oleh Radvanskyj
 * @version 3.0.1
 */
public class WindowOptions implements Serializable {

    private boolean isConfirmExit;
    private boolean isSaveWindowSize;
    private int typeOfWindowLocation;
    private Rectangle m_bounds;
    private boolean m_isToolBarVisible;
    private String m_lookAndFeelClassName;

    public WindowOptions() {
        isConfirmExit = true;
        isSaveWindowSize = true;
        typeOfWindowLocation = TextEditorWindow.CENTER_WINDOW_ON_SCREEN;
        m_bounds = new Rectangle(0, 0, TextEditorWindow.DEFAULT_WINDOW_WIDTH, TextEditorWindow.DEFAULT_WINDOW_HEIGHT);
        m_isToolBarVisible = true;
        m_lookAndFeelClassName = UIManager.getCrossPlatformLookAndFeelClassName();
    }

    /**
     * Build properties from program values.
     * @param window
     */
    public void buildProperties(TextEditorWindow window) {
        m_lookAndFeelClassName = window.getLookAndFeel();
        m_bounds = window.getBounds();
        isConfirmExit = window.isConfirmExit();
        isSaveWindowSize = window.isSaveWindowSize();
        typeOfWindowLocation = window.getTypeOfWindowLocation();
        m_isToolBarVisible = window.isToolBarVisible();
    }

    /**
     * Establish properties for application.
     * @param window
     */
    public void establishProperties(TextEditorWindow window) {
        window.setConfirmingExit(isConfirmExit);
        window.setSavingWindowSize(isSaveWindowSize);
        window.setTypeOfWindowLocation(typeOfWindowLocation);
        if (window.isSaveWindowSize()) {
            window.setSize(m_bounds.width, m_bounds.height);
        } else {
            window.setSize(window.getDefaultSize());
        }
        if (window.getTypeOfWindowLocation() == TextEditorWindow.SAVE_WINDOW_LOCATION) {
            window.setLocation(m_bounds.x, m_bounds.y);
        } else if (window.getTypeOfWindowLocation() == TextEditorWindow.CENTER_WINDOW_ON_SCREEN) {
            window.centerWindowOnScreen();
        } else if (window.getTypeOfWindowLocation() == TextEditorWindow.RANDOMIZE_WINDOW_LOCATION) {
            window.randomizeWindowLocation();
        }
        window.setToolBarVisible(m_isToolBarVisible);
        window.setLookAndFeel(m_lookAndFeelClassName);
    }

}
