package neutrino.text;

/**
 * Encapsulates the operations with plain text
 * @author Oleh Radvanskyj
 * @version 1.0
 */
public interface IPlainTextComponent {

    /**
     * Set type of line start. If true then line start as previous.
     * If false then line start from beginning.
     * @param flag - boolean value
     */
    public void setAutoIndentMode(boolean flag);

    /**
     * Return true if line starts as previous line.
     * @return boolean value
     */
    public boolean isAutoIndentMode();

    /**
     * Returns true when the current character or selection can be made to upper case
     * @return boolean
     */
    public boolean canMakeUpperCase();

    /**
     * Make selection uppercase
     */
    public void makeUpperCase();

    /**
     * Returns true when the current character or selection can be made to lower case
     * @return boolean
     */
    public boolean canMakeLowerCase();

    /**
     * Make selection lowercase
     */
    public void makeLowerCase();

    /**
     * Returns true when the current character or selection can be made to title case
     * @return boolean
     */
    public boolean canMakeTitleCase();

    /**
     * Make selection or current character title case
     */
    public void makeTitleCase();

    /**
     * Returns true when the selected text or current word can be capitalized
     * @return boolean
     */
    public boolean canCapitalize();

    /**
     * Capitalizes the selected text or current word
     */
    public void capitalize();

    /**
     * Returns whether the capitalization of current word or selection can be inverted
     * @return boolean
     */
    public boolean canInvertCapitalization();

    /**
     * Inverts the capitalization of current word or selected text
     */
    public void invertCapitalization();

    /**
     * Returns true when operation of inverting the case of current character or selection can be done
     * @return boolean
     */
    public boolean canInvertCase();

    /**
     * Invert the case of current letter or selected text
     */
    public void invertCase();

    /**
     * Returns true when the selection or current line can be shifted in left
     * @return - boolean
     */
    public boolean canShiftInLeft();

    /**
     * Shift selected text in left on one character.
     * If text is not selected shift current line in left.
     */
    public void shiftInLeft();

    /**
     * Returns true when the selection or current line can be shifted in right
     * @return - boolean
     */
    public boolean canShiftInRight();

    /**
     * Shift selected text in right on one character.
     * If text is not selected shift current line in right.
     */
    public void shiftInRight();

    /**
     * Returns true when the selected text can be tabified
     * @return - boolean
     */
    public boolean canTabifySelectedLines();

    /*
    * Replaces groups of spaces with tabs in selection.
    * If text is not selected do nothing.
    */
    public void tabifySelectedLines();

    /**
     * Returns true when the selected text can be untabified
     * @return - boolean
     */
    public boolean canUntabifySelectedLines();

    /**
     * Replaces tabs with groups of spaces in selection.
     * If text is not selected do nothing
     */
    public void untabifySelectedLines();

    /**
     * Returns true when the horizontal white space can be deleted from the selection or current line
     * @return - boolean
     */
    public boolean canDeleteHorizontalWhiteSpace();

    /**
     * Removes start spaces from current line or from selection.
     */
    public void deleteHorizontalWhiteSpace();

    /**
     * Returns true when the trailing white space can be deleted from the selection or current line
     * @return - boolean
     */
    public boolean canRemoveTrailingWhitespaces();

    /**
     * Removes trailing whitespaces from current line or selected text
     */
    public void removeTrailingWhitespaces();

    /**
     * Returns true when the selection or current line can be trimmed
     * @return - boolean
     */
    public boolean canTrimSelectedLines();

    /**
     * Trims the selected lines
     */
    public void trimSelectedLines();

    /**
     * Returns true when the lines can be joined
     * @return - boolean
     */
    public boolean canJoinSelectedLines();

    /**
     * Joins selected lines
     */
    public void joinSelectedLines();

    /**
     * Returns true when the current line is empty or the selected text contains empty lines
     * @return boolean
     */
    public boolean canRemoveEmptyLines();

    /**
     * Removes the empty lines in selection or current line when is empty
     */
    public void removeEmptyLines();

    /**
     * Returns true when can duplicate the current line or selection
     * @return - boolean
     */
    public boolean canDuplicateSelectedLines();

    /**
     * Duplicates the current line or selection
     */
    public void duplicateSelectedLines();

    /**
     * Returns true when the current line or selected text can be splitted into lines by words
     * @return boolean
     */
    public boolean canSplitIntoLines();

    /**
     * Spits each word in the current or selected lines into a separate lines
     */
    public void splitIntoLines();

    /**
     * Returns true when can sort lines ascendant
     * @return - boolean
     */
    public boolean canSortLinesAscendant();

    /**
     * Sorts the selected lines ascendant
     */
    public void sortLinesAscendant();

    /**
     * Returns true when can sort lines descendant
     * @return - boolean
     */
    public boolean canSortLinesDescendant();

    /**
     * Sorts the selected lines descendant
     */
    public void sortLinesDescendant();

    /**
     * Returns true when can move the selected or current line up
     * @return - boolean
     */
    public boolean canMoveLinesUp();

    /**
     * Moves the selected or current line up
     */
    public void moveLinesUp();

    /**
     * Returns true when the lines can be moved down
     * @return - boolean
     */
    public boolean canMoveLinesDown();

    /**
     * Moves the selected text or current line down
     */
    public void moveLinesDown();

    /**
     * Returns true when the text can be aligned to left
     * @return - boolean
     */
    public boolean canAlignTextLeft();

    /**
     * Aligns the text to left
     */
    public void alignTextLeft();

    /**
     * Returns true when the text can be aligned to right
     * @return - boolean
     */
    public boolean canAlignTextRight();

    /**
     * Aligns the text to right
     */
    public void alignTextRight();

    /**
     * Returns true when the text can be centered in editor
     * @return - boolean
     */
    public boolean canCenterText();

    /**
     * Centers the text in editor
     */
    public void centerText();

    /**
     * Returns true when the text can be justified in editor
     * @return - boolean
     */
    public boolean canJustifyText();

    /**
     * Centers the text in editor
     */
    public void justifyText();

    /**
     * Returns true when the latin paragraph can be made
     * @return -- boolean
     */
    public boolean canMakeLatinParagraph();

    /**
     * Makes the latin paragraph
     */
    public void makeLatinParagraph();

    /**
     * Returns true when the cyrillic paragraph can be made
     * @return -- boolean
     */
    public boolean canMakeCyrillicParagraph();

    /**
     * Makes the cyrillic paragraph
     */
    public void makeCyrillicParagraph();

    public int getNumberOfCurrentLine();

    public int getNumberOfCurrentColumn();

}
