/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.lang.reflect.Method;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.batik.bridge.SVGFontFamily;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.renderer.StrokingTextPainter;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.TextPaintInfo;
import org.apache.batik.gvt.text.TextSpanLayout;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.svg.PDFGraphics2D;
import org.apache.fop.svg.PDFTextUtil;
import org.apache.fop.util.CharUtilities;

public class PDFTextPainter
extends StrokingTextPainter {
    private static final boolean DEBUG = false;
    private boolean strokeText = false;
    private FontInfo fontInfo;

    public PDFTextPainter(FontInfo fi) {
        this.fontInfo = fi;
    }

    protected void paintTextRuns(List textRuns, Graphics2D g2d) {
        if (!(g2d instanceof PDFGraphics2D) || this.strokeText) {
            super.paintTextRuns(textRuns, g2d);
            return;
        }
        PDFGraphics2D pdf = (PDFGraphics2D)((Object)g2d);
        PDFTextUtil textUtil = new PDFTextUtil(pdf);
        for (int i = 0; i < textRuns.size(); ++i) {
            StrokingTextPainter.TextRun textRun = (StrokingTextPainter.TextRun)textRuns.get(i);
            AttributedCharacterIterator runaci = textRun.getACI();
            runaci.first();
            TextPaintInfo tpi = (TextPaintInfo)runaci.getAttribute(PAINT_INFO);
            if (tpi == null || !tpi.visible) continue;
            if (tpi != null && tpi.composite != null) {
                g2d.setComposite(tpi.composite);
            }
            TextSpanLayout layout = textRun.getLayout();
            StringBuffer chars = new StringBuffer();
            runaci.first();
            while (runaci.getIndex() < runaci.getEndIndex()) {
                chars.append(runaci.current());
                runaci.next();
            }
            runaci.first();
            Object debugShapes = null;
            Font[] fonts = this.findFonts(runaci);
            if (fonts == null || fonts.length == 0) {
                textRun.getLayout().draw(g2d);
                continue;
            }
            textUtil.saveGraphicsState();
            textUtil.concatMatrixCurrentTransform();
            Shape imclip = g2d.getClip();
            pdf.writeClip(imclip);
            this.applyColorAndPaint(tpi, pdf);
            textUtil.beginTextObject();
            textUtil.setFonts(fonts);
            textUtil.setTextRenderingMode(tpi.fillPaint != null, tpi.strokePaint != null, false);
            AffineTransform localTransform = new AffineTransform();
            Point2D prevPos = null;
            double prevVisibleCharWidth = 0.0;
            GVTGlyphVector gv = layout.getGlyphVector();
            int c = gv.getNumGlyphs();
            for (int index = 0; index < c; ++index) {
                Font f;
                boolean yPosChanged;
                boolean visibleChar;
                char ch = chars.charAt(index);
                boolean bl = visibleChar = gv.isGlyphVisible(index) || CharUtilities.isAnySpace(ch) && !CharUtilities.isZeroWidthSpace(ch);
                if (!visibleChar) continue;
                Point2D p = gv.getGlyphPosition(index);
                AffineTransform glyphTransform = gv.getGlyphTransform(index);
                localTransform.setToIdentity();
                localTransform.translate(p.getX(), p.getY());
                if (glyphTransform != null) {
                    localTransform.concatenate(glyphTransform);
                }
                localTransform.scale(1.0, -1.0);
                boolean bl2 = yPosChanged = prevPos == null || prevPos.getY() != p.getY() || glyphTransform != null;
                if (yPosChanged) {
                    if (index > 0) {
                        textUtil.writeTJ();
                        textUtil.writeTextMatrix(localTransform);
                    }
                } else {
                    double xdiff = p.getX() - prevPos.getX();
                    Font font = textUtil.getCurrentFont();
                    double cw = prevVisibleCharWidth;
                    double effxdiff = 1000.0 * xdiff - cw;
                    if (effxdiff != 0.0) {
                        double adjust = -effxdiff / (double)font.getFontSize();
                        textUtil.adjustGlyphTJ(adjust * 1000.0);
                    }
                }
                if ((f = textUtil.selectFontForChar(ch)) != textUtil.getCurrentFont()) {
                    textUtil.writeTJ();
                    textUtil.setCurrentFont(f);
                    textUtil.writeTf(f);
                    textUtil.writeTextMatrix(localTransform);
                }
                char paintChar = CharUtilities.isAnySpace(ch) ? (char)' ' : (char)ch;
                textUtil.writeTJChar(paintChar);
                prevPos = p;
                prevVisibleCharWidth = textUtil.getCurrentFont().getCharWidth(chars.charAt(index));
            }
            textUtil.writeTJ();
            textUtil.endTextObject();
            textUtil.restoreGraphicsState();
        }
    }

    private void applyColorAndPaint(TextPaintInfo tpi, PDFGraphics2D pdf) {
        Color col;
        Paint fillPaint = tpi.fillPaint;
        Paint strokePaint = tpi.strokePaint;
        Stroke stroke = tpi.strokeStroke;
        int fillAlpha = 255;
        if (fillPaint instanceof Color) {
            col = (Color)fillPaint;
            pdf.applyColor(col, true);
            fillAlpha = col.getAlpha();
        }
        if (strokePaint instanceof Color) {
            col = (Color)strokePaint;
            pdf.applyColor(col, false);
        }
        pdf.applyPaint(fillPaint, true);
        pdf.applyStroke(stroke);
        if (strokePaint != null) {
            pdf.applyPaint(strokePaint, false);
        }
        pdf.applyAlpha(fillAlpha, 255);
    }

    private Font[] findFonts(AttributedCharacterIterator aci) {
        int fsize;
        FontTriplet triplet;
        ArrayList<Font> fonts = new ArrayList<Font>();
        List gvtFonts = (List)aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.GVT_FONT_FAMILIES);
        Float posture = (Float)aci.getAttribute(TextAttribute.POSTURE);
        Float taWeight = (Float)aci.getAttribute(TextAttribute.WEIGHT);
        Float fontSize = (Float)aci.getAttribute(TextAttribute.SIZE);
        String style = posture != null && (double)posture.floatValue() > 0.0 ? "italic" : "normal";
        int weight = taWeight != null && (double)taWeight.floatValue() > 1.0 ? 700 : 400;
        String fontFamily = null;
        GVTFont gvtFont = (GVTFont)aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.GVT_FONT);
        if (gvtFont != null) {
            try {
                Method method = gvtFont.getClass().getMethod("getFamilyName", null);
                String gvtFontFamily = (String)method.invoke((Object)gvtFont, null);
                if (this.fontInfo.hasFont(gvtFontFamily, style, weight)) {
                    triplet = this.fontInfo.fontLookup(gvtFontFamily, style, weight);
                    fsize = (int)(fontSize.floatValue() * 1000.0f);
                    fonts.add(this.fontInfo.getFontInstance(triplet, fsize));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (gvtFonts != null) {
            Iterator i = gvtFonts.iterator();
            while (i.hasNext()) {
                GVTFontFamily fam = (GVTFontFamily)i.next();
                if (fam instanceof SVGFontFamily) {
                    return null;
                }
                fontFamily = fam.getFamilyName();
                if (!this.fontInfo.hasFont(fontFamily, style, weight)) continue;
                triplet = this.fontInfo.fontLookup(fontFamily, style, weight);
                fsize = (int)(fontSize.floatValue() * 1000.0f);
                fonts.add(this.fontInfo.getFontInstance(triplet, fsize));
            }
        }
        if (fonts.size() == 0) {
            FontTriplet triplet2 = this.fontInfo.fontLookup("any", style, 400);
            int fsize2 = (int)(fontSize.floatValue() * 1000.0f);
            fonts.add(this.fontInfo.getFontInstance(triplet2, fsize2));
        }
        return fonts.toArray(new Font[fonts.size()]);
    }
}

