/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.index;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.index.IndexTerm;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.module.ContentImpl;
import org.dita.dost.writer.AbstractWriter;
import org.dita.dost.writer.CHMIndexWriter;
import org.dita.dost.writer.EclipseIndexWriter;
import org.dita.dost.writer.IDitaTranstypeIndexWriter;
import org.dita.dost.writer.JavaHelpIndexWriter;

public class IndexTermCollection {
    private static IndexTermCollection collection = null;
    private List termList = new ArrayList(16);
    private String indexType = null;
    private String indexClass = null;
    private String outputFileRoot = null;
    private DITAOTJavaLogger javaLogger = new DITAOTJavaLogger();

    private IndexTermCollection() {
    }

    public static IndexTermCollection getInstantce() {
        if (collection == null) {
            collection = new IndexTermCollection();
        }
        return collection;
    }

    public void clear() {
        this.termList.clear();
    }

    public String getIndexType() {
        return this.indexType;
    }

    public void setIndexType(String type) {
        this.indexType = type;
    }

    public String getIndexClass() {
        return this.indexClass;
    }

    public void setIndexClass(String indexClass) {
        this.indexClass = indexClass;
    }

    public void addTerm(IndexTerm term) {
        int i;
        int termNum = this.termList.size();
        for (i = 0; i < termNum; ++i) {
            IndexTerm indexTerm = (IndexTerm)this.termList.get(i);
            if (indexTerm.equals(term)) {
                return;
            }
            if (!indexTerm.getTermFullName().equals(term.getTermFullName()) || !indexTerm.getTermKey().equals(term.getTermKey())) continue;
            indexTerm.addTargets(term.getTargetList());
            indexTerm.addSubTerms(term.getSubTerms());
            break;
        }
        if (i == termNum) {
            this.termList.add(term);
        }
    }

    public List getTermList() {
        return this.termList;
    }

    public void sort() {
        int termListSize = this.termList.size();
        if (IndexTerm.getTermLocale() == null || IndexTerm.getTermLocale().getLanguage().trim().length() == 0) {
            IndexTerm.setTermLocale(new Locale("en", "us"));
        }
        for (int i = 0; i < termListSize; ++i) {
            IndexTerm term = (IndexTerm)this.termList.get(i);
            term.sortSubTerms();
        }
        Collections.sort(this.termList);
    }

    public void outputTerms() throws DITAOTException {
        StringBuffer buff = new StringBuffer(this.outputFileRoot);
        AbstractWriter abstractWriter = null;
        IDitaTranstypeIndexWriter indexWriter = null;
        ContentImpl content = new ContentImpl();
        if (this.indexClass != null && this.indexClass.length() > 0) {
            Class<?> anIndexClass = null;
            try {
                anIndexClass = Class.forName(this.indexClass);
                abstractWriter = (AbstractWriter)anIndexClass.newInstance();
                indexWriter = (IDitaTranstypeIndexWriter)anIndexClass.newInstance();
                buff = new StringBuffer(indexWriter.getIndexFileName(this.outputFileRoot));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        } else if ("htmlhelp".equalsIgnoreCase(this.indexType)) {
            abstractWriter = new CHMIndexWriter();
            buff.append(".hhk");
        } else if ("javahelp".equalsIgnoreCase(this.indexType)) {
            abstractWriter = new JavaHelpIndexWriter();
            buff.append("_index.xml");
        } else if ("eclipsehelp".equalsIgnoreCase(this.indexType)) {
            abstractWriter = new EclipseIndexWriter();
            File indexDir = new File(buff.toString()).getParentFile();
            ((EclipseIndexWriter)abstractWriter).setFilePath(indexDir.getAbsolutePath());
            buff = new StringBuffer(new File(indexDir, "index.xml").getAbsolutePath());
        }
        content.setCollection(this.getTermList());
        abstractWriter.setContent(content);
        abstractWriter.write(buff.toString());
    }

    public void setOutputFileRoot(String fileRoot) {
        this.outputFileRoot = fileRoot;
    }
}

