/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.invoker;

import java.io.File;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.pipeline.PipelineFacade;
import org.dita.dost.pipeline.PipelineHashIO;
import org.dita.dost.resolver.DitaURIResolverFactory;

public class JavaInvoker {
    private static DITAOTJavaLogger javaLogger = new DITAOTJavaLogger();

    public static void removeFiles(String dir) {
        File file = new File(dir);
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        int size = file.listFiles().length;
        for (int i = 0; i < size; ++i) {
            File f = file.listFiles()[i];
            f.deleteOnExit();
        }
    }

    private JavaInvoker() {
    }

    public static void main(String[] args) {
        PipelineFacade facade = new PipelineFacade();
        PipelineHashIO pipelineInput = new PipelineHashIO();
        String baseDir = "C:/20091124/DITA-OT1.5/tablebug";
        String tempDir = baseDir + "/temp";
        if (!new File(tempDir).exists()) {
            new File(tempDir).mkdir();
        }
        String inputDir = baseDir + "";
        String outDir = baseDir + "/out";
        String inputMap = inputDir + "/test.ditamap";
        String maplinks = tempDir + "maplinks.unordered";
        String style = "C:/20091026/DITA-OT1.5/demo/fo/xsl/common/topicmerge.xsl";
        String output = tempDir + "/xrefbug_mergedzdh.xml";
        pipelineInput.setAttribute("inputmap", inputMap);
        pipelineInput.setAttribute("maplinks", maplinks);
        pipelineInput.setAttribute("style", style);
        pipelineInput.setAttribute("basedir", tempDir);
        pipelineInput.setAttribute("inputdir", inputDir);
        pipelineInput.setAttribute("outputdir", outDir);
        pipelineInput.setAttribute("output", output);
        pipelineInput.setAttribute("tempDir", tempDir);
        pipelineInput.setAttribute("ditadir", "C:/20091104/DITA-OT1.5/");
        pipelineInput.setAttribute("ditaext", ".xml");
        pipelineInput.setAttribute("transtype", "eclipsehelp");
        pipelineInput.setAttribute("indextype", "eclipsehelp");
        pipelineInput.setAttribute("indexclass", "org.dita.dost.writer.EclipseIndexWriter");
        pipelineInput.setAttribute("encoding", "en-US");
        pipelineInput.setAttribute("targetext", ".html");
        pipelineInput.setAttribute("validate", "false");
        pipelineInput.setAttribute("generatecopyouter", "2");
        pipelineInput.setAttribute("outercontrol", "warn");
        pipelineInput.setAttribute("onlytopicinmap", "false");
        pipelineInput.setAttribute("ditalist", tempDir + "/dita.list");
        pipelineInput.setAttribute("maplinks", tempDir + "/maplinks.unordered");
        DitaURIResolverFactory.setPath(tempDir);
        try {
            facade.execute("GenMapAndTopicList", pipelineInput);
            facade.execute("DebugAndFilter", pipelineInput);
        }
        catch (DITAOTException e) {
            e.printStackTrace();
            javaLogger.logException(e);
        }
    }
}

