/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.log;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.HashSet;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.DateUtils;
import org.apache.tools.ant.util.StringUtils;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.DITAOTFileLogger;
import org.dita.dost.log.MessageBean;
import org.dita.dost.util.LogUtils;

public class DITAOTBuildLogger
implements BuildLogger {
    public static final int LEFT_COLUMN_SIZE = 12;
    protected static final String LINE_SEP = StringUtils.LINE_SEP;
    private PrintStream err = null;
    private DITAOTFileLogger logger = null;
    private int msgOutputLevel = 0;
    private PrintStream out = null;
    private long startTime = System.currentTimeMillis();
    private HashSet exceptionsCaptured = new HashSet();

    protected static String formatTime(long millis) {
        return DateUtils.formatElapsedTime((long)millis);
    }

    protected static String getBuildFailedMessage() {
        return "BUILD FAILED";
    }

    protected static String getBuildSuccessfulMessage() {
        return "BUILD SUCCESSFUL";
    }

    protected static void printMessage(String message, PrintStream stream, int priority) {
        if (priority <= 2) {
            stream.println(message);
        }
    }

    public DITAOTBuildLogger() {
        this.logger = DITAOTFileLogger.getInstance();
    }

    public void buildFinished(BuildEvent event) {
        Throwable error = event.getException();
        StringBuffer message = new StringBuffer();
        String msg = null;
        message.append("Processing ended.");
        message.append(LINE_SEP);
        if (error == null && !LogUtils.haveFatalOrError()) {
            message.append(LINE_SEP);
            message.append(DITAOTBuildLogger.getBuildSuccessfulMessage());
        } else {
            message.append(LINE_SEP);
            message.append(DITAOTBuildLogger.getBuildFailedMessage());
            message.append(LINE_SEP);
            if (error != null) {
                message.append(error.toString());
                message.append(LINE_SEP);
                if (3 <= this.msgOutputLevel) {
                    message.append(StringUtils.getStackTrace((Throwable)error));
                }
            }
        }
        message.append(LINE_SEP);
        message.append(LogUtils.getLogStatisticInfo());
        message.append(LINE_SEP);
        message.append("Total time: ");
        message.append(DITAOTBuildLogger.formatTime(System.currentTimeMillis() - this.startTime));
        msg = message.toString();
        if (error == null) {
            DITAOTBuildLogger.printMessage(msg, this.out, 2);
            this.logger.logInfo(msg);
        } else {
            DITAOTBuildLogger.printMessage(msg, this.out, 0);
            this.logger.logError(msg);
        }
        this.logger.closeLogger();
    }

    public void buildStarted(BuildEvent event) {
        this.startTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageLogged(BuildEvent event) {
        StringBuffer message = new StringBuffer();
        String msg = null;
        Task eventTask = event.getTask();
        int priority = event.getPriority();
        if (priority > this.msgOutputLevel) {
            return;
        }
        if (eventTask != null) {
            String label = new StringBuffer().append("  [").append(eventTask.getTaskName()).append("] ").toString();
            BufferedReader r = null;
            try {
                boolean first = true;
                r = new BufferedReader(new StringReader(event.getMessage()));
                String line = r.readLine();
                while (line != null) {
                    if (!first) {
                        message.append(StringUtils.LINE_SEP);
                    }
                    first = false;
                    message.append(label).append(line);
                    line = r.readLine();
                }
            }
            catch (IOException e) {
                message.append(label).append(event.getMessage());
            }
            finally {
                try {
                    r.close();
                }
                catch (IOException ioe) {}
            }
        } else {
            message.append(event.getMessage());
        }
        msg = message.toString();
        this.catchHHCError(msg);
        if (priority != 0) {
            boolean flag = false;
            if (eventTask != null && "xslt".equals(eventTask.getTaskName()) && msg.indexOf("DOTX") == -1) {
                flag = true;
            }
            if (eventTask != null && "fop".equals(eventTask.getTaskName())) {
                flag = true;
            }
            if (!flag) {
                DITAOTBuildLogger.printMessage(msg, this.out, priority);
            }
            this.logger.logInfo(msg);
        } else {
            DITAOTBuildLogger.printMessage(msg, this.err, priority);
            this.logger.logError(msg);
        }
    }

    public void setEmacsMode(boolean mode) {
    }

    public void setErrorPrintStream(PrintStream errorPrintStream) {
        this.err = new PrintStream(errorPrintStream, true);
    }

    public void setMessageOutputLevel(int level) {
        this.msgOutputLevel = level;
    }

    public void setOutputPrintStream(PrintStream output) {
        this.out = new PrintStream(output, true);
    }

    public void targetFinished(BuildEvent event) {
    }

    public void targetStarted(BuildEvent event) {
        if (2 <= this.msgOutputLevel && !"".equals(event.getTarget().getName())) {
            String desc = event.getTarget().getDescription();
            String msg = desc + "...";
            if (desc == null || "".equals(desc.trim())) {
                return;
            }
            DITAOTBuildLogger.printMessage(msg, this.out, 2);
            this.logger.logInfo(msg);
        }
    }

    public void taskFinished(BuildEvent event) {
        if (event.getException() == null) {
            return;
        }
        Throwable exception = event.getException();
        if (exception instanceof BuildException) {
            BuildException buildEx = (BuildException)exception;
            Throwable innerEx = buildEx.getException();
            if (innerEx != null && innerEx instanceof DITAOTException) {
                DITAOTException ex = (DITAOTException)innerEx;
                if (ex.alreadyCaptured()) {
                    return;
                }
                ex.setCaptured(true);
                MessageBean msgBean = ex.getMessageBean();
                if (msgBean != null) {
                    LogUtils.increaseNumOfExceptionByType(msgBean.getType());
                } else {
                    LogUtils.increaseNumOfExceptionByType(null);
                }
                return;
            }
            if (!this.chkThrowableAlreadyCaptured((Throwable)buildEx)) {
                LogUtils.increaseNumOfErrors();
                return;
            }
        } else if (!this.chkThrowableAlreadyCaptured(exception)) {
            LogUtils.increaseNumOfErrors();
        }
    }

    public void taskStarted(BuildEvent event) {
    }

    private boolean chkThrowableAlreadyCaptured(Throwable ex) {
        boolean captured = false;
        if (ex == null) {
            return true;
        }
        Throwable parent = ex;
        for (Throwable unknownEx = parent.getCause(); unknownEx != null; unknownEx = unknownEx.getCause()) {
            parent = unknownEx;
            if (!this.exceptionsCaptured.contains(unknownEx) && !(unknownEx instanceof DITAOTException)) continue;
            captured = true;
            return captured;
        }
        if (!captured) {
            this.exceptionsCaptured.add(parent);
        }
        return captured;
    }

    private void catchHHCError(String message) {
        if (message == null) {
            return;
        }
        String upperMessage = message.toUpperCase();
        if (upperMessage.indexOf("HHC") != -1 && upperMessage.indexOf("ERROR:") != -1) {
            LogUtils.increaseNumOfErrors();
        }
    }
}

