/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.log;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.dita.dost.log.DITAOTJavaLogger;

public class DITAOTFileLogger {
    private static DITAOTFileLogger logger = null;
    private File tmpLogFile = null;
    private String logFile = null;
    private String logDir = null;
    private PrintWriter printWriter = null;

    private DITAOTFileLogger() {
        try {
            this.tmpLogFile = File.createTempFile("ditaot-", ".log");
            this.printWriter = new PrintWriter(new FileOutputStream(this.tmpLogFile));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static DITAOTFileLogger getInstance() {
        if (logger == null) {
            logger = new DITAOTFileLogger();
        }
        return logger;
    }

    public void closeLogger() {
        DITAOTJavaLogger javaLogger = new DITAOTJavaLogger();
        if (logger == null) {
            return;
        }
        this.printWriter.close();
        if (this.logDir != null && this.logFile != null) {
            File log = new File(this.logDir, this.logFile);
            if (log.exists()) {
                log.delete();
            }
            if (this.tmpLogFile.renameTo(log)) {
                StringBuffer buff = new StringBuffer(256);
                buff.append("Log file '").append(this.logFile);
                buff.append("' was generated successfully in directory '");
                buff.append(this.logDir).append("'.");
                javaLogger.logInfo(buff.toString());
                return;
            }
        }
        if (this.tmpLogFile.exists()) {
            this.tmpLogFile.delete();
        }
        javaLogger.logError("Failed to generate log file.");
    }

    public String getLogDir() {
        return this.logDir;
    }

    public void setLogFile(String filename) {
        this.logFile = filename;
    }

    public void setLogDir(String logdir) {
        this.logDir = logdir;
    }

    public void logInfo(String msg) {
        this.logMessage(msg);
    }

    public void logWarn(String msg) {
        this.logMessage(msg);
    }

    public void logError(String msg) {
        this.logMessage(msg);
    }

    public void logDebug(String msg) {
        this.logMessage(msg);
    }

    public void logException(Throwable t) {
        this.logError(t.getMessage());
        t.printStackTrace(this.printWriter);
    }

    private void logMessage(String msg) {
        this.printWriter.println(msg);
    }
}

