/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.log;

import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.log.MessageBean;
import org.dita.dost.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MessageUtils {
    private static Hashtable hashTable = null;
    private static String messageFile = null;
    private static DITAOTJavaLogger fileLogger = new DITAOTJavaLogger();
    private static String defaultResource = "resource/messages.xml";
    private static MessageUtils utils = null;

    private MessageUtils() {
    }

    private static MessageUtils getInstance() {
        if (utils == null) {
            utils = new MessageUtils();
        }
        return utils;
    }

    public static void loadDefaultMessages() {
        MessageUtils.getInstance().loadDefMsg();
    }

    private void loadDefMsg() {
        if (!new File(defaultResource).exists()) {
            MessageUtils.loadMessages(this.getClass().getClassLoader().getResource(defaultResource).toString());
        } else {
            MessageUtils.loadMessages(defaultResource);
        }
    }

    public static void loadMessages(String newMessageFile) {
        if (!MessageUtils.updateMessageFile(newMessageFile)) {
            return;
        }
        hashTable = new Hashtable();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(messageFile);
            Element messages = doc.getDocumentElement();
            NodeList messageList = messages.getElementsByTagName("message");
            int messageListLength = messageList.getLength();
            for (int i = 0; i < messageListLength; ++i) {
                Element message = (Element)messageList.item(i);
                Node reason = message.getElementsByTagName("reason").item(0);
                Node response = message.getElementsByTagName("response").item(0);
                MessageBean messageBean = new MessageBean();
                NamedNodeMap attrs = message.getAttributes();
                String id = attrs.getNamedItem("id").getNodeValue();
                messageBean.setId(id);
                messageBean.setType(attrs.getNamedItem("type").getNodeValue());
                messageBean.setReason(reason.getFirstChild().getNodeValue());
                messageBean.setResponse(response.getFirstChild().getNodeValue());
                hashTable.put(id, messageBean);
            }
        }
        catch (Exception e) {
            StringBuffer buff = new StringBuffer(128);
            buff.append("  Failed to load messages from '");
            buff.append(messageFile);
            buff.append("' due to exception: ");
            buff.append(e.getMessage());
            buff.append(". Please check if there are files 'resource/messages.xml'");
            buff.append(" and 'resource/messages.dtd' in the directory");
            buff.append(" that you run the toolkit. If not, please copy them");
            buff.append(" from the toolkit's root directory.");
            fileLogger.logError(buff.toString());
        }
    }

    private static boolean updateMessageFile(String newMessageFile) {
        String oldMessagePath = null;
        String newMessagePath = null;
        if (messageFile == null) {
            messageFile = newMessageFile;
            return true;
        }
        oldMessagePath = new File(messageFile).getAbsolutePath();
        if (oldMessagePath.equalsIgnoreCase(newMessagePath = new File(newMessageFile).getAbsolutePath())) {
            return false;
        }
        messageFile = newMessageFile;
        return true;
    }

    public static MessageBean getMessage(String id) {
        MessageBean message = null;
        MessageBean hashMessage = null;
        if (hashTable == null) {
            MessageUtils.loadDefaultMessages();
        }
        if ((hashMessage = (MessageBean)hashTable.get(id)) != null) {
            message = new MessageBean(hashMessage);
        }
        if (message == null) {
            message = new MessageBean(id, "", "", "");
            fileLogger.logWarn("  Can't find message for id: " + id);
        }
        return message;
    }

    public static MessageBean getMessage(String id, Properties prop) {
        String reason = null;
        String response = null;
        Iterator<Object> iter = null;
        MessageBean messageBean = MessageUtils.getMessage(id);
        if (prop == null || prop.size() == 0) {
            return messageBean;
        }
        reason = messageBean.getReason();
        response = messageBean.getResponse();
        for (String string : prop.keySet()) {
            String replacement = prop.getProperty(string);
            reason = StringUtils.replaceAll(reason, string, replacement);
            response = StringUtils.replaceAll(response, string, replacement);
        }
        messageBean.setReason(reason);
        messageBean.setResponse(response);
        return messageBean;
    }
}

