/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.util.Properties;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.MessageBean;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.AbstractPipelineModule;

public class ModuleFactory {
    private static ModuleFactory moduleFactory = null;
    private final String packagePrefix = "org.dita.dost.module.";

    public static ModuleFactory instance() {
        if (moduleFactory == null) {
            moduleFactory = new ModuleFactory();
        }
        return moduleFactory;
    }

    public AbstractPipelineModule createModule(String moduleName) throws DITAOTException {
        String module = "org.dita.dost.module." + moduleName + "Module";
        try {
            return (AbstractPipelineModule)Class.forName(module).newInstance();
        }
        catch (Exception e) {
            String msg = null;
            Properties params = new Properties();
            params.put("%1", module);
            MessageBean msgBean = MessageUtils.getMessage("DOTJ005F", params);
            msg = msgBean.toString();
            throw new DITAOTException(msgBean, e, msg);
        }
    }
}

