/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.AbstractPipelineModule;
import org.dita.dost.module.ContentImpl;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.pipeline.PipelineHashIO;
import org.dita.dost.reader.MapMetaReader;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.ListUtils;
import org.dita.dost.util.StringUtils;
import org.dita.dost.writer.DitaMetaWriter;

public class MoveMetaModule
implements AbstractPipelineModule {
    private ContentImpl content = new ContentImpl();
    private DITAOTJavaLogger logger = new DITAOTJavaLogger();

    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        String baseDir = ((PipelineHashIO)input).getAttribute("basedir");
        String tempDir = ((PipelineHashIO)input).getAttribute("tempDir");
        MapMetaReader metaReader = new MapMetaReader();
        DitaMetaWriter inserter = new DitaMetaWriter();
        if (!new File(tempDir).isAbsolute()) {
            tempDir = new File(baseDir, tempDir).getAbsolutePath();
        }
        Properties properties = null;
        try {
            properties = ListUtils.getDitaList();
        }
        catch (IOException e) {
            throw new DITAOTException(e);
        }
        Set<String> fullditamaplist = StringUtils.restoreSet(properties.getProperty("fullditamaplist"));
        for (String mapFile : fullditamaplist) {
            Properties p;
            mapFile = new File(tempDir, mapFile).getAbsolutePath();
            metaReader.read(mapFile);
            File oldMap = new File(mapFile);
            File newMap = new File(mapFile + ".temp");
            if (!newMap.exists()) continue;
            if (!oldMap.delete()) {
                p = new Properties();
                p.put("%1", oldMap.getPath());
                p.put("%2", newMap.getAbsolutePath() + ".chunk");
                this.logger.logError(MessageUtils.getMessage("DOTJ009E", p).toString());
            }
            if (newMap.renameTo(oldMap)) continue;
            p = new Properties();
            p.put("%1", oldMap.getPath());
            p.put("%2", newMap.getAbsolutePath() + ".chunk");
            this.logger.logError(MessageUtils.getMessage("DOTJ009E", p).toString());
        }
        Set mapSet = (Set)metaReader.getContent().getCollection();
        Iterator i = mapSet.iterator();
        String targetFileName = null;
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            targetFileName = (String)entry.getKey();
            String string = targetFileName = targetFileName.indexOf("#") != -1 ? targetFileName.substring(0, targetFileName.indexOf("#")) : targetFileName;
            if (!targetFileName.endsWith(".dita") && !targetFileName.endsWith(".xml")) continue;
            this.content.setValue(entry.getValue());
            inserter.setContent(this.content);
            if (FileUtils.fileExists((String)entry.getKey())) {
                inserter.write((String)entry.getKey());
                continue;
            }
            this.logger.logError(" ERROR FILE DOES NOT EXIST " + (String)entry.getKey());
        }
        return null;
    }
}

