/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.platform;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.platform.IAction;
import org.dita.dost.util.Constants;
import org.dita.dost.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertAction
extends DefaultHandler
implements IAction,
LexicalHandler {
    protected XMLReader reader;
    protected DITAOTJavaLogger logger;
    protected Set<String> fileNameSet = new LinkedHashSet<String>(16);
    protected StringBuffer retBuf;
    protected Hashtable<String, String> paramTable = null;
    protected int elemLevel = 0;

    public InsertAction() {
        this.logger = new DITAOTJavaLogger();
        this.retBuf = new StringBuffer(4096);
        this.paramTable = new Hashtable();
        try {
            if (System.getProperty("org.xml.sax.driver") == null) {
                StringUtils.initSaxDriver();
            }
            this.reader = XMLReaderFactory.createXMLReader();
            this.reader.setContentHandler(this);
            this.reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            this.reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            this.reader.setFeature("http://apache.org/xml/features/scanner/notify-char-refs", true);
            this.reader.setFeature("http://apache.org/xml/features/scanner/notify-builtin-refs", true);
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    @Override
    public void setInput(String input) {
        StringTokenizer inputTokenizer = new StringTokenizer(input, ",");
        while (inputTokenizer.hasMoreElements()) {
            this.fileNameSet.add((String)inputTokenizer.nextElement());
        }
    }

    @Override
    public void setParam(String param) {
        StringTokenizer paramTokenizer = new StringTokenizer(param, ";");
        String paramExpression = null;
        while (paramTokenizer.hasMoreElements()) {
            paramExpression = (String)paramTokenizer.nextElement();
            int index = paramExpression.indexOf("=");
            if (index <= 0) continue;
            this.paramTable.put(paramExpression.substring(0, index), paramExpression.substring(index + 1));
        }
    }

    @Override
    public String getResult() {
        Iterator<String> iter = this.fileNameSet.iterator();
        try {
            while (iter.hasNext()) {
                this.reader.parse(iter.next());
            }
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
        return this.retBuf.toString();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.elemLevel != 0) {
            int attLen = attributes.getLength();
            this.retBuf.append(Constants.LINE_SEPARATOR);
            this.retBuf.append("<" + qName);
            for (int i = 0; i < attLen; ++i) {
                this.retBuf.append(" ").append(attributes.getQName(i)).append("=\"");
                this.retBuf.append(attributes.getValue(i)).append("\"");
            }
            this.retBuf.append(">");
        }
        ++this.elemLevel;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.retBuf.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        --this.elemLevel;
        if (this.elemLevel != 0) {
            this.retBuf.append(Constants.LINE_SEPARATOR);
            this.retBuf.append("</" + qName + ">");
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.retBuf.append(ch, start, length);
    }

    @Override
    public void startDocument() throws SAXException {
        this.elemLevel = 0;
    }

    @Override
    public void setFeatures(Hashtable<String, String> h) {
    }

    @Override
    public void startCDATA() throws SAXException {
        this.retBuf.append("<![CDATA[");
    }

    @Override
    public void endCDATA() throws SAXException {
        this.retBuf.append("]]>");
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
    }
}

