/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.io.File;
import java.util.Hashtable;
import java.util.Properties;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.Content;
import org.dita.dost.module.ContentImpl;
import org.dita.dost.reader.AbstractXMLReader;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ConrefPushReader
extends AbstractXMLReader {
    private Hashtable<String, Hashtable<String, String>> pushtable = new Hashtable();
    private DITAOTJavaLogger javaLogger = new DITAOTJavaLogger();
    private XMLReader reader = null;
    private boolean needResolveEntity = true;
    private String filePath = null;
    private StringBuffer pushcontent = null;
    private boolean start = false;
    private int level = 0;
    private String target = null;
    private String pushType = null;

    public Content getContent() {
        ContentImpl content = new ContentImpl();
        content.setCollection(this.pushtable.entrySet());
        return content;
    }

    public void read(String filename) {
        this.filePath = new File(filename).getParentFile().getAbsolutePath();
        this.start = false;
        this.pushcontent = new StringBuffer(256);
        this.pushType = null;
        try {
            this.reader.parse(filename);
        }
        catch (Exception e) {
            this.javaLogger.logException(e);
        }
    }

    public ConrefPushReader() {
        try {
            this.reader = XMLReaderFactory.createXMLReader();
            this.reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            this.reader.setFeature("http://xml.org/sax/features/namespaces", true);
            this.reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            this.reader.setFeature("http://apache.org/xml/features/scanner/notify-char-refs", true);
            this.reader.setFeature("http://apache.org/xml/features/scanner/notify-builtin-refs", true);
            this.needResolveEntity = true;
        }
        catch (Exception e) {
            this.javaLogger.logException(e);
        }
        this.reader.setContentHandler(this);
    }

    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        if (this.start) {
            ++this.level;
            this.putElement(this.pushcontent, name, atts, false);
        }
        String conactValue = atts.getValue("conaction");
        if (!this.start && conactValue != null) {
            if ("pushbefore".equalsIgnoreCase(conactValue)) {
                if (this.pushcontent.length() != 0) {
                    this.pushcontent = new StringBuffer();
                    Properties prop = new Properties();
                    prop.put("%1", atts.getValue("xtrf"));
                    prop.put("%2", atts.getValue("xtrc"));
                    this.javaLogger.logWarn(MessageUtils.getMessage("DOTJ044W", prop).toString());
                }
                this.start = true;
                this.level = 0;
                ++this.level;
                this.putElement(this.pushcontent, name, atts, true);
                this.pushType = "pushbefore";
            } else if ("pushafter".equalsIgnoreCase(conactValue)) {
                this.start = true;
                this.level = 0;
                ++this.level;
                if (this.target == null) {
                    Properties prop = new Properties();
                    prop.put("%1", atts.getValue("xtrf"));
                    prop.put("%2", atts.getValue("xtrc"));
                    this.javaLogger.logError(MessageUtils.getMessage("DOTJ039E", prop).toString());
                } else {
                    this.putElement(this.pushcontent, name, atts, true);
                    this.pushType = "pushafter";
                }
            } else if ("pushreplace".equalsIgnoreCase(conactValue)) {
                this.start = true;
                this.level = 0;
                ++this.level;
                this.target = atts.getValue("conref");
                if (this.target == null) {
                    Properties prop = new Properties();
                    prop.put("%1", atts.getValue("xtrf"));
                    prop.put("%2", atts.getValue("xtrc"));
                    this.javaLogger.logError(MessageUtils.getMessage("DOTJ040E", prop).toString());
                } else {
                    this.pushType = "pushreplace";
                    this.putElement(this.pushcontent, name, atts, true);
                }
            } else if ("mark".equalsIgnoreCase(conactValue)) {
                this.target = atts.getValue("conref");
                if (this.pushcontent != null && this.pushcontent.length() > 0 && "pushbefore".equals(this.pushType)) {
                    this.replaceContent();
                    this.addtoPushTable(this.target, this.pushcontent.toString(), this.pushType);
                    this.pushcontent = new StringBuffer(256);
                    this.target = null;
                    this.pushType = null;
                }
            }
        } else if (this.pushcontent == null || this.pushcontent.length() <= 0 || this.level == 0) {
            // empty if block
        }
    }

    private void replaceContent() {
        int index = 0;
        int nextindex = 0;
        int hrefindex = this.pushcontent.indexOf("href=\"", index);
        int conrefindex = this.pushcontent.indexOf("conref=\"", index);
        StringBuffer resultBuffer = new StringBuffer(256);
        if (hrefindex < 0 && conrefindex < 0) {
            return;
        }
        while (hrefindex >= 0 || conrefindex >= 0) {
            if (hrefindex > 0 && conrefindex > 0) {
                nextindex = hrefindex < conrefindex ? hrefindex : conrefindex;
            } else if (hrefindex > 0) {
                nextindex = hrefindex;
            } else if (conrefindex > 0) {
                nextindex = conrefindex;
            }
            int valueindex = this.pushcontent.indexOf("\"", nextindex) + 1;
            resultBuffer.append(this.pushcontent.substring(index, valueindex));
            resultBuffer.append(this.replaceURL(this.pushcontent.substring(valueindex, this.pushcontent.indexOf("\"", valueindex))));
            index = this.pushcontent.indexOf("\"", valueindex);
            if (hrefindex > 0) {
                hrefindex = this.pushcontent.indexOf("href=\"", index);
            }
            if (conrefindex <= 0) continue;
            conrefindex = this.pushcontent.indexOf("conref=\"", index);
        }
        resultBuffer.append(this.pushcontent.substring(index));
        this.pushcontent = resultBuffer;
    }

    private void putElement(StringBuffer buf, String elemName, Attributes atts, boolean removeConref) {
        int index = 0;
        buf.append("<").append(elemName);
        for (index = 0; index < atts.getLength(); ++index) {
            if (removeConref && ("conref".equals(atts.getQName(index)) || "conaction".equals(atts.getQName(index)))) continue;
            buf.append(" ");
            buf.append(atts.getQName(index)).append("=").append("\"");
            String value = atts.getValue(index);
            value = StringUtils.escapeXML(value);
            if ("href".equals(atts.getQName(index)) || "conref".equals(atts.getQName(index))) {
                value = this.replaceURL(value);
            }
            buf.append(value).append("\"");
        }
        if ("pushreplace".equals(this.pushType) && atts.getValue("id") == null && this.level == 1) {
            int sharpIndex = this.target.indexOf("#");
            if (sharpIndex == -1) {
                Properties prop = new Properties();
                prop.put("%1", this.target);
                this.javaLogger.logError(MessageUtils.getMessage("DOTJ041E", prop).toString());
            } else {
                String targetLoc = this.target.substring(sharpIndex + 1);
                String id = "";
                id = targetLoc.contains("/") ? targetLoc.substring(targetLoc.lastIndexOf("/") + 1) : targetLoc;
                buf.append(" ");
                buf.append("id").append("=").append("\"");
                buf.append(id).append("\"");
            }
        }
        buf.append(">");
    }

    private String replaceURL(String value) {
        if (value == null) {
            return null;
        }
        if (this.target == null || FileUtils.isAbsolutePath(value) || value.contains("://") || value.startsWith("#")) {
            return value;
        }
        String source = FileUtils.resolveFile(this.filePath, this.target);
        String urltarget = FileUtils.resolveTopic(this.filePath, value);
        return FileUtils.getRelativePathFromMap(source, urltarget);
    }

    private void addtoPushTable(String target, String pushcontent, String type) {
        int sharpIndex = target.indexOf("#");
        if (sharpIndex == -1) {
            Properties prop = new Properties();
            prop.put("%1", target);
            this.javaLogger.logError(MessageUtils.getMessage("DOTJ041E", prop).toString());
        }
        String key = FileUtils.resolveFile(this.filePath, target);
        Hashtable<Object, Object> table = null;
        if (this.pushtable.containsKey(key)) {
            table = this.pushtable.get(key);
        } else {
            table = new Hashtable();
            this.pushtable.put(key, table);
        }
        String targetLoc = target.substring(sharpIndex);
        String addon = "|" + type;
        if (table.containsKey(targetLoc + addon)) {
            if ("pushreplace".equalsIgnoreCase(type)) {
                Properties prop = new Properties();
                prop.put("%1", target);
                this.javaLogger.logError(MessageUtils.getMessage("DOTJ042E", prop).toString());
            } else {
                table.put(targetLoc + addon, (String)table.get(targetLoc + addon) + pushcontent);
            }
        } else {
            table.put(targetLoc + addon, pushcontent);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.start && this.needResolveEntity) {
            this.pushcontent.append(StringUtils.escapeXML(ch, start, length));
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.start) {
            --this.level;
            this.pushcontent.append("<").append("/").append(name).append(">");
        }
        if (this.level == 0) {
            this.start = false;
            if (("pushafter".equals(this.pushType) || "pushreplace".equals(this.pushType)) && this.target != null) {
                this.addtoPushTable(this.target, this.pushcontent.toString(), this.pushType);
                this.pushcontent = new StringBuffer(256);
                this.target = null;
                this.pushType = null;
            }
        }
    }

    public void startEntity(String name) throws SAXException {
        try {
            this.needResolveEntity = StringUtils.checkEntity(name);
            if (!this.needResolveEntity) {
                this.pushcontent.append(StringUtils.getEntity(name));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void endEntity(String name) throws SAXException {
        if (!this.needResolveEntity) {
            this.needResolveEntity = true;
        }
    }
}

