/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.exception.DITAOTXMLErrorHandler;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.log.MessageBean;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.reader.AbstractXMLReader;
import org.dita.dost.util.CatalogUtils;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.FilterUtils;
import org.dita.dost.util.OutputUtils;
import org.dita.dost.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenListModuleReader
extends AbstractXMLReader {
    private static XMLReader reader = null;
    private static HashMap<String, String> catalogMap = null;
    private String currentDir = null;
    private boolean hasConRef = false;
    private boolean hasHref = false;
    private boolean hasKeyRef = false;
    private boolean hasCodeRef = false;
    private Set<String> nonConrefCopytoTargets = null;
    private Set<String> conrefTargets = null;
    private Set<String> hrefTargets = null;
    private Set<String> hrefTopicSet = null;
    private Set<String> chunkTopicSet = null;
    private Set<String> schemeSet = null;
    private Set<String> subsidiarySet = null;
    private Set<String> ignoredCopytoSourceSet = null;
    private Map<String, String> copytoMap = null;
    private Map<String, String> keysDefMap = null;
    private boolean hasconaction = false;
    private boolean insideExcludedElement = false;
    private int excludedLevel = 0;
    private int foreignLevel = 0;
    private int chunkLevel = 0;
    private int chunkToNavLevel = 0;
    private int topicGroupLevel = 0;
    private boolean isValidInput = false;
    private String props = null;
    private DITAOTJavaLogger javaLogger = null;
    private Set<String> outDitaFilesSet = null;
    private static String rootDir = null;
    private String currentFile = null;
    private static String rootFilePath = null;
    private Stack<String> processRoleStack;
    private int processRoleLevel = 0;
    private Set<String> resourceOnlySet;
    private Set<String> crossSet;
    private Set<String> schemeRefSet = null;
    private Map<String, Set<String>> relationGraph = null;
    private StringBuffer result = new StringBuffer();
    private boolean hasExport = false;
    private boolean shouldAppendEndTag = false;
    private String topicHref = "";
    private HashSet<String> topicMetaSet = null;
    private String topicId = "";
    private Map<String, Set<String>> pluginMap = new HashMap<String, Set<String>>();
    private String transtype;

    public String getTranstype() {
        return this.transtype;
    }

    public void setTranstype(String transtype) {
        this.transtype = transtype;
    }

    public Map<String, Set<String>> getPluginMap() {
        return this.pluginMap;
    }

    public StringBuffer getResult() {
        return this.result;
    }

    public GenListModuleReader() {
        this.nonConrefCopytoTargets = new HashSet<String>(64);
        this.hrefTargets = new HashSet<String>(32);
        this.hrefTopicSet = new HashSet<String>(32);
        this.chunkTopicSet = new HashSet<String>(32);
        this.schemeSet = new HashSet<String>(32);
        this.schemeRefSet = new HashSet<String>(32);
        this.conrefTargets = new HashSet<String>(32);
        this.copytoMap = new HashMap<String, String>(16);
        this.subsidiarySet = new HashSet<String>(16);
        this.ignoredCopytoSourceSet = new HashSet<String>(16);
        this.outDitaFilesSet = new HashSet<String>(64);
        this.keysDefMap = new HashMap<String, String>();
        this.processRoleStack = new Stack();
        this.resourceOnlySet = new HashSet<String>(32);
        this.crossSet = new HashSet<String>(32);
        this.topicMetaSet = new HashSet(16);
        reader.setContentHandler(this);
        this.javaLogger = new DITAOTJavaLogger();
        try {
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        }
        catch (SAXNotRecognizedException e1) {
            this.javaLogger.logException(e1);
        }
        catch (SAXNotSupportedException e1) {
            this.javaLogger.logException(e1);
        }
        try {
            Class.forName("org.apache.xml.resolver.tools.CatalogResolver");
            reader.setEntityResolver((EntityResolver)CatalogUtils.getCatalogResolver());
        }
        catch (ClassNotFoundException e) {
            reader.setEntityResolver(this);
        }
    }

    public static void initXMLReader(String ditaDir, boolean validate, String rootFile) throws SAXException {
        DITAOTJavaLogger javaLogger = new DITAOTJavaLogger();
        if (System.getProperty("org.xml.sax.driver") == null) {
            StringUtils.initSaxDriver();
        }
        rootDir = new File(rootFile).getAbsoluteFile().getParent();
        rootFilePath = new File(rootFile).getAbsolutePath();
        rootFilePath = FileUtils.removeRedundantNames(rootFilePath);
        rootDir = FileUtils.removeRedundantNames(rootDir);
        reader = XMLReaderFactory.createXMLReader();
        reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        if (validate) {
            reader.setFeature("http://xml.org/sax/features/validation", true);
            reader.setFeature("http://apache.org/xml/features/validation/schema", true);
        } else {
            String msg = MessageUtils.getMessage("DOTJ037W").toString();
            javaLogger.logWarn(msg);
        }
        CatalogUtils.setDitaDir(ditaDir);
        catalogMap = CatalogUtils.getCatalog(ditaDir);
    }

    public void reset() {
        this.hasKeyRef = false;
        this.hasConRef = false;
        this.hasHref = false;
        this.hasCodeRef = false;
        this.currentDir = null;
        this.insideExcludedElement = false;
        this.excludedLevel = 0;
        this.foreignLevel = 0;
        this.chunkLevel = 0;
        this.chunkToNavLevel = 0;
        this.topicGroupLevel = 0;
        this.isValidInput = false;
        this.hasconaction = false;
        this.nonConrefCopytoTargets.clear();
        this.hrefTargets.clear();
        this.hrefTopicSet.clear();
        this.chunkTopicSet.clear();
        this.conrefTargets.clear();
        this.copytoMap.clear();
        this.ignoredCopytoSourceSet.clear();
        this.outDitaFilesSet.clear();
        this.keysDefMap.clear();
        this.schemeSet.clear();
        this.schemeRefSet.clear();
        this.processRoleLevel = 0;
        this.processRoleStack.clear();
    }

    public boolean hasConRef() {
        return this.hasConRef;
    }

    public boolean hasKeyRef() {
        return this.hasKeyRef;
    }

    public boolean hasCodeRef() {
        return this.hasCodeRef;
    }

    public boolean hasHref() {
        return this.hasHref;
    }

    public Set<String> getNonCopytoResult() {
        HashSet<String> nonCopytoSet = new HashSet<String>(128);
        nonCopytoSet.addAll(this.nonConrefCopytoTargets);
        nonCopytoSet.addAll(this.conrefTargets);
        nonCopytoSet.addAll(this.copytoMap.values());
        nonCopytoSet.addAll(this.ignoredCopytoSourceSet);
        return nonCopytoSet;
    }

    public Set<String> getHrefTargets() {
        return this.hrefTargets;
    }

    public Set<String> getConrefTargets() {
        return this.conrefTargets;
    }

    public Set<String> getSubsidiaryTargets() {
        return this.subsidiarySet;
    }

    public Set<String> getOutDitaFilesSet() {
        return this.outDitaFilesSet;
    }

    public Set<String> getNonConrefCopytoTargets() {
        return this.nonConrefCopytoTargets;
    }

    public Set<String> getIgnoredCopytoSourceSet() {
        return this.ignoredCopytoSourceSet;
    }

    public Map<String, String> getCopytoMap() {
        return this.copytoMap;
    }

    public Map<String, String> getKeysDMap() {
        return this.keysDefMap;
    }

    public void setCurrentDir(String dir) {
        this.currentDir = dir;
    }

    public boolean isValidInput() {
        return this.isValidInput;
    }

    public boolean hasConaction() {
        return this.hasconaction;
    }

    public void parse(File file) throws FileNotFoundException, IOException, SAXException {
        this.currentFile = file.getAbsolutePath();
        reader.setErrorHandler(new DITAOTXMLErrorHandler(file.getName()));
        reader.parse(new InputSource(new FileInputStream(file)));
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String domains = null;
        Properties params = new Properties();
        String attrValue = atts.getValue("processing-role");
        String href = atts.getValue("href");
        if (attrValue != null) {
            this.processRoleStack.push(attrValue);
            ++this.processRoleLevel;
            if ("resource-only".equals(attrValue)) {
                if (href != null) {
                    this.resourceOnlySet.add(FileUtils.resolveFile(this.currentDir, href));
                }
            } else if ("normal".equalsIgnoreCase(attrValue) && href != null) {
                this.crossSet.add(FileUtils.resolveFile(this.currentDir, href));
            }
        } else if (this.processRoleLevel > 0) {
            ++this.processRoleLevel;
            if ("resource-only".equalsIgnoreCase(this.processRoleStack.peek())) {
                if (href != null) {
                    this.resourceOnlySet.add(FileUtils.resolveFile(this.currentDir, href));
                }
            } else if ("normal".equalsIgnoreCase(this.processRoleStack.peek()) && href != null) {
                this.crossSet.add(FileUtils.resolveFile(this.currentDir, href));
            }
        } else if (href != null) {
            this.crossSet.add(FileUtils.resolveFile(this.currentDir, href));
        }
        if ((attrValue = atts.getValue("class")) != null) {
            String filename;
            if (attrValue.contains(" topic/topic ")) {
                this.topicId = atts.getValue("id");
                filename = FileUtils.getRelativePathFromMap(rootFilePath, this.currentFile);
                if (this.result.indexOf(filename + "?") != -1) {
                    this.result = new StringBuffer(this.result.toString().replace(filename + "?", this.topicId));
                }
            }
            if (FileUtils.isDITAMapFile(this.currentFile) && this.currentFile.equals(rootFilePath) && attrValue.contains(" map/map ") && this.transtype.equals("eclipsehelp")) {
                String pluginId = atts.getValue("id");
                if (pluginId == null) {
                    pluginId = "org.sample.help.doc";
                }
                Set<String> set = StringUtils.restoreSet(pluginId);
                this.pluginMap.put("pluginId", set);
            }
            if (this.transtype.equals("eclipsehelp")) {
                if (attrValue.contains(" map/topicmeta ") || attrValue.contains(" topic/prolog ")) {
                    this.topicMetaSet.add(qName);
                }
                if (attrValue.contains(" delay-d/exportanchors ")) {
                    this.hasExport = true;
                    if (FileUtils.isDITAMapFile(this.currentFile)) {
                        String editedHref = "";
                        editedHref = this.topicHref.endsWith(".xml") ? this.topicHref.replace(".xml", ".dita") : this.topicHref;
                        this.result.append("<file name=\"" + editedHref + "\">");
                        this.result.append("<topicid name=\"" + this.topicId + "\"/>");
                    } else if (FileUtils.isDITATopicFile(this.currentFile)) {
                        filename = FileUtils.getRelativePathFromMap(rootFilePath, this.currentFile);
                        if (filename.endsWith(".xml")) {
                            filename = filename.replace(".xml", ".dita");
                        }
                        filename = filename.replace("\\", "/");
                        this.result.append("<file name=\"" + filename + "\">");
                        this.result.append("<topicid name=\"" + this.topicId + "\">");
                        this.shouldAppendEndTag = true;
                    }
                } else if (attrValue.contains(" delay-d/anchorkey ")) {
                    String keyref = atts.getValue("keyref");
                    this.result.append("<keyref name=\"" + keyref + "\"/>");
                } else if (attrValue.contains(" delay-d/anchorid ")) {
                    String id = atts.getValue("id");
                    if (FileUtils.isDITAMapFile(this.currentFile)) {
                        if (!this.topicId.equals(id)) {
                            this.result.append("<id name=\"" + id + "\"/>");
                        }
                    } else if (FileUtils.isDITATopicFile(this.currentFile) && !this.topicId.equals(id)) {
                        this.result.append("<id name=\"" + id + "\"/>");
                    }
                }
            }
        }
        if (attrValue != null) {
            Set<String> children;
            if (attrValue.contains(" subjectScheme/subjectScheme ")) {
                if (this.relationGraph == null) {
                    this.relationGraph = new LinkedHashMap<String, Set<String>>();
                }
                if ((children = this.relationGraph.get("ROOT")) == null || children.isEmpty()) {
                    children = new LinkedHashSet<String>();
                }
                children.add(this.currentFile);
                this.relationGraph.put("ROOT", children);
                this.schemeRefSet.add(FileUtils.getRelativePathFromMap(rootFilePath, this.currentFile));
            } else if (attrValue.contains(" subjectScheme/schemeref ")) {
                children = this.relationGraph.get(this.currentFile);
                if (children == null) {
                    children = new LinkedHashSet<String>();
                    this.relationGraph.put(this.currentFile, children);
                }
                if (href != null) {
                    children.add(FileUtils.resolveFile(rootDir, href));
                }
            }
        }
        if (this.foreignLevel > 0) {
            ++this.foreignLevel;
            return;
        }
        if (attrValue != null && (attrValue.indexOf(" topic/foreign ") != -1 || attrValue.indexOf(" topic/unknown ") != -1)) {
            ++this.foreignLevel;
        }
        if (this.chunkLevel > 0) {
            ++this.chunkLevel;
        } else if (atts.getValue("chunk") != null) {
            ++this.chunkLevel;
        }
        if (this.chunkToNavLevel > 0) {
            ++this.chunkToNavLevel;
        } else if (atts.getValue("chunk") != null && atts.getValue("chunk").indexOf("to-navigation") != -1) {
            ++this.chunkToNavLevel;
        }
        if (this.topicGroupLevel > 0) {
            ++this.topicGroupLevel;
        } else if (atts.getValue("class") != null && atts.getValue("class").contains(" mapgroup-d/topicgroup ")) {
            ++this.topicGroupLevel;
        }
        if (attrValue == null && !"dita".equals(localName)) {
            params.clear();
            params.put("%1", localName);
            this.javaLogger.logInfo(MessageUtils.getMessage("DOTJ030I", params).toString());
        }
        if (attrValue != null && attrValue.indexOf(" topic/topic ") != -1) {
            domains = atts.getValue("domains");
            if (domains == null) {
                params.clear();
                params.put("%1", localName);
                this.javaLogger.logInfo(MessageUtils.getMessage("DOTJ029I", params).toString());
            } else {
                this.props = StringUtils.getExtProps(domains);
            }
        }
        if (this.insideExcludedElement) {
            ++this.excludedLevel;
            return;
        }
        if (FilterUtils.needExclude(atts, this.props)) {
            this.insideExcludedElement = true;
            ++this.excludedLevel;
            return;
        }
        if (attrValue != null) {
            if (attrValue.indexOf(" map/map ") != -1 || attrValue.indexOf(" topic/title ") != -1) {
                this.isValidInput = true;
            } else if (attrValue.indexOf(" topic/object ") != -1) {
                this.parseAttribute(atts, "data");
            }
        }
        this.parseAttribute(atts, "conref");
        this.parseAttribute(atts, "href");
        this.parseAttribute(atts, "copy-to");
        this.parseAttribute(atts, "img");
        this.parseAttribute(atts, "conaction");
        this.parseAttribute(atts, "keys");
        this.parseAttribute(atts, "conkeyref");
        this.parseAttribute(atts, "keyref");
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.processRoleLevel > 0) {
            --this.processRoleLevel;
            this.processRoleStack.pop();
        }
        if (FileUtils.isDITATopicFile(this.currentFile) && this.shouldAppendEndTag) {
            this.result.append("</file>");
            this.shouldAppendEndTag = false;
        }
    }

    @Override
    public void startDocument() throws SAXException {
        String href = FileUtils.getRelativePathFromMap(rootFilePath, this.currentFile);
        if (FileUtils.isDITAMapFile(this.currentFile) && this.resourceOnlySet.contains(href) && !this.crossSet.contains(href)) {
            ++this.processRoleLevel;
            this.processRoleStack.push("resource-only");
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.processRoleLevel > 0) {
            if (this.processRoleLevel == this.processRoleStack.size()) {
                this.processRoleStack.pop();
            }
            --this.processRoleLevel;
        }
        if (this.foreignLevel > 0) {
            --this.foreignLevel;
            return;
        }
        if (this.chunkLevel > 0) {
            --this.chunkLevel;
        }
        if (this.chunkToNavLevel > 0) {
            --this.chunkToNavLevel;
        }
        if (this.topicGroupLevel > 0) {
            --this.topicGroupLevel;
        }
        if (this.insideExcludedElement) {
            if (this.excludedLevel == 1) {
                this.insideExcludedElement = false;
            }
            --this.excludedLevel;
        }
        if (this.topicMetaSet.contains(qName) && this.hasExport) {
            if (FileUtils.isDITAMapFile(this.currentFile)) {
                this.result.append("</file>");
            } else if (FileUtils.isDITATopicFile(this.currentFile)) {
                this.result.append("</topicid>");
            }
            this.hasExport = false;
            this.topicMetaSet.clear();
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (catalogMap.get(publicId) != null) {
            File dtdFile = new File(catalogMap.get(publicId));
            return new InputSource(dtdFile.getAbsolutePath());
        }
        if (catalogMap.get(systemId) != null) {
            File schemaFile = new File(catalogMap.get(systemId));
            return new InputSource(schemaFile.getAbsolutePath());
        }
        return null;
    }

    private void parseAttribute(Attributes atts, String attrName) throws SAXException {
        Object target;
        String attrValue = atts.getValue(attrName);
        String filename = null;
        String attrClass = atts.getValue("class");
        String attrScope = atts.getValue("scope");
        String attrFormat = atts.getValue("format");
        String attrType = atts.getValue("type");
        if (attrValue == null) {
            return;
        }
        if ("conref".equals(attrName) || "conkeyref".equals(attrName)) {
            this.hasConRef = true;
        } else if ("href".equals(attrName)) {
            if (attrClass != null && attrClass.contains(" pr-d/coderef ")) {
                this.hasCodeRef = true;
            } else {
                this.hasHref = true;
            }
        } else if ("keyref".equals(attrName)) {
            this.hasKeyRef = true;
        }
        if ("keys".equals(attrName) && !attrValue.equals("")) {
            String copy_to;
            target = atts.getValue("href");
            if (target != null) {
                target = StringUtils.escapeXML((String)target);
            }
            if (!StringUtils.isEmptyString(copy_to = atts.getValue("copy-to"))) {
                target = copy_to;
            }
            String temp = target;
            for (String key : attrValue.split(" ")) {
                if (!this.keysDefMap.containsKey(key) && !key.equals("")) {
                    if (target != null && !((String)target).equals("")) {
                        if (attrScope != null && (attrScope.equals("external") || attrScope.equals("peer"))) {
                            this.keysDefMap.put(key, (String)target);
                        } else {
                            String tail = "";
                            if (((String)target).indexOf("#") != -1) {
                                tail = ((String)target).substring(((String)target).indexOf("#"));
                                target = ((String)target).substring(0, ((String)target).indexOf("#"));
                            }
                            if (new File((String)target).isAbsolute()) {
                                target = FileUtils.getRelativePathFromMap(rootFilePath, (String)target);
                            }
                            target = FileUtils.normalizeDirectory(this.currentDir, (String)target);
                            this.keysDefMap.put(key, (String)target + tail);
                        }
                    } else {
                        this.keysDefMap.put(key, "");
                    }
                } else {
                    Properties prop = new Properties();
                    prop.setProperty("%1", key);
                    prop.setProperty("%2", (String)target);
                    this.javaLogger.logWarn(MessageUtils.getMessage("DOTJ045W", prop).toString());
                }
                target = temp;
            }
        }
        if ("external".equalsIgnoreCase(attrScope) || "peer".equalsIgnoreCase(attrScope) || attrValue.indexOf("://") != -1 || attrValue.startsWith("#")) {
            return;
        }
        target = new File(attrValue);
        if (((File)target).isAbsolute()) {
            attrValue = FileUtils.getRelativePathFromMap(rootFilePath, attrValue);
        }
        filename = FileUtils.normalizeDirectory(this.currentDir, attrValue);
        try {
            filename = URLDecoder.decode(filename, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        if (attrClass.contains(" map/topicref ")) {
            if ("subjectScheme".equalsIgnoreCase(attrType)) {
                this.schemeSet.add(filename);
            }
            if (this.transtype.equals("eclipsehelp")) {
                if (attrFormat == null || "dita".equalsIgnoreCase(attrFormat)) {
                    if (attrName.equals("href")) {
                        this.topicHref = filename;
                        this.topicHref = this.topicHref.replace("\\", "/");
                        if (attrValue.lastIndexOf("#") != -1) {
                            int position = attrValue.lastIndexOf("#");
                            this.topicId = attrValue.substring(position + 1);
                        } else if (FileUtils.isDITAFile(this.topicHref)) {
                            this.topicId = this.topicHref + "?";
                        }
                    }
                } else {
                    this.topicHref = "";
                    this.topicId = "";
                }
            }
        }
        if ("DITA-foreign".equals(attrType) && "data".equals(attrName) || attrClass != null && attrClass.contains(" pr-d/coderef ")) {
            this.subsidiarySet.add(filename);
            return;
        }
        if (FileUtils.isValidTarget(filename.toLowerCase()) && (StringUtils.isEmptyString(atts.getValue("copy-to")) || !FileUtils.isTopicFile(atts.getValue("copy-to").toLowerCase()) || atts.getValue("chunk") != null && atts.getValue("chunk").contains("to-content")) && !"conref".equals(attrName) && !"copy-to".equals(attrName) && this.canResolved()) {
            if (attrFormat != null) {
                this.nonConrefCopytoTargets.add(filename + "|" + attrFormat);
            } else {
                this.nonConrefCopytoTargets.add(filename);
            }
        }
        if (attrFormat != null && !"dita".equalsIgnoreCase(attrFormat)) {
            return;
        }
        if ("href".equals(attrName) && FileUtils.isTopicFile(filename) && this.canResolved()) {
            this.hrefTargets.add(new File(filename).getPath());
            this.toOutFile(new File(filename).getPath());
            String pathWithoutID = FileUtils.resolveFile(this.currentDir, attrValue);
            if (this.chunkLevel > 0 && this.chunkToNavLevel == 0 && this.topicGroupLevel == 0) {
                this.chunkTopicSet.add(pathWithoutID);
            } else {
                this.hrefTopicSet.add(pathWithoutID);
            }
        }
        if ("conref".equals(attrName) && FileUtils.isDITAFile(filename)) {
            this.conrefTargets.add(filename);
            this.toOutFile(new File(filename).getPath());
        }
        if ("copy-to".equals(attrName) && FileUtils.isTopicFile(filename)) {
            String href = atts.getValue("href");
            if (StringUtils.isEmptyString(href)) {
                StringBuffer buff = new StringBuffer();
                buff.append("[WARN]: Copy-to task [href=\"\" copy-to=\"");
                buff.append(filename);
                buff.append("\"] was ignored.");
                this.javaLogger.logWarn(buff.toString());
            } else if (this.copytoMap.get(filename) != null) {
                Properties prop = new Properties();
                prop.setProperty("%1", href);
                prop.setProperty("%2", filename);
                this.javaLogger.logWarn(MessageUtils.getMessage("DOTX065W", prop).toString());
                this.ignoredCopytoSourceSet.add(href);
            } else if (atts.getValue("chunk") == null || !atts.getValue("chunk").contains("to-content")) {
                this.copytoMap.put(filename, FileUtils.normalizeDirectory(this.currentDir, href));
            }
            String pathWithoutID = FileUtils.resolveFile(this.currentDir, attrValue);
            if (this.chunkLevel > 0 && this.chunkToNavLevel == 0 && this.topicGroupLevel == 0) {
                this.chunkTopicSet.add(pathWithoutID);
            } else {
                this.hrefTopicSet.add(pathWithoutID);
            }
        }
        if ("conaction".equals(attrName) && (attrValue.equals("mark") || attrValue.equals("pushreplace"))) {
            this.hasconaction = true;
        }
    }

    private boolean isOutFile(String toCheckPath) {
        return toCheckPath.startsWith("..");
    }

    private boolean isMapFile() {
        String current = FileUtils.removeRedundantNames(this.currentFile);
        return FileUtils.isDITAMapFile(current);
    }

    private boolean canResolved() {
        return !OutputUtils.getOnlyTopicInMap() || this.isMapFile();
    }

    private void addToOutFilesSet(String hrefedFile) {
        if (this.canResolved()) {
            this.outDitaFilesSet.add(hrefedFile);
        }
    }

    private void toOutFile(String filename) throws SAXException {
        Properties prop = new Properties();
        prop.put("%1", FileUtils.normalizeDirectory(rootDir, filename));
        prop.put("%2", FileUtils.removeRedundantNames(this.currentFile));
        if ((OutputUtils.getGeneratecopyouter() == 1 || OutputUtils.getGeneratecopyouter() == 2) && this.isOutFile(filename)) {
            if (OutputUtils.getOutterControl().equals("FAIL")) {
                MessageBean msgBean = MessageUtils.getMessage("DOTJ035F", prop);
                throw new SAXParseException(null, null, new DITAOTException(msgBean, null, msgBean.toString()));
            }
            if (OutputUtils.getOutterControl().equals("WARN")) {
                String message = MessageUtils.getMessage("DOTJ036W", prop).toString();
                this.javaLogger.logWarn(message);
            }
            this.addToOutFilesSet(filename);
        }
    }

    public Set<String> getOutFilesSet() {
        return this.outDitaFilesSet;
    }

    public Set<String> getHrefTopicSet() {
        return this.hrefTopicSet;
    }

    public Set<String> getChunkTopicSet() {
        return this.chunkTopicSet;
    }

    public Set<String> getSchemeSet() {
        return this.schemeSet;
    }

    public Set<String> getSchemeRefSet() {
        return this.schemeRefSet;
    }

    public Set<String> getResourceOnlySet() {
        this.resourceOnlySet.removeAll(this.crossSet);
        return this.resourceOnlySet;
    }

    public Map<String, Set<String>> getRelationshipGrap() {
        return this.relationGraph;
    }

    public static HashMap<String, String> getCatalogMap() {
        return catalogMap;
    }
}

