/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.dita.dost.index.IndexTerm;
import org.dita.dost.index.IndexTermCollection;
import org.dita.dost.index.IndexTermTarget;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.reader.AbstractXMLReader;
import org.dita.dost.util.Constants;
import org.dita.dost.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class IndexTermReader
extends AbstractXMLReader {
    private String targetFile = null;
    private String title = null;
    private String defaultTitle = null;
    private boolean inTitleElement = false;
    private boolean insideSortingAs = false;
    private Stack<IndexTerm> termStack = new Stack();
    private Stack<String> topicIdStack = new Stack();
    private List<String> indexTermSpecList = new ArrayList<String>(16);
    private List<String> indexSeeSpecList = new ArrayList<String>(16);
    private List<String> indexSeeAlsoSpecList = new ArrayList<String>(16);
    private List<String> indexSortAsSpecList = new ArrayList<String>(16);
    private List<String> topicSpecList = new ArrayList<String>(16);
    private List<String> titleSpecList = new ArrayList<String>(16);
    private List<IndexTerm> indexTermList = new ArrayList<IndexTerm>(256);
    private Map<String, String> titleMap = new HashMap<String, String>(256);
    private Stack<String> processRoleStack = new Stack();
    private int processRoleLevel = 0;
    private DITAOTJavaLogger javaLogger = new DITAOTJavaLogger();

    public void reset() {
        this.targetFile = null;
        this.title = null;
        this.defaultTitle = null;
        this.inTitleElement = false;
        this.termStack.clear();
        this.topicIdStack.clear();
        this.indexTermSpecList.clear();
        this.indexSeeSpecList.clear();
        this.indexSeeAlsoSpecList.clear();
        this.indexSortAsSpecList.clear();
        this.topicSpecList.clear();
        this.indexTermList.clear();
        this.processRoleStack.clear();
        this.processRoleLevel = 0;
        this.titleMap.clear();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String temp = new String(ch, start, length);
        if (ch[start] == '\n' || temp.startsWith(Constants.LINE_SEPARATOR)) {
            temp = " " + temp.substring(1);
        }
        char[] chars = temp.toCharArray();
        int flag = 10;
        StringBuffer sb = new StringBuffer();
        for (int n : chars) {
            if (n == 32) {
                if (flag == 32) continue;
                sb.append((char)n);
                flag = n;
                continue;
            }
            sb.append((char)n);
            flag = n;
        }
        temp = sb.toString();
        if (this.processRoleStack.isEmpty() || !"resource-only".equalsIgnoreCase(this.processRoleStack.peek())) {
            IndexTerm indexTerm;
            if (!this.insideSortingAs && !this.termStack.empty()) {
                indexTerm = this.termStack.peek();
                temp = StringUtils.restoreEntity(temp);
                indexTerm.setTermName(StringUtils.setOrAppend(indexTerm.getTermName(), temp, false));
            } else if (this.insideSortingAs && temp.length() > 0) {
                indexTerm = this.termStack.peek();
                temp = StringUtils.restoreEntity(temp);
                indexTerm.setTermKey(StringUtils.setOrAppend(indexTerm.getTermKey(), temp, false));
            } else if (this.inTitleElement) {
                temp = StringUtils.restoreEntity(temp);
                this.title = StringUtils.setOrAppend(this.title, temp, false);
            }
        }
    }

    public void endDocument() throws SAXException {
        int size = this.indexTermList.size();
        this.updateIndexTermTargetName();
        for (int i = 0; i < size; ++i) {
            IndexTerm indexterm = this.indexTermList.get(i);
            IndexTermCollection.getInstantce().addTerm(indexterm);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        IndexTerm parentTerm;
        IndexTerm term;
        if (this.processRoleLevel > 0) {
            String role = this.processRoleStack.peek();
            if (this.processRoleLevel == this.processRoleStack.size()) {
                role = this.processRoleStack.pop();
            }
            --this.processRoleLevel;
            if ("resource-only".equalsIgnoreCase(role)) {
                return;
            }
        }
        if (this.indexTermSpecList.contains(localName)) {
            term = this.termStack.pop();
            if (term.getTermName() == null || term.getTermName().trim().equals("")) {
                if (term.getEndAttribute() != null && !term.hasSubTerms()) {
                    return;
                }
                term.setTermName("***");
                this.javaLogger.logWarn(MessageUtils.getMessage("DOTJ014W").toString());
            }
            if (term.getTermKey() == null) {
                term.setTermKey(term.getTermName());
            }
            if (term.isLeaf()) {
                IndexTermTarget target = this.genTarget();
                term.addTarget(target);
            }
            if (this.termStack.empty()) {
                this.indexTermList.add(term);
            } else {
                parentTerm = this.termStack.peek();
                parentTerm.addSubTerm(term);
            }
        }
        if (this.indexSeeSpecList.contains(localName) || this.indexSeeAlsoSpecList.contains(localName)) {
            term = this.termStack.pop();
            parentTerm = this.termStack.peek();
            if (term.getTermKey() == null) {
                term.setTermKey(term.getTermFullName());
            }
            term.addTarget(this.genTarget());
            parentTerm.addSubTerm(term);
        }
        if (this.titleSpecList.contains(localName)) {
            this.inTitleElement = false;
            if (!this.titleMap.containsKey(this.topicIdStack.peek())) {
                if (this.titleMap.size() == 0) {
                    this.defaultTitle = this.title;
                }
                this.titleMap.put(this.topicIdStack.peek(), this.title);
            }
        }
        if (this.indexSortAsSpecList.contains(localName)) {
            this.insideSortingAs = false;
        }
        if (this.topicSpecList.contains(localName)) {
            this.topicIdStack.pop();
        }
    }

    private IndexTermTarget genTarget() {
        IndexTermTarget target = new IndexTermTarget();
        String fragment = null;
        fragment = this.topicIdStack.peek() == null ? null : this.topicIdStack.peek().toString();
        if (this.title != null) {
            target.setTargetName(this.title);
        } else {
            target.setTargetName(this.targetFile);
        }
        if (fragment != null) {
            target.setTargetURI(this.targetFile + "#" + fragment);
        } else {
            target.setTargetURI(this.targetFile);
        }
        return target;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String xmlLang;
        String attrValue = attributes.getValue("processing-role");
        if (attrValue != null) {
            this.processRoleStack.push(attrValue);
            ++this.processRoleLevel;
            if ("resource-only".equals(attrValue)) {
                return;
            }
        } else if (this.processRoleLevel > 0) {
            ++this.processRoleLevel;
            if ("resource-only".equals(this.processRoleStack.peek())) {
                return;
            }
        }
        String classAttr = attributes.getValue("class");
        this.handleSpecialization(localName, classAttr);
        this.parseTopic(localName, attributes.getValue("id"));
        this.parseIndexTerm(localName, attributes);
        this.parseIndexSee(localName);
        this.parseIndexSeeAlso(localName);
        if (IndexTerm.getTermLocale() == null && (xmlLang = attributes.getValue("xml:lang")) != null) {
            IndexTerm.setTermLocale(StringUtils.getLocale(xmlLang));
        }
        if (this.titleSpecList.contains(localName) && !this.titleMap.containsKey(this.topicIdStack.peek())) {
            this.inTitleElement = true;
            this.title = null;
        }
        if (this.indexSortAsSpecList.contains(localName)) {
            this.insideSortingAs = true;
        }
    }

    private void parseTopic(String localName, String id) {
        if (this.topicSpecList.contains(localName)) {
            this.topicIdStack.push(id);
        }
    }

    private void parseIndexSeeAlso(String localName) {
        if (this.indexSeeAlsoSpecList.contains(localName)) {
            IndexTerm indexTerm = new IndexTerm();
            IndexTerm parentTerm = null;
            if (!this.termStack.isEmpty() && (parentTerm = this.termStack.peek()).hasSubTerms()) {
                parentTerm.updateSubTerm();
            }
            indexTerm.setTermPrefix("See also");
            this.termStack.push(indexTerm);
        }
    }

    private void parseIndexSee(String localName) {
        if (this.indexSeeSpecList.contains(localName)) {
            IndexTerm indexTerm = new IndexTerm();
            IndexTerm parentTerm = null;
            indexTerm.setTermPrefix("See");
            if (!this.termStack.isEmpty() && (parentTerm = this.termStack.peek()).hasSubTerms()) {
                parentTerm.updateSubTerm();
                indexTerm.setTermPrefix("See also");
            }
            this.termStack.push(indexTerm);
        }
    }

    private void parseIndexTerm(String localName, Attributes attributes) {
        if (this.indexTermSpecList.contains(localName)) {
            IndexTerm indexTerm = new IndexTerm();
            indexTerm.setStartAttribute(attributes.getValue("end"));
            indexTerm.setEndAttribute(attributes.getValue("end"));
            IndexTerm parentTerm = null;
            if (!this.termStack.isEmpty() && (parentTerm = this.termStack.peek()).hasSubTerms()) {
                parentTerm.updateSubTerm();
            }
            this.termStack.push(indexTerm);
        }
    }

    private void handleSpecialization(String localName, String classAttr) {
        if (classAttr == null) {
            return;
        }
        if (classAttr.indexOf(" topic/indexterm ") != -1) {
            if (!this.indexTermSpecList.contains(localName)) {
                this.indexTermSpecList.add(localName);
            }
        } else if (classAttr.indexOf(" indexing-d/index-see-also ") != -1) {
            if (!this.indexSeeAlsoSpecList.contains(localName)) {
                this.indexSeeAlsoSpecList.add(localName);
            }
        } else if (classAttr.indexOf(" indexing-d/index-see ") != -1) {
            if (!this.indexSeeSpecList.contains(localName)) {
                this.indexSeeSpecList.add(localName);
            }
        } else if (classAttr.indexOf(" indexing-d/index-sort-as ") != -1) {
            if (!this.indexSortAsSpecList.contains(localName)) {
                this.indexSortAsSpecList.add(localName);
            }
        } else if (classAttr.indexOf(" topic/topic ") != -1) {
            if (!this.topicSpecList.contains(localName)) {
                this.topicSpecList.add(localName);
            }
        } else if (classAttr.indexOf(" topic/title ") != -1 && !this.titleSpecList.contains(localName)) {
            this.titleSpecList.add(localName);
        }
    }

    public void setTargetFile(String target) {
        this.targetFile = target;
    }

    private void updateIndexTermTargetName() {
        int size = this.indexTermList.size();
        if (this.defaultTitle == null) {
            this.defaultTitle = this.targetFile;
        }
        for (int i = 0; i < size; ++i) {
            IndexTerm indexterm = this.indexTermList.get(i);
            this.updateIndexTermTargetName(indexterm);
        }
    }

    private void updateIndexTermTargetName(IndexTerm indexterm) {
        int i;
        int targetSize = indexterm.getTargetList().size();
        int subtermSize = indexterm.getSubTerms().size();
        for (i = 0; i < targetSize; ++i) {
            String fragment;
            IndexTermTarget target = (IndexTermTarget)indexterm.getTargetList().get(i);
            String uri = target.getTargetURI();
            int indexOfSharp = uri.lastIndexOf("#");
            String string = fragment = indexOfSharp == -1 || uri.endsWith("#") ? null : uri.substring(indexOfSharp + 1);
            if (fragment != null && this.titleMap.containsKey(fragment)) {
                target.setTargetName(this.titleMap.get(fragment).toString());
                continue;
            }
            target.setTargetName(this.defaultTitle);
        }
        for (i = 0; i < subtermSize; ++i) {
            IndexTerm subterm = (IndexTerm)indexterm.getSubTerms().get(i);
            this.updateIndexTermTargetName(subterm);
        }
    }
}

