/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.io.File;
import java.io.FileOutputStream;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.dita.dost.exception.DITAOTXMLErrorHandler;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.module.Content;
import org.dita.dost.module.ContentImpl;
import org.dita.dost.reader.AbstractReader;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapMetaReader
implements AbstractReader {
    private static final String INTERNET_LINK_MARK = "://";
    private static Hashtable<String, Hashtable<String, Element>> resultTable = null;
    private static HashSet<String> uniqueSet = new HashSet(16);
    private static HashSet<String> cascadeSet;
    private static HashSet<String> metaSet;
    private static Vector<String> metaPos;
    private DITAOTJavaLogger javaLogger = new DITAOTJavaLogger();
    private Hashtable<String, Element> globalMeta = new Hashtable(16);
    private Document doc = null;
    private String filePath = null;

    public MapMetaReader() {
        resultTable = new Hashtable(16);
    }

    @Override
    public void read(String filename) {
        File inputFile = new File(filename);
        this.filePath = inputFile.getParent();
        inputFile.getPath();
        this.globalMeta.clear();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new DITAOTXMLErrorHandler(filename));
            this.doc = builder.parse(inputFile);
            Element root = this.doc.getDocumentElement();
            NodeList list = root.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                Node classAttr = null;
                if (node.getNodeType() == 1) {
                    classAttr = node.getAttributes().getNamedItem("class");
                }
                if (classAttr != null && classAttr.getNodeValue().indexOf(" map/topicmeta ") != -1) {
                    this.handleGlobalMeta(node);
                    continue;
                }
                if (classAttr == null || classAttr.getNodeValue().indexOf(" map/topicref ") == -1) continue;
                this.handleTopicref(node, this.globalMeta);
            }
            for (Hashtable<String, Element> resultTableEntry : resultTable.values()) {
                for (Map.Entry<String, Element> mapEntry : resultTableEntry.entrySet()) {
                    String key = mapEntry.getKey();
                    if (!" topic/keywords ".equals(key)) continue;
                    this.removeIndexTermRecursive(mapEntry.getValue());
                }
            }
            FileOutputStream file = new FileOutputStream(inputFile.getCanonicalPath() + ".temp");
            StreamResult res = new StreamResult(file);
            DOMSource ds = new DOMSource(this.doc);
            TransformerFactory tff = TransformerFactory.newInstance();
            Transformer tf = tff.newTransformer();
            tf.transform(ds, res);
            if (res.getOutputStream() != null) {
                res.getOutputStream().close();
            }
            if (file != null) {
                file.close();
            }
        }
        catch (Exception e) {
            this.javaLogger.logException(e);
        }
    }

    private void removeIndexTermRecursive(Element parent) {
        if (parent == null) {
            return;
        }
        NodeList children = parent.getChildNodes();
        Element child = null;
        for (int i = 0; i < children.getLength(); ++i) {
            boolean hasEnd;
            if (children.item(i).getNodeType() != 1) continue;
            child = (Element)children.item(i);
            boolean isIndexTerm = child.getAttribute("class").contains(" topic/indexterm ");
            boolean hasStart = !StringUtils.isEmptyString(child.getAttribute("start"));
            boolean bl = hasEnd = !StringUtils.isEmptyString(child.getAttribute("end"));
            if (isIndexTerm && (hasStart || hasEnd)) {
                parent.removeChild(child);
                continue;
            }
            this.removeIndexTermRecursive(child);
        }
    }

    private void handleTopicref(Node topicref, Hashtable<String, Element> inheritance) {
        Node hrefAttr = topicref.getAttributes().getNamedItem("href");
        Node copytoAttr = topicref.getAttributes().getNamedItem("copy-to");
        Node scopeAttr = topicref.getAttributes().getNamedItem("scope");
        Node formatAttr = topicref.getAttributes().getNamedItem("format");
        Hashtable<String, Element> current = this.mergeMeta(null, inheritance, cascadeSet);
        String topicPath = null;
        Node metaNode = null;
        NodeList children = topicref.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            Node classAttr = null;
            if (node.getNodeType() == 1) {
                classAttr = node.getAttributes().getNamedItem("class");
            }
            if (classAttr != null && hrefAttr != null && classAttr.getNodeValue().indexOf(" map/topicmeta ") != -1 && hrefAttr != null && hrefAttr.getNodeValue().indexOf(INTERNET_LINK_MARK) == -1 && (scopeAttr == null || "local".equalsIgnoreCase(scopeAttr.getNodeValue())) && (formatAttr == null || "dita".equalsIgnoreCase(formatAttr.getNodeValue()))) {
                metaNode = node;
                current = this.handleMeta(node, inheritance);
                continue;
            }
            if (classAttr == null || classAttr.getNodeValue().indexOf(" map/topicref ") == -1) continue;
            this.handleTopicref(node, current);
        }
        if (!current.isEmpty() && hrefAttr != null) {
            topicPath = copytoAttr != null && new File(FileUtils.resolveFile(this.filePath, copytoAttr.getNodeValue())).exists() ? FileUtils.resolveTopic(this.filePath, copytoAttr.getNodeValue()) : FileUtils.resolveTopic(this.filePath, hrefAttr.getNodeValue());
            if (formatAttr == null || "dita".equalsIgnoreCase(formatAttr.getNodeValue())) {
                if (resultTable.containsKey(topicPath)) {
                    Hashtable<String, Element> previous = resultTable.get(topicPath);
                    resultTable.put(topicPath, this.mergeMeta(previous, current, metaSet));
                } else {
                    resultTable.put(topicPath, current);
                }
                Hashtable<String, Element> metas = resultTable.get(topicPath);
                if (!metas.isEmpty()) {
                    if (metaNode != null) {
                        topicref.removeChild(metaNode);
                    }
                    Element newMeta = this.doc.createElement("topicmeta");
                    newMeta.setAttribute("class", "- map/topicmeta ");
                    for (int i = 0; i < metaPos.size(); ++i) {
                        Node stub = metas.get(metaPos.get(i));
                        if (stub == null) continue;
                        NodeList clist = stub.getChildNodes();
                        for (int j = 0; j < clist.getLength(); ++j) {
                            newMeta.appendChild(topicref.getOwnerDocument().importNode(clist.item(j), true));
                        }
                    }
                    topicref.insertBefore(newMeta, topicref.getFirstChild());
                }
            }
        }
    }

    private Hashtable<String, Element> handleMeta(Node meta, Hashtable<String, Element> inheritance) {
        Hashtable<String, Element> topicMetaTable = new Hashtable<String, Element>(16);
        this.getMeta(meta, topicMetaTable);
        return this.mergeMeta(topicMetaTable, inheritance, cascadeSet);
    }

    private void getMeta(Node meta, Hashtable<String, Element> topicMetaTable) {
        NodeList children = meta.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            Node attr = null;
            if (node.getNodeType() == 1) {
                attr = node.getAttributes().getNamedItem("class");
            }
            if (attr == null) continue;
            String attrValue = attr.getNodeValue();
            String metaKey = attrValue.substring(1, attrValue.indexOf(" ", attrValue.indexOf("/")) + 1);
            if (attrValue.contains(" topic/metadata ")) {
                this.getMeta(node, topicMetaTable);
                continue;
            }
            if (topicMetaTable.containsKey(metaKey)) {
                topicMetaTable.get(metaKey).appendChild(node.cloneNode(true));
                continue;
            }
            Element stub = this.doc.createElement("stub");
            stub.appendChild(node.cloneNode(true));
            topicMetaTable.put(metaKey, stub);
        }
    }

    private Hashtable<String, Element> mergeMeta(Hashtable<String, Element> topicMetaTable, Hashtable<String, Element> inheritance, HashSet<String> enableSet) {
        if (topicMetaTable == null) {
            topicMetaTable = new Hashtable(16);
        }
        Node item = null;
        for (String key : enableSet) {
            Node inheritStub;
            if (!inheritance.containsKey(key)) continue;
            if (uniqueSet.contains(key)) {
                if (topicMetaTable.containsKey(key)) continue;
                topicMetaTable.put(key, inheritance.get(key));
                continue;
            }
            if (!topicMetaTable.containsKey(key)) {
                topicMetaTable.put(key, inheritance.get(key));
                continue;
            }
            Node stub = topicMetaTable.get(key);
            if (stub != (inheritStub = (Node)inheritance.get(key))) {
                NodeList children = inheritStub.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    item = children.item(i).cloneNode(true);
                    item = stub.getOwnerDocument().importNode(item, true);
                    stub.appendChild(item);
                }
            }
            topicMetaTable.put(key, (Element)stub);
        }
        return topicMetaTable;
    }

    private void handleGlobalMeta(Node metadata) {
        NodeList children = metadata.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            Node attr = null;
            if (node.getNodeType() == 1) {
                attr = node.getAttributes().getNamedItem("class");
            }
            if (attr == null) continue;
            String attrValue = attr.getNodeValue();
            String metaKey = attrValue.substring(1, attrValue.indexOf(" ", attrValue.indexOf("/")) + 1);
            if (attrValue.contains(" topic/metadata ")) {
                this.handleGlobalMeta(node);
                continue;
            }
            if (cascadeSet.contains(metaKey) && this.globalMeta.containsKey(metaKey)) {
                this.globalMeta.get(metaKey).appendChild(node.cloneNode(true));
                continue;
            }
            if (!cascadeSet.contains(metaKey)) continue;
            Element stub = this.doc.createElement("stub");
            stub.appendChild(node.cloneNode(true));
            this.globalMeta.put(metaKey, stub);
        }
    }

    @Override
    public Content getContent() {
        ContentImpl result = new ContentImpl();
        result.setCollection(resultTable.entrySet());
        return result;
    }

    static {
        uniqueSet.add(" topic/critdates ");
        uniqueSet.add(" topic/permissions ");
        uniqueSet.add(" topic/publisher ");
        uniqueSet.add(" topic/source ");
        uniqueSet.add(" map/searchtitle ");
        cascadeSet = new HashSet(16);
        cascadeSet.add(" topic/audience ");
        cascadeSet.add(" topic/author ");
        cascadeSet.add(" topic/category ");
        cascadeSet.add(" topic/copyright ");
        cascadeSet.add(" topic/critdates ");
        cascadeSet.add(" topic/permissions ");
        cascadeSet.add(" topic/prodinfo ");
        cascadeSet.add(" topic/publisher ");
        metaSet = new HashSet(16);
        metaSet.add(" map/searchtitle ");
        metaSet.add(" topic/author ");
        metaSet.add(" topic/source ");
        metaSet.add(" topic/publisher ");
        metaSet.add(" topic/copyright ");
        metaSet.add(" topic/critdates ");
        metaSet.add(" topic/permissions ");
        metaSet.add(" topic/audience ");
        metaSet.add(" topic/category ");
        metaSet.add(" topic/keywords ");
        metaSet.add(" topic/prodinfo ");
        metaSet.add(" topic/othermeta ");
        metaSet.add(" topic/resourceid ");
        metaSet.add(" topic/data ");
        metaSet.add(" topic/data-about ");
        metaSet.add(" topic/foreign ");
        metaSet.add(" topic/unknown ");
        metaPos = new Vector(16);
        metaPos.add(" map/searchtitle ");
        metaPos.add(" topic/author ");
        metaPos.add(" topic/source ");
        metaPos.add(" topic/publisher ");
        metaPos.add(" topic/copyright ");
        metaPos.add(" topic/critdates ");
        metaPos.add(" topic/permissions ");
        metaPos.add(" topic/audience ");
        metaPos.add(" topic/category ");
        metaPos.add(" topic/keywords ");
        metaPos.add(" topic/prodinfo ");
        metaPos.add(" topic/othermeta ");
        metaPos.add(" topic/resourceid ");
        metaPos.add(" topic/data ");
        metaPos.add(" topic/data-about ");
        metaPos.add(" topic/foreign ");
        metaPos.add(" topic/unknown ");
        metaPos.add(" map/linktext ");
        metaPos.add(" map/shortdesc ");
    }
}

