/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.log.MessageUtils;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterUtils {
    private static HashMap<String, String> filterMap = null;
    private static HashSet<String> notMappingRules = new HashSet();

    private FilterUtils() {
    }

    public static void setFilterMap(HashMap<String, String> filtermap) {
        filterMap = filtermap;
    }

    public static HashMap<String, String> getFilterMap() {
        return filterMap;
    }

    public static boolean needExclude(Attributes atts, String extProps) {
        boolean ret = false;
        boolean extRet = false;
        StringTokenizer prop = null;
        StringTokenizer propPathTokenizer = null;
        String propName = null;
        String propValue = null;
        String propPath = null;
        ArrayList<String> propList = null;
        int propListIndex = 0;
        String attrPropsValue = null;
        if (filterMap == null) {
            return false;
        }
        boolean bl = ret = FilterUtils.checkExclude("audience", atts.getValue("audience")) || FilterUtils.checkExclude("platform", atts.getValue("platform")) || FilterUtils.checkExclude("product", atts.getValue("product")) || FilterUtils.checkExclude("otherprops", atts.getValue("otherprops"));
        if (extProps == null) {
            return ret;
        }
        prop = new StringTokenizer(extProps, ",");
        while (prop.hasMoreElements()) {
            propPath = (String)prop.nextElement();
            propPathTokenizer = new StringTokenizer(propPath, " ");
            propList = new ArrayList<String>(128);
            while (propPathTokenizer.hasMoreElements()) {
                propList.add((String)propPathTokenizer.nextElement());
            }
            propListIndex = propList.size() - 1;
            propName = (String)propList.get(propListIndex);
            propValue = atts.getValue(propName);
            while (propValue == null && propListIndex > 0) {
                if ((attrPropsValue = atts.getValue((String)propList.get(--propListIndex))) == null) continue;
                int propStart = -1;
                if (attrPropsValue.startsWith(new StringBuffer(propName).append("(").toString(), 0) || attrPropsValue.indexOf(new StringBuffer(" " + propName).append("(").toString(), 0) != -1) {
                    propStart = attrPropsValue.indexOf(new StringBuffer(propName).append("(").toString());
                }
                if (propStart != -1) {
                    propStart = propStart + propName.length() + 1;
                }
                int propEnd = attrPropsValue.indexOf(")", propStart);
                if (propStart == -1 || propEnd == -1) continue;
                propValue = attrPropsValue.substring(propStart, propEnd).trim();
            }
            extRet = extRet || FilterUtils.extCheckExclude(propList, propValue);
        }
        return ret || extRet;
    }

    private static boolean extCheckExclude(List<String> propList, String attValue) {
        int propListIndex = 0;
        boolean hasNullAction = false;
        boolean hasExcludeAction = false;
        StringTokenizer tokenizer = null;
        String attName = null;
        if (attValue == null || attValue.trim().length() == 0 || propList.size() == 0 || attValue.indexOf("(") != -1) {
            return false;
        }
        FilterUtils.checkRuleMapping(propList.get(propListIndex), attValue);
        for (propListIndex = propList.size() - 1; propListIndex >= 0; --propListIndex) {
            hasNullAction = false;
            hasExcludeAction = false;
            tokenizer = new StringTokenizer(attValue, " ");
            attName = propList.get(propListIndex);
            while (tokenizer.hasMoreTokens()) {
                String attSubValue = tokenizer.nextToken();
                String filterKey = new StringBuffer().append(attName).append("=").append(attSubValue).toString();
                String filterAction = filterMap.get(filterKey);
                if (filterAction == null) {
                    String attDefaultAction = filterMap.get(attName);
                    if (attDefaultAction != null) {
                        if (!"exclude".equalsIgnoreCase(attDefaultAction)) {
                            return false;
                        }
                        hasExcludeAction = true;
                        if (!hasNullAction) continue;
                        if (FilterUtils.checkExcludeOfGlobalDefaultAction()) {
                            hasNullAction = false;
                            continue;
                        }
                        return false;
                    }
                    if (hasExcludeAction) {
                        if (FilterUtils.checkExcludeOfGlobalDefaultAction()) continue;
                        return false;
                    }
                    hasNullAction = true;
                    continue;
                }
                if ("exclude".equalsIgnoreCase(filterAction)) {
                    hasExcludeAction = true;
                    if (!hasNullAction) continue;
                    if (FilterUtils.checkExcludeOfGlobalDefaultAction()) {
                        hasNullAction = false;
                        continue;
                    }
                    return false;
                }
                return false;
            }
            if (hasNullAction) {
                if (0 != propListIndex) continue;
                return FilterUtils.checkExcludeOfGlobalDefaultAction();
            }
            if (!hasExcludeAction) continue;
            return true;
        }
        return false;
    }

    private static boolean checkExclude(String attName, String attValue) {
        if (attValue == null || attValue.trim().length() == 0) {
            return false;
        }
        FilterUtils.checkRuleMapping(attName, attValue);
        StringTokenizer tokenizer = new StringTokenizer(attValue, " ");
        while (tokenizer.hasMoreTokens()) {
            String attSubValue = tokenizer.nextToken();
            String filterKey = new StringBuffer().append(attName).append("=").append(attSubValue).toString();
            String filterAction = filterMap.get(filterKey);
            if (filterAction == null) {
                String attDefaultAction = filterMap.get(attName);
                if (attDefaultAction != null) {
                    filterAction = attDefaultAction;
                    if ("exclude".equalsIgnoreCase(attDefaultAction)) continue;
                    return false;
                }
                if (FilterUtils.checkExcludeOfGlobalDefaultAction()) continue;
                return false;
            }
            if ("exclude".equalsIgnoreCase(filterAction)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkExcludeOfGlobalDefaultAction() {
        String defaultAction = filterMap.get("default");
        if (defaultAction == null) {
            return false;
        }
        return "exclude".equalsIgnoreCase(defaultAction);
    }

    private static void checkRuleMapping(String attName, String attValue) {
        if (attValue == null || attValue.trim().length() == 0) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(attValue, " ");
        while (tokenizer.hasMoreTokens()) {
            String attSubValue = tokenizer.nextToken();
            String filterKey = new StringBuffer().append(attName).append("=").append(attSubValue).toString();
            String filterAction = filterMap.get(filterKey);
            if (filterAction != null) continue;
            FilterUtils.noRuleMapping(filterKey);
        }
    }

    private static void noRuleMapping(String notMappingKey) {
        if (!FilterUtils.alreadyShowed(notMappingKey)) {
            FilterUtils.showInfoOfNoRuleMapping(notMappingKey);
        }
    }

    private static void showInfoOfNoRuleMapping(String notMappingKey) {
        Properties prop = new Properties();
        prop.put("%1", notMappingKey);
        DITAOTJavaLogger javaLogger = new DITAOTJavaLogger();
        javaLogger.logInfo(MessageUtils.getMessage("DOTJ031I", prop).toString());
    }

    private static boolean alreadyShowed(String notMappingKey) {
        if (!notMappingRules.contains(notMappingKey)) {
            notMappingRules.add(notMappingKey);
            return false;
        }
        return true;
    }
}

