/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.index.IndexTerm;
import org.dita.dost.index.IndexTermTarget;
import org.dita.dost.module.Content;
import org.dita.dost.writer.AbstractWriter;
import org.dita.dost.writer.IDitaTranstypeIndexWriter;

public class CHMIndexWriter
implements AbstractWriter,
IDitaTranstypeIndexWriter {
    private List termList = null;

    public void setContent(Content content) {
        this.termList = (List)content.getCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream outputStream) throws UnsupportedEncodingException {
        PrintWriter printWriter = null;
        int termNum = this.termList.size();
        try {
            printWriter = new PrintWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            printWriter.println("<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML//EN\">");
            printWriter.println("<html>");
            printWriter.println("<head>");
            printWriter.println("<meta name=\"GENERATOR\" content=\"Microsoft&reg; HTML Help Workshop 4.1\">");
            printWriter.println("<!-- Sitemap 1.0 -->");
            printWriter.println("</head>");
            printWriter.println("<body>");
            printWriter.println("<ul>");
            for (int i = 0; i < termNum; ++i) {
                IndexTerm term = (IndexTerm)this.termList.get(i);
                this.outputIndexTerm(term, printWriter);
            }
            printWriter.println("</ul>");
            printWriter.println("</body>");
            printWriter.println("</html>");
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    public void write(String filename) throws DITAOTException {
        try {
            this.write(new FileOutputStream(filename));
        }
        catch (Exception e) {
            throw new DITAOTException(e);
        }
    }

    private void outputIndexTerm(IndexTerm term, PrintWriter printWriter) {
        int i;
        List targets = term.getTargetList();
        List subTerms = term.getSubTerms();
        int targetNum = targets.size();
        int subTermNum = subTerms.size();
        printWriter.println("<li> <object type=\"text/sitemap\">");
        printWriter.print("<param name=\"Name\" value=\"");
        printWriter.print(term.getTermFullName());
        printWriter.print("\">");
        printWriter.println();
        if (targets == null || targets.isEmpty()) {
            this.findTargets(term);
            targets = term.getTargetList();
            targetNum = targets.size();
        }
        for (i = 0; i < targetNum; ++i) {
            IndexTermTarget target = (IndexTermTarget)targets.get(i);
            printWriter.print("<param name=\"Name\" value=\"");
            printWriter.print(target.getTargetName());
            printWriter.print("\">");
            printWriter.println();
            printWriter.print("<param name=\"Local\" value=\"");
            printWriter.print(target.getTargetURI());
            printWriter.print("\">");
            printWriter.println();
        }
        printWriter.println("</object>");
        if (subTerms != null && subTermNum > 0) {
            printWriter.println("<ul>");
            for (i = 0; i < subTermNum; ++i) {
                IndexTerm subTerm = (IndexTerm)subTerms.get(i);
                this.outputIndexTerm(subTerm, printWriter);
            }
            printWriter.println("</ul>");
        }
        printWriter.println("</li>");
    }

    private void findTargets(IndexTerm term) {
        List subTerms = term.getSubTerms();
        List subTargets = null;
        if (subTerms != null && !subTerms.isEmpty()) {
            for (int i = 0; i < subTerms.size(); ++i) {
                IndexTerm subTerm = (IndexTerm)subTerms.get(i);
                subTargets = subTerm.getTargetList();
                if (subTargets != null && !subTargets.isEmpty()) {
                    term.addTargets(subTerm.getTargetList());
                } else {
                    this.findTargets(subTerm);
                }
                term.addTargets(subTerm.getTargetList());
            }
        }
    }

    public String getIndexFileName(String outputFileRoot) {
        StringBuffer indexFilename = new StringBuffer(outputFileRoot);
        indexFilename.append(".hhk");
        return indexFilename.toString();
    }
}

