/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import org.dita.dost.exception.DITAOTXMLErrorHandler;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.Content;
import org.dita.dost.module.DebugAndFilterModule;
import org.dita.dost.util.CatalogUtils;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DelayConrefUtils;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.FilterUtils;
import org.dita.dost.util.OutputUtils;
import org.dita.dost.util.StringUtils;
import org.dita.dost.writer.AbstractXMLWriter;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DitaWriter
extends AbstractXMLWriter {
    private static final String ATTRIBUTE_END = "\"";
    private static final String ATTRIBUTE_XTRC_START = " xtrc=\"";
    private static final String ATTRIBUTE_XTRF_START = " xtrf=\"";
    private static final String COLUMN_NAME_COL = "col";
    private static final String OS_NAME_WINDOWS = "windows";
    private static final String PI_END = "?>";
    private static final String PI_PATH2PROJ_HEAD = "<?path2project ";
    private static final String PI_WORKDIR_HEAD = "<?workdir ";
    private static final String NOT_LOCAL_URL = "://";
    private static final String ATTRIBUTE_XTRC = "xtrc";
    private static final String ATTRIBUTE_XTRF = "xtrf";
    private Document root = null;
    private String absolutePath;
    private static HashMap<String, String> catalogMap;
    private List<String> colSpec;
    private int columnNumber = 1;
    private int columnNumberEnd = 0;
    private Stack<List> colSpecStack;
    private int rowNumber = 0;
    private int totalColumns = 0;
    private Map<String, Integer> rowsMap = new HashMap<String, Integer>();
    private String transtype;
    private HashMap<String, Integer> counterMap;
    private boolean exclude = false;
    private int foreignLevel;
    private int level;
    private DITAOTJavaLogger logger;
    private boolean needResolveEntity;
    private OutputStreamWriter output;
    private String path2Project;
    private String props;
    private String tempDir;
    private String traceFilename;
    private boolean insideCDATA;
    private Map<String, String> keys = null;
    private HashMap<String, HashMap<String, HashSet<String>>> validateMap = null;
    private HashMap<String, HashMap<String, String>> defaultValueMap = null;
    private static XMLReader reader;
    private static String extName;

    private static boolean checkDITAHREF(Attributes atts) {
        String classValue = atts.getValue("class");
        String scopeValue = atts.getValue("scope");
        String formatValue = atts.getValue("format");
        if (classValue == null || classValue.indexOf(" topic/xref ") == -1 && classValue.indexOf(" topic/link ") == -1 && classValue.indexOf(" map/topicref ") == -1) {
            return false;
        }
        if (scopeValue == null) {
            scopeValue = "local";
        }
        if (formatValue == null) {
            formatValue = "dita";
        }
        return scopeValue.equalsIgnoreCase("local") && formatValue.equalsIgnoreCase("dita");
    }

    private static String replaceCONREF(Attributes atts) {
        String attValue = atts.getValue("conref");
        int sharp_index = attValue.lastIndexOf("#");
        int dot_index = attValue.lastIndexOf(".");
        if (sharp_index != -1 && dot_index < sharp_index) {
            File target;
            String path = attValue.substring(0, sharp_index);
            String topic = attValue.substring(sharp_index);
            if (!path.equals("") && (target = new File(path)).isAbsolute()) {
                String relativePath = FileUtils.getRelativePathFromMap(OutputUtils.getInputMapPathName(), path);
                attValue = relativePath + topic;
            }
        } else {
            File target = new File(attValue);
            if (target.isAbsolute()) {
                attValue = FileUtils.getRelativePathFromMap(OutputUtils.getInputMapPathName(), attValue);
            }
        }
        if (attValue != null) {
            attValue = attValue.replaceAll("\\\\", "/");
        }
        if (attValue.indexOf(".ditamap") == -1) {
            return FileUtils.replaceExtName(attValue, extName);
        }
        return attValue;
    }

    private static boolean notLocalURL(String valueOfURL) {
        return valueOfURL.indexOf(NOT_LOCAL_URL) != -1;
    }

    private static boolean warnOfNoneTopicFormat(Attributes attrs, String valueOfHref) {
        String hrefValue = valueOfHref;
        String formatValue = attrs.getValue("format");
        String classValue = attrs.getValue("class");
        String extOfHref = DitaWriter.getExtName(valueOfHref);
        DITAOTJavaLogger logger = new DITAOTJavaLogger();
        Properties params = new Properties();
        params.put("%1", hrefValue);
        if (DitaWriter.notLocalURL(hrefValue)) {
            return true;
        }
        if (classValue != null && classValue.contains(" pr-d/coderef ")) {
            return true;
        }
        if (formatValue == null && extOfHref != null && !extOfHref.equalsIgnoreCase("DITA") && !extOfHref.equalsIgnoreCase("XML")) {
            logger.logError(MessageUtils.getMessage("DOTJ028E", params).toString());
            return true;
        }
        return false;
    }

    public static String getExtName(String attValue) {
        int index = attValue.indexOf("#");
        if (attValue.startsWith("#")) {
            return null;
        }
        if (index != -1) {
            String fileName = attValue.substring(0, index);
            int fileExtIndex = fileName.lastIndexOf(".");
            return fileExtIndex != -1 ? fileName.substring(fileExtIndex + 1, fileName.length()) : null;
        }
        int fileExtIndex = attValue.lastIndexOf(".");
        return fileExtIndex != -1 ? attValue.substring(fileExtIndex + 1, attValue.length()) : null;
    }

    private static String replaceHREF(String attName, Attributes atts) {
        String attValue = null;
        if (attName == null) {
            return null;
        }
        attValue = atts.getValue(attName);
        if (attValue != null) {
            int dot_index = attValue.lastIndexOf(".");
            int sharp_index = attValue.lastIndexOf("#");
            if (sharp_index != -1 && dot_index < sharp_index) {
                File target;
                String path = attValue.substring(0, sharp_index);
                String topic = attValue.substring(sharp_index);
                if (!path.equals("") && (target = new File(path)).isAbsolute()) {
                    String relativePath = FileUtils.getRelativePathFromMap(OutputUtils.getInputMapPathName(), path);
                    attValue = relativePath + topic;
                }
            } else {
                File target = new File(attValue);
                if (target.isAbsolute()) {
                    attValue = FileUtils.getRelativePathFromMap(OutputUtils.getInputMapPathName(), attValue);
                }
            }
        } else {
            return null;
        }
        attValue = attValue.replaceAll("\\\\", "/");
        if (DitaWriter.checkDITAHREF(atts) && !DitaWriter.warnOfNoneTopicFormat(atts, attValue)) {
            return FileUtils.replaceExtName(attValue, extName);
        }
        return attValue;
    }

    public DitaWriter() {
        catalogMap = CatalogUtils.getCatalog(null);
        this.absolutePath = null;
        this.path2Project = null;
        this.counterMap = null;
        this.traceFilename = null;
        this.foreignLevel = 0;
        this.level = 0;
        this.needResolveEntity = false;
        this.insideCDATA = false;
        this.output = null;
        this.tempDir = null;
        this.colSpec = null;
        this.colSpecStack = new Stack();
        this.props = null;
        this.validateMap = null;
        this.logger = new DITAOTJavaLogger();
        reader.setContentHandler(this);
        try {
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            reader.setFeature("http://apache.org/xml/features/scanner/notify-char-refs", true);
            reader.setFeature("http://apache.org/xml/features/scanner/notify-builtin-refs", true);
        }
        catch (SAXNotRecognizedException e1) {
            this.logger.logException(e1);
        }
        catch (SAXNotSupportedException e1) {
            this.logger.logException(e1);
        }
        reader.setEntityResolver((EntityResolver)CatalogUtils.getCatalogResolver());
    }

    public static void initXMLReader(String ditaDir, boolean validate) throws SAXException {
        DITAOTJavaLogger logger = new DITAOTJavaLogger();
        if (System.getProperty("org.xml.sax.driver") == null) {
            StringUtils.initSaxDriver();
        }
        try {
            reader = XMLReaderFactory.createXMLReader();
            reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            if (validate) {
                reader.setFeature("http://xml.org/sax/features/validation", true);
                reader.setFeature("http://apache.org/xml/features/validation/schema", true);
            }
            reader.setFeature("http://xml.org/sax/features/namespaces", true);
        }
        catch (Exception e) {
            logger.logException(e);
        }
        CatalogUtils.setDitaDir(ditaDir);
        catalogMap = CatalogUtils.getCatalog(ditaDir);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String test = new String(ch, start, length);
        if (!this.exclude && this.needResolveEntity) {
            try {
                if (this.insideCDATA) {
                    this.output.write(ch, start, length);
                } else {
                    this.output.write(StringUtils.escapeXML(ch, start, length));
                }
            }
            catch (Exception e) {
                this.logger.logException(e);
            }
        }
    }

    private void copyAttribute(String attQName, String attValue) throws IOException {
        this.output.write(new StringBuffer().append(" ").append(attQName).append("=").append(ATTRIBUTE_END).append(attValue).append(ATTRIBUTE_END).toString());
    }

    private void copyElementAttribute(String qName, Attributes atts) throws IOException {
        int attsLen = atts.getLength();
        boolean conkeyrefValid = false;
        for (int i = 0; i < attsLen; ++i) {
            String defaultValue;
            HashMap<String, String> defaultMap;
            String attQName = atts.getQName(i);
            String attValue = atts.getValue(i);
            String nsUri = atts.getURI(i);
            if (attQName.equals(ATTRIBUTE_XTRF) || attQName.equals(ATTRIBUTE_XTRC)) continue;
            if (StringUtils.isEmptyString(attValue) && this.defaultValueMap != null && (defaultMap = this.defaultValueMap.get(attQName)) != null && (defaultValue = defaultMap.get(qName)) != null) {
                attValue = defaultValue;
            }
            attValue = "href".equals(attQName) || "copy-to".equals(attQName) ? (atts.getValue("scope") != null && (atts.getValue("scope").equalsIgnoreCase("external") || atts.getValue("scope").equalsIgnoreCase("peer")) ? atts.getValue(i) : DitaWriter.replaceHREF(attQName, atts)) : ("conref".equals(attQName) ? DitaWriter.replaceCONREF(atts) : atts.getValue(i));
            if ("DITAArchVersion".equals(attQName)) {
                String attName = "ditaarch:" + attQName;
                this.copyAttribute(attName, attValue);
                this.copyAttribute("xmlns:ditaarch", nsUri);
            }
            if ("conkeyref".equals(attQName) && !attValue.equals("")) {
                int sharpIndex = attValue.indexOf("#");
                int slashIndex = attValue.indexOf("/");
                int keyIndex = -1;
                if (sharpIndex != -1) {
                    keyIndex = sharpIndex;
                } else if (slashIndex != -1) {
                    keyIndex = slashIndex;
                }
                if (keyIndex != -1) {
                    String key = attValue.substring(0, keyIndex);
                    if (!key.equals("") && this.keys.containsKey(key)) {
                        String href = this.keys.get(key);
                        href = FileUtils.normalizeDirectory(null, href);
                        href = href.replace("\\", "/");
                        String id = attValue.substring(keyIndex + 1);
                        boolean idExported = false;
                        boolean keyrefExported = false;
                        List<Boolean> list = null;
                        if (this.transtype.equals("eclipsehelp")) {
                            list = DelayConrefUtils.getInstance().checkExport(href, id, key, this.tempDir);
                            idExported = list.get(0);
                            keyrefExported = list.get(1);
                        }
                        if (idExported && keyrefExported && this.transtype.equals("eclipsehelp")) {
                            this.copyAttribute("conkeyref", attValue);
                        } else {
                            String tail;
                            String target = this.keys.get(key);
                            target = FileUtils.replaceExtName(target, extName);
                            if (sharpIndex == -1) {
                                tail = target.indexOf("#") == -1 ? attValue.substring(keyIndex).replaceAll("/", "#") : attValue.substring(keyIndex);
                            } else {
                                tail = attValue.substring(keyIndex);
                                if (target.indexOf("#") != -1) {
                                    target = target.substring(0, target.indexOf("#"));
                                }
                            }
                            this.copyAttribute("conref", target + tail);
                            conkeyrefValid = true;
                        }
                    } else {
                        Properties prop = new Properties();
                        prop.setProperty("%1", attValue);
                        this.logger.logError(MessageUtils.getMessage("DOTJ046E", prop).toString());
                    }
                } else if (this.keys.containsKey(attValue)) {
                    String href = this.keys.get(attValue);
                    href = FileUtils.normalizeDirectory(null, href);
                    href = href.replace("\\", "/");
                    String id = null;
                    List<Boolean> list = DelayConrefUtils.getInstance().checkExport(href, id, attValue, this.tempDir);
                    boolean keyrefExported = list.get(1);
                    if (keyrefExported && this.transtype.equals("eclipsehelp")) {
                        this.copyAttribute("conkeyref", attValue);
                    } else {
                        String target = this.keys.get(attValue);
                        this.copyAttribute("conref", FileUtils.replaceExtName(target, extName));
                        conkeyrefValid = true;
                    }
                } else {
                    Properties prop = new Properties();
                    prop.setProperty("%1", attValue);
                    this.logger.logError(MessageUtils.getMessage("DOTJ046E", prop).toString());
                }
            }
            attValue = StringUtils.escapeXML(attValue);
            if ("colname".equals(attQName) || "namest".equals(attQName) || "DITAArchVersion".equals(attQName) || "nameend".equals(attQName) || "conkeyref".equals(attQName) || "conref".equals(attQName)) continue;
            this.copyAttribute(attQName, attValue);
        }
        String conref = atts.getValue("conref");
        if (conref != null && !conkeyrefValid) {
            conref = DitaWriter.replaceCONREF(atts);
            conref = StringUtils.escapeXML(conref);
            this.copyAttribute("conref", conref);
        }
    }

    private void copyElementName(String qName, Attributes atts) throws IOException {
        this.output.write("<" + qName);
        if ("tgroup".equals(qName)) {
            this.columnNumber = 1;
            this.columnNumberEnd = 0;
            this.colSpec = new ArrayList<String>(16);
            this.colSpecStack.push(this.colSpec);
        } else if ("row".equals(qName)) {
            this.columnNumber = 1;
            this.columnNumberEnd = 0;
            ++this.rowNumber;
        } else if ("colspec".equals(qName)) {
            this.columnNumber = this.columnNumberEnd + 1;
            if (atts.getValue("colname") != null) {
                this.colSpec.add(atts.getValue("colname"));
            } else {
                this.colSpec.add(COLUMN_NAME_COL + this.columnNumber);
            }
            this.columnNumberEnd = this.columnNumber;
            this.copyAttribute("colname", COLUMN_NAME_COL + this.columnNumber);
            this.totalColumns = this.columnNumberEnd;
        } else if ("entry".equals(qName)) {
            this.columnNumber = this.getStartNumber(atts, this.columnNumberEnd);
            if (atts.getValue("morerows") != null) {
                String pos = String.valueOf(this.rowNumber) + String.valueOf(this.columnNumber);
                int total = Integer.parseInt(atts.getValue("morerows")) + this.rowNumber;
                this.rowsMap.put(pos, total);
            }
            if (this.columnNumber > this.columnNumberEnd) {
                if (this.rowNumber == 1) {
                    this.copyAttribute("colname", COLUMN_NAME_COL + this.columnNumber);
                    if (atts.getValue("namest") != null) {
                        this.copyAttribute("namest", COLUMN_NAME_COL + this.columnNumber);
                    }
                    if (atts.getValue("nameend") != null) {
                        this.copyAttribute("nameend", COLUMN_NAME_COL + this.getEndNumber(atts, this.columnNumber));
                    }
                } else {
                    boolean spanRows = false;
                    int offset = 0;
                    for (int row = 1; row < this.rowNumber; ++row) {
                        int totalSpanRows;
                        String pos = String.valueOf(row) + String.valueOf(this.columnNumber);
                        if (!this.rowsMap.containsKey(pos) || this.rowNumber > (totalSpanRows = this.rowsMap.get(pos).intValue())) continue;
                        spanRows = true;
                        ++offset;
                        break;
                    }
                    if (!spanRows) {
                        this.copyAttribute("colname", COLUMN_NAME_COL + this.columnNumber);
                        if (atts.getValue("namest") != null) {
                            this.copyAttribute("namest", COLUMN_NAME_COL + this.columnNumber);
                        }
                        if (atts.getValue("nameend") != null) {
                            this.copyAttribute("nameend", COLUMN_NAME_COL + this.getEndNumber(atts, this.columnNumber));
                        }
                    } else {
                        boolean shouldStopSearch = false;
                        block1: for (int col = this.columnNumber + 1; col <= this.totalColumns && !shouldStopSearch; ++col) {
                            for (int row = 1; row < this.rowNumber; ++row) {
                                int totalSpanRows;
                                String pos = String.valueOf(row) + String.valueOf(col);
                                if (this.rowsMap.containsKey(pos) && this.rowNumber <= (totalSpanRows = this.rowsMap.get(pos).intValue())) {
                                    ++offset;
                                    continue block1;
                                }
                                if (row != this.rowNumber - 1) continue;
                                shouldStopSearch = true;
                            }
                        }
                        this.copyAttribute("colname", COLUMN_NAME_COL + (this.columnNumber + offset));
                        if (atts.getValue("namest") != null) {
                            this.copyAttribute("namest", COLUMN_NAME_COL + (this.columnNumber + offset));
                        }
                        if (atts.getValue("nameend") != null) {
                            this.copyAttribute("nameend", COLUMN_NAME_COL + this.getEndNumber(atts, this.columnNumber + offset));
                        }
                    }
                }
            }
            this.columnNumberEnd = this.getEndNumber(atts, this.columnNumber);
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        this.insideCDATA = false;
        try {
            this.output.write("]]>");
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.output.flush();
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.foreignLevel > 0) {
            --this.foreignLevel;
        }
        if (this.exclude) {
            if (this.level > 0) {
                --this.level;
            } else {
                this.exclude = false;
            }
        } else {
            try {
                this.output.write("</" + qName + ">");
            }
            catch (Exception e) {
                this.logger.logException(e);
            }
        }
        if ("tgroup".equals(qName)) {
            this.colSpecStack.pop();
            this.colSpec = !this.colSpecStack.isEmpty() ? this.colSpecStack.peek() : null;
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        if (!this.needResolveEntity) {
            this.needResolveEntity = true;
        }
    }

    private int getEndNumber(Attributes atts, int columnStart) {
        if (atts.getValue("nameend") == null) {
            return columnStart;
        }
        int ret = this.colSpec.indexOf(atts.getValue("nameend")) + 1;
        if (ret == 0) {
            return columnStart;
        }
        return ret;
    }

    private int getStartNumber(Attributes atts, int previousEnd) {
        if (atts.getValue("colnum") != null) {
            return new Integer(atts.getValue("colnum"));
        }
        if (atts.getValue("namest") != null) {
            int ret = this.colSpec.indexOf(atts.getValue("namest")) + 1;
            if (ret == 0) {
                return previousEnd + 1;
            }
            return ret;
        }
        if (atts.getValue("colname") != null) {
            int ret = this.colSpec.indexOf(atts.getValue("colname")) + 1;
            if (ret == 0) {
                return previousEnd + 1;
            }
            return ret;
        }
        return previousEnd + 1;
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (!this.exclude) {
            try {
                this.output.write(ch, start, length);
            }
            catch (Exception e) {
                this.logger.logException(e);
            }
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (!this.exclude) {
            try {
                super.processingInstruction(target, data);
                String pi = data != null ? target + " " + data : target;
                this.output.write("<?" + pi + "?" + ">");
            }
            catch (Exception e) {
                this.logger.logException(e);
            }
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (catalogMap.get(publicId) != null) {
            File dtdFile = new File(catalogMap.get(publicId));
            return new InputSource(dtdFile.getAbsolutePath());
        }
        if (catalogMap.get(systemId) != null) {
            File schemaFile = new File(catalogMap.get(systemId));
            return new InputSource(schemaFile.getAbsolutePath());
        }
        return null;
    }

    @Override
    public void setContent(Content content) {
        this.tempDir = (String)content.getValue();
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (!this.exclude) {
            try {
                this.output.write(StringUtils.getEntity(name));
            }
            catch (Exception e) {
                this.logger.logException(e);
            }
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        try {
            this.insideCDATA = true;
            this.output.write("<![CDATA[");
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.output.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            this.output.write(Constants.LINE_SEPARATOR);
            if (Constants.OS_NAME.toLowerCase().indexOf(OS_NAME_WINDOWS) == -1) {
                this.output.write(PI_WORKDIR_HEAD + this.absolutePath + PI_END);
            } else {
                this.output.write("<?workdir /" + this.absolutePath + PI_END);
            }
            this.output.write(Constants.LINE_SEPARATOR);
            if (this.path2Project != null) {
                this.output.write(PI_PATH2PROJ_HEAD + this.path2Project + PI_END);
            } else {
                this.output.write("<?path2project ?>");
            }
            this.output.write(Constants.LINE_SEPARATOR);
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        Integer nextValue;
        String domains = null;
        Properties params = new Properties();
        String attrValue = atts.getValue("class");
        if (this.foreignLevel > 0) {
            ++this.foreignLevel;
        } else if (this.foreignLevel == 0) {
            if (attrValue == null && !"dita".equals(localName)) {
                params.clear();
                params.put("%1", localName);
                this.logger.logInfo(MessageUtils.getMessage("DOTJ030I", params).toString());
            }
            if (attrValue != null && attrValue.indexOf(" topic/topic ") != -1) {
                domains = atts.getValue("domains");
                if (domains == null) {
                    params.clear();
                    params.put("%1", localName);
                    this.logger.logInfo(MessageUtils.getMessage("DOTJ029I", params).toString());
                } else {
                    this.props = StringUtils.getExtProps(domains);
                }
            }
            if (attrValue != null && (attrValue.indexOf(" topic/foreign ") != -1 || attrValue.indexOf(" topic/unknown ") != -1)) {
                this.foreignLevel = 1;
            }
        }
        this.validateAttributeValues(qName, atts);
        if (this.counterMap.containsKey(qName)) {
            Integer value = this.counterMap.get(qName);
            nextValue = new Integer(value + 1);
            this.counterMap.put(qName, nextValue);
        } else {
            nextValue = new Integer(1);
            this.counterMap.put(qName, nextValue);
        }
        if (this.exclude) {
            ++this.level;
        } else if (this.foreignLevel <= 1 && FilterUtils.needExclude(atts, this.props)) {
            this.exclude = true;
            this.level = 0;
        } else {
            try {
                this.copyElementName(qName, atts);
                this.copyElementAttribute(qName, atts);
                if (this.foreignLevel <= 1) {
                    this.output.write(ATTRIBUTE_XTRF_START + this.traceFilename + ATTRIBUTE_END);
                    this.output.write(ATTRIBUTE_XTRC_START + qName + ":" + nextValue.toString() + ATTRIBUTE_END);
                }
                this.output.write(">");
            }
            catch (Exception e) {
                this.logger.logException(e);
            }
        }
    }

    @Override
    public void startEntity(String name) throws SAXException {
        if (!this.exclude) {
            try {
                this.needResolveEntity = StringUtils.checkEntity(name);
                if (!this.needResolveEntity) {
                    this.output.write(StringUtils.getEntity(name));
                }
            }
            catch (Exception e) {
                this.logger.logException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String filename) {
        FileOutputStream fileOutput = null;
        this.exclude = false;
        this.needResolveEntity = true;
        if (null == this.keys) {
            this.keys = new HashMap<String, String>();
            Properties prop = new Properties();
            if (!new File(this.tempDir).isAbsolute()) {
                this.tempDir = new File(this.tempDir).getAbsolutePath();
            }
            File ditafile = new File(this.tempDir, "dita.list");
            File ditaxmlfile = new File(this.tempDir, "dita.xml.properties");
            try {
                if (ditaxmlfile.exists()) {
                    prop.loadFromXML(new FileInputStream(ditaxmlfile));
                } else {
                    prop.load(new FileInputStream(ditafile));
                }
            }
            catch (Exception e) {
                this.logger.logException(e);
            }
            if (prop.getProperty("keylist") != "") {
                String[] keylist;
                for (String keyinfo : keylist = prop.getProperty("keylist").split(",")) {
                    String key = keyinfo.substring(0, keyinfo.indexOf("="));
                    String value = keyinfo.substring(keyinfo.indexOf("=") + 1, keyinfo.indexOf("("));
                    this.keys.put(key, value);
                }
            }
        }
        int index = filename.indexOf("|");
        int fileExtIndex = filename.endsWith(".ditamap") ? -1 : filename.lastIndexOf(".");
        try {
            StringBuffer outputFilename = new StringBuffer(this.tempDir + File.separator);
            if (index != -1) {
                this.traceFilename = filename.replace('|', File.separatorChar).replace('/', File.separatorChar).replace('\\', File.separatorChar);
                outputFilename.append(fileExtIndex == -1 || fileExtIndex <= index ? filename.substring(index + 1) : filename.substring(index + 1, fileExtIndex) + DebugAndFilterModule.extName);
                if (OutputUtils.getGeneratecopyouter() != 3) {
                    if (this.isOutFile(this.traceFilename)) {
                        this.path2Project = this.getRelativePathFromOut(this.traceFilename);
                    } else {
                        this.path2Project = FileUtils.getRelativePathFromMap(this.traceFilename, OutputUtils.getInputMapPathName());
                        this.path2Project = new File(this.path2Project).getParent();
                        if (this.path2Project != null && this.path2Project.length() > 0) {
                            this.path2Project = this.path2Project + File.separator;
                        }
                    }
                } else {
                    this.path2Project = FileUtils.getPathtoProject(filename.substring(index + 1));
                }
            } else {
                this.traceFilename = filename;
                outputFilename.append(fileExtIndex == -1 ? filename : filename.substring(0, fileExtIndex) + DebugAndFilterModule.extName);
                if (OutputUtils.getGeneratecopyouter() != 3) {
                    if (this.isOutFile(this.traceFilename)) {
                        this.path2Project = this.getRelativePathFromOut(this.traceFilename);
                    } else {
                        this.path2Project = FileUtils.getRelativePathFromMap(this.traceFilename, OutputUtils.getInputMapPathName());
                        this.path2Project = new File(this.path2Project).getParent();
                        if (this.path2Project != null && this.path2Project.length() > 0) {
                            this.path2Project = this.path2Project + File.separator;
                        }
                    }
                } else {
                    this.path2Project = FileUtils.getPathtoProject(filename);
                }
            }
            File outputFile = new File(outputFilename.toString());
            this.counterMap = new HashMap();
            File dirFile = outputFile.getParentFile();
            if (!dirFile.exists()) {
                dirFile.mkdirs();
            }
            this.absolutePath = dirFile.getCanonicalPath();
            fileOutput = new FileOutputStream(outputFile);
            this.output = new OutputStreamWriter((OutputStream)fileOutput, "UTF-8");
            reader.setErrorHandler(new DITAOTXMLErrorHandler(this.traceFilename));
            reader.parse(new InputSource(new FileInputStream(new File(this.traceFilename))));
            this.output.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.logException(e);
        }
        finally {
            try {
                fileOutput.close();
            }
            catch (Exception e) {
                this.logger.logException(e);
            }
        }
    }

    public String getRelativePathFromOut(String overflowingFile) {
        File mapPathName = new File(OutputUtils.getInputMapPathName());
        File currFilePathName = new File(overflowingFile);
        String relativePath = FileUtils.getRelativePathFromMap(mapPathName.toString(), currFilePathName.toString());
        String outputDir = OutputUtils.getOutputDir();
        StringBuffer outputPathName = new StringBuffer(outputDir).append(File.separator).append("index.html");
        String finalOutFilePathName = FileUtils.resolveFile(outputDir, relativePath);
        String finalRelativePathName = FileUtils.getRelativePathFromMap(finalOutFilePathName, outputPathName.toString());
        String parentDir = new File(finalRelativePathName).getParent();
        StringBuffer finalRelativePath = new StringBuffer(parentDir);
        if (finalRelativePath.length() > 0) {
            finalRelativePath.append(File.separator);
        } else {
            finalRelativePath.append(".").append(File.separator);
        }
        return finalRelativePath.toString();
    }

    private boolean isOutFile(String filePathName) {
        String relativePath = FileUtils.getRelativePathFromMap(OutputUtils.getInputMapPathName(), new File(filePathName).getPath());
        return relativePath != null && relativePath.length() != 0 && relativePath.startsWith("..");
    }

    private void validateAttributeValues(String qName, Attributes atts) {
        if (this.validateMap == null) {
            return;
        }
        Properties prop = new Properties();
        for (int i = 0; i < atts.getLength(); ++i) {
            String[] keylist;
            String attrName = atts.getQName(i);
            String attrValue = atts.getValue(i);
            HashMap<String, HashSet<String>> valueMap = this.validateMap.get(attrName);
            if (valueMap == null) continue;
            HashSet<String> valueSet = valueMap.get(qName);
            if (valueSet == null) {
                valueSet = valueMap.get("*");
            }
            if (valueSet == null) continue;
            for (String s : keylist = attrValue.trim().split("\\s+")) {
                if (StringUtils.isEmptyString(s) || valueSet.contains(s)) continue;
                prop.clear();
                prop.put("%1", attrName);
                prop.put("%2", qName);
                prop.put("%3", attrValue);
                prop.put("%4", StringUtils.assembleString(valueSet, ","));
                this.logger.logWarn(MessageUtils.getMessage("DOTJ049W", prop).toString());
            }
        }
    }

    public HashMap<String, HashMap<String, HashSet<String>>> getValidateMap() {
        return this.validateMap;
    }

    public void setValidateMap(HashMap<String, HashMap<String, HashSet<String>>> validateMap) {
        this.validateMap = validateMap;
    }

    public void setDefaultValueMap(HashMap<String, HashMap<String, String>> defaultMap) {
        this.defaultValueMap = defaultMap;
    }

    public String getTranstype() {
        return this.transtype;
    }

    public void setTranstype(String transtype) {
        this.transtype = transtype;
    }

    public String getExtName() {
        return extName;
    }

    public void setExtName(String extName) {
        DitaWriter.extName = extName;
    }

    static {
        reader = null;
    }
}

