/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.index.IndexTerm;
import org.dita.dost.index.IndexTermTarget;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.module.Content;
import org.dita.dost.writer.AbstractWriter;
import org.dita.dost.writer.IDitaTranstypeIndexWriter;

public class EclipseIndexWriter
implements AbstractWriter,
IDitaTranstypeIndexWriter {
    private List termList = null;
    private String filepath = null;
    private DITAOTJavaLogger javaLogger = new DITAOTJavaLogger();

    public void setContent(Content content) {
        this.termList = (List)content.getCollection();
    }

    public void setFilePath(String filePath) {
        this.filepath = filePath;
    }

    public String getFilePath() {
        return this.filepath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream outputStream) throws UnsupportedEncodingException {
        PrintWriter printWriter = null;
        int termNum = this.termList.size();
        try {
            printWriter = new PrintWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            printWriter.print("<?xml version='1.0' encoding='UTF-8' ?>");
            printWriter.print(System.getProperty("line.separator"));
            printWriter.print("<index>");
            printWriter.print(System.getProperty("line.separator"));
            for (int i = 0; i < termNum; ++i) {
                IndexTerm term = (IndexTerm)this.termList.get(i);
                this.outputIndexTerm(term, printWriter);
            }
            printWriter.print("</index>");
            printWriter.print(System.getProperty("line.separator"));
        }
        finally {
            printWriter.close();
        }
    }

    public void write(String filename) throws DITAOTException {
        try {
            this.write(new FileOutputStream(filename));
        }
        catch (Exception e) {
            throw new DITAOTException(e);
        }
    }

    private void outputIndexTerm(IndexTerm term, PrintWriter printWriter) {
        int i;
        List targets = term.getTargetList();
        List subTerms = term.getSubTerms();
        int targetNum = targets.size();
        int subTermNum = subTerms.size();
        String termPrefix = term.getTermPrefix();
        printWriter.print("<entry keyword=\"");
        printWriter.print(term.getTermFullName());
        printWriter.print("\">");
        printWriter.print(System.getProperty("line.separator"));
        if (targets != null && !targets.isEmpty()) {
            for (i = 0; i < targetNum; ++i) {
                IndexTermTarget target = (IndexTermTarget)targets.get(i);
                String targetUri = target.getTargetURI();
                String targetName = target.getTargetName();
                if (targetUri == null) {
                    this.javaLogger.logDebug("Term for " + target.getTargetName() + " does not have a target");
                    printWriter.print("<topic");
                    printWriter.print(" title=\"");
                    printWriter.print(target.getTargetName());
                    printWriter.print("\"/>");
                    printWriter.print(System.getProperty("line.separator"));
                    continue;
                }
                if (targetName == null) continue;
                printWriter.print("<topic href=\"");
                printWriter.print(this.replaceExtName(targetUri));
                printWriter.print("\"");
                if (targetName.trim().length() > 0) {
                    printWriter.print(" title=\"");
                    printWriter.print(target.getTargetName());
                    printWriter.print("\"");
                }
                printWriter.print("/>");
                printWriter.print(System.getProperty("line.separator"));
            }
        }
        if (subTerms != null && subTermNum > 0) {
            for (i = 0; i < subTermNum; ++i) {
                IndexTerm subTerm = (IndexTerm)subTerms.get(i);
                this.outputIndexTerm(subTerm, printWriter);
            }
        }
        printWriter.print("</entry>");
        printWriter.print(System.getProperty("line.separator"));
    }

    public String replaceExtName(String aFileName) {
        int index = aFileName.indexOf("#");
        if (aFileName.startsWith("#")) {
            return aFileName;
        }
        if (index != -1) {
            String fileName = aFileName.substring(0, index);
            int fileExtIndex = fileName.lastIndexOf(".");
            return fileExtIndex != -1 ? fileName.substring(0, fileExtIndex) + ".html" + aFileName.substring(index) : aFileName;
        }
        int fileExtIndex = aFileName.lastIndexOf(".");
        return fileExtIndex != -1 ? aFileName.substring(0, fileExtIndex) + ".html" : aFileName;
    }

    public String getIndexFileName(String outputFileRoot) {
        File indexDir = new File(outputFileRoot).getParentFile();
        this.setFilePath(indexDir.getAbsolutePath());
        StringBuffer indexFilename = new StringBuffer(new File(indexDir, "index.xml").getAbsolutePath());
        return indexFilename.toString();
    }
}

