/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.index.IndexTerm;
import org.dita.dost.index.IndexTermTarget;
import org.dita.dost.module.Content;
import org.dita.dost.writer.AbstractWriter;
import org.dita.dost.writer.IDitaTranstypeIndexWriter;

public class HTMLIndexWriter
implements AbstractWriter,
IDitaTranstypeIndexWriter {
    private List termList = null;

    public void setContent(Content content) {
        this.termList = (List)content.getCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream outputStream) throws UnsupportedEncodingException {
        PrintWriter printWriter = null;
        int termNum = this.termList.size();
        try {
            printWriter = new PrintWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            printWriter.println("<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML//EN\">");
            printWriter.println("<html>");
            printWriter.println("<head>");
            printWriter.println("<!-- Sitemap 1.0 -->");
            printWriter.println("</head>");
            printWriter.println("<body>");
            printWriter.println("<ul>");
            String printLetter = "A";
            for (int i = 0; i < termNum; ++i) {
                String firstLetter;
                IndexTerm term = (IndexTerm)this.termList.get(i);
                if (i == 0) {
                    printLetter = term.getTermFullName().substring(0, 1);
                    printWriter.println(printLetter);
                }
                if (!(firstLetter = term.getTermFullName().substring(0, 1)).equals(printLetter)) {
                    printLetter = firstLetter;
                    printWriter.println(printLetter);
                }
                this.outputIndexTerm(term, printWriter);
            }
            printWriter.println("</ul>");
            printWriter.println("</body>");
            printWriter.println("</html>");
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    public void write(String filename) throws DITAOTException {
        try {
            this.write(new FileOutputStream(filename));
        }
        catch (Exception e) {
            throw new DITAOTException(e);
        }
    }

    private void outputIndexTerm(IndexTerm term, PrintWriter printWriter) {
        List targets = term.getTargetList();
        List subTerms = term.getSubTerms();
        int targetNum = targets.size();
        int subTermNum = subTerms.size();
        printWriter.println("<li>");
        printWriter.println();
        if (targets == null || targets.isEmpty()) {
            this.findTargets(term);
            targets = term.getTargetList();
            targetNum = targets.size();
        }
        if (targetNum > 1) {
            printWriter.print(term.getTermFullName());
            printWriter.println();
        } else {
            IndexTermTarget target = (IndexTermTarget)targets.get(0);
            printWriter.print("<a href=\"");
            printWriter.print(target.getTargetURI());
            printWriter.print("\">");
            printWriter.print(term.getTermFullName());
            printWriter.print("</a>");
            printWriter.println();
        }
        if (subTerms != null && subTermNum > 0) {
            printWriter.println("<ul>");
            for (int i = 0; i < subTermNum; ++i) {
                IndexTerm subTerm = (IndexTerm)subTerms.get(i);
                this.outputIndexTerm(subTerm, printWriter);
            }
            printWriter.println("</ul>");
        }
        printWriter.println("</li>");
    }

    private void findTargets(IndexTerm term) {
        List subTerms = term.getSubTerms();
        List subTargets = null;
        if (subTerms != null && !subTerms.isEmpty()) {
            for (int i = 0; i < subTerms.size(); ++i) {
                IndexTerm subTerm = (IndexTerm)subTerms.get(i);
                subTargets = subTerm.getTargetList();
                if (subTargets != null && !subTargets.isEmpty()) {
                    this.findTargets(subTerm);
                }
                term.addTargets(subTerm.getTargetList());
            }
        }
    }

    public String getIndexFileName(String outputFileRoot) {
        StringBuffer indexFilename = new StringBuffer(outputFileRoot);
        indexFilename.append(".hhk");
        return indexFilename.toString();
    }
}

