/*
 * Decompiled with CFR 0.152.
 */
package jaxe;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import jaxe.Config;
import jaxe.DialogueRechercher;
import jaxe.JaxeDocument;
import jaxe.JaxeResourceBundle;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogueXpath
extends JFrame
implements ActionListener,
ItemListener,
CaretListener {
    private static final Logger LOG = Logger.getLogger(DialogueXpath.class);
    private static final ResourceBundle rb = JaxeResourceBundle.getRB();
    private JTextField textF;
    private ArrayList<Element> listeTousElements;
    private ArrayList<Element> listeElements;
    private DialogueRechercher dialRech;
    private JaxeDocument doc;
    private final JComboBox choix;
    private Element refElementCourant;
    private String nomElementCourant = "";
    private JTextField textInterne;
    private ZoneAttribut[] attributs;
    private String typeRechTxt;
    private final JPanel pane;
    private final JPanel listPane;
    private boolean existNS = false;

    public DialogueXpath(DialogueRechercher dialogueRechercher, JaxeDocument jaxeDocument) {
        super(rb.getString("xpath.ExprXpath"));
        this.dialRech = dialogueRechercher;
        this.doc = jaxeDocument;
        Element element = jaxeDocument.DOMdoc.getDocumentElement();
        if (element != null && element.getNamespaceURI() != null) {
            this.existNS = true;
        }
        this.pane = new JPanel();
        this.pane.setLayout(new BoxLayout(this.pane, 1));
        this.listPane = new JPanel(new FlowLayout());
        JLabel jLabel = new JLabel(rb.getString("xpath.TitreElt"));
        this.listeTousElements = jaxeDocument.cfg.listeTousElements();
        this.listeElements = this.triListingElt(this.listeTousElements);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Element element2 : this.listeElements) {
            if (this.existNS) {
                String string = jaxeDocument.cfg.prefixeElement(element2);
                if (string == null) {
                    arrayList.add(jaxeDocument.cfg.titreElement(element2));
                    continue;
                }
                arrayList.add(string + ":" + jaxeDocument.cfg.titreElement(element2));
                continue;
            }
            arrayList.add(jaxeDocument.cfg.titreElement(element2));
        }
        this.choix = new JComboBox<Object>(arrayList.toArray());
        if ("".equals(this.nomElementCourant)) {
            this.refElementCourant = this.listeElements.get(0);
            this.nomElementCourant = jaxeDocument.cfg.nomElement(this.refElementCourant);
        }
        this.choix.addItemListener(this);
        this.listPane.add(jLabel);
        this.listPane.add(this.choix);
        this.majAttPanel();
        this.majExprXpath();
        this.setContentPane(this.pane);
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DialogueXpath.this.dispose();
                DialogueXpath.this.dialRech.setVisible(true);
            }
        });
    }

    public void majAttPanel() {
        Object object;
        Object object2;
        Object object3;
        if (this.refElementCourant == null) {
            this.dispose();
            JOptionPane.showMessageDialog(this, rb.getString("xpath.ErrBalise"), rb.getString("xpath.Err"), 1);
            return;
        }
        Config config = this.doc.cfg.getRefConf(this.refElementCourant);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JLabel jLabel = new JLabel(rb.getString("xpath.IncludingText"));
        this.textInterne = new JTextField("");
        this.textInterne.addCaretListener(this);
        this.typeRechTxt = "contient";
        ButtonGroup buttonGroup = new ButtonGroup();
        JCheckBox jCheckBox = new JCheckBox(rb.getString("xpath.TexteExact"), false);
        buttonGroup.add(jCheckBox);
        jCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                DialogueXpath.this.typeRechTxt = "texte exact";
                DialogueXpath.this.majExprXpath();
            }
        });
        JCheckBox jCheckBox2 = new JCheckBox(rb.getString("xpath.Contient"), true);
        buttonGroup.add(jCheckBox2);
        jCheckBox2.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                DialogueXpath.this.typeRechTxt = "contient";
                DialogueXpath.this.majExprXpath();
            }
        });
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(jLabel);
        jPanel.add(Box.createHorizontalStrut(2));
        jPanel.add(this.textInterne);
        jPanel.add(jCheckBox);
        jPanel.add(jCheckBox2);
        jPanel.add(Box.createHorizontalStrut(5));
        JPanel jPanel2 = new JPanel();
        JScrollPane jScrollPane = new JScrollPane(jPanel2, 22, 31){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                if (dimension.height > 500) {
                    dimension.height = 500;
                }
                return dimension;
            }
        };
        jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        jScrollPane.setOpaque(false);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1, Color.white, new Color(70, 70, 70)), rb.getString("xpath.TitleAtt") + " \" " + config.nomElement(this.refElementCourant) + " \"", 1, 2));
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (Element object52 : this.listeTousElements) {
            if (this.nomElementCourant == null || !this.nomElementCourant.equals(config.nomElement(object52))) continue;
            for (Element element : config.listeAttributs(object52)) {
                object3 = config.nomAttribut(element);
                if (object3 == null) continue;
                boolean bl = false;
                object2 = arrayList.iterator();
                while (object2.hasNext()) {
                    object = (String[])object2.next();
                    if (!((String)object3).equals(config.nomAttribut((Element)object))) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                arrayList.add(element);
            }
        }
        int n = arrayList.size();
        this.attributs = new ZoneAttribut[n];
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (n == 0) {
            JLabel i = new JLabel(rb.getString("xpath.NoneAtt"));
            i.setForeground(Color.gray);
            jPanel2.add(i);
            jPanel2.add(Box.createVerticalStrut(30));
        }
        for (int jPanel3 = 0; jPanel3 < n; ++jPanel3) {
            ZoneAttribut zoneAttribut;
            this.attributs[jPanel3] = zoneAttribut = new ZoneAttribut();
            object3 = (Element)arrayList.get(jPanel3);
            zoneAttribut.nom = config.nomAttribut((Element)object3);
            zoneAttribut.titre = config.titreAttribut(this.refElementCourant, (Element)object3);
            JLabel jLabel2 = new JLabel(zoneAttribut.titre + " : ");
            zoneAttribut.valeurs = object2 = config.listeValeursAttribut((Element)object3);
            if (object2 != null && ((ArrayList)object2).size() > 0) {
                zoneAttribut.valeurs.add(0, "");
                object = new String[zoneAttribut.valeurs.size()];
                for (int i = 0; i < zoneAttribut.valeurs.size(); ++i) {
                    object[i] = config.titreValeurAttribut(this.refElementCourant, (Element)object3, zoneAttribut.valeurs.get(i));
                }
                zoneAttribut.champ = new JComboBox<String>((E[])object);
                ((JComboBox)zoneAttribut.champ).addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        DialogueXpath.this.majExprXpath();
                    }
                });
            } else {
                zoneAttribut.champ = new JTextField(42);
                ((JTextField)zoneAttribut.champ).addCaretListener(this);
            }
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = jPanel3;
            gridBagConstraints.anchor = 13;
            jPanel2.add((Component)jLabel2, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = jPanel3;
            gridBagConstraints.anchor = 17;
            jPanel2.add((Component)zoneAttribut.champ, gridBagConstraints);
            if (zoneAttribut.champ instanceof JTextField) {
                zoneAttribut.typeRech = "contient";
                object = new ButtonGroup();
                JCheckBox jCheckBox3 = new JCheckBox(rb.getString("xpath.MotExact"), false);
                ((ButtonGroup)object).add(jCheckBox3);
                jCheckBox3.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent itemEvent) {
                        zoneAttribut.typeRech = "mot exact";
                        DialogueXpath.this.majExprXpath();
                    }
                });
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = jPanel3;
                jPanel2.add((Component)jCheckBox3, gridBagConstraints);
                JCheckBox jCheckBox4 = new JCheckBox(rb.getString("xpath.Contient"), true);
                ((ButtonGroup)object).add(jCheckBox4);
                jCheckBox4.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent itemEvent) {
                        zoneAttribut.typeRech = "contient";
                        DialogueXpath.this.majExprXpath();
                    }
                });
                gridBagConstraints.gridx = 3;
                gridBagConstraints.gridy = jPanel3;
                jPanel2.add((Component)jCheckBox4, gridBagConstraints);
                continue;
            }
            zoneAttribut.typeRech = "mot exact";
        }
        JPanel jPanel3 = new JPanel(new FlowLayout());
        JLabel jLabel3 = new JLabel(rb.getString("xpath.Expr"));
        this.textF = new JTextField("", 55);
        this.textF.setEditable(false);
        this.textF.setForeground(Color.red);
        jPanel3.add(jLabel3);
        jPanel3.add(this.textF);
        object3 = new JPanel();
        JButton jButton = new JButton(rb.getString("xpath.Ok"));
        jButton.addActionListener(this);
        jButton.setActionCommand("OK");
        this.getRootPane().setDefaultButton(jButton);
        object2 = new JButton(rb.getString("xpath.Annuler"));
        ((AbstractButton)object2).addActionListener(this);
        ((AbstractButton)object2).setActionCommand("Annuler");
        ((Container)object3).add(jButton);
        ((Container)object3).add((Component)object2);
        this.pane.add(Box.createVerticalStrut(10));
        this.pane.add(this.listPane);
        this.pane.add(Box.createVerticalStrut(10));
        this.pane.add(jPanel);
        this.pane.add(Box.createVerticalStrut(10));
        this.pane.add(jScrollPane);
        this.pane.add(Box.createVerticalStrut(10));
        this.pane.add(jPanel3);
        this.pane.add(Box.createVerticalStrut(5));
        this.pane.add((Component)object3);
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        this.majExprXpath();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("OK".equals(string)) {
            this.dispose();
            this.dialRech.setTexteRecherche(this.textF.getText());
            this.dialRech.setVisible(true);
        } else if ("Annuler".equals(string)) {
            this.dispose();
            this.dialRech.setVisible(true);
        }
    }

    public void majExprXpath() {
        String string;
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.existNS) {
            string = this.doc.cfg.prefixeElement(this.refElementCourant);
            if (string != null) {
                stringBuilder.append("//");
                stringBuilder.append(string);
                stringBuilder.append(":");
                stringBuilder.append(this.nomElementCourant);
            } else {
                stringBuilder.append("//*[local-name()=\"");
                stringBuilder.append(this.nomElementCourant);
                stringBuilder.append("\"");
                bl = true;
            }
        } else {
            stringBuilder.append("//");
            stringBuilder.append(this.nomElementCourant);
        }
        string = this.textInterne.getText();
        if (!string.equals("")) {
            if (bl) {
                stringBuilder.append(" and ");
            } else {
                stringBuilder.append("[");
                bl = true;
            }
            if (this.typeRechTxt.equals("contient")) {
                stringBuilder.append("contains(.,\"");
                stringBuilder.append(string);
                stringBuilder.append("\")");
            } else {
                stringBuilder.append(".=\"");
                stringBuilder.append(string);
                stringBuilder.append("\"");
            }
        }
        for (ZoneAttribut zoneAttribut : this.attributs) {
            int n;
            String string2 = "";
            if (zoneAttribut.champ instanceof JTextField) {
                string2 = ((JTextField)zoneAttribut.champ).getText();
            } else if (zoneAttribut.champ instanceof JComboBox) {
                n = ((JComboBox)zoneAttribut.champ).getSelectedIndex();
                string2 = zoneAttribut.valeurs.get(n);
            }
            int n2 = n = !"".equals(string2) ? 1 : 0;
            if (n == 0) continue;
            if (bl) {
                stringBuilder.append(" and ");
            } else {
                stringBuilder.append("[");
                bl = true;
            }
            if (zoneAttribut.typeRech.equals("contient")) {
                stringBuilder.append("contains(@");
                stringBuilder.append(zoneAttribut.nom);
                stringBuilder.append(",\"");
                stringBuilder.append(string2);
                stringBuilder.append("\")");
                continue;
            }
            stringBuilder.append("@");
            stringBuilder.append(zoneAttribut.nom);
            stringBuilder.append("=\"");
            stringBuilder.append(string2);
            stringBuilder.append("\"");
        }
        if (bl) {
            stringBuilder.append("]");
        }
        this.textF.setText(stringBuilder.toString());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.choix && itemEvent.getStateChange() == 1) {
            this.refElementCourant = this.listeElements.get(this.choix.getSelectedIndex());
            this.nomElementCourant = this.doc.cfg.nomElement(this.refElementCourant);
            this.pane.removeAll();
            this.majAttPanel();
            this.pane.validate();
            this.majExprXpath();
            this.pack();
        }
    }

    private ArrayList<Element> triListingElt(ArrayList<Element> arrayList) {
        ArrayList<Element> arrayList2 = new ArrayList<Element>(arrayList);
        Collections.sort(arrayList2, new ComparateurDeTitres());
        ArrayList<Element> arrayList3 = new ArrayList<Element>();
        Element element = null;
        for (Element element2 : arrayList2) {
            if (element == null || !this.doc.cfg.nomElement(element).equals(this.doc.cfg.nomElement(element2))) {
                arrayList3.add(element2);
            } else {
                String string = this.doc.cfg.espaceElement(element);
                String string2 = this.doc.cfg.espaceElement(element2);
                if (!(string2 == null && string == null || string2 != null && string2.equals(string))) {
                    arrayList3.add(element2);
                }
            }
            element = element2;
        }
        return arrayList3;
    }

    class ZoneAttribut {
        JComponent champ;
        String nom;
        String titre;
        ArrayList<String> valeurs;
        String typeRech;

        ZoneAttribut() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ComparateurDeTitres
    implements Comparator<Element> {
        final String maj1 = "\u00d4\u00cf\u00ce\u00c0\u00c2\u00cb\u00ca\u00c8\u00c9";
        final String maj2 = "OIIAAEEEE";

        ComparateurDeTitres() {
        }

        @Override
        public int compare(Element element, Element element2) {
            String string = this.convertir(((DialogueXpath)DialogueXpath.this).doc.cfg.titreElement(element).toUpperCase().trim());
            String string2 = this.convertir(((DialogueXpath)DialogueXpath.this).doc.cfg.titreElement(element2).toUpperCase().trim());
            return string.compareToIgnoreCase(string2);
        }

        private String convertir(String string) {
            StringBuilder stringBuilder = new StringBuilder(string);
            for (int i = 0; i < stringBuilder.length(); ++i) {
                char c = stringBuilder.charAt(i);
                int n = "\u00d4\u00cf\u00ce\u00c0\u00c2\u00cb\u00ca\u00c8\u00c9".indexOf(c);
                if (n == -1) continue;
                stringBuilder.setCharAt(i, "OIIAAEEEE".charAt(n));
            }
            return stringBuilder.toString();
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof ComparateurDeTitres;
        }
    }
}

