/*
 * Decompiled with CFR 0.152.
 */
package jaxe.elements;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import jaxe.Balise;
import jaxe.Config;
import jaxe.DialogueAideElement;
import jaxe.ImageKeeper;
import jaxe.JaxeDocument;
import jaxe.JaxeElement;
import org.apache.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AffichageFormulaire
implements DocumentListener,
ItemListener {
    private static final Logger LOG = Logger.getLogger(AffichageFormulaire.class);
    private static final Color couleurErreur = new Color(200, 0, 0);
    private static final Color couleurObligatoire = new Color(150, 0, 0);
    private static final Color couleurFacultatif = new Color(0, 100, 0);
    private static final ImageIcon iconeAttributs = new ImageIcon(ImageKeeper.loadImage("images/attributs.gif", true));
    private static final int profondeurMax = 10;
    private final Element refNoeud;
    private Node noeud;
    private final boolean attribut;
    private final AffichageFormulaire affParent;
    private final JaxeDocument doc;
    private final Config cfg;
    private ArrayList<Node> enfants;
    private JComponent comp = null;
    private final ArrayList<Element> refEnfantsPossibles;
    private final ArrayList<Element> refAttributsPossibles;
    private JLabel labelTitre = null;
    private JPanel panelElement = null;
    private JPanel panelEnfants = null;
    private JPanel panelGauche = null;
    private JPanel panelDroite = null;
    private int profondeur;
    private ArrayList<AffichageFormulaire> affEnfants = null;
    private ArrayList<String> listeValeurs = null;

    public AffichageFormulaire(Element element, Element element2, AffichageFormulaire affichageFormulaire, JaxeDocument jaxeDocument) {
        this(element, element2, affichageFormulaire, jaxeDocument, false);
    }

    public AffichageFormulaire(Element element, Node node, AffichageFormulaire affichageFormulaire, JaxeDocument jaxeDocument, boolean bl) {
        this.refNoeud = element;
        this.noeud = node;
        this.affParent = affichageFormulaire;
        this.doc = jaxeDocument;
        this.cfg = !bl ? jaxeDocument.cfg.getRefConf(element) : affichageFormulaire.cfg;
        this.attribut = bl;
        this.profondeur = affichageFormulaire == null ? 0 : affichageFormulaire.getProfondeur() + 1;
        if (!bl) {
            this.refAttributsPossibles = this.cfg.listeAttributs(element);
            this.refEnfantsPossibles = this.cfg.listeSousElements(element);
        } else {
            this.refAttributsPossibles = null;
            this.refEnfantsPossibles = null;
        }
        this.lireEnfants();
    }

    private void lireEnfants() {
        if (this.attribut || this.noeud == null) {
            this.enfants = null;
            return;
        }
        this.enfants = new ArrayList();
        NamedNodeMap namedNodeMap = this.noeud.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            this.enfants.add(namedNodeMap.item(i));
        }
        NodeList nodeList = ((Element)this.noeud).getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            this.enfants.add(node);
        }
    }

    private boolean avecEnfants() {
        return this.refAttributsPossibles != null && this.refAttributsPossibles.size() > 0 || this.refEnfantsPossibles != null && this.refEnfantsPossibles.size() > 0;
    }

    public JPanel getPanel() {
        return this.getPanel(false);
    }

    private JPanel getPanel(boolean bl) {
        this.panelEnfants = new JPanel(new GridBagLayout());
        this.panelElement = new JPanel(new BorderLayout());
        if (!this.attribut && this.affParent != null && this.affParent.enfantsMultiples(this.refNoeud)) {
            JButton jButton;
            JPanel jPanel = new JPanel(new BorderLayout());
            if (bl) {
                jButton = new JButton("+");
                jButton.setAction(new AbstractAction("+"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        AffichageFormulaire.this.affParent.ajouterAffichageEnfant(AffichageFormulaire.this);
                    }
                });
                jPanel.add((Component)jButton, "West");
            }
            jButton = new JButton("-");
            jButton.setAction(new AbstractAction("-"){

                public void actionPerformed(ActionEvent actionEvent) {
                    AffichageFormulaire.this.affParent.retirerAffichageEnfant(AffichageFormulaire.this);
                }
            });
            jPanel.add((Component)jButton, "East");
            this.panelElement.add((Component)jPanel, "East");
            this.panelElement.add((Component)this.panelEnfants, "Center");
        } else {
            this.panelElement.add((Component)this.panelEnfants, "Center");
        }
        if (this.affParent != null) {
            this.panelElement.add((Component)this.getPanelTitre(), "North");
            this.panelEnfants.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.panelElement.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        }
        this.majPanel(null);
        if (this.affParent == null) {
            this.panelEnfants.setFocusCycleRoot(true);
            this.panelElement = new JPanel(new BorderLayout()){

                public Dimension getMaximumSize() {
                    if (System.getProperty("os.name").startsWith("Mac OS")) {
                        Dimension dimension = ((AffichageFormulaire)AffichageFormulaire.this).doc.textPane.getSize();
                        JaxeElement jaxeElement = AffichageFormulaire.this.doc.getElementForNode(AffichageFormulaire.this.noeud);
                        return new Dimension(dimension.width - 20 * (jaxeElement.indentations() + 1) - 2, dimension.height);
                    }
                    return super.getMaximumSize();
                }
            };
            this.panelElement.setOpaque(false);
            this.panelElement.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            this.panelEnfants.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.getTitre()), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.panelElement.add((Component)this.panelEnfants, "Center");
        }
        return this.panelElement;
    }

    private JPanel getPanelTitre() {
        JButton jButton = new JButton(new ActionAide(this.refNoeud));
        jButton.setFont(jButton.getFont().deriveFont(9.0f));
        if (System.getProperty("os.name").startsWith("Mac OS")) {
            jButton.setText("?");
            if ("10.5".compareTo(System.getProperty("os.version")) <= 0) {
                jButton.putClientProperty("JButton.buttonType", "help");
            } else {
                jButton.putClientProperty("JButton.buttonType", "toolbar");
            }
        } else {
            jButton.setIcon(new ImageIcon(ImageKeeper.loadImage("images/aide.png")));
            jButton.setMargin(new Insets(0, 0, 0, 0));
            jButton.setBorderPainted(false);
            jButton.setContentAreaFilled(false);
        }
        String string = this.getDocumentation();
        if (string != null) {
            jButton.setToolTipText(string);
        }
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        JLabel jLabel = new JLabel(this.getTitre());
        Color color = this.affParent != null ? (this.obligatoire() ? couleurObligatoire : couleurFacultatif) : this.panelEnfants.getForeground();
        jLabel.setForeground(color);
        jPanel.add(jLabel);
        jPanel.setBorder(BorderFactory.createEtchedBorder(0));
        JPanel jPanel2 = new JPanel(new FlowLayout(3, 0, 0));
        jPanel2.add(jPanel);
        return jPanel2;
    }

    private void majPanel(Element element) {
        this.lireEnfants();
        if (this.profondeur > 10) {
            return;
        }
        this.panelEnfants.removeAll();
        this.affEnfants = new ArrayList();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        if (!this.attribut) {
            Object object;
            Object object2;
            Object object3;
            for (Element element2 : this.refAttributsPossibles) {
                Node node = null;
                if (this.enfants != null) {
                    for (Node node2 : this.enfants) {
                        if (!(node2 instanceof Attr)) continue;
                        object3 = node2.getNodeName();
                        object2 = node2.getNamespaceURI();
                        boolean bl = ((String)object3).equals(this.cfg.nomAttribut(element2));
                        object = this.cfg.espaceAttribut(element2);
                        if (!(bl = bl && (object2 == null && object == null || object2 != null && ((String)object2).equals(object)))) continue;
                        node = node2;
                    }
                }
                AffichageFormulaire affichageFormulaire = new AffichageFormulaire(element2, node, this, this.doc, true);
                this.affEnfants.add(affichageFormulaire);
                this.placerAffichage(affichageFormulaire, this.panelEnfants, gridBagConstraints, n++, false);
            }
            for (Element element2 : this.refEnfantsPossibles) {
                boolean bl = false;
                if (this.enfants != null) {
                    int n2 = this.enfants.size();
                    for (int i = 0; i < n2; ++i) {
                        Node node;
                        object3 = this.enfants.get(i);
                        if (!(object3 instanceof Element) || (object2 = this.cfg.getElementRef((Element)object3)) != element2) continue;
                        AffichageFormulaire affichageFormulaire = new AffichageFormulaire((Element)object2, (Node)object3, this, this.doc, false);
                        this.affEnfants.add(affichageFormulaire);
                        object = i + 1 < n2 ? ((node = this.enfants.get(i + 1)) instanceof Element ? this.cfg.getElementRef((Element)node) : null) : null;
                        boolean bl2 = element == null && object != object2;
                        this.placerAffichage(affichageFormulaire, this.panelEnfants, gridBagConstraints, n++, bl2);
                        bl = true;
                    }
                }
                if (bl && element2 != element) continue;
                AffichageFormulaire affichageFormulaire = new AffichageFormulaire(element2, null, this, this.doc, false);
                this.affEnfants.add(affichageFormulaire);
                this.placerAffichage(affichageFormulaire, this.panelEnfants, gridBagConstraints, n++, true);
            }
        }
    }

    private void placerAffichage(AffichageFormulaire affichageFormulaire, JPanel jPanel, GridBagConstraints gridBagConstraints, int n, boolean bl) {
        if (affichageFormulaire.avecEnfants()) {
            JPanel jPanel2 = affichageFormulaire.getPanel(bl);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 10;
            jPanel.add((Component)jPanel2, gridBagConstraints);
        } else {
            JPanel jPanel3 = affichageFormulaire.getPanelGauche();
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)jPanel3, gridBagConstraints);
            JPanel jPanel4 = affichageFormulaire.getPanelDroite(bl);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 10;
            jPanel.add((Component)jPanel4, gridBagConstraints);
        }
    }

    private JPanel getPanelGauche() {
        this.panelGauche = new JPanel(new FlowLayout(0));
        JButton jButton = new JButton(new ActionAide(this.refNoeud));
        jButton.setFont(jButton.getFont().deriveFont(9.0f));
        if (System.getProperty("os.name").startsWith("Mac OS")) {
            jButton.setText("?");
            if ("10.5".compareTo(System.getProperty("os.version")) <= 0) {
                jButton.putClientProperty("JButton.buttonType", "help");
            } else {
                jButton.putClientProperty("JButton.buttonType", "toolbar");
            }
        } else {
            jButton.setIcon(new ImageIcon(ImageKeeper.loadImage("images/aide.png")));
            jButton.setMargin(new Insets(0, 0, 0, 0));
            jButton.setBorderPainted(false);
            jButton.setContentAreaFilled(false);
        }
        String string = this.getDocumentation();
        if (string != null) {
            jButton.setToolTipText(string);
        }
        if (string == null && this.attribut) {
            jButton.setEnabled(false);
        }
        this.panelGauche.add(jButton);
        this.labelTitre = new JLabel(this.getTitre());
        if (this.affParent != null) {
            if (this.obligatoire()) {
                this.labelTitre.setForeground(couleurObligatoire);
            } else {
                this.labelTitre.setForeground(couleurFacultatif);
            }
        }
        this.panelGauche.add(this.labelTitre);
        return this.panelGauche;
    }

    private JPanel getPanelDroite(boolean bl) {
        Object object;
        Object object2;
        this.panelDroite = new JPanel(new BorderLayout());
        String string = "";
        if (this.noeud != null) {
            if (this.attribut) {
                string = this.noeud.getNodeValue();
            } else {
                object2 = ((Element)this.noeud).getFirstChild();
                if (object2 != null && object2.getNodeType() == 3) {
                    string = object2.getNodeValue();
                }
            }
        }
        if (this.attribut || this.cfg.contientDuTexte(this.refNoeud)) {
            object2 = this.attribut ? this.cfg.listeValeursAttribut(this.refNoeud) : this.cfg.listeValeursElement(this.refNoeud);
            object = new String[]{"true", "false", "1", "0"};
            if (object2 != null && Arrays.equals(((ArrayList)object2).toArray(), (Object[])object)) {
                String string2 = this.getTitre();
                JCheckBox jCheckBox = new JCheckBox(string2);
                if ("true".equals(string.trim()) || "1".equals(string.trim())) {
                    jCheckBox.setSelected(true);
                }
                jCheckBox.addItemListener(this);
                this.comp = jCheckBox;
            } else if (object2 != null) {
                Object object3;
                String string32;
                this.listeValeurs = new ArrayList(object2);
                if (!this.listeValeurs.contains(string)) {
                    this.listeValeurs.add(string);
                }
                if (!this.obligatoire() && !this.listeValeurs.contains("")) {
                    this.listeValeurs.add("");
                }
                ArrayList<Object> arrayList = new ArrayList<Object>(this.listeValeurs.size());
                for (String string32 : this.listeValeurs) {
                    if (this.attribut) {
                        Element element = this.affParent.getNoeudRef();
                        object3 = this.cfg.titreValeurAttribut(element, this.refNoeud, string32);
                    } else {
                        object3 = this.cfg.titreValeurElement(this.refNoeud, string32);
                    }
                    arrayList.add(object3);
                }
                JComboBox<Object> jComboBox = new JComboBox<Object>(arrayList.toArray());
                if (this.attribut) {
                    object3 = this.affParent.getNoeudRef();
                    string32 = this.cfg.titreValeurAttribut((Element)object3, this.refNoeud, string);
                } else {
                    string32 = this.cfg.titreValeurElement(this.refNoeud, string);
                }
                jComboBox.setSelectedItem(string32);
                jComboBox.addItemListener(this);
                this.comp = jComboBox;
            } else {
                ArrayList<String> arrayList;
                ArrayList<String> arrayList2;
                if (this.attribut) {
                    arrayList2 = this.affParent.getNoeudRef();
                    arrayList = this.doc.cfg.listeValeursSuggereesAttribut((Element)((Object)arrayList2), this.refNoeud);
                } else {
                    arrayList = this.doc.cfg.listeValeursSuggereesElement(this.refNoeud);
                }
                if (arrayList != null && arrayList.size() > 0) {
                    Object object4;
                    String string42;
                    this.listeValeurs = new ArrayList<String>(arrayList);
                    if (!this.listeValeurs.contains(string)) {
                        this.listeValeurs.add(string);
                    }
                    arrayList2 = new ArrayList<String>(this.listeValeurs.size());
                    for (String string42 : this.listeValeurs) {
                        if (this.attribut) {
                            Element element = this.affParent.getNoeudRef();
                            object4 = this.cfg.titreValeurAttribut(element, this.refNoeud, string42);
                        } else {
                            object4 = this.cfg.titreValeurElement(this.refNoeud, string42);
                        }
                        arrayList2.add((String)object4);
                    }
                    JComboBox<Object> jComboBox = new JComboBox<Object>(arrayList2.toArray());
                    jComboBox.setEditable(true);
                    if (this.attribut) {
                        object4 = this.affParent.getNoeudRef();
                        string42 = this.cfg.titreValeurAttribut((Element)object4, this.refNoeud, string);
                    } else {
                        string42 = this.cfg.titreValeurElement(this.refNoeud, string);
                    }
                    jComboBox.setSelectedItem(string42);
                    jComboBox.addItemListener(this);
                    this.comp = jComboBox;
                } else {
                    arrayList2 = new JTextField(string);
                    ((JTextComponent)((Object)arrayList2)).getDocument().addDocumentListener(this);
                    this.comp = arrayList2;
                }
            }
            this.panelDroite.add((Component)this.comp, "Center");
            if (!"".equals(string)) {
                if (this.attribut) {
                    this.setValidite(this.cfg.attributValide(this.refNoeud, string));
                } else {
                    this.setValidite(this.cfg.valeurElementValide(this.refNoeud, string));
                }
            }
        }
        if (!this.attribut && this.affParent != null && this.affParent.enfantsMultiples(this.refNoeud)) {
            object2 = new JPanel(new FlowLayout(1, 0, 0));
            if (bl) {
                object = new JButton("+");
                ((AbstractButton)object).setAction(new AbstractAction("+"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        AffichageFormulaire.this.affParent.ajouterAffichageEnfant(AffichageFormulaire.this);
                    }
                });
                ((Container)object2).add((Component)object);
            }
            object = new JButton("-");
            ((AbstractButton)object).setAction(new AbstractAction("-"){

                public void actionPerformed(ActionEvent actionEvent) {
                    AffichageFormulaire.this.affParent.retirerAffichageEnfant(AffichageFormulaire.this);
                }
            });
            ((Container)object2).add((Component)object);
            this.panelDroite.add((Component)object2, "East");
        }
        this.panelDroite.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
        return this.panelDroite;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.enregistrerChangement();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.enregistrerChangement();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.enregistrerChangement();
    }

    private void enregistrerChangement() {
        String string = this.getValeur();
        if (string == null) {
            string = "";
        }
        this.doc.setModif(true);
        MyCompoundEdit myCompoundEdit = null;
        if (this.noeud == null && !"".equals(string)) {
            myCompoundEdit = new MyCompoundEdit();
            this.creerNoeud(myCompoundEdit);
        } else if (this.noeud != null && "".equals(string) && this.affParent != null) {
            this.effacerNoeud(false, null);
            return;
        }
        if (!this.attribut) {
            Element element = (Element)this.noeud;
            Node node = element.getFirstChild();
            if (node == null) {
                FormUndoableEdit formUndoableEdit = new FormUndoableEdit(this, "", string);
                if (myCompoundEdit != null) {
                    myCompoundEdit.addEdit(formUndoableEdit);
                } else {
                    this.doc.textPane.addEdit(formUndoableEdit);
                }
                Text text = element.getOwnerDocument().createTextNode(string);
                element.appendChild(text);
            } else if (node.getNodeType() == 3) {
                FormUndoableEdit formUndoableEdit = new FormUndoableEdit(this, node.getNodeValue(), string);
                if (myCompoundEdit != null) {
                    myCompoundEdit.addEdit(formUndoableEdit);
                } else {
                    this.doc.textPane.addEdit(formUndoableEdit);
                }
                node.setNodeValue(string);
            } else {
                LOG.error((Object)"AffichageFormulaire.enregistrerChangement : pas de noeud texte pour enregistrer le champ");
            }
        } else {
            FormUndoableEdit formUndoableEdit = new FormUndoableEdit(this, this.noeud.getNodeValue(), string);
            if (myCompoundEdit != null) {
                myCompoundEdit.addEdit(formUndoableEdit);
            } else {
                this.doc.textPane.addEdit(formUndoableEdit);
            }
            Element element = (Element)this.affParent.getNoeud();
            String string2 = this.cfg.nomAttribut(this.refNoeud);
            String string3 = this.cfg.espaceAttribut(this.refNoeud);
            element.setAttributeNS(string3, string2, string);
        }
        if (myCompoundEdit != null) {
            myCompoundEdit.end();
            this.doc.textPane.addEdit(myCompoundEdit);
        }
        if ("".equals(string)) {
            this.setValidite(true);
        } else if (this.attribut) {
            this.setValidite(this.cfg.attributValide(this.refNoeud, string));
        } else {
            this.setValidite(this.cfg.valeurElementValide(this.refNoeud, string));
        }
    }

    private String getValeur() {
        String string;
        if (this.comp instanceof JTextField) {
            Document document = ((JTextField)this.comp).getDocument();
            try {
                string = document.getText(0, document.getLength());
            }
            catch (BadLocationException badLocationException) {
                LOG.error((Object)"lecture du champ texte", (Throwable)badLocationException);
                return null;
            }
        } else {
            JComboBox jComboBox;
            int n;
            string = this.comp instanceof JCheckBox ? Boolean.toString(((JCheckBox)this.comp).isSelected()) : (this.comp instanceof JComboBox ? ((n = (jComboBox = (JComboBox)this.comp).getSelectedIndex()) != -1 ? this.listeValeurs.get(jComboBox.getSelectedIndex()) : (String)jComboBox.getSelectedItem()) : null);
        }
        return string;
    }

    private void setValidite(boolean bl) {
        if (this.comp == null) {
            LOG.error((Object)"AffichageFormulaire.setValidite : pas de champ ?");
        }
        if (bl) {
            this.comp.setForeground(Color.black);
        } else {
            this.comp.setForeground(couleurErreur);
        }
    }

    private Node getNoeud() {
        return this.noeud;
    }

    private Element getNoeudRef() {
        return this.refNoeud;
    }

    private String getTitre() {
        if (this.attribut) {
            Element element = this.affParent.getNoeudRef();
            return this.cfg.titreAttribut(element, this.refNoeud);
        }
        return this.cfg.titreElement(this.refNoeud);
    }

    private String getDocumentation() {
        String string;
        if (this.attribut) {
            Element element = this.affParent.getNoeudRef();
            string = this.cfg.documentationAttribut(element, this.refNoeud);
        } else {
            string = this.cfg.documentation(this.refNoeud);
        }
        if (string != null) {
            string = "<html><body>" + string.replaceAll("\n", "<br>") + "</body></html>";
        }
        return string;
    }

    private int getProfondeur() {
        return this.profondeur;
    }

    private void creerNoeud(MyCompoundEdit myCompoundEdit) {
        if (this.attribut) {
            Element element = (Element)this.affParent.getNoeud();
            if (element == null) {
                this.affParent.creerNoeud(myCompoundEdit);
                element = (Element)this.affParent.getNoeud();
            }
            String string = this.cfg.nomAttribut(this.refNoeud);
            String string2 = this.cfg.espaceAttribut(this.refNoeud);
            element.setAttributeNS(string2, string, "");
            this.noeud = element.getAttributeNodeNS(string2, string);
            myCompoundEdit.addEdit(new FormUndoableEdit(FormUndoableEdit.TypeEdition.AJOUTER, this));
        } else {
            this.noeud = JaxeElement.nouvelElementDOM(this.doc, this.refNoeud);
            Element element = (Element)this.affParent.getNoeud();
            if (element == null) {
                this.affParent.creerNoeud(myCompoundEdit);
                element = (Element)this.affParent.getNoeud();
                element.appendChild(this.noeud.getOwnerDocument().createTextNode("\n"));
            }
            Element element2 = this.affParent.trouverSuivant(this.refNoeud);
            Text text = this.noeud.getOwnerDocument().createTextNode("\n");
            if (element2 == null) {
                element.appendChild(this.noeud);
                element.appendChild(text);
            } else {
                element.insertBefore(this.noeud, element2);
                element.insertBefore(text, element2);
            }
            myCompoundEdit.addEdit(new FormUndoableEdit(FormUndoableEdit.TypeEdition.AJOUTER, this));
        }
        this.affParent.lireEnfants();
        this.doc.textPane.miseAJourArbre();
    }

    private Element trouverSuivant(Element element) {
        int n = this.refEnfantsPossibles.indexOf(element);
        if (n == this.refEnfantsPossibles.size() - 1) {
            return null;
        }
        if (this.enfants == null) {
            return null;
        }
        for (Node node : this.enfants) {
            Element element2;
            int n2;
            if (!(node instanceof Element) || (n2 = this.refEnfantsPossibles.indexOf(element2 = this.cfg.getElementRef((Element)node))) <= n) continue;
            return (Element)node;
        }
        return null;
    }

    private void effacerNoeud(boolean bl, CompoundEdit compoundEdit) {
        Object object;
        CompoundEdit compoundEdit2 = null;
        if (!bl) {
            object = new FormUndoableEdit(FormUndoableEdit.TypeEdition.SUPPRIMER, this);
            if (compoundEdit != null) {
                compoundEdit.addEdit((UndoableEdit)object);
            } else {
                compoundEdit2 = new CompoundEdit();
                compoundEdit2.addEdit((UndoableEdit)object);
            }
        }
        object = (Element)this.affParent.getNoeud();
        if (this.attribut) {
            String string = this.cfg.nomAttribut(this.refNoeud);
            String string2 = this.cfg.espaceAttribut(this.refNoeud);
            object.removeAttributeNS(string2, string);
        } else {
            Node node = this.noeud.getNextSibling();
            object.removeChild(this.noeud);
            if (node.getNodeType() == 3) {
                object.removeChild(node);
            }
        }
        this.noeud = null;
        if (!bl) {
            this.affParent.testEffacementParent(compoundEdit != null ? compoundEdit : compoundEdit2);
        } else {
            this.lireEnfants();
        }
        this.doc.textPane.miseAJourArbre();
        if (compoundEdit == null && compoundEdit2 != null) {
            compoundEdit2.end();
            this.doc.textPane.addEdit(compoundEdit2);
        }
    }

    private void testEffacementParent(CompoundEdit compoundEdit) {
        this.lireEnfants();
        if (this.enfants.size() == 0 && this.noeud != null && this.affParent != null) {
            this.effacerNoeud(false, compoundEdit);
        }
    }

    private boolean enfantsMultiples(Element element) {
        if (this.attribut) {
            return false;
        }
        if (this.cfg.getSchema() == null) {
            return true;
        }
        return this.cfg.getSchema().enfantsMultiples(this.refNoeud, element);
    }

    private boolean obligatoire() {
        if (this.attribut) {
            return this.affParent.attributObligatoire(this.refNoeud);
        }
        return this.affParent.elementObligatoire(this.refNoeud);
    }

    private boolean elementObligatoire(Element element) {
        if (this.cfg.getSchema() == null) {
            return false;
        }
        return this.cfg.getSchema().elementObligatoire(this.refNoeud, element);
    }

    private boolean attributObligatoire(Element element) {
        return this.cfg.attributObligatoire(this.refNoeud, element);
    }

    private void ajouterAffichageEnfant(AffichageFormulaire affichageFormulaire) {
        this.majPanel(affichageFormulaire.getNoeudRef());
    }

    private void retirerAffichageEnfant(AffichageFormulaire affichageFormulaire) {
        if (affichageFormulaire.getNoeud() != null) {
            affichageFormulaire.effacerNoeud(false, null);
        }
        this.majPanel(null);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.enregistrerChangement();
    }

    public Point getPointEnfant(Element element) {
        if (this.noeud == element) {
            return this.getPoint();
        }
        if (this.affEnfants != null) {
            for (AffichageFormulaire affichageFormulaire : this.affEnfants) {
                Point point = affichageFormulaire.getPointEnfant(element);
                if (point == null) continue;
                Point point2 = this.getPoint();
                if (point2 != null) {
                    point.translate(point2.x, point2.y);
                }
                Point point3 = this.panelEnfants.getLocation();
                point.translate(point3.x, point3.y);
                return point;
            }
        }
        return null;
    }

    public Point getPoint() {
        if (this.panelElement != null) {
            return this.panelElement.getLocation();
        }
        if (this.panelGauche != null) {
            return this.panelGauche.getLocation();
        }
        return null;
    }

    private AffichageFormulaire chercherAffichage(Node node) {
        if (node == this.noeud) {
            return this;
        }
        if (this.affEnfants == null) {
            return null;
        }
        for (AffichageFormulaire affichageFormulaire : this.affEnfants) {
            AffichageFormulaire affichageFormulaire2 = affichageFormulaire.chercherAffichage(node);
            if (affichageFormulaire2 == null) continue;
            return affichageFormulaire2;
        }
        return null;
    }

    private AffichageFormulaire chercherAffichageParRef(Element element) {
        if (element == this.refNoeud) {
            return this;
        }
        if (this.affEnfants == null) {
            return null;
        }
        for (AffichageFormulaire affichageFormulaire : this.affEnfants) {
            AffichageFormulaire affichageFormulaire2 = affichageFormulaire.chercherAffichageParRef(element);
            if (affichageFormulaire2 == null) continue;
            return affichageFormulaire2;
        }
        return null;
    }

    private JaxeDocument getJaxeDocument() {
        return this.doc;
    }

    public void selection(boolean bl) {
        if (bl) {
            this.panelEnfants.setBackground(Balise.getCouleurs()[0][1]);
        } else {
            this.panelEnfants.setBackground(null);
        }
    }

    public void setFocus() {
        if (this.affEnfants == null || this.affEnfants.size() == 0) {
            return;
        }
        AffichageFormulaire affichageFormulaire = this.affEnfants.get(0);
        while (affichageFormulaire != null) {
            if (affichageFormulaire.comp != null) {
                affichageFormulaire.comp.requestFocusInWindow();
                return;
            }
            if (affichageFormulaire.affEnfants == null || affichageFormulaire.affEnfants.size() == 0) {
                return;
            }
            affichageFormulaire = affichageFormulaire.affEnfants.get(0);
        }
    }

    public void majAffichage() {
    }

    static class FormUndoableEdit
    extends AbstractUndoableEdit {
        private TypeEdition ajsup;
        private String ancienTexte;
        private String nouveauTexte;
        private Node noeud;
        private Node parent;
        private AffichageFormulaire premierAffichage;
        private Node suivant;

        public FormUndoableEdit(TypeEdition typeEdition, AffichageFormulaire affichageFormulaire) {
            this.ajsup = typeEdition;
            this.noeud = affichageFormulaire.getNoeud();
            this.parent = this.noeud instanceof Attr ? ((Attr)this.noeud).getOwnerElement() : this.noeud.getParentNode();
            this.premierAffichage = affichageFormulaire;
            while (this.premierAffichage.affParent != null) {
                this.premierAffichage = this.premierAffichage.affParent;
            }
            this.suivant = this.noeud.getNextSibling();
            if (this.suivant != null) {
                this.suivant = this.suivant.getNextSibling();
            }
        }

        public FormUndoableEdit(AffichageFormulaire affichageFormulaire, String string, String string2) {
            this.ajsup = TypeEdition.MODIFIER;
            this.noeud = affichageFormulaire.getNoeud();
            this.parent = this.noeud instanceof Attr ? ((Attr)this.noeud).getOwnerElement() : this.noeud.getParentNode();
            this.premierAffichage = affichageFormulaire;
            while (this.premierAffichage.affParent != null) {
                this.premierAffichage = this.premierAffichage.affParent;
            }
            this.ancienTexte = string;
            this.nouveauTexte = string2;
            this.suivant = null;
            if (this.noeud instanceof Element) {
                this.suivant = this.noeud.getNextSibling();
                if (this.suivant != null) {
                    this.suivant = this.suivant.getNextSibling();
                }
            }
        }

        private void recreerElement() {
            Text text = this.noeud.getOwnerDocument().createTextNode("\n");
            Element element = (Element)this.parent;
            if (this.suivant == null) {
                element.appendChild(this.noeud);
                element.appendChild(text);
            } else {
                element.insertBefore(this.noeud, this.suivant);
                element.insertBefore(text, this.suivant);
            }
        }

        private void ajouter() {
            Object object;
            AffichageFormulaire affichageFormulaire = this.premierAffichage.chercherAffichage(this.parent);
            if (this.noeud instanceof Element) {
                this.recreerElement();
            } else {
                object = (Element)this.parent;
                object.setAttributeNodeNS((Attr)this.noeud);
            }
            affichageFormulaire.lireEnfants();
            ((AffichageFormulaire)affichageFormulaire).getJaxeDocument().textPane.miseAJourArbre();
            affichageFormulaire.majPanel(null);
            object = affichageFormulaire.chercherAffichage(this.noeud);
            if (object != null && ((AffichageFormulaire)object).comp != null) {
                ((AffichageFormulaire)object).comp.requestFocusInWindow();
            }
        }

        private void supprimer() {
            AffichageFormulaire affichageFormulaire = this.premierAffichage.chercherAffichage(this.noeud);
            final Element element = affichageFormulaire.refNoeud;
            AffichageFormulaire affichageFormulaire2 = affichageFormulaire.affParent;
            this.suivant = this.noeud.getNextSibling();
            if (this.suivant != null) {
                this.suivant = this.suivant.getNextSibling();
            }
            affichageFormulaire.effacerNoeud(true, null);
            affichageFormulaire2.majPanel(null);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AffichageFormulaire affichageFormulaire = FormUndoableEdit.this.premierAffichage.chercherAffichageParRef(element);
                    if (affichageFormulaire != null && affichageFormulaire.comp != null) {
                        affichageFormulaire.comp.requestFocusInWindow();
                    }
                }
            });
        }

        private void changerTexte(String string) {
            Object object;
            AffichageFormulaire affichageFormulaire = this.premierAffichage.chercherAffichage(this.parent);
            if (this.noeud instanceof Element) {
                object = affichageFormulaire.chercherAffichage(this.noeud);
                Node node = this.noeud.getFirstChild();
                if (object == null && !"".equals(string)) {
                    this.recreerElement();
                } else if (node != null) {
                    node.setNodeValue(string);
                } else {
                    node = this.noeud.getOwnerDocument().createTextNode(string);
                    this.noeud.appendChild(node);
                }
                affichageFormulaire.majPanel(null);
            } else {
                object = (Element)this.parent;
                if (!object.hasAttributeNS(this.noeud.getNamespaceURI(), this.noeud.getLocalName())) {
                    object.setAttributeNodeNS((Attr)this.noeud);
                }
                this.noeud.setNodeValue(string);
                affichageFormulaire.majPanel(null);
            }
            object = affichageFormulaire.chercherAffichage(this.noeud);
            if (object != null && ((AffichageFormulaire)object).comp != null) {
                ((AffichageFormulaire)object).comp.requestFocusInWindow();
            }
        }

        private void refaireModifTexte() {
            this.changerTexte(this.nouveauTexte);
        }

        private void defaireModifTexte() {
            this.changerTexte(this.ancienTexte);
        }

        public boolean addEdit(UndoableEdit undoableEdit) {
            if (undoableEdit instanceof FormUndoableEdit) {
                FormUndoableEdit formUndoableEdit = (FormUndoableEdit)undoableEdit;
                if (this.ajsup == TypeEdition.MODIFIER && this.noeud == formUndoableEdit.noeud && formUndoableEdit.ajsup == TypeEdition.MODIFIER) {
                    this.nouveauTexte = formUndoableEdit.nouveauTexte;
                    formUndoableEdit.die();
                    return true;
                }
            }
            return false;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            if (this.ajsup == TypeEdition.AJOUTER) {
                this.supprimer();
            } else if (this.ajsup == TypeEdition.SUPPRIMER) {
                this.ajouter();
            } else {
                this.defaireModifTexte();
            }
        }

        public void redo() throws CannotUndoException {
            super.redo();
            if (this.ajsup == TypeEdition.AJOUTER) {
                this.ajouter();
            } else if (this.ajsup == TypeEdition.SUPPRIMER) {
                this.supprimer();
            } else {
                this.refaireModifTexte();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum TypeEdition {
            AJOUTER,
            SUPPRIMER,
            MODIFIER;

        }
    }

    static class MyCompoundEdit
    extends CompoundEdit {
        public boolean addEdit(UndoableEdit undoableEdit) {
            UndoableEdit undoableEdit2;
            boolean bl = super.addEdit(undoableEdit);
            if (!bl && !this.isInProgress() && undoableEdit instanceof FormUndoableEdit && (undoableEdit2 = this.lastEdit()) != null && undoableEdit2 instanceof FormUndoableEdit) {
                return undoableEdit2.addEdit(undoableEdit);
            }
            return bl;
        }
    }

    class ActionAide
    extends AbstractAction {
        Element refNoeud;

        ActionAide(Element element) {
            this.refNoeud = element;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DialogueAideElement dialogueAideElement;
            if (AffichageFormulaire.this.attribut) {
                Element element = AffichageFormulaire.this.affParent.getNoeudRef();
                dialogueAideElement = new DialogueAideElement(this.refNoeud, element, AffichageFormulaire.this.cfg.getRefConf(element), (JFrame)((AffichageFormulaire)AffichageFormulaire.this).doc.textPane.getTopLevelAncestor());
            } else {
                dialogueAideElement = new DialogueAideElement(this.refNoeud, AffichageFormulaire.this.cfg.getRefConf(this.refNoeud), (JFrame)((AffichageFormulaire)AffichageFormulaire.this).doc.textPane.getTopLevelAncestor());
            }
            dialogueAideElement.setVisible(true);
        }
    }
}

