/*
 * Decompiled with CFR 0.152.
 */
package com.cqs.ftp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class Connection {
    public static final int CONNECTION_SERVER_TYPE = 1;
    public static final int CONNECTION_CLIENT_TYPE = 2;
    public static final int SO_TIMEOUT = 0;
    public static final int BUFFER_SIZE = 65536;
    private int m_type = 0;
    private Socket m_socket = null;
    private ServerSocket m_serversocket = null;
    private String m_host = null;
    private int m_port = -1;
    private byte[] m_buffer = new byte[65536];
    private InputStream m_inputstream = null;
    private OutputStream m_outputstream = null;
    private InputStreamReader m_inputstreamreader = null;
    private BufferedReader m_bufferedreader = null;
    private boolean connected = false;

    public Connection(int type) {
        this.m_type = type;
    }

    public Connection(Socket socket) {
        this.m_type = 1;
        this.m_socket = socket;
        try {
            this.m_outputstream = this.m_socket.getOutputStream();
            this.m_inputstream = this.m_socket.getInputStream();
            this.m_inputstreamreader = new InputStreamReader(this.m_inputstream);
            this.m_bufferedreader = new BufferedReader(this.m_inputstreamreader);
        }
        catch (IOException e) {
            return;
        }
        try {
            this.m_socket.setSoTimeout(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connected = true;
    }

    public int connect(String host, int port) {
        if (this.connected) {
            return 0;
        }
        this.m_host = host;
        this.m_port = port;
        if (this.m_type == 1) {
            try {
                this.m_serversocket = new ServerSocket(this.m_port);
                this.m_port = this.m_serversocket.getLocalPort();
                this.m_socket = this.m_serversocket.accept();
            }
            catch (IOException e) {
                int n = -1;
                return n;
            }
        }
        try {
            this.m_socket = new Socket(this.m_host, this.m_port);
        }
        catch (IOException e) {
            int n = -1;
            return n;
        }
        try {
            this.m_outputstream = this.m_socket.getOutputStream();
            this.m_inputstream = this.m_socket.getInputStream();
            this.m_inputstreamreader = new InputStreamReader(this.m_inputstream);
            this.m_bufferedreader = new BufferedReader(this.m_inputstreamreader);
        }
        catch (IOException e) {
            int n = -1;
            return n;
        }
        try {
            this.m_socket.setSoTimeout(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connected = true;
        return 0;
    }

    public synchronized int disconnect() {
        if (!this.connected) {
            return 0;
        }
        try {
            this.m_bufferedreader.close();
            this.m_outputstream.flush();
            this.m_outputstream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.m_socket.close();
        }
        catch (IOException e) {
            int n = -1;
            return n;
        }
        this.connected = false;
        return 0;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String read() throws IOException {
        if (!this.connected) {
            return null;
        }
        return this.m_bufferedreader.readLine();
    }

    public int write(byte[] toWrite) {
        if (toWrite == null) {
            return 0;
        }
        if (toWrite.length == 0) {
            return 0;
        }
        if (!this.connected) {
            return 0;
        }
        try {
            this.m_outputstream.write(toWrite);
            this.m_outputstream.flush();
        }
        catch (IOException e) {
            int n = -1;
            return n;
        }
        return 0;
    }

    public int getLocalPort() {
        return this.m_port;
    }

    static {
        CONNECTION_SERVER_TYPE = 1;
        CONNECTION_CLIENT_TYPE = 2;
        SO_TIMEOUT = 0;
        BUFFER_SIZE = 65536;
    }
}

