/*
 * Decompiled with CFR 0.152.
 */
package com.cqs.ftp;

import java.util.Date;

public abstract class TransferThread
extends Thread {
    public static final int TYPE_DOWNLOAD = 0;
    public static final int TYPE_UPLOAD = 1;
    public static final int TYPE_LIST = 2;
    public static final int STATE_SETTING_UP = 0;
    public static final int STATE_TRANSFERRING = 1;
    public static final int STATE_PAUSED = 2;
    public static final int STATE_FINISHED = 3;
    public static final long SIZE_NOT_SPECIFIED = -1L;
    public static final long TIME_NOT_ESTIMABLE = -1L;
    public static final double PERCENT_NOT_CALCULABLE = -1.0;
    protected long transferStartTime = new Date().getTime();
    protected long finalSize = -1L;
    protected int transferState = 0;
    protected long transferredSize = 0L;
    protected long offsetSize = 0L;

    public void run() {
        this.transferState = 1;
        this.performTransfer();
        this.transferState = 3;
    }

    public abstract int getTransferType();

    public abstract void performTransfer();

    public long getOffsetSize() {
        return this.offsetSize;
    }

    public void setOffsetSize(long offsetSize) {
        this.offsetSize = offsetSize;
    }

    public long getFinalSize() {
        return this.finalSize;
    }

    public void setFinalSize(long finalSize) {
        this.finalSize = finalSize;
    }

    public long getTransferTime() {
        long now = new Date().getTime();
        return now - this.transferStartTime;
    }

    public long getTotalEstimatedTime() {
        if (this.getTransferredPercent() == -1.0) {
            return -1L;
        }
        return Math.round((double)this.getTransferTime() * this.getTransferredPercent());
    }

    public long getTransferredSize() {
        return this.transferredSize;
    }

    public double getTransferredPercent() {
        if (this.getFinalSize() == -1L) {
            return -1.0;
        }
        return (double)this.getTransferredSize() / (double)(this.getFinalSize() - this.getOffsetSize());
    }

    public int getTransferState() {
        return this.transferState;
    }

    static {
        TYPE_DOWNLOAD = 0;
        TYPE_UPLOAD = 1;
        TYPE_LIST = 2;
        STATE_SETTING_UP = 0;
        STATE_TRANSFERRING = 1;
        STATE_PAUSED = 2;
        STATE_FINISHED = 3;
        SIZE_NOT_SPECIFIED = -1L;
        TIME_NOT_ESTIMABLE = -1L;
        PERCENT_NOT_CALCULABLE = -1.0;
    }
}

