/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.plugin;

import com.fluendo.plugin.AudioSink;
import com.fluendo.utils.Debug;
import java.io.IOException;
import java.io.InputStream;
import sun.audio.AudioPlayer;
import sun.audio.AudioStream;

public class AudioSinkSA
extends AudioSink {
    private static final int BUFFER = 16384;
    private static final int SEGSIZE = 256;
    private static final int DELAY = 8000;
    private double rateDiff;
    private int delay;
    private static final boolean ZEROTRAP = true;
    private static final short BIAS = 132;
    private static final int CLIP = 32635;
    private static final byte[] exp_lut = new byte[]{0, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private static final short[] header = new short[]{46, 115, 110, 100, 0, 0, 0, 24, 127, 255, 255, 255, 0, 0, 0, 1, 0, 0, 31, 64, 0, 0, 0, 1};
    private int headerPos;

    private final int toUlaw(int n) {
        int n2;
        byte by;
        int n3;
        if (n > Short.MAX_VALUE) {
            n = Short.MAX_VALUE;
        } else if (n < Short.MIN_VALUE) {
            n = Short.MIN_VALUE;
        }
        int n4 = n >> 8 & 0x80;
        if (n4 != 0) {
            n = -n;
        }
        if (n > 32635) {
            n = 32635;
        }
        if ((n3 = ~(n4 | (by = exp_lut[(n += 132) >> 7 & 0xFF]) << 4 | (n2 = n >> by + 3 & 0xF))) == 0) {
            n3 = 2;
        }
        if (n3 < 0) {
            n3 += 256;
        }
        return n3;
    }

    protected AudioSink.RingBuffer createRingBuffer() {
        return new RingBufferSA();
    }

    protected boolean open(AudioSink.RingBuffer ringBuffer) {
        this.rateDiff = (double)ringBuffer.rate / 8000.0;
        Debug.log(3, "rateDiff: " + this.rateDiff);
        ringBuffer.segSize = (int)(256.0 * this.rateDiff);
        ringBuffer.segSize *= ringBuffer.bps;
        ringBuffer.segTotal = (int)(16384.0 * this.rateDiff);
        ringBuffer.segTotal = ringBuffer.segTotal * ringBuffer.bps / ringBuffer.segSize;
        ringBuffer.emptySeg = new byte[ringBuffer.segSize];
        ((RingBufferSA)ringBuffer).nextSeg = ringBuffer.segSize;
        this.delay = 8000;
        return true;
    }

    protected boolean close(AudioSink.RingBuffer ringBuffer) {
        return true;
    }

    protected int write(byte[] byArray, int n, int n2) {
        System.out.println("write should not be called");
        return -1;
    }

    protected long delay() {
        long l = (int)((double)this.delay * this.rateDiff);
        return l;
    }

    protected void reset() {
    }

    public String getFactoryName() {
        return "audiosinksa";
    }

    private class RingBufferSA
    extends AudioSink.RingBuffer {
        private RingReader reader;
        private int devicePos;
        public int nextSeg;

        public RingBufferSA() {
            this.reader = new RingReader(this);
            this.devicePos = 0;
        }

        protected void startWriteThread() {
        }

        public synchronized boolean play() {
            boolean bl = super.play();
            this.reader.play();
            return bl;
        }

        public synchronized boolean pause() {
            boolean bl = super.pause();
            this.reader.pause();
            return bl;
        }

        public synchronized boolean stop() {
            boolean bl = super.stop();
            this.reader.stop();
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() {
            int n = (int)((double)this.devicePos * AudioSinkSA.this.rateDiff) * this.bps;
            if (this.segTotal == 0) {
                return -1;
            }
            while (n >= this.nextSeg) {
                RingBufferSA ringBufferSA = this;
                synchronized (ringBufferSA) {
                    this.clear((int)(this.playSeg % (long)this.segTotal));
                    ++this.playSeg;
                    this.notifyAll();
                }
                this.nextSeg += this.segSize;
            }
            int n2 = 0;
            int n3 = n % this.buffer.length;
            for (int i = 0; i < this.channels; ++i) {
                byte by = this.buffer[n3];
                int n4 = this.buffer[n3 + 1];
                if (n4 < 0) {
                    n4 += 256;
                }
                n2 += by * 256 | n4;
                n3 += 2;
            }
            ++this.devicePos;
            return AudioSinkSA.this.toUlaw(n2 /= this.channels);
        }
    }

    private class RingReader
    extends InputStream {
        private AudioStream stream;
        private RingBufferSA ringBuffer;

        public RingReader(RingBufferSA ringBufferSA) {
            this.ringBuffer = ringBufferSA;
            try {
                AudioSinkSA.this.headerPos = 0;
                this.stream = new AudioStream((InputStream)this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public synchronized boolean play() {
            AudioPlayer.player.start((InputStream)this.stream);
            return true;
        }

        public synchronized boolean pause() {
            AudioPlayer.player.stop((InputStream)this.stream);
            return true;
        }

        public synchronized boolean stop() {
            AudioPlayer.player.stop((InputStream)this.stream);
            return true;
        }

        public int read() throws IOException {
            int n = AudioSinkSA.this.headerPos < header.length ? header[AudioSinkSA.this.headerPos++] : this.ringBuffer.read();
            return n;
        }
    }
}

