/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jheora;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;

public class YUVBuffer
implements ImageProducer {
    public int y_width;
    public int y_height;
    public int y_stride;
    public int uv_width;
    public int uv_height;
    public int uv_stride;
    public short[] data;
    public int y_offset;
    public int u_offset;
    public int v_offset;
    private int[] pixels;
    private int pix_size;
    private boolean newPixels = true;
    private ColorModel colorModel = ColorModel.getRGBdefault();
    private static final int VAL_RANGE = 256;
    private static final int SHIFT = 16;
    private static final int CR_FAC = 91881;
    private static final int CB_FAC = 116129;
    private static final int CR_DIFF_FAC = 46801;
    private static final int CB_DIFF_FAC = 22553;
    private static int[] r_tab = new int[768];
    private static int[] g_tab = new int[768];
    private static int[] b_tab = new int[768];

    public void addConsumer(ImageConsumer imageConsumer) {
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        return false;
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    public void startProduction(ImageConsumer imageConsumer) {
        imageConsumer.setColorModel(this.colorModel);
        imageConsumer.setHints(30);
        imageConsumer.setDimensions(this.y_width, this.y_height);
        this.prepareRGBData(0, 0, this.y_width, this.y_height);
        imageConsumer.setPixels(0, 0, this.y_width, this.y_height, this.colorModel, this.pixels, 0, this.y_width);
        imageConsumer.imageComplete(3);
    }

    private synchronized void prepareRGBData(int n, int n2, int n3, int n4) {
        if (!this.newPixels) {
            return;
        }
        int n5 = n3 * n4;
        try {
            if (n5 != this.pix_size) {
                this.pixels = new int[n5];
                this.pix_size = n5;
            }
            this.YUVtoRGB(n, n2, n3, n4);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.newPixels = false;
    }

    public synchronized void newPixels() {
        this.newPixels = true;
    }

    public Object getObject(int n, int n2, int n3, int n4) {
        return this;
    }

    private void YUVtoRGB(int n, int n2, int n3, int n4) {
        int n5 = this.y_offset + n + n2 * this.y_stride;
        int n6 = n5 + this.y_stride;
        int n7 = this.u_offset + n / 2 + n2 / 2 * this.uv_stride;
        int n8 = this.v_offset + n / 2 + n2 / 2 * this.uv_stride;
        int n9 = 0;
        int n10 = n3;
        int n11 = n3 / 2;
        int n12 = n4 / 2;
        int n13 = this.y_stride * 2 - n11 * 2;
        int n14 = this.uv_stride - n11;
        int n15 = n3;
        for (int i = 0; i < n12; ++i) {
            for (int j = 0; j < n11; ++j) {
                int n16 = this.data[n7++] - 128;
                int n17 = this.data[n8++] - 128;
                int n18 = n16 * 22553 + n17 * 46801 - 0x1000000;
                n16 = n16 * 116129 + 0x1000000;
                n17 = n17 * 91881 + 0x1000000;
                int n19 = this.data[n5] << 16;
                this.pixels[n9] = r_tab[n19 + n17 >> 16] | b_tab[n19 + n16 >> 16] | g_tab[n19 - n18 >> 16];
                n19 = this.data[n5 + 1] << 16;
                this.pixels[n9 + 1] = r_tab[n19 + n17 >> 16] | b_tab[n19 + n16 >> 16] | g_tab[n19 - n18 >> 16];
                n19 = this.data[n6] << 16;
                this.pixels[n10] = r_tab[n19 + n17 >> 16] | b_tab[n19 + n16 >> 16] | g_tab[n19 - n18 >> 16];
                n19 = this.data[n6 + 1] << 16;
                this.pixels[n10 + 1] = r_tab[n19 + n17 >> 16] | b_tab[n19 + n16 >> 16] | g_tab[n19 - n18 >> 16];
                n5 += 2;
                n6 += 2;
                n9 += 2;
                n10 += 2;
            }
            n5 += n13;
            n6 += n13;
            n7 += n14;
            n8 += n14;
            n9 += n15;
            n10 += n15;
        }
    }

    private static final short clamp255(int n) {
        n -= 255;
        n = -(255 + (n >> 31 & n));
        return (short)(-(n >> 31 & n));
    }

    private static void SetupRgbYuvAccelerators() {
        for (int i = 0; i < 768; ++i) {
            YUVBuffer.r_tab[i] = YUVBuffer.clamp255(i - 256) << 16;
            YUVBuffer.g_tab[i] = YUVBuffer.clamp255(i - 256) << 8;
            YUVBuffer.b_tab[i] = YUVBuffer.clamp255(i - 256) | 0xFF000000;
        }
    }

    static {
        YUVBuffer.SetupRgbYuvAccelerators();
    }
}

