<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:redirect="http://xml.apache.org/xalan/redirect" extension-element-prefixes="redirect" xmlns="http://www.w3.org/1999/xhtml" version="1.0">

<!-- Auteur : Damien Guillaume  ( Observatoire de Paris )-->
<!-- Contributeurs : Pierre Brochard & Didier Courtaud ( CEA )-->

<xsl:output doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" doctype-system="http://www.w3.org/TR/xhtml1/loose.dtd" encoding="ISO-8859-1" indent="yes" method="xhtml"/>

<!-- options (valeurs: oui|non) -->
<xsl:param name="commentaires"><xsl:choose>
    <xsl:when test="/EXPOSE/METADONNEES/OPTIONS/COMMENTAIRES"><xsl:value-of select="/EXPOSE/METADONNEES/OPTIONS/COMMENTAIRES"/></xsl:when>
    <xsl:otherwise>non</xsl:otherwise></xsl:choose>
</xsl:param>

<xsl:param name="impression"><xsl:choose>
    <xsl:when test="/EXPOSE/METADONNEES/OPTIONS/IMPRESSION"><xsl:value-of select="/EXPOSE/METADONNEES/OPTIONS/IMPRESSION"/></xsl:when>
    <xsl:otherwise>non</xsl:otherwise></xsl:choose>
</xsl:param>

    <xsl:template match="/">
            <xsl:apply-templates select="EXPOSE"/>
    </xsl:template>
    
<xsl:template match="PAGE_TITRE" >
		
	    <div class="cover">
		<table width="100%">

		    <tr>
		      <td align="left" class="vingt"><xsl:apply-templates select="../LOGO_GAUCHE"/></td>
                      <td align="center" class="soixante">
                      </td>
                      <td align="right" class="vingt"><tt><xsl:apply-templates select="../LOGO_DROIT"/></tt></td>

		    </tr>

                </table>
		
		<table width="100%" height="80%">
		<tbody>
		<tr><td><xsl:if test="normalize-space(TITRE)!=''">
                        <h1><xsl:value-of select="TITRE"/></h1>
                      </xsl:if></td></tr>
		<tr><td><h2> <xsl:apply-templates select="SOUS_TITRE"/></h2></td></tr>
		<tr><td><h5> <xsl:value-of select="AUTEUR"/></h5></td></tr>
		</tbody>
		<tfoot>
		<tr><td><h6><tt> <xsl:apply-templates select="EMAIL"/></tt></h6></td></tr>
		</tfoot>
		</table>
		
		<table width="100%">
		    <tr>
			    <td align="left" class="tiers"><tt><xsl:apply-templates select="../PIEDPAGE_GAUCHE"/></tt></td>
			    <td align="center" class="tiers"><tt><xsl:value-of select="DATE_EXPOSE"/></tt></td>
			    <td align="right" class="tiers"><tt><xsl:apply-templates select="../PIEDPAGE_DROIT"/></tt></td>
                     </tr>
	    </table>
		
	    </div>
	    
	    </xsl:template>
	
    <xsl:template match="EXPOSE">
    
	<redirect:open file="jaxe_custom.css" />
	<redirect:write file="jaxe_custom.css">
		* { opacity: 1 }
	</redirect:write>
     
        <html>
        <head>
            <xsl:choose>
            <xsl:when test="normalize-space(PAGE_TITRE/TITRE)!=''">
                <title><xsl:value-of select="PAGE_TITRE/TITRE"/></title>
            </xsl:when>
            <xsl:otherwise>
                <title>Prsentation</title>
            </xsl:otherwise>
            </xsl:choose>
            <xsl:choose>
            <xsl:when test="normalize-space(PAGE_TITRE/IDENTIFIANT)!=''">
                <META name="id" content="{normalize-space(PAGE_TITRE/IDENTIFIANT)}"/>
                <META name="type" content="{normalize-space(PAGE_TITRE/IDENTIFIANT/@TYPE)}"/>
            </xsl:when>
            </xsl:choose>
            <style type="text/css">
                <xsl:call-template name="css"/>
            </style>
	    
            <xsl:call-template name="javascript"/>
	    
	    <link rel="stylesheet" type="text/css" href="jaxe_custom.css"> </link>
	    
        </head>
            <!-- <body onclick="mouseButtonClick(event);" onload="afficher_slide(0);" onDrag="do_nothing();"> -->
	    <!-- <body onload="afficher_slide(0);" onDrag="do_nothing();"> -->
	    <body onDrag="do_nothing();" onload="afficher_slide_init();" onclick="mouseButtonClick(event);">

            <a name="0"/>
	    
	 <xsl:apply-templates select="PAGE_TITRE"/>
	
	    <div class="sommaire">

<!--	    <xsl:apply-templates select="LOGO_GAUCHE"/>
	    <xsl:apply-templates select="LOGO_DROIT"/>
	    
                <xsl:apply-templates select="METADONNEES/DATECRE"/>
                <xsl:if test="normalize-space(TITRE)!=''">
                    <h1><xsl:value-of select="TITRE"/></h1>
                </xsl:if>
                <xsl:if test="count(METADONNEES/AUTEUR)&gt;0">
                    <div class="auteur">- <xsl:apply-templates select="METADONNEES/AUTEUR"/></div>
                </xsl:if> -->

<!--		<xsl:apply-templates select="METADONNEES/DATECRE"/>
-->

                  <table width="100%">

		    <tr>
		      <td align="left" class="vingt"><xsl:apply-templates select="LOGO_GAUCHE"/></td>
                      <td align="center" class="soixante">
		      <h1> Plan </h1>
                      </td>
                      <td align="right" class="vingt"><tt><xsl:apply-templates select="LOGO_DROIT"/></tt></td>

		    </tr>

             </table>

                <xsl:if test="count(METADONNEES/AUTEUR)&gt;0">
                    <div class="auteur">- <xsl:apply-templates select="METADONNEES/AUTEUR"/></div>
                </xsl:if> 


		
                <ul>
                    <!-- <xsl:for-each select="PARTIE/SECTION">
                        <li>
				<a class="elsommaire" href="#{position()}" onclick="afficher_slide({position()}); return false;"><xsl:choose>
                                <xsl:when test="normalize-space(TITRE)!=''"><xsl:value-of select="TITRE"/></xsl:when>
                                <xsl:otherwise>section <xsl:value-of select="position()"/></xsl:otherwise>
                            </xsl:choose></a>
                        </li>
		</xsl:for-each> --> 

                          
			  
		        <xsl:for-each select="PARTIE">

                        
			<xsl:variable name="nbsec"> <xsl:value-of select="count(preceding::SECTION)+count(preceding::PAGE_TITRE)+1"/>  </xsl:variable>
				
			 			  
			  
                         <li>
			        
                                <a class="elsommaire" href="#{position()}" onclick="afficher_slide({$nbsec}); return false;"><xsl:choose>
                                <xsl:when test="normalize-space(TITRE)!=''"><xsl:value-of select="TITRE"/></xsl:when>
                                <xsl:otherwise>section <xsl:value-of select="position()"/></xsl:otherwise>
                            </xsl:choose></a>

			 
			 </li>

			
			</xsl:for-each> 



                </ul>
                <xsl:if test="$commentaires='oui'">
                    <div class="commentaire">
                        note: les commentaires sont affich�s
                    </div>
                </xsl:if>
            </div>
            <xsl:apply-templates select="PARTIE/SECTION"/>
        </body>
        </html>
	
		<redirect:close file="jaxe_custom.css"/>
	
    </xsl:template>
    
    <xsl:template name="css">
body { background: #FFFFFF }
h1 { text-align: center; font-size: 150%; font-family: sans-serif; color: #963232 }
h2 { text-align: center; font-size: 110%; font-weight: bold; font-family: sans-serif; color: #963232 }
h3 { font-size: 100%; font-weight: bold; font-family: serif; margin-bottom: 0.5em }
h5 { text-align: center; font-size: 90%; font-weight: bold; font-family: serif; margin-bottom: 0.5em; color: #963232 }
h6 { text-align: center; font-size: 70%; font-weight: bold; font-family: serif; margin-bottom: 0.5em; color: #963232 }
.auteur { text-align: center }
.date { text-align: left }
.sommaire { page-break-after: always; background: #F5F5FF; margin: 0.5em; padding: 0.5em; <xsl:if test="$impression='non'">border: gray outset</xsl:if> }
.cover { page-break-after: always; background: #F5F5FF; margin: 0.5em; padding: 0.5em; <xsl:if test="$impression='non'">border: gray outset</xsl:if> }
.section { page-break-after: always; background: #FFFFEB; margin: 2em 0.5em; padding: 0.5em; <xsl:if test="$impression='non'">border: gray outset</xsl:if> }
.titreimage { text-align: center; font-weight: bold; font-family: sans-serif; background-color: #E0E0FF }
.envimage { text-align: center; border: gray outset; padding: 0; margin: 1em; background: #EBFFEB }
.legende { font-family: sans-serif; margin-top: 1em }
p { text-indent: 1em; text-align: justify; margin-top: 0.5em }
pre { background: #EBFFEB; padding-left: 2em; padding-bottom: 0.5em }
tt { color: #963232 }
ul { margin-top: 0.5em }
li { margin-bottom: 0.5em; }
dt { font-weight: bold; }
dd { margin-bottom: 0.5em; }
th { background: #FFF0E0 }
.tableau1 { background: #FFFAE0 }
.tableau2 { background: #FFF5E0 }
.elsommaire { font-size: 110%; color: #000000; text-decoration: none; font-weight: bold }
.elsommaire:hover { font-size: 110%; color: #663399; text-decoration: none; font-weight: bold }
.commentaire { margin: 1em; color: #196419 }
.equation { vertical-align : middle }
td.tiers { width: 33% }
td.vingt { width: 20% }
td.soixante { width: 60% }


    </xsl:template>
    
    <xsl:template name="javascript">
<script type="text/javascript">
<xsl:text disable-output-escaping="yes">
var n = 0;
document.onkeydown = onKeyDown;
function onKeyDown(event) {
    var code = event.keyCode;
    switch (code) {
    case 37:
        // left
        n = n - 1;
        location.href='#' + n;
        break
    case 38:
        // up
        n = 0;
        location.href='#' + n;
        break
    case 39:
        // right
        n = n + 1;
        location.href='#' + n;
        break
     case 32:
        // space bar
        n = n + 1;
        location.href='#' + n;
        break
    case 40:
        // down
        n = n + 1;
        location.href='#' + n;
	break
     }
    afficher_slide(n);
}
function afficher_slide_init() {
	var ind=location.href.indexOf("#");
	var nn = 0;

	if(ind > 0)
	{
		nn = parseInt(location.href.substring(ind+1));
	}

	afficher_slide(nn);
}

function afficher_slide(num) {
    var liste_div = document.getElementsByTagName('div');
    var ns = 0;
    for (var i=0; i &lt; liste_div.length; i++) {
        var classe = liste_div[i].getAttribute('class');
        if (classe == 'section' || classe == 'sommaire' || classe == "cover") {
            if (ns == num)
                liste_div[i].style.display = 'block';
            else
                liste_div[i].style.display='none';
            ns++;
        }
    }
    n = num;
}
function afficher_lien(num){
nsource = n;
afficher_slide(num);
}
function nextslide () {
var liste_div = document.getElementsByTagName('div');
n = n + 1 ;
location.href='#' + n;
afficher_slide(n);
}
function previousslide () {
n = n - 1 ;
location.href='#' + n;
afficher_slide(n);
}

function do_nothing () {
return ;
}


function mouseButtonClick(e)
{
   var rightclick = false;
   var leftclick = false;
   var middleclick = false;
   var target;

   if (!e)
      var e = window.event;

   if (e.target)
      target = e.target;
   else if (e.srcElement)
      target = e.srcElement;

   // work around Safari bug
   if (target.nodeType == 3)
      target = target.parentNode;

   if (e.which) // all browsers except IE
   {
      leftclick = (e.which == 1);
      middleclick = (e.which == 2);
      rightclick = (e.which == 3);
   }

 else if (e.button)
   {
      // Konqueror gives 1 for left, 4 for middle
      // IE6 gives 0 for left and not 1 as I expected

      if (e.button == 4)
        middleclick = true;

      // all browsers agree on 2 for right button
      rightclick = (e.button == 2);
   }
   else leftclick = true;
   
   if (leftclick &amp;&amp; target.nodeName != "A") {
       nextslide();
       e.stopPropagation();
       }

   if (middleclick) {
      
      if(!e.ctrlKey) {
       	previousslide();
       	e.stopPropagation();
       }
       else {
  
       afficher_slide(nsource);
       e.stopPropagation();

       }
    }  
       
}

/** This is high-level function.
 * It must react to delta being more/less than zero.
 */
function handle(delta) {
        if (delta &lt; 0)
		previousslide();
        else
		 nextslide();
}

/** Event handler for mouse wheel event.
 */
function wheel(event){
        var delta = 0;
        if (!event) /* For IE. */
                event = window.event;
        if (event.wheelDelta) { /* IE/Opera. */
                delta = event.wheelDelta/120;
                /** In Opera 9, delta differs in sign as compared to IE.
                 */
                if (window.opera)
                        delta = -delta;
        } else if (event.detail) { /** Mozilla case. */
                /** In Mozilla, sign of delta is different than in IE.
                 * Also, delta is multiple of 3.
                 */
                delta = -event.detail/3;
        }
        /** If delta is nonzero, handle it.
         * Basically, delta is now positive if wheel was scrolled up,
         * and negative, if wheel was scrolled down.
         */
        if (delta &amp;&amp; !event.ctrlKey)
                handle(delta);
		return false;
        /** Prevent default actions caused by mouse wheel.
         * That might be ugly, but we handle scrolls somehow
         * anyway, so don't bother here..
         */
        if (event.preventDefault)
                event.preventDefault();
	event.returnValue = false;
}

/** Initialization code. 
 * If you use your own event management code, change it as required.
 */
if (window.addEventListener)
        /** DOMMouseScroll is for mozilla. */
        window.addEventListener('DOMMouseScroll', wheel, false);
/** IE/Opera. */
window.onmousewheel = document.onmousewheel = wheel;



</xsl:text>
</script>
    </xsl:template>
    
    <xsl:template match="LOGO_GAUCHE">
        <xsl:choose>
            <xsl:when test="@url!=''">
                <a href="{@url}"><img align="left" alt="{@alt}" border="0" src="{@fichier}"/></a>
            </xsl:when>
	    <!-- <xsl:when test="substring-after(@fichier,'.')='svg'"> -->	    
	   <xsl:when test="substring(@fichier,string-length(@fichier) - 3) = '.svg'">
	    	<object align="left" data="{@fichier}" height="{@hauteur_SVG}%"  width="{@largeur_SVG}%" title="{@alt}" type="image/svg+xml"> 
    			<img align="left" alt="{@alt}" src="{@image_alternative}"/> 
		</object>              
            </xsl:when>
	   <xsl:otherwise>
                <img align="left" alt="{@alt}" src="{@fichier}"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>


        <xsl:template match="LOGO_DROIT">
        <xsl:choose>
            <xsl:when test="@url!=''">
                <a href="{@url}"><img align="right" alt="{@alt}" border="0" src="{@fichier}"/></a>
            </xsl:when>
	    <xsl:when test="substring-after(@fichier,'.')='svg'">

	    	<object align="right" data="{@fichier}" height="{@hauteur_SVG}%" title="{@alt}" type="image/svg+xml" width="{@largeur_SVG}%"> 
    			<img align="right" alt="{@alt}" src="{@image_alternative}"/> 
		</object>
                
            </xsl:when>
            <xsl:otherwise>
                <img align="right" alt="{@alt}" src="{@fichier}"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    
    <xsl:template match="SECTION">
	    <div class="section">

	    <table width="100%">

		    <tr>
		      <td align="left" class="vingt"><xsl:apply-templates select="../../LOGO_GAUCHE"/></td>
                      <td align="center" class="soixante"><h2><xsl:value-of select="TITRE"/></h2></td>
                      <td align="right" class="vingt"><xsl:apply-templates select="../../LOGO_DROIT"/></td>

		    </tr>

             </table>

	<!--<xsl:apply-templates select="../LOGO_GAUCHE"/>
	<xsl:apply-templates select="../LOGO_DROIT"/> -->

            <!--<xsl:variable name="numero"><xsl:number count="ancestor-or-self::SECTION"/></xsl:variable> -->
	    <xsl:variable name="numero"> <xsl:value-of select="count(preceding::SECTION)+1"/>  </xsl:variable>
            <a name="{$numero}"/>
   <!--     <xsl:if test="$impression='oui'">
		    <div align="right"><tt><xsl:value-of select="$numero"/>/<xsl:value-of select="count(//SECTION)"/></tt></div>
            </xsl:if>
            <xsl:if test="TITRE!=''">
                <h2><xsl:value-of select="TITRE"/></h2>
	</xsl:if> -->
            <xsl:apply-templates/>
	    <!--    <xsl:if test="$impression='non'">
                <br/>
	     </xsl:if>  -->

	    <table width="100%">
		    <tr>
			    <td align="left" class="tiers"><tt><xsl:apply-templates select="../../PIEDPAGE_GAUCHE"/></tt></td>
			    <td align="center" class="tiers"><tt><xsl:value-of select="$numero"/>/<xsl:value-of select="count(//SECTION)"/></tt></td>
			    <td align="right" class="tiers"><tt><xsl:apply-templates select="../../PIEDPAGE_DROIT"/></tt></td>
                     </tr>
	    </table>
        </div>
    </xsl:template>
    
    <xsl:template match="AUTEUR">
        <xsl:value-of select="."/> -
    </xsl:template>
    
    <xsl:template match="DATECRE">
        <div class="date"><xsl:value-of select="."/></div>
    </xsl:template>
    
    <xsl:template match="TITRE">
    </xsl:template>
    
    <xsl:template match="PARAGRAPHE">
        <xsl:if test="normalize-space(TITRE)!=''">
            <h3><xsl:value-of select="TITRE"/></h3>
        </xsl:if>
        <p><xsl:apply-templates/></p>
    </xsl:template>

    <xsl:template match="EXEMPLE">
        <xsl:if test="normalize-space(@label)!=''">
            <h3><xsl:value-of select="@label"/></h3>
        </xsl:if>
        <pre><xsl:apply-templates/></pre>
    </xsl:template>
    
    <xsl:template match="CODE">
        <tt onDrag="do_nothing()"><xsl:apply-templates/></tt>
    </xsl:template>
    
    <xsl:template match="EMPHASE">
        <em><xsl:apply-templates/></em>
    </xsl:template>
    
    <xsl:template match="LIEN_INTERNE">
	   
	    <a href="#{@num}" onclick="afficher_lien({@num}+1); return false;"><xsl:apply-templates/></a>
	    
    </xsl:template>

    <xsl:template match="LIEN_EXTERNE">
    
	    <a href="{@href}"><xsl:apply-templates/></a>

    </xsl:template>

    <xsl:template match="LISTE">
        <xsl:if test="normalize-space(TITRE)!=''">
            <h3><xsl:value-of select="TITRE"/></h3>
        </xsl:if>

	
	<ul type="{@type}">
			
		<xsl:apply-templates select="EL"/>
	    
	</ul>
		
	
	
    </xsl:template>


    <xsl:template match="EL">
	
	<xsl:choose>
	
		<xsl:when test="normalize-space(../@image_puce)!=''">
			<xsl:variable name="npart"> <xsl:value-of select="count(ancestor-or-self::PARTIE)"/>  </xsl:variable>
			<xsl:variable name="nsect"> <xsl:value-of select="count(ancestor-or-self::SECTION)"/>  </xsl:variable>
			<xsl:variable name="nlist"> <xsl:value-of select="count(ancestor-or-self::LISTE)"/>  </xsl:variable>
			<xsl:variable name="nitem"> <xsl:value-of select="count(preceding::EL)"/>  </xsl:variable>
		
			<xsl:variable name="id_el"> <xsl:value-of select="concat('x',$npart,$nsect,$nlist,$nitem)"/> </xsl:variable>
			<li id="{$id_el}"> <xsl:apply-templates/> </li>
		
			<redirect:write file="jaxe_custom.css">	
				li#<xsl:value-of select="$id_el"/> { list-style-image:url("<xsl:value-of select="../@image_puce"/>") }	
			</redirect:write> 

		</xsl:when>
	
		<xsl:when test="normalize-space(../@couleur_puce)!=''">
			<xsl:variable name="npart"> <xsl:value-of select="count(ancestor-or-self::PARTIE)"/>  </xsl:variable>
			<xsl:variable name="nsect"> <xsl:value-of select="count(ancestor-or-self::SECTION)"/>  </xsl:variable>
			<xsl:variable name="nlist"> <xsl:value-of select="count(ancestor-or-self::LISTE)"/>  </xsl:variable>
			<xsl:variable name="nitem"> <xsl:value-of select="count(preceding::EL)"/>  </xsl:variable>
		
			<xsl:variable name="id_el"> <xsl:value-of select="concat('l',$npart,$nsect,$nlist,$nitem)"/> </xsl:variable>
			<xsl:variable name="id_span"> <xsl:value-of select="concat('s',$npart,$nsect,$nlist,$nitem)"/> </xsl:variable>
			<xsl:variable name="coltext">
				<xsl:choose>
					<xsl:when test="normalize-space(../@couleur_texte)!=''">
						<xsl:value-of select="../@couleur_texte"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="'black'"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
						
				<li id="{$id_el}"><span id="{$id_span}"><xsl:apply-templates/></span></li>
				
			<redirect:write file="jaxe_custom.css">
				
				li#<xsl:value-of select="$id_el"/> { color:<xsl:value-of select="../@couleur_puce"/> }
				span#<xsl:value-of select="$id_span"/> { color: <xsl:value-of select="$coltext"/>}
				
			</redirect:write>
			
		</xsl:when>
		
		
		<xsl:when test="normalize-space(../@couleur_texte)!=''">
			<xsl:variable name="npart"> <xsl:value-of select="count(ancestor-or-self::PARTIE)"/>  </xsl:variable>
			<xsl:variable name="nsect"> <xsl:value-of select="count(ancestor-or-self::SECTION)"/>  </xsl:variable>
			<xsl:variable name="nlist"> <xsl:value-of select="count(ancestor-or-self::LISTE)"/>  </xsl:variable>
			<xsl:variable name="nitem"> <xsl:value-of select="count(preceding::EL)"/>  </xsl:variable>
			
			<xsl:variable name="id_el"> <xsl:value-of select="concat('l',$npart,$nsect,$nlist,$nitem)"/> </xsl:variable>
			<xsl:variable name="id_span"> <xsl:value-of select="concat('s',$npart,$nsect,$nlist,$nitem)"/> </xsl:variable>
						
				<li id="{$id_el}"><span id="{$id_span}"><xsl:apply-templates/></span></li>
				
			<redirect:write file="jaxe_custom.css">
				
				li#<xsl:value-of select="$id_el"/> { color:black }
				span#<xsl:value-of select="$id_span"/> { color:<xsl:value-of select="../@couleur_texte"/> }
				
			</redirect:write>
			
		</xsl:when>
		
		
		
		<xsl:otherwise>
			<li><xsl:apply-templates/></li>
		</xsl:otherwise>
	
	</xsl:choose> 
    </xsl:template>
    
    <xsl:template match="LISTEDEF">
        <xsl:if test="normalize-space(TITRE)!=''">
            <h3><xsl:value-of select="TITRE"/></h3>
        </xsl:if>
        <dl>
            <xsl:apply-templates select="TERME | DEF"/>
        </dl>
    </xsl:template>
    
    <xsl:template match="TERME">
        <dt><xsl:apply-templates/></dt>
    </xsl:template>
    
    <xsl:template match="DEF">
        <dd><xsl:apply-templates/></dd>
    </xsl:template>
    
    <xsl:template match="ESP"></xsl:template>
    
    <xsl:template match="BR"><br/></xsl:template>
    
    <xsl:template match="IMAGE">
        <img alt="{@alt}" src="{@fichier}"/>
    </xsl:template>
    
    <xsl:template match="TABLEAU">
        <table border="1" width="100%">
            <xsl:apply-templates/>
        </table>
    </xsl:template>
    
    <xsl:template match="LT">
        <tr><xsl:apply-templates/></tr>
    </xsl:template>
    
    <xsl:template match="ET">
        <th>
            <xsl:if test="@colspan"><xsl:attribute name="colspan"><xsl:value-of select="@colspan"/></xsl:attribute></xsl:if>
            <xsl:apply-templates/>
        </th>
    </xsl:template>
    
    <xsl:template match="CT">
        <xsl:variable name="ltpos"><xsl:number count="LT" from="TABLEAU"/></xsl:variable>
        <td class="tableau{1+($ltpos mod 2)}">
            <xsl:if test="@colspan"><xsl:attribute name="colspan"><xsl:value-of select="@colspan"/></xsl:attribute></xsl:if>
            <xsl:if test="@rowspan"><xsl:attribute name="rowspan"><xsl:value-of select="@rowspan"/></xsl:attribute></xsl:if>
            <xsl:apply-templates/>
        </td>
    </xsl:template>
    
    <xsl:template match="EQUATION">
        <img alt="{@texte}" class="equation" src="{@image}"/>
    </xsl:template>
    
    <xsl:template match="ENVIMAGE">
        <div align="center"><table border="0" cellspacing="10" class="envimage">
            <xsl:if test="normalize-space(TITRE)!=''">
                <tr><td><div class="titreimage"><xsl:value-of select="TITRE"/></div></td></tr>
            </xsl:if>
            <tr><td><xsl:apply-templates/></td></tr>
        </table></div>
    </xsl:template>
    
    <xsl:template match="LEGENDE">
        <div class="legende">
            <xsl:apply-templates/>
        </div>
    </xsl:template>
    
    <xsl:template match="COMMENTAIRE">
        <xsl:if test="$commentaires='oui'">
            <div class="commentaire">
                <xsl:apply-templates/>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="APPLET">
        <applet archive="{@archive}" code="{@classe}" height="{@hauteur}" width="{@largeur}">
            <xsl:apply-templates/>
        </applet>
        <br/>
    </xsl:template>
    
    <xsl:template match="PARAM">
        <param name="{@nom}" value="{@valeur}"/>
    </xsl:template>
    
    <xsl:template match="HTML">
	<xsl:value-of select="." disable-output-escaping="yes"/> 	
    </xsl:template>
    
</xsl:stylesheet>
