/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.propertiespanel;

import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEComponentSettings;
import org.enhydra.jawe.JaWEComponentView;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.XPDLElementChangeInfo;
import org.enhydra.jawe.base.panel.InlinePanel;
import org.enhydra.jawe.base.panel.PanelSettings;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.elements.Package;

public class PropertiesPanelComponent
implements JaWEComponent,
Observer {
    protected String type = "OTHER";
    protected InlinePanel inlinePanel;
    protected String name = null;
    protected PanelSettings settings;
    protected boolean updateInProgress = false;

    public PropertiesPanelComponent(JaWEComponentSettings jaWEComponentSettings) throws Exception {
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            this.inlinePanel = (InlinePanel)classLoader.loadClass(JaWEManager.getInstance().getInlinePanelClassName()).newInstance();
        }
        catch (Exception exception) {
            String string = "PropertiesPanelComponent --> Problems while instantiating InlinePanel class '" + JaWEManager.getInstance().getInlinePanelClassName() + "' - using default implementation!";
            JaWEManager.getInstance().getLoggingManager().error(string, (Throwable)exception);
            this.inlinePanel = new InlinePanel();
        }
        try {
            this.settings = (PanelSettings)jaWEComponentSettings;
            this.inlinePanel.setJaWEComponent((JaWEComponent)this);
            this.settings.init((JaWEComponent)this);
            this.inlinePanel.init();
            JaWEManager.getInstance().getJaWEController().addObserver((Observer)this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public JaWEComponentSettings getSettings() {
        return this.settings;
    }

    public PanelSettings getPanelSettings() {
        return (PanelSettings)this.getSettings();
    }

    public void setUpdateInProgress(boolean bl) {
        this.updateInProgress = bl;
    }

    public boolean isUpdateInProgress() {
        return this.updateInProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable observable, Object object) {
        if (!(object instanceof XPDLElementChangeInfo)) {
            return;
        }
        if (this.updateInProgress) {
            return;
        }
        if (!(object instanceof XPDLElementChangeInfo)) {
            return;
        }
        XPDLElementChangeInfo xPDLElementChangeInfo = (XPDLElementChangeInfo)object;
        int n = xPDLElementChangeInfo.getAction();
        if (n != 1 && n != 3 && n != 5 && n != 8 && n != 15 && n != 16 && n != 17) {
            return;
        }
        long l = System.currentTimeMillis();
        this.updateInProgress = true;
        try {
            if (n == 15 || n == 16 || n == 17) {
                if (n == 15) {
                    for (int i = 0; i < xPDLElementChangeInfo.getChangedSubElements().size(); ++i) {
                        XPDLElementChangeInfo xPDLElementChangeInfo2 = (XPDLElementChangeInfo)xPDLElementChangeInfo.getChangedSubElements().get(i);
                        if (xPDLElementChangeInfo2.getAction() != 5) continue;
                        this.inlinePanel.update(xPDLElementChangeInfo2);
                    }
                }
                this.inlinePanel.setActiveElement(null);
            } else {
                this.inlinePanel.update(xPDLElementChangeInfo);
            }
        }
        finally {
            this.updateInProgress = false;
        }
        long l2 = System.currentTimeMillis();
        double d = (double)(l2 - l) / 1000.0;
        JaWEManager.getInstance().getLoggingManager().debug("THE UPDATE OF PROPERTY PANEL COMPONENT LASTED FOR " + d + " SECONDS!");
    }

    public JaWEComponentView getView() {
        return this.inlinePanel;
    }

    public String getComponentType() {
        return this.type;
    }

    public void setComponentType(String string) {
        this.type = string;
    }

    public String getName() {
        return "PropertiesPanelComponent";
    }

    public boolean adjustXPDL(Package package_) {
        return false;
    }

    public List checkValidity(XMLElement xMLElement, boolean bl) {
        return null;
    }

    public boolean canCreateElement(XMLCollection xMLCollection) {
        return true;
    }

    public boolean canInsertElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    public boolean canModifyElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    public boolean canModifyElement(XMLElement xMLElement) {
        return true;
    }

    public boolean canRemoveElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    public boolean canDuplicateElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    public boolean canRepositionElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }
}

