/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.extpkgrelations;

import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEComponentSettings;
import org.enhydra.jawe.JaWEComponentView;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.XPDLElementChangeInfo;
import org.enhydra.jawe.components.extpkgrelations.ExtPkgRelationsPanel;
import org.enhydra.jawe.components.extpkgrelations.ExtPkgRelationsSettings;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.elements.Package;

public class ExtPkgRelations
implements Observer,
JaWEComponent {
    protected String type = "SPECIAL";
    protected boolean updateInProgress = false;
    protected ExtPkgRelationsPanel panel;
    protected ExtPkgRelationsSettings settings;

    public ExtPkgRelations(JaWEComponentSettings jaWEComponentSettings) throws Exception {
        this.settings = (ExtPkgRelationsSettings)jaWEComponentSettings;
        this.settings.init(this);
        this.init();
        JaWEManager.getInstance().getJaWEController().addObserver((Observer)this);
    }

    @Override
    public void update(Observable observable, Object object) {
        if (!(object instanceof XPDLElementChangeInfo)) {
            return;
        }
        XPDLElementChangeInfo xPDLElementChangeInfo = (XPDLElementChangeInfo)object;
        int n = xPDLElementChangeInfo.getAction();
        if (n != 3 && n != 5 && n != 8 && n != 10) {
            return;
        }
        long l = System.currentTimeMillis();
        JaWEManager.getInstance().getLoggingManager().info("ExtPkgOverview -> update for event " + xPDLElementChangeInfo + " started ...");
        this.update(xPDLElementChangeInfo);
        JaWEManager.getInstance().getLoggingManager().info("ExtPkgOverview -> update ended...");
        long l2 = System.currentTimeMillis();
        double d = (double)(l2 - l) / 1000.0;
        JaWEManager.getInstance().getLoggingManager().debug("THE UPDATE OF EXT PKG OVERVIEW COMPONENT LASTED FOR " + d + " SECONDS!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(XPDLElementChangeInfo xPDLElementChangeInfo) {
        if (this.updateInProgress) {
            return;
        }
        if (xPDLElementChangeInfo.getSource() == this) {
            return;
        }
        this.updateInProgress = true;
        try {
            this.panel.refreshExtPkgPanel(xPDLElementChangeInfo);
            this.settings.adjustActions();
        }
        finally {
            this.updateInProgress = false;
        }
    }

    protected void init() {
        this.panel = new ExtPkgRelationsPanel(this);
        this.panel.configure();
    }

    public JaWEComponentView getView() {
        return this.panel;
    }

    public JComponent getDisplay() {
        return this.panel.getDisplay();
    }

    public String getComponentType() {
        return this.type;
    }

    public void setComponentType(String string) {
        this.type = string;
    }

    public String getName() {
        return "ExtPkgRelationsComponent";
    }

    public JaWEComponentSettings getSettings() {
        return this.settings;
    }

    public ExtPkgRelationsSettings getExtSettings() {
        return this.settings;
    }

    public boolean hasRelations() {
        return this.panel.hasRelations();
    }

    public boolean adjustXPDL(Package package_) {
        return false;
    }

    public List checkValidity(XMLElement xMLElement, boolean bl) {
        return null;
    }

    public boolean canCreateElement(XMLCollection xMLCollection) {
        return true;
    }

    public boolean canInsertElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    public boolean canModifyElement(XMLElement xMLElement) {
        return true;
    }

    public boolean canRemoveElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    public boolean canDuplicateElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    public boolean canRepositionElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    public void setUpdateInProgress(boolean bl) {
        this.updateInProgress = bl;
    }

    public boolean isUpdateInProgress() {
        return this.updateInProgress;
    }
}

