/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.searchnavigator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.enhydra.jawe.BarFactory;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEComponentView;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.SearchResult;
import org.enhydra.jawe.XPDLElementChangeInfo;
import org.enhydra.jawe.components.XPDLTreeCellRenderer;
import org.enhydra.jawe.components.XPDLTreeNode;
import org.enhydra.jawe.components.XPDLTreeUtil;
import org.enhydra.jawe.components.searchnavigator.SearchNavigator;
import org.enhydra.jawe.components.searchnavigator.SearchNavigatorTreeModel;
import org.enhydra.jxpdl.XMLComplexElement;
import org.enhydra.jxpdl.XMLElement;

public class SearchNavigatorPanel
extends JPanel
implements JaWEComponentView {
    protected SearchNavigatorTreeModel treeModel;
    protected JTree tree;
    protected JToolBar toolbar;
    protected JLabel searchInfo = new JLabel();
    protected JPanel innerPanel = new JPanel();
    protected JScrollPane scrollPane;
    protected SearchNavigator controller;
    protected int xClick;
    protected int yClick;
    protected MouseListener mouseListener;
    protected XPDLTreeCellRenderer renderer;

    public SearchNavigatorPanel(SearchNavigator searchNavigator) {
        this.controller = searchNavigator;
    }

    public void configure() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.toolbar = BarFactory.createToolbar((String)"defaultToolbar", (JaWEComponent)this.controller);
        this.toolbar.setFloatable(false);
        if (this.toolbar.getComponentCount() > 0) {
            this.add((Component)this.toolbar, "North");
        }
        this.innerPanel.setLayout(new BorderLayout());
        this.innerPanel.add((Component)this.searchInfo, "North");
        this.add((Component)this.innerPanel, "Center");
        this.init();
    }

    public void init() {
        this.treeModel = new SearchNavigatorTreeModel(this.controller);
        this.tree = new JTree((TreeModel)((Object)this.treeModel)){

            @Override
            public void scrollRectToVisible(Rectangle rectangle) {
                rectangle.x = SearchNavigatorPanel.this.scrollPane.getHorizontalScrollBar().getValue();
                super.scrollRectToVisible(rectangle);
            }
        };
        this.tree.getSelectionModel().setSelectionMode(4);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.renderer = new XPDLTreeCellRenderer((JaWEComponent)this.controller);
        Color color = this.controller.getNavigatorSettings().getBackGroundColor();
        this.renderer.setBackgroundNonSelectionColor(color);
        this.tree.setBackground(color);
        this.tree.setCellRenderer((TreeCellRenderer)this.renderer);
        this.tree.addTreeSelectionListener(this.controller);
        this.mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SearchNavigatorPanel.this.xClick = mouseEvent.getX();
                SearchNavigatorPanel.this.yClick = mouseEvent.getY();
                TreePath treePath = SearchNavigatorPanel.this.tree.getPathForLocation(SearchNavigatorPanel.this.xClick, SearchNavigatorPanel.this.yClick);
                if (treePath != null) {
                    Object object;
                    SearchNavigatorPanel.this.tree.setAnchorSelectionPath(treePath);
                    if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                        if (!SearchNavigatorPanel.this.tree.isPathSelected(treePath)) {
                            SearchNavigatorPanel.this.tree.setSelectionPath(treePath);
                        }
                        object = BarFactory.createPopupMenu((String)"default", (JaWEComponent)SearchNavigatorPanel.this.controller);
                        ((JPopupMenu)object).show(SearchNavigatorPanel.this.tree, mouseEvent.getX(), mouseEvent.getY());
                    }
                    object = (XPDLTreeNode)treePath.getLastPathComponent();
                    if (mouseEvent.getClickCount() > 1 && !SwingUtilities.isRightMouseButton(mouseEvent) && SearchNavigatorPanel.this.tree.getModel().isLeaf(object)) {
                        JaWEManager.getInstance().getJaWEController().getJaWEActions().getAction("EditProperties").actionPerformed(null);
                    }
                } else {
                    TreePath treePath2 = SearchNavigatorPanel.this.tree.getClosestPathForLocation(SearchNavigatorPanel.this.xClick, SearchNavigatorPanel.this.yClick);
                    Rectangle rectangle = SearchNavigatorPanel.this.tree.getPathBounds(treePath2);
                    if (rectangle == null || rectangle.y >= SearchNavigatorPanel.this.yClick || rectangle.y + rectangle.height <= SearchNavigatorPanel.this.yClick) {
                        JaWEManager.getInstance().getJaWEController().getSelectionManager().setSelection((XMLElement)null, false);
                        SearchNavigatorPanel.this.tree.clearSelection();
                    }
                }
            }
        };
        this.tree.addMouseListener(this.mouseListener);
        this.scrollPane = new JScrollPane();
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setViewportView(this.tree);
        JViewport jViewport = this.scrollPane.getViewport();
        jViewport.setScrollMode(1);
        this.scrollPane.setBackground(Color.lightGray);
        this.innerPanel.add((Component)this.scrollPane, "Center");
    }

    public TreeModel getTreeModel() {
        return this.treeModel;
    }

    public JTree getTree() {
        return this.tree;
    }

    public JaWEComponent getJaWEComponent() {
        return this.controller;
    }

    public JComponent getDisplay() {
        return this;
    }

    public Point getMouseClickLocation() {
        return new Point(this.xClick, this.yClick);
    }

    public void refreshDisplay(List list) {
        this.renderer.setValidationErrors(list);
        this.tree.repaint();
    }

    public void refreshSearchPanel(XMLElement xMLElement, List list, int n) {
        Set set = this.renderer.getErrors();
        Set set2 = this.renderer.getWarnings();
        this.reinitialize();
        if (xMLElement != null && list != null) {
            JTabbedPane jTabbedPane;
            Object object;
            String string;
            this.renderer.setErrors(set);
            this.renderer.setWarnings(set2);
            if (n == 9) {
                string = null;
                if (xMLElement instanceof XMLComplexElement && (object = ((XMLComplexElement)xMLElement).get("Id")) != null) {
                    string = object.toValue();
                }
                object = " " + JaWEManager.getInstance().getLabelGenerator().getLabel(xMLElement) + " '" + JaWEManager.getInstance().getDisplayNameGenerator().getDisplayName(xMLElement) + "'";
                if (string != null) {
                    object = (String)object + ", Id='" + string + "'";
                }
                object = (String)object + " - " + list.size() + " " + this.controller.getSettings().getLanguageDependentString("ReferencesFound");
                this.searchInfo.setText((String)object);
            } else {
                string = " '" + xMLElement.toName() + "'";
                string = string + " - " + list.size() + " " + this.controller.getSettings().getLanguageDependentString("MatchesFound");
                this.searchInfo.setText(string);
            }
            for (int i = 0; i < list.size(); ++i) {
                object = ((SearchResult)list.get(i)).getElement();
                this.treeModel.insertNode((XMLElement)object);
            }
            if (this.getParent() instanceof JTabbedPane && (object = (jTabbedPane = (JTabbedPane)this.getParent()).getSelectedComponent()) != this) {
                for (int i = 0; i < jTabbedPane.getTabCount(); ++i) {
                    object = jTabbedPane.getComponentAt(i);
                    if (object != this) continue;
                    jTabbedPane.setSelectedIndex(i);
                    break;
                }
            }
            this.requestFocus();
        }
        XPDLTreeUtil.expandOrCollapsToLevel((JTree)this.tree, (TreePath)new TreePath(this.treeModel.getRootNode()), (int)3, (boolean)true);
    }

    public void removeLostReferences(XPDLElementChangeInfo xPDLElementChangeInfo) {
        List list;
        if (xPDLElementChangeInfo.getAction() == 5 && (list = xPDLElementChangeInfo.getChangedSubElements()) != null) {
            for (int i = 0; i < list.size(); ++i) {
                this.treeModel.removeNode((XMLElement)list.get(i));
            }
        }
    }

    protected boolean hasMatches() {
        return this.treeModel.getChildCount(this.treeModel.getRoot()) > 0;
    }

    protected void reinitialize() {
        this.tree.removeMouseListener(this.mouseListener);
        this.tree.removeTreeSelectionListener(this.controller);
        this.innerPanel.remove(this.scrollPane);
        this.treeModel.clearTree();
        this.tree.getSelectionModel().clearSelection();
        this.tree.setCellRenderer(null);
        this.searchInfo.setText("");
        this.init();
    }
}

