/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe;

import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEComponentSettings;
import org.enhydra.jawe.JaWEConstants;
import org.enhydra.jawe.JaWESplash;
import org.enhydra.jawe.PropertyMgr;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.XPDLUtils;
import org.enhydra.jawe.base.componentmanager.ComponentManager;
import org.enhydra.jawe.base.controller.ControllerSettings;
import org.enhydra.jawe.base.controller.JaWEController;
import org.enhydra.jawe.base.display.DisplayNameGenerator;
import org.enhydra.jawe.base.display.DisplayNameGeneratorSettings;
import org.enhydra.jawe.base.display.StandardDisplayNameGenerator;
import org.enhydra.jawe.base.editor.NewStandardXPDLEditorSettings;
import org.enhydra.jawe.base.editor.NewStandardXPDLElementEditor;
import org.enhydra.jawe.base.editor.TableEditor;
import org.enhydra.jawe.base.editor.TableEditorSettings;
import org.enhydra.jawe.base.editor.ValidationOrSearchResultEditor;
import org.enhydra.jawe.base.editor.XPDLElementEditor;
import org.enhydra.jawe.base.idfactory.IdFactory;
import org.enhydra.jawe.base.idfactory.IdFactorySettings;
import org.enhydra.jawe.base.label.LabelGenerator;
import org.enhydra.jawe.base.label.LabelGeneratorSettings;
import org.enhydra.jawe.base.label.StandardLabelGenerator;
import org.enhydra.jawe.base.logger.LoggingManager;
import org.enhydra.jawe.base.panel.InlinePanel;
import org.enhydra.jawe.base.panel.PanelSettings;
import org.enhydra.jawe.base.panel.PanelValidator;
import org.enhydra.jawe.base.panel.StandardPanelGenerator;
import org.enhydra.jawe.base.panel.StandardPanelValidator;
import org.enhydra.jawe.base.tooltip.StandardTooltipGenerator;
import org.enhydra.jawe.base.tooltip.TooltipGenerator;
import org.enhydra.jawe.base.tooltip.TooltipGeneratorSettings;
import org.enhydra.jawe.base.transitionhandler.TransitionHandler;
import org.enhydra.jawe.base.transitionhandler.TransitionHandlerSettings;
import org.enhydra.jawe.base.xpdlhandler.XPDLHandler;
import org.enhydra.jawe.base.xpdlhandler.XPDLHandlerSettings;
import org.enhydra.jawe.base.xpdlobjectfactory.XPDLObjectFactory;
import org.enhydra.jawe.base.xpdlobjectfactory.XPDLObjectFactorySettings;
import org.enhydra.jawe.base.xpdlvalidator.XPDLValidatorSettings;
import org.enhydra.jxpdl.StandardPackageValidator;
import org.enhydra.jxpdl.XMLUtil;
import org.enhydra.jxpdl.XPDLRepositoryHandler;

public class JaWEManager {
    public static final String TOGWE_BASIC_PROPERTYFILE_PATH = "org/enhydra/jawe/properties/";
    public static final String TOGWE_BASIC_PROPERTYFILE_NAME = "togwebasic.properties";
    protected PropertyMgr propertyMgr;
    protected static boolean isConfigured = false;
    protected static Properties properties;
    protected ComponentManager componentManager;
    protected LabelGenerator labelGenerator;
    protected LoggingManager loggingManager;
    protected IdFactory idFactory;
    protected XPDLObjectFactory xpdlObjectFactory;
    protected TransitionHandler transitionHandler;
    protected PanelValidator panelValidator;
    protected StandardPackageValidator xpdlValidator;
    protected XPDLHandler xpdlHandler;
    protected JaWEController jaweController;
    protected DisplayNameGenerator displayNameGenerator;
    protected XPDLElementEditor xpdlElementEditor;
    protected TableEditor tableEditor;
    protected TooltipGenerator tooltipGenerator;
    protected String panelGeneratorClassName;
    protected String inlinePanelClassName;
    protected XPDLUtils xpdlUtils;
    protected ValidationOrSearchResultEditor validationOrSearchResultEditor;
    protected static String splash;
    protected boolean showSplash = false;
    protected static String aboutMsg;
    protected static boolean showLicenseInfo;
    protected static String additionalLicenseText;
    protected static JaWEManager jaweManager;

    protected JaWEManager() {
        splash = "org/enhydra/jawe/images/JaWESplash.jpg";
        aboutMsg = " Visit <a href=\"http://www.together.at/prod/workflow/twe\">Together Workflow Editor Homepage</a> for more <br>information about the product.<br><br>For support please contact: <a href=\"mailto:jawe@enhydra.org\">jawe@enhydra.org</a><br><br>\u00a9 <a href=\"http://www.together.at\">Together Teamsolutions Co., Ltd</a></p>";
        additionalLicenseText = "<html><p align center><br>This product includes software developed by the <br>Apache Software Foundation (http://www.apache.org/).</html>";
        splash = properties.getProperty("JaWESplash.Image", "org/enhydra/jawe/images/JaWESplash.jpg");
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("org.enhydra.jawe.aboutbox");
            aboutMsg = resourceBundle.getString("aboutMsg");
            showLicenseInfo = new Boolean(resourceBundle.getString("showLicenseInfo"));
            additionalLicenseText = resourceBundle.getString("additionalLicenseText");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.showSplash = true;
        this.propertyMgr = new JaWEPropertyMgr();
    }

    public static JaWEManager getInstance() {
        if (jaweManager == null) {
            jaweManager = new JaWEManager();
        }
        return jaweManager;
    }

    public static void configure(Properties properties) {
        if (isConfigured) {
            JaWEManager.getInstance().getLoggingManager().info("Trying to configure " + jaweManager.getName() + " instance that is already configured !!!");
            return;
        }
        if (properties == null) {
            throw new Error(jaweManager.getName() + " needs to be configured properly - given Properties have null value!!!");
        }
        JaWEManager.configureFromJar();
        Utils.adjustProperties(JaWEManager.properties, properties);
        isConfigured = true;
    }

    public static void configure(String string) {
        if (isConfigured) {
            JaWEManager.getInstance().getLoggingManager().info("Trying to configure " + jaweManager.getName() + " instance that is already configured !!!");
            return;
        }
        if (string == null) {
            throw new Error(jaweManager.getName() + " need to be configured properly - given path to configuration file is null!!!");
        }
        File file = new File(string);
        JaWEManager.configure(file);
    }

    public static void configure(File file) {
        if (isConfigured) {
            JaWEManager.getInstance().getLoggingManager().info("Trying to configure " + jaweManager.getName() + " instance that is already configured !!!");
            return;
        }
        if (file == null) {
            throw new Error(jaweManager.getName() + " need to be configured properly - given configuration file is null!!!");
        }
        if (!file.isAbsolute()) {
            file = file.getAbsoluteFile();
        }
        if (file.exists()) {
            JaWEManager.configureFromJar();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                Properties properties = new Properties();
                properties.load(fileInputStream);
                fileInputStream.close();
                Utils.adjustProperties(JaWEManager.properties, properties);
            }
            catch (Exception exception) {
                throw new Error("Something went wrong while reading of configuration from the file!!!", exception);
            }
        } else {
            throw new Error(jaweManager.getName() + " needs to be configured properly - configuration file " + file + " does not exist!!!");
        }
        isConfigured = true;
    }

    public static void configure() {
        if (isConfigured) {
            JaWEManager.getInstance().getLoggingManager().info("Trying to configure " + jaweManager.getName() + " instance that is already configured !!!");
            return;
        }
        JaWEManager.configureFromJar();
        isConfigured = true;
    }

    protected static void configureFromJar() {
        try {
            File file = new File(JaWEConstants.JAWE_USER_HOME);
            if (!file.exists()) {
                try {
                    file.mkdir();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            URL uRL = JaWEManager.class.getClassLoader().getResource("org/enhydra/jawe/properties/jaweconfiguration.properties");
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            properties = new Properties();
            properties.load(inputStream);
            Utils.copyPropertyFile(TOGWE_BASIC_PROPERTYFILE_PATH, "jaweconfiguration.properties", false);
            uRL = JaWEManager.class.getClassLoader().getResource("org/enhydra/jawe/language/jawelanguagemisc.properties");
            uRLConnection = uRL.openConnection();
            inputStream = uRLConnection.getInputStream();
            Utils.copyPropertyFile("org/enhydra/jawe/language/", "jawelanguagemisc.properties", false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Error(jaweManager.getName() + " need to be configured properly - Can't read " + jaweManager.getName() + "'s default configuration from JAR!!!", exception);
        }
    }

    public void init() {
        Object object;
        Object object2;
        XPDLRepositoryHandler xPDLRepositoryHandler;
        if (!isConfigured) {
            return;
        }
        String string = properties.getProperty("ComponentManager.Class", "org.enhydra.jawe.base.componentmanager.ComponentManager");
        String string2 = properties.getProperty("DisplayNameGenerator.Class", "org.enhydra.jawe.base.display.StandardDisplayNameGenerator");
        String string3 = properties.getProperty("DisplayNameGenerator.Settings", "org.enhydra.jawe.base.display.DisplayNameGeneratorSettings");
        String string4 = properties.getProperty("JaWEController.Class", "org.enhydra.jawe.base.controller.JaWEController");
        String string5 = properties.getProperty("JaWEController.Settings", "org.enhydra.jawe.base.controller.ControllerSettings");
        String string6 = properties.getProperty("LabelGenerator.Class", "org.enhydra.jawe.base.label.StandardLabelGenerator");
        String string7 = properties.getProperty("LabelGenerator.Settings", "org.enhydra.jawe.base.label.LabelGeneratorSettings");
        String string8 = properties.getProperty("LoggingManager.Class", "org.enhydra.jawe.base.logger.LoggingManager");
        String string9 = properties.getProperty("TransitionHandler.Class", "org.enhydra.jawe.base.transitionhandler.TransitionHandler");
        String string10 = properties.getProperty("TransitionHandler.Settings", "org.enhydra.jawe.base.transitionhandler.TransitionHandlerSettings");
        String string11 = properties.getProperty("IdFactory.Class", "org.enhydra.jawe.base.idfactory.IdFactory");
        String string12 = properties.getProperty("IdFactory.Settings", "org.enhydra.jawe.base.idfactory.IdFactorySettings");
        String string13 = properties.getProperty("XPDLObjectFactory.Class", "org.enhydra.jawe.base.xpdlobjectfactory.XPDLObjectFactory");
        String string14 = properties.getProperty("XPDLObjectFactory.Settings", "org.enhydra.jawe.base.xpdlobjectfactory.XPDLObjectFactorySettings");
        String string15 = properties.getProperty("PanelValidator.Class", "org.enhydra.jawe.base.panel.StandardPanelValidator");
        String string16 = properties.getProperty("XPDLValidator.Class", "org.enhydra.jawe.base.xpdlvalidator.TogWEXPDLValidator");
        String string17 = properties.getProperty("XPDLValidator.Settings", "org.enhydra.jawe.base.xpdlvalidator.XPDLValidatorSettings");
        String string18 = properties.getProperty("XPDLRepositoryHandler.Class", "org.enhydra.jxpdl.XPDLRepositoryHandler");
        String string19 = properties.getProperty("XPDLElementEditor.Class", "org.enhydra.jawe.base.editor.TogWEStandardXPDLElementEditor");
        String string20 = properties.getProperty("XPDLElementEditor.Settings", "org.enhydra.jawe.base.editor.TogWEStandardXPDLEditorSettings");
        String string21 = properties.getProperty("TableEditor.Class", "org.enhydra.jawe.base.editor.TogWETableEditor");
        String string22 = properties.getProperty("TableEditor.Settings", "org.enhydra.jawe.base.editor.TableEditorSettings");
        String string23 = properties.getProperty("TooltipGenerator.Class", "org.enhydra.jawe.base.tooltip.StandardTooltipGenerator");
        String string24 = properties.getProperty("TooltipGenerator.Settings", "org.enhydra.jawe.base.tooltip.TooltipGeneratorSettings");
        this.panelGeneratorClassName = properties.getProperty("PanelGenerator.Class", "org.enhydra.jawe.base.panel.StandardPanelGenerator");
        this.inlinePanelClassName = properties.getProperty("InlinePanel.Class", "org.enhydra.jawe.base.panel.InlinePanel");
        String string25 = properties.getProperty("XPDLUtils.Class", "org.enhydra.jawe.XPDLUtils");
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            xPDLRepositoryHandler = Class.forName(string8).getConstructor(new Class[0]);
            this.loggingManager = (LoggingManager)xPDLRepositoryHandler.newInstance(new Object[0]);
            this.loggingManager.info("JaWEManager -> Working with '" + string8 + "' implementation of Logging Manager");
        }
        catch (Throwable throwable) {
            String string26 = "JaweManager -> Problems while instantiating Logging Manager '" + string8 + "' !";
            System.err.println(string26);
            throw new Error(string26, throwable);
        }
        try {
            xPDLRepositoryHandler = Class.forName(string25).getConstructor(new Class[0]);
            this.xpdlUtils = (XPDLUtils)xPDLRepositoryHandler.newInstance(new Object[0]);
            this.loggingManager.info("JaWEManager -> Working with '" + string25 + "' implementation of XPDLUtils");
        }
        catch (Throwable throwable) {
            this.xpdlUtils = new XPDLUtils();
            object2 = "JaweManager -> Problems while instantiating XPDL Utils '" + string25 + "' - using default implementation!";
            this.loggingManager.error((String)object2, throwable);
        }
        xPDLRepositoryHandler = null;
        try {
            object2 = Class.forName(string18).getConstructor(new Class[0]);
            xPDLRepositoryHandler = (XPDLRepositoryHandler)((Constructor)object2).newInstance(new Object[0]);
            this.loggingManager.info("JaWEManager -> Working with '" + string18 + "' implementation of XPDL Repository Handler");
        }
        catch (Throwable throwable) {
            xPDLRepositoryHandler = new XPDLRepositoryHandler();
            object = "JaweManager -> Problems while instantiating XPDL Repository Handler class '" + string18 + "' - using default implementation!";
            this.loggingManager.error((String)object, throwable);
        }
        this.xpdlHandler = this.createXPDLHandler(xPDLRepositoryHandler);
        this.loggingManager.info("JaWEManager -> Working with '" + ((Object)((Object)this.xpdlHandler)).getClass().getName() + "' implementation of XPDL Handler");
        try {
            object2 = (ControllerSettings)classLoader.loadClass(string5).newInstance();
            ((JaWEComponentSettings)object2).setPropertyMgr(this.propertyMgr);
            object = Class.forName(string4).getConstructor(ControllerSettings.class);
            this.jaweController = (JaWEController)((Constructor)object).newInstance(object2);
            this.jaweController.init();
            this.loggingManager.info("JaWEManager -> Working with '" + string4 + "' implementation of JaWE Controller");
        }
        catch (Throwable throwable) {
            this.jaweController = new JaWEController(new ControllerSettings());
            this.jaweController.init();
            object = "JaweManager -> Problems while instantiating JaWE Controller '" + string4 + "' - using default implementation!";
            this.loggingManager.error((String)object, throwable);
        }
        try {
            object2 = (LabelGeneratorSettings)classLoader.loadClass(string7).newInstance();
            ((JaWEComponentSettings)object2).setPropertyMgr(this.propertyMgr);
            object = Class.forName(string6).getConstructor(LabelGeneratorSettings.class);
            this.labelGenerator = (StandardLabelGenerator)((Constructor)object).newInstance(object2);
            this.loggingManager.info("JaWEManager -> Working with '" + string6 + "' implementation of Label Generator");
        }
        catch (Exception exception) {
            this.labelGenerator = new StandardLabelGenerator();
            object = "JaweManager -> Problems while instantiating Label Generator '" + string6 + "' - using default implementation!";
            this.loggingManager.error((String)object, exception);
        }
        try {
            object2 = (TransitionHandlerSettings)classLoader.loadClass(string10).newInstance();
            ((JaWEComponentSettings)object2).setPropertyMgr(this.propertyMgr);
            object = Class.forName(string9).getConstructor(TransitionHandlerSettings.class);
            this.transitionHandler = (TransitionHandler)((Constructor)object).newInstance(object2);
            this.loggingManager.info("JaWEManager -> Working with '" + string9 + "' implementation of Transition Handler");
        }
        catch (Throwable throwable) {
            this.transitionHandler = new TransitionHandler();
            object = "JaweManager -> Problems while instantiating Transition Handler class '" + string9 + "' - using default implementation!";
            this.loggingManager.error((String)object, throwable);
        }
        try {
            object2 = (IdFactorySettings)classLoader.loadClass(string12).newInstance();
            ((JaWEComponentSettings)object2).setPropertyMgr(this.propertyMgr);
            object = Class.forName(string11).getConstructor(IdFactorySettings.class);
            this.idFactory = (IdFactory)((Constructor)object).newInstance(object2);
            this.loggingManager.info("JaWEManager -> Working with '" + string11 + "' implementation of Id Factory");
        }
        catch (Throwable throwable) {
            this.idFactory = new IdFactory();
            object = "JaweManager -> Problems while instantiating Id Factory class '" + string11 + "' - using default implementation!";
            this.loggingManager.error((String)object, throwable);
        }
        try {
            object2 = (XPDLObjectFactorySettings)classLoader.loadClass(string14).newInstance();
            ((JaWEComponentSettings)object2).setPropertyMgr(this.propertyMgr);
            object = Class.forName(string13).getConstructor(XPDLObjectFactorySettings.class);
            this.xpdlObjectFactory = (XPDLObjectFactory)((Constructor)object).newInstance(object2);
            this.loggingManager.info("JaWEManager -> Working with '" + string13 + "' implementation of XPDL Object Factory");
        }
        catch (Throwable throwable) {
            this.xpdlObjectFactory = new XPDLObjectFactory();
            object = "JaweManager -> Problems while instantiating XPDL Object Factory class '" + string13 + "' - using default implementation!";
            this.loggingManager.error((String)object, throwable);
        }
        try {
            this.panelValidator = (StandardPanelValidator)classLoader.loadClass(string15).newInstance();
            this.loggingManager.info("JaWEManager -> Working with '" + string15 + "' implementation of Panel Validator");
        }
        catch (Throwable throwable) {
            this.panelValidator = new StandardPanelValidator();
            object = "JaweManager -> Problems while instantiating Panel Validator class '" + string15 + "' - using default implementation!";
            this.loggingManager.error((String)object, throwable);
        }
        try {
            object2 = (XPDLValidatorSettings)classLoader.loadClass(string17).newInstance();
            ((JaWEComponentSettings)object2).setPropertyMgr(this.propertyMgr);
            ((XPDLValidatorSettings)object2).init(null);
            object = Class.forName(string16).getConstructor(Properties.class);
            this.xpdlValidator = (StandardPackageValidator)((Constructor)object).newInstance(((XPDLValidatorSettings)object2).getProperties());
            this.loggingManager.info("JaWEManager -> Working with '" + string16 + "' implementation of XPDL Validator");
        }
        catch (Throwable throwable) {
            object = new XPDLValidatorSettings();
            ((XPDLValidatorSettings)object).init(null);
            this.xpdlValidator = new StandardPackageValidator(((XPDLValidatorSettings)object).getProperties());
            String string27 = "JaweManager -> Problems while instantiating XPDL Validator class '" + string16 + "' - using default implementation!";
            this.loggingManager.error(string27, throwable);
        }
        this.validationOrSearchResultEditor = new ValidationOrSearchResultEditor();
        try {
            object2 = (DisplayNameGeneratorSettings)classLoader.loadClass(string3).newInstance();
            ((JaWEComponentSettings)object2).setPropertyMgr(this.propertyMgr);
            object = Class.forName(string2).getConstructor(DisplayNameGeneratorSettings.class);
            this.displayNameGenerator = (StandardDisplayNameGenerator)((Constructor)object).newInstance(object2);
            this.loggingManager.info("JaWEManager -> Working with '" + string2 + "' implementation of Display Name Generator");
        }
        catch (Exception exception) {
            this.displayNameGenerator = new StandardDisplayNameGenerator();
            object = "JaweManager -> Problems while instantiating Display Name Generator class '" + string2 + "' - using default implementation!";
            this.loggingManager.error((String)object, exception);
        }
        try {
            classLoader.loadClass(this.panelGeneratorClassName).newInstance();
            this.loggingManager.info("JaWEManager -> Using '" + this.panelGeneratorClassName + "' implementation of Panel Generator");
        }
        catch (Exception exception) {
            object = "JaWEManager -> Problems while instantiating Panel Generator class '" + JaWEManager.getInstance().getPanelGeneratorClassName() + "' - using default implementation!";
            JaWEManager.getInstance().getLoggingManager().error((String)object, exception);
            this.panelGeneratorClassName = StandardPanelGenerator.class.getName();
        }
        try {
            classLoader.loadClass(this.inlinePanelClassName).newInstance();
            this.loggingManager.info("JaWEManager -> Using '" + this.inlinePanelClassName + "' implementation of Inline Panel");
        }
        catch (Exception exception) {
            object = "JaWEManager --> Problems while instantiating InlinePanel class '" + JaWEManager.getInstance().getInlinePanelClassName() + "' - using default implementation!";
            JaWEManager.getInstance().getLoggingManager().error((String)object, exception);
            this.inlinePanelClassName = InlinePanel.class.getName();
        }
        try {
            object2 = (PanelSettings)classLoader.loadClass(string20).newInstance();
            ((JaWEComponentSettings)object2).setPropertyMgr(this.propertyMgr);
            object = Class.forName(string19).getConstructor(PanelSettings.class);
            this.xpdlElementEditor = (XPDLElementEditor)((Constructor)object).newInstance(object2);
            this.loggingManager.info("JaWEManager -> Working with '" + string19 + "' implementation of XPDL Element Editor ");
        }
        catch (Throwable throwable) {
            this.xpdlElementEditor = new NewStandardXPDLElementEditor(new NewStandardXPDLEditorSettings());
            object = "JaweManager -> Problems while instantiating XPDL Element Editor class '" + string19 + "' - using default implementation!";
            this.loggingManager.error((String)object, throwable);
        }
        try {
            object2 = (TableEditorSettings)classLoader.loadClass(string22).newInstance();
            ((JaWEComponentSettings)object2).setPropertyMgr(this.propertyMgr);
            object = Class.forName(string21).getConstructor(TableEditorSettings.class);
            this.tableEditor = (TableEditor)((Constructor)object).newInstance(object2);
            this.loggingManager.info("JaWEManager -> Working with '" + string21 + "' implementation of Table Editor ");
        }
        catch (Throwable throwable) {
            this.tableEditor = new TableEditor(new TableEditorSettings());
            object = "JaweManager -> Problems while instantiating table editor class '" + string21 + "' - using default implementation!";
            this.loggingManager.error((String)object, throwable);
        }
        try {
            object2 = (TooltipGeneratorSettings)classLoader.loadClass(string24).newInstance();
            ((JaWEComponentSettings)object2).setPropertyMgr(this.propertyMgr);
            object = Class.forName(string23).getConstructor(TooltipGeneratorSettings.class);
            this.tooltipGenerator = (StandardTooltipGenerator)((Constructor)object).newInstance(object2);
            this.loggingManager.info("JaWEManager -> Working with '" + string23 + "' implementation of Tooltip Generator");
        }
        catch (Exception exception) {
            this.tooltipGenerator = new StandardTooltipGenerator();
            object = "JaweManager -> Problems while instantiating Tooltip Generator class '" + string23 + "' - using default implementation!";
            this.loggingManager.error((String)object, exception);
        }
        try {
            this.componentManager = (ComponentManager)classLoader.loadClass(string).newInstance();
            this.componentManager.setPropertyMgr(this.propertyMgr);
            this.componentManager.init();
            this.loggingManager.info("JaWEManager -> Working with '" + string + "' implementation of Component Manager");
        }
        catch (Throwable throwable) {
            this.componentManager = new ComponentManager();
            this.componentManager.init();
            object = "JaWEManger -> Problems while instantiating Component Manager class '" + string + "' - using default implementation!";
            this.loggingManager.error((String)object, throwable);
        }
        this.getXPDLHandler().getXPDLRepositoryHandler().setXPDLPrefixEnabled(Boolean.valueOf(properties.getProperty("UseXPDLPrefix", "true")).booleanValue());
        Utils.getActivityIconsMap();
        this.loadTransientPackages();
    }

    public void restart(String string) throws Throwable {
        this.clearComponents();
        String string2 = System.getProperty("JaWE_CURRENT_CONFIG_HOME");
        String string3 = string2 + "/" + TOGWE_BASIC_PROPERTYFILE_NAME;
        File file = new File(string3);
        if (!file.exists()) {
            string3 = string2 + "/" + "jaweconfiguration.properties";
            file = new File(string3);
        }
        if (file.exists()) {
            JaWEManager.configure(file);
        } else {
            JaWEManager.configure();
        }
        ResourceManager.reconfigure();
        JaWEManager.getInstance().start(string);
    }

    public void loadTransientPackages() {
        String string = properties.getProperty("DefaultTransientPackages", "");
        String[] stringArray = XMLUtil.tokenize((String)string, (String)",");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i].trim();
                this.getJaWEController().addTransientPackage(string2);
            }
        }
    }

    public String getName() {
        return ResourceManager.getLanguageDependentString("Title");
    }

    public XPDLHandler createXPDLHandler(XPDLRepositoryHandler xPDLRepositoryHandler) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        String string = properties.getProperty("XPDLHandler.Class", "org.enhydra.jawe.base.xpdlhandler.XPDLHandler");
        String string2 = properties.getProperty("XPDLHandler.Settings", "org.enhydra.jawe.base.xpdlhandler.XPDLHandlerSettings");
        XPDLHandler xPDLHandler = null;
        try {
            XPDLHandlerSettings xPDLHandlerSettings = (XPDLHandlerSettings)classLoader.loadClass(string2).newInstance();
            xPDLHandlerSettings.setPropertyMgr(this.propertyMgr);
            Constructor<?> constructor = Class.forName(string).getConstructor(XPDLHandlerSettings.class);
            xPDLHandler = (XPDLHandler)((Object)constructor.newInstance(xPDLHandlerSettings));
        }
        catch (Throwable throwable) {
            String string3 = "JaweManager -> Problems while instantiating XPDL Handler class '" + string + "' - using default!";
            xPDLHandler = new XPDLHandler();
            xPDLHandler.setXPDLRepositoryHandler(xPDLRepositoryHandler);
            this.loggingManager.error(string3, throwable);
        }
        xPDLHandler.setXPDLRepositoryHandler(xPDLRepositoryHandler);
        xPDLHandler.setLocale(ResourceManager.getChoosenLocale());
        return xPDLHandler;
    }

    protected void clearComponents() {
        this.getJaWEController().getJaWEFrame().dispose();
        isConfigured = false;
        this.showSplash = false;
        this.componentManager = null;
        this.labelGenerator = null;
        this.loggingManager = null;
        this.idFactory = null;
        this.xpdlObjectFactory = null;
        this.transitionHandler = null;
        this.panelValidator = null;
        this.xpdlValidator = null;
        this.xpdlHandler = null;
        this.jaweController = null;
        this.displayNameGenerator = null;
        this.xpdlElementEditor = null;
        this.tableEditor = null;
        this.tooltipGenerator = null;
        this.panelGeneratorClassName = null;
        this.inlinePanelClassName = null;
        this.xpdlUtils = null;
    }

    public void start(String string) throws Throwable {
        Object object;
        long l;
        block17: {
            if (!isConfigured) {
                return;
            }
            l = System.currentTimeMillis();
            String string2 = JaWEManager.getLookAndFeelClassName();
            if (string2 == null || !string2.equals("")) {
                try {
                    UIManager.setLookAndFeel(string2);
                }
                catch (Exception exception) {
                    if (File.pathSeparator.equals(";")) {
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                        break block17;
                    }
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                }
            } else if (File.pathSeparator.equals(";")) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
        }
        try {
            FontUIResource fontUIResource;
            try {
                fontUIResource = new FontUIResource(JaWEManager.getFontName(), 0, JaWEManager.getFontSize());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                fontUIResource = (FontUIResource)UIManager.getDefaults().get("Label.font");
            }
            object = UIManager.getDefaults().keys();
            while (object.hasMoreElements()) {
                Object e = object.nextElement();
                Object object2 = UIManager.get(e);
                if (!(object2 instanceof FontUIResource)) continue;
                UIManager.put(e, fontUIResource);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = null;
        if (this.showSplash) {
            object = new JaWESplash();
        }
        JaWEManager.getInstance().init();
        long l2 = System.currentTimeMillis();
        if (this.loggingManager != null) {
            this.loggingManager.info("JaWEManager -> " + this.getName() + " editor initialization is finished, it lasted " + (l2 - l) + " ms");
            this.loggingManager.info(this.getName() + " ready and waiting ...");
        }
        if (string != null) {
            this.jaweController.openPackageFromFile(string);
        }
        if (object != null) {
            ((Window)object).dispose();
            object = null;
        }
        this.jaweController.showJaWEFrame();
    }

    public static String getFontName() {
        if (isConfigured) {
            try {
                FontUIResource fontUIResource = (FontUIResource)UIManager.getDefaults().get("Label.font");
                return properties.getProperty("Font.Name", fontUIResource.getFontName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "System";
    }

    public static int getFontSize() {
        int n = 11;
        if (isConfigured) {
            try {
                FontUIResource fontUIResource = (FontUIResource)UIManager.getDefaults().get("Label.font");
                n = fontUIResource.getSize();
                String string = properties.getProperty("Font.Size", String.valueOf(n));
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public String getStartingLocale() {
        if (isConfigured) {
            return properties.getProperty("StartingLocale", "default");
        }
        return "default";
    }

    public static String getLookAndFeelClassName() {
        if (isConfigured) {
            return properties.getProperty("LookAndFeelClassName", "");
        }
        return null;
    }

    public static String getSplashScreenImage() {
        return splash;
    }

    public static String getAboutMsg() {
        return aboutMsg;
    }

    public static boolean showLicenseInfo() {
        return showLicenseInfo;
    }

    public static String getAdditionalLicenseText() {
        return additionalLicenseText;
    }

    public ComponentManager getComponentManager() {
        return this.componentManager;
    }

    public LabelGenerator getLabelGenerator() {
        return this.labelGenerator;
    }

    public LoggingManager getLoggingManager() {
        return this.loggingManager;
    }

    public TransitionHandler getTransitionHandler() {
        return this.transitionHandler;
    }

    public IdFactory getIdFactory() {
        return this.idFactory;
    }

    public XPDLObjectFactory getXPDLObjectFactory() {
        return this.xpdlObjectFactory;
    }

    public PanelValidator getPanelValidator() {
        return this.panelValidator;
    }

    public StandardPackageValidator getXPDLValidator() {
        return this.xpdlValidator;
    }

    public XPDLHandler getXPDLHandler() {
        return this.xpdlHandler;
    }

    public JaWEController getJaWEController() {
        return this.jaweController;
    }

    public DisplayNameGenerator getDisplayNameGenerator() {
        return this.displayNameGenerator;
    }

    public XPDLElementEditor getXPDLElementEditor() {
        return this.xpdlElementEditor;
    }

    public TableEditor getTableEditor() {
        return this.tableEditor;
    }

    public TooltipGenerator getTooltipGenerator() {
        return this.tooltipGenerator;
    }

    public String getPanelGeneratorClassName() {
        return this.panelGeneratorClassName;
    }

    public String getInlinePanelClassName() {
        return this.inlinePanelClassName;
    }

    public XPDLUtils getXPDLUtils() {
        return this.xpdlUtils;
    }

    public ValidationOrSearchResultEditor getValidationOrSearchResultEditor() {
        return this.validationOrSearchResultEditor;
    }

    static {
        showLicenseInfo = true;
    }

    class JaWEPropertyMgr
    implements PropertyMgr {
        JaWEPropertyMgr() {
        }

        @Override
        public Properties loadProperties(String string, String string2) {
            Properties properties = new Properties();
            try {
                Utils.manageProperties(properties, string, string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return properties;
        }

        @Override
        public void manageProperties(JaWEComponent jaWEComponent, JaWEComponentSettings jaWEComponentSettings, String string, String string2) {
            try {
                jaWEComponentSettings.loadDefault(jaWEComponent, this.loadProperties(string, string2));
            }
            catch (Exception exception) {
                System.err.println("Something's wrong with " + string2 + ", it has been overwritten by the default one!");
                try {
                    jaWEComponentSettings.clear();
                    Utils.copyPropertyFile(string, string2, true);
                    jaWEComponentSettings.loadDefault(jaWEComponent, new Properties());
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
    }
}

