/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.enhydra.jawe.AdditionalResourceManager;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.misc.PFLocale;

public class ResourceManager {
    public static final String RESOURCE_PATH = "org.enhydra.jawe.language.JaWE";
    protected static Locale defaultLocale;
    protected static ResourceBundle defaultResourceBoundle;
    protected static Locale choosenLocale;
    protected static ResourceBundle choosenResourceBundle;
    protected static AdditionalResourceManager addResMgr;

    public static String getLanguageDependentString(String string) {
        String string2;
        try {
            string2 = choosenResourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            try {
                string2 = defaultResourceBoundle.getString(string);
            }
            catch (MissingResourceException missingResourceException2) {
                try {
                    string2 = addResMgr.getLanguageDependentString(string);
                }
                catch (Exception exception) {
                    string2 = null;
                }
            }
        }
        return string2;
    }

    public static String getLanguageDependentString(AdditionalResourceManager additionalResourceManager, String string) {
        String string2 = ResourceManager.getLanguageDependentString(string);
        if (string2 == null && additionalResourceManager != null) {
            string2 = additionalResourceManager.getLanguageDependentString(string);
        }
        return string2;
    }

    public static String getResourceString(Properties properties, String string) {
        String string2 = null;
        try {
            string2 = properties.getProperty(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public static List getResourceStrings(Properties properties, String string) {
        return ResourceManager.getResourceStrings(properties, string, true);
    }

    public static List getResourceStrings(Properties properties, String string, boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = string.length();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (!((String)entry.getKey()).startsWith(string)) continue;
            if (bl) {
                arrayList.add(entry.getValue());
                continue;
            }
            arrayList.add(((String)entry.getKey()).substring(n));
        }
        return arrayList;
    }

    public static URL getResource(Properties properties, String string) {
        String string2 = properties.getProperty(string);
        if (string2 != null) {
            URL uRL = ResourceManager.class.getClassLoader().getResource(string2);
            return uRL;
        }
        return null;
    }

    public static void setDefault() {
        choosenResourceBundle = defaultResourceBoundle;
        choosenLocale = defaultLocale;
    }

    public static void setSystem() {
        choosenLocale = Locale.getDefault();
        choosenResourceBundle = ResourceBundle.getBundle(RESOURCE_PATH, choosenLocale);
    }

    public static ResourceBundle getDefaultResourceBundle() {
        return defaultResourceBoundle;
    }

    public static ResourceBundle getChoosenResourceBundle() {
        return choosenResourceBundle;
    }

    public static Locale getDefaultLocale() {
        return defaultLocale;
    }

    public static Locale getChoosenLocale() {
        return choosenLocale;
    }

    public static void setChoosen(Locale locale) throws MissingResourceException {
        Locale locale2 = choosenLocale;
        try {
            choosenLocale = locale;
            choosenResourceBundle = ResourceBundle.getBundle(RESOURCE_PATH, locale);
        }
        catch (Exception exception) {
            choosenLocale = locale2;
        }
    }

    public static void reconfigure() {
        try {
            Object object;
            defaultLocale = new Locale("");
            defaultResourceBoundle = ResourceBundle.getBundle(RESOURCE_PATH, defaultLocale);
            String string = JaWEManager.getInstance().getStartingLocale();
            if (string != null && string.length() > 0) {
                if (!string.equals("default")) {
                    object = PFLocale.createPFLocale(string);
                    choosenLocale = ((PFLocale)object).getLocale();
                } else {
                    choosenLocale = defaultLocale;
                }
            } else {
                choosenLocale = Locale.getDefault();
            }
            choosenResourceBundle = string != null && !string.equals("default") ? ResourceBundle.getBundle(RESOURCE_PATH, choosenLocale) : defaultResourceBoundle;
            object = new Properties();
            ((Properties)object).put("AdditionalLanguagePropertyFile.1", "jawelanguagemisc.properties");
            addResMgr = new AdditionalResourceManager((Properties)object);
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("org.enhydra.jawe.language.JaWE.properties not found");
            System.exit(1);
        }
    }

    static {
        ResourceManager.reconfigure();
    }
}

