/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.base.controller;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.ToolTipManager;
import org.enhydra.jawe.BarFactory;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEComponentView;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.JaWETabbedPane;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.base.controller.JaWEController;
import org.enhydra.jxpdl.XMLUtil;

public class JaWEFrame
extends JFrame
implements JaWEComponentView {
    protected JaWEController controller;
    protected JMenuBar menubar = new JMenuBar();
    protected JToolBar toolbar;
    protected JPanel menubarAndToolbar = new JPanel();
    protected JPanel workingArea = new JPanel();
    protected JSplitPane bigSplit;
    protected JSplitPane smallSplit1;
    protected JSplitPane smallSplit2;
    protected JaWETabbedPane treeComponents = new JaWETabbedPane();
    protected JaWETabbedPane specialComponents = new JaWETabbedPane();
    protected JaWETabbedPane mainComponents = new JaWETabbedPane();
    protected JaWETabbedPane otherComponents = new JaWETabbedPane();
    protected JaWETabbedPane buttonComponents = new JaWETabbedPane();
    private Rectangle oldBounds;
    private JComponent maxComponent;
    private Container maxCompParent;

    public JaWEFrame(JaWEController jaWEController) {
        this.controller = jaWEController;
        this.setLocale(ResourceManager.getChoosenLocale());
        JOptionPane.setDefaultLocale(ResourceManager.getChoosenLocale());
        JFileChooser.setDefaultLocale(ResourceManager.getChoosenLocale());
    }

    @Override
    public void configure() {
        this.init();
    }

    public void maximizeComponent(JComponent jComponent) {
        this.workingArea.removeAll();
        this.oldBounds = new Rectangle(jComponent.getBounds());
        jComponent.setBounds(0, 0, this.workingArea.getWidth(), this.workingArea.getHeight());
        this.maxComponent = jComponent;
        this.maxCompParent = this.maxComponent.getParent();
        this.workingArea.add((Component)jComponent, "Center");
        jComponent.setVisible(true);
    }

    public void restoreWorkingArea() {
        this.maxComponent.setBounds(this.oldBounds);
        this.workingArea.remove(this.maxComponent);
        this.workingArea.removeAll();
        this.maxCompParent.add(this.maxComponent);
        this.workingArea.add((Component)this.bigSplit, "Center");
    }

    @Override
    public void init() {
        this.mainComponents.setName("MAIN");
        this.specialComponents.setName("SPECIAL");
        this.treeComponents.setName("TREE");
        this.otherComponents.setName("OTHER");
        this.menubar = BarFactory.createMainMenu(this.controller);
        this.toolbar = BarFactory.createToolbar("defaultToolbar", this.controller);
        this.toolbar.setFloatable(false);
        this.setIconImage(this.controller.getControllerSettings().getApplicationIcon().getImage());
        this.setBackground(Color.lightGray);
        this.getContentPane().setLayout(new BorderLayout());
        this.setDefaultCloseOperation(0);
        this.workingArea.setLayout(new BorderLayout());
        this.menubarAndToolbar.setLayout(new BorderLayout());
        this.menubarAndToolbar.add((Component)this.menubar, "North");
        this.menubarAndToolbar.add((Component)this.toolbar, "Center");
        this.arrangeFrame();
        this.getContentPane().add((Component)this.menubarAndToolbar, "North");
        this.workingArea.add((Component)this.bigSplit, "Center");
        this.getContentPane().add((Component)this.workingArea, "Center");
        this.getContentPane().add((Component)this.buttonComponents, "South");
        this.addWindowListener(this.createAppCloser());
        this.pack();
        Dimension dimension = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds().getSize();
        int n = 24;
        int n2 = 50;
        this.setBounds(n / 2, n2 / 2, dimension.width - n, dimension.height - n2);
        if (this.controller.getControllerSettings().shoudStartMaximized()) {
            this.setExtendedState(6);
        }
        ToolTipManager.sharedInstance().setEnabled(this.controller.getControllerSettings().showTooltip());
    }

    @Override
    public JaWEComponent getJaWEComponent() {
        return this.controller;
    }

    @Override
    public JComponent getDisplay() {
        return null;
    }

    public void addMainComponent(String string, JComponent jComponent) {
        String string2 = this.controller.getSettings().getLanguageDependentString(string + "Label");
        JaWEManager.getInstance().getLoggingManager().debug("Added Main component " + string2);
        String string3 = this.controller.getSettings().getLanguageDependentString("DoubleClickToMaximize") + " " + string2 + ". " + this.controller.getSettings().getLanguageDependentString("RightClickToAdd");
        this.mainComponents.insertTab(string2, null, jComponent, string3, this.mainComponents.getComponentCount());
    }

    public void removeMainComponent(JComponent jComponent) {
        this.mainComponents.remove(jComponent);
    }

    public void addToTreeComponents(String string, JComponent jComponent) {
        String string2 = this.controller.getSettings().getLanguageDependentString(string + "Label");
        JaWEManager.getInstance().getLoggingManager().debug("Added tree component " + string2);
        String string3 = this.controller.getSettings().getLanguageDependentString("DoubleClickToMaximize") + " " + string2 + ". " + this.controller.getSettings().getLanguageDependentString("RightClickToAdd");
        this.treeComponents.insertTab(string2, null, jComponent, string3, this.treeComponents.getComponentCount());
    }

    public void removeTreeComponent(JComponent jComponent) {
        this.treeComponents.remove(jComponent);
    }

    public void addToSpecialComponents(String string, JComponent jComponent) {
        String string2 = this.controller.getSettings().getLanguageDependentString(string + "Label");
        JaWEManager.getInstance().getLoggingManager().debug("Added special component " + string2);
        String string3 = this.controller.getSettings().getLanguageDependentString("DoubleClickToMaximize") + " " + string2 + ". " + this.controller.getSettings().getLanguageDependentString("RightClickToAdd");
        this.specialComponents.insertTab(string2, null, jComponent, string3, this.specialComponents.getComponentCount());
    }

    public void removeSpecialComponent(JComponent jComponent) {
        this.specialComponents.remove(jComponent);
    }

    public void addToOtherComponents(String string, JComponent jComponent) {
        String string2 = this.controller.getSettings().getLanguageDependentString(string + "Label");
        JaWEManager.getInstance().getLoggingManager().debug("Added other component " + string2);
        String string3 = this.controller.getSettings().getLanguageDependentString("DoubleClickToMaximize") + " " + string2 + ". " + this.controller.getSettings().getLanguageDependentString("RightClickToAdd");
        this.otherComponents.insertTab(string2, null, jComponent, string3, this.otherComponents.getComponentCount());
    }

    public void removeOtherComponent(JComponent jComponent) {
        this.otherComponents.remove(jComponent);
    }

    public void addUpperStatusComponent(String string, JComponent jComponent) {
        String string2 = this.controller.getSettings().getLanguageDependentString(string + "Label");
        JaWEManager.getInstance().getLoggingManager().debug("Added upper status  component " + string2);
        this.menubarAndToolbar.add((Component)jComponent, "South");
    }

    public void removeUpperStatusComponent(JComponent jComponent) {
        this.menubarAndToolbar.remove(jComponent);
    }

    public void addLowerStatusComponent(String string, JComponent jComponent) {
        String string2 = this.controller.getSettings().getLanguageDependentString(string + "Label");
        JaWEManager.getInstance().getLoggingManager().debug("Added lower status  component " + string2);
        this.workingArea.add((Component)jComponent, "South");
    }

    public void removeLowerStatusComponent(JComponent jComponent) {
        this.workingArea.remove(jComponent);
    }

    protected WindowAdapter createAppCloser() {
        return new AppCloser();
    }

    public void arrangeFrame() {
        String string = this.controller.getControllerSettings().getFrameSettings();
        int n = this.controller.getControllerSettings().getFirstSmallDividerLocation();
        int n2 = this.controller.getControllerSettings().getSecondSmallDividerLocation();
        int n3 = this.controller.getControllerSettings().getMainDividerLocation();
        try {
            String[] stringArray = XMLUtil.tokenize((String)string, (String)";");
            String string2 = stringArray[0];
            if (stringArray.length == 1) {
                String[] stringArray2 = XMLUtil.tokenize((String)string2, (String)" ");
                if (stringArray2.length == 1) {
                    this.bigSplit = new JSplitPane(1);
                    this.bigSplit.add(this.getFrameComponentByName(stringArray2[0]));
                } else {
                    int n4 = 1;
                    JComponent jComponent = this.getFrameComponentByName(stringArray2[0]);
                    JComponent jComponent2 = this.getFrameComponentByName(stringArray2[2]);
                    if (stringArray2[1].equals("H")) {
                        n4 = 0;
                    }
                    this.bigSplit = new JSplitPane(n4, jComponent, jComponent2);
                    this.bigSplit.setDividerLocation(n);
                }
            } else {
                String string3 = stringArray[1];
                String string4 = stringArray[2];
                String[] stringArray3 = XMLUtil.tokenize((String)string3, (String)" ");
                int n5 = 1;
                JComponent jComponent = this.getFrameComponentByName(stringArray3[0]);
                JComponent jComponent3 = null;
                if (stringArray3.length != 1) {
                    if (stringArray3[1].equals("H")) {
                        n5 = 0;
                    }
                    jComponent3 = this.getFrameComponentByName(stringArray3[2]);
                }
                this.smallSplit1 = new JSplitPane(n5);
                this.smallSplit1.add(jComponent);
                if (stringArray3.length != 1) {
                    this.smallSplit1.add(jComponent3);
                    this.smallSplit1.setDividerLocation(n);
                }
                String[] stringArray4 = XMLUtil.tokenize((String)string4, (String)" ");
                n5 = 1;
                jComponent = this.getFrameComponentByName(stringArray4[0]);
                jComponent3 = null;
                if (stringArray4.length != 1) {
                    if (stringArray4[1].equals("H")) {
                        n5 = 0;
                    }
                    jComponent3 = this.getFrameComponentByName(stringArray4[2]);
                }
                this.smallSplit2 = new JSplitPane(n5);
                this.smallSplit2.add(jComponent);
                if (stringArray4.length != 1) {
                    this.smallSplit2.add(jComponent3);
                    this.smallSplit2.setDividerLocation(n2);
                }
                n5 = 1;
                if (string2.equals("H")) {
                    n5 = 0;
                }
                this.bigSplit = new JSplitPane(n5, this.smallSplit1, this.smallSplit2);
                this.bigSplit.setDividerLocation(n3);
            }
        }
        catch (Exception exception) {
            JaWEManager.getInstance().getLoggingManager().error("JaWEFrame -> Can't customize frame! Using default!");
            this.smallSplit1 = new JSplitPane(0, this.specialComponents, this.treeComponents);
            this.smallSplit1.setDividerLocation(180);
            this.smallSplit2 = new JSplitPane(0, this.mainComponents, this.otherComponents);
            this.smallSplit2.setDividerLocation(400);
            this.bigSplit = new JSplitPane(1, this.smallSplit1, this.smallSplit2);
            this.bigSplit.setDividerLocation(180);
        }
    }

    public void rearrangeFrame() {
        int n;
        int n2;
        int n3;
        int n4 = this.mainComponents.getComponentCount();
        if (n4 == 0) {
            this.mainComponents.getParent().remove(this.mainComponents);
        }
        if ((n3 = this.treeComponents.getComponentCount()) == 0) {
            this.treeComponents.getParent().remove(this.treeComponents);
        }
        if ((n2 = this.specialComponents.getComponentCount()) == 0) {
            this.specialComponents.getParent().remove(this.specialComponents);
        }
        if ((n = this.otherComponents.getComponentCount()) == 0) {
            this.otherComponents.getParent().remove(this.otherComponents);
        }
    }

    private JComponent getFrameComponentByName(String string) {
        if (string.equals("main")) {
            return this.mainComponents;
        }
        if (string.equals("tree")) {
            return this.treeComponents;
        }
        if (string.equals("special")) {
            return this.specialComponents;
        }
        if (string.equals("other")) {
            return this.otherComponents;
        }
        return null;
    }

    public final class AppCloser
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent windowEvent) {
            JaWEManager.getInstance().getJaWEController().getSettings().getAction("Exit").getAction().actionPerformed(null);
        }
    }
}

