/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.base.editor;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEComponentSettings;
import org.enhydra.jawe.JaWEComponentView;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.XPDLElementChangeInfo;
import org.enhydra.jawe.base.panel.InlinePanel;
import org.enhydra.jawe.base.panel.panels.ValidationErrorOrSearchResultListPanel;
import org.enhydra.jawe.base.panel.panels.XMLBasicPanel;
import org.enhydra.jawe.base.panel.panels.XMLPanel;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.elements.Package;

public class ValidationOrSearchResultEditor
extends JDialog
implements JaWEComponent,
Observer {
    protected String type = "OTHER";
    protected Properties properties = new Properties();
    protected XMLPanel panelToEdit = new XMLBasicPanel();
    protected boolean validationDisplayEnabled = true;
    protected boolean searchDisplayEnabled = true;
    protected WindowListener wl = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            ValidationOrSearchResultEditor.this.close();
        }
    };
    protected ActionListener cl = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ValidationOrSearchResultEditor.this.close();
        }
    };

    public String getLanguageDependentString(String string) {
        return ResourceManager.getLanguageDependentString(string);
    }

    public ValidationOrSearchResultEditor() {
        super((Frame)JaWEManager.getInstance().getJaWEController().getJaWEFrame(), false);
        this.init();
    }

    @Override
    public JaWEComponentSettings getSettings() {
        return null;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setValidationDisplayEnabled(boolean bl) {
        this.validationDisplayEnabled = bl;
    }

    public void setSearchDisplayEnabled(boolean bl) {
        this.searchDisplayEnabled = bl;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (!(object instanceof XPDLElementChangeInfo)) {
            return;
        }
        XPDLElementChangeInfo xPDLElementChangeInfo = (XPDLElementChangeInfo)((Object)object);
        if (xPDLElementChangeInfo.getChangedElement() == null) {
            return;
        }
        int n = xPDLElementChangeInfo.getAction();
        if (!(n == 10 && this.validationDisplayEnabled && xPDLElementChangeInfo.getOldValue() instanceof Boolean && !((Boolean)xPDLElementChangeInfo.getOldValue()).booleanValue() || (n == 20 || n == 9) && this.searchDisplayEnabled)) {
            return;
        }
        String string = "";
        string = n == 10 ? this.getLanguageDependentString("DialogValidationReport") : this.getLanguageDependentString("DialogSearchResult");
        this.setTitle(string);
        this.setDisplayPanel(string, xPDLElementChangeInfo.getChangedElement(), xPDLElementChangeInfo.getChangedSubElements());
    }

    @Override
    public JaWEComponentView getView() {
        return null;
    }

    public JComponent getDisplay() {
        return null;
    }

    @Override
    public String getComponentType() {
        return this.type;
    }

    @Override
    public void setComponentType(String string) {
        this.type = string;
    }

    @Override
    public String getName() {
        return "VALIDATION_EDITOR";
    }

    @Override
    public boolean adjustXPDL(Package package_) {
        return false;
    }

    @Override
    public List checkValidity(XMLElement xMLElement, boolean bl) {
        return null;
    }

    @Override
    public boolean canCreateElement(XMLCollection xMLCollection) {
        return true;
    }

    @Override
    public boolean canInsertElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    public boolean canModifyElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    @Override
    public boolean canModifyElement(XMLElement xMLElement) {
        return true;
    }

    @Override
    public boolean canRemoveElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    @Override
    public boolean canDuplicateElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    @Override
    public boolean canRepositionElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    public Action getAction(String string) {
        return null;
    }

    public Action[] getActions() {
        return null;
    }

    public void configure(Properties properties) {
        this.properties = properties;
    }

    protected void init() {
        try {
            JaWEManager.getInstance().getJaWEController().addObserver(this);
            this.initDialog();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void initDialog() {
        try {
            Container container = this.getContentPane();
            container.setLayout(new BoxLayout(container, 1));
            container.add(this.panelToEdit);
            this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0, false), "Cancel");
            this.getRootPane().getInputMap(0).put(KeyStroke.getKeyStroke(27, 0, false), "Cancel");
            this.getRootPane().getActionMap().put("Cancel", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ValidationOrSearchResultEditor.this.cl.actionPerformed(actionEvent);
                }
            });
            this.addWindowListener(this.wl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setDefaultCloseOperation(0);
        this.setResizable(true);
    }

    public InlinePanel getInlinePanel() {
        return null;
    }

    public void close() {
        this.setVisible(false);
        this.panelToEdit.cleanup();
        Container container = this.getContentPane();
        container.remove(this.panelToEdit);
        this.panelToEdit = new XMLBasicPanel();
        container.add((Component)this.panelToEdit, 0);
    }

    public void setDisplayPanel(String string, XMLElement xMLElement, List list) {
        this.setModal(true);
        this.showPanel(new ValidationErrorOrSearchResultListPanel(xMLElement, list, string, true, true));
    }

    public void showPanel(XMLPanel xMLPanel) {
        Container container = this.getContentPane();
        container.remove(this.panelToEdit);
        this.panelToEdit = xMLPanel;
        container.add((Component)this.panelToEdit, 0);
        this.pack();
        this.panelToEdit.requestFocus();
        this.pack();
        if (!this.isVisible()) {
            this.setLocationRelativeTo(JaWEManager.getInstance().getJaWEController().getJaWEFrame());
            this.setVisible(true);
        }
    }

    @Override
    public void setUpdateInProgress(boolean bl) {
    }

    @Override
    public boolean isUpdateInProgress() {
        return false;
    }
}

