/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.base.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import org.enhydra.jawe.BarFactory;
import org.enhydra.jawe.HistoryManager;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEComponentView;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.Settings;
import org.enhydra.jawe.XPDLElementChangeInfo;
import org.enhydra.jawe.base.controller.JaWESelectionManager;
import org.enhydra.jawe.base.display.DisplayNameGenerator;
import org.enhydra.jawe.base.label.LabelGenerator;
import org.enhydra.jawe.base.panel.ActivityTypesChoiceElement;
import org.enhydra.jawe.base.panel.PanelContainer;
import org.enhydra.jawe.base.panel.PanelGenerator;
import org.enhydra.jawe.base.panel.PanelSettings;
import org.enhydra.jawe.base.panel.PanelValidator;
import org.enhydra.jawe.base.panel.SpecialChoiceElement;
import org.enhydra.jawe.base.panel.StandardPanelGenerator;
import org.enhydra.jawe.base.panel.panels.XMLBasicPanel;
import org.enhydra.jawe.base.panel.panels.XMLPanel;
import org.enhydra.jawe.base.panel.panels.XMLTabbedPanel;
import org.enhydra.jawe.base.tooltip.TooltipGenerator;
import org.enhydra.jxpdl.XMLComplexChoice;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLUtil;

public class InlinePanel
extends JPanel
implements JaWEComponentView,
PanelContainer {
    protected JaWEComponent controller;
    protected JScrollPane scrollPane;
    protected boolean displayTitle = false;
    protected JLabel title;
    protected boolean isModified = false;
    protected PanelGenerator panelGenerator;
    protected Map lastActiveTabs = new HashMap();
    protected HistoryManager hm;

    @Override
    public void configure() {
    }

    public void setJaWEComponent(JaWEComponent jaWEComponent) {
        this.controller = jaWEComponent;
    }

    public PanelSettings getPanelSettings() {
        return (PanelSettings)this.controller.getSettings();
    }

    @Override
    public void init() {
        Object object;
        Object object2;
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            this.panelGenerator = (PanelGenerator)classLoader.loadClass(JaWEManager.getInstance().getPanelGeneratorClassName()).newInstance();
        }
        catch (Exception exception) {
            object2 = "InlinePanel -> Problems while instantiating Panel Generator class '" + JaWEManager.getInstance().getPanelGeneratorClassName() + "' - using default implementation!";
            JaWEManager.getInstance().getLoggingManager().error((String)object2, exception);
            this.panelGenerator = new StandardPanelGenerator();
        }
        this.panelGenerator.setPanelContainer(this);
        try {
            object = this.getPanelSettings().historyManagerClass();
            if (object != null && !((String)object).equals("")) {
                this.hm = (HistoryManager)Class.forName((String)object).newInstance();
                this.hm.init(this.getPanelSettings().historySize());
            }
        }
        catch (Exception exception) {
            System.err.println("Failed to instantiate history manager - my controller is " + this.controller);
        }
        this.getPanelSettings().adjustActions();
        this.displayTitle = (Boolean)this.controller.getSettings().getSetting("DisplayTitle");
        this.scrollPane = new JScrollPane();
        if (((Boolean)this.controller.getSettings().getSetting("UseScrollBar")).booleanValue()) {
            this.scrollPane.setHorizontalScrollBarPolicy(30);
            this.scrollPane.setVerticalScrollBarPolicy(20);
        } else {
            this.scrollPane.setHorizontalScrollBarPolicy(31);
            this.scrollPane.setVerticalScrollBarPolicy(21);
        }
        object = this.scrollPane.getViewport();
        ((JViewport)object).setScrollMode(1);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(40);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        object2 = new JPanel();
        JToolBar jToolBar = BarFactory.createToolbar("defaultToolbar", this.controller);
        jToolBar.setFloatable(false);
        jToolBar.setRollover(true);
        ((Container)object2).setLayout(new BoxLayout((Container)object2, 1));
        ((Container)object2).add(Box.createVerticalStrut(5));
        if (this.displayTitle) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            this.title = new JLabel("");
            this.title.setAlignmentX(0.0f);
            this.title.setAlignmentY(1.0f);
            jPanel.add(this.title);
            jPanel.add(Box.createHorizontalGlue());
            ((Container)object2).add(jPanel);
        }
        ((Container)object2).add(this.scrollPane);
        this.add((Component)jToolBar, "North");
        this.add((Component)object2, "Center");
    }

    @Override
    public JaWEComponent getJaWEComponent() {
        return this.controller;
    }

    @Override
    public JComponent getDisplay() {
        return this;
    }

    public void update(XPDLElementChangeInfo xPDLElementChangeInfo) {
        if (xPDLElementChangeInfo.getSource() == this) {
            return;
        }
        XMLElement xMLElement = xPDLElementChangeInfo.getChangedElement();
        XMLElement xMLElement2 = this.getActiveElement();
        ArrayList<XMLElement> arrayList = new ArrayList<XMLElement>();
        JaWESelectionManager jaWESelectionManager = JaWEManager.getInstance().getJaWEController().getSelectionManager();
        if (xMLElement == null || jaWESelectionManager.getSelectedElements().size() == 1 && !jaWESelectionManager.canEditProperties()) {
            this.setActiveElement(null);
        } else if (xPDLElementChangeInfo.getAction() == 1) {
            if (xMLElement2 != null && XMLUtil.isChildsParent((XMLElement)xMLElement2, (XMLElement)xPDLElementChangeInfo.getChangedElement())) {
                this.setActiveElement(xMLElement2);
            }
        } else if (xPDLElementChangeInfo.getAction() == 8) {
            this.setActiveElement(xMLElement);
        } else if (xPDLElementChangeInfo.getAction() == 5) {
            ArrayList<XMLElement> arrayList2 = xPDLElementChangeInfo.getChangedSubElements();
            if (arrayList2 == null || arrayList2.size() == 0) {
                arrayList2 = new ArrayList<XMLElement>();
                arrayList2.add(xPDLElementChangeInfo.getChangedElement());
            }
            for (int i = 0; i < arrayList2.size(); ++i) {
                XMLElement xMLElement3 = (XMLElement)arrayList2.get(i);
                if (xMLElement3 == xMLElement2 || XMLUtil.isParentsChild((XMLElement)xMLElement3, (XMLElement)xMLElement2)) {
                    this.setActiveElement(null);
                }
                arrayList.add(xMLElement3);
            }
        }
        if (this.hm != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                this.hm.removeFromHistory((XMLElement)arrayList.get(i));
            }
        }
        this.getPanelSettings().adjustActions();
    }

    public void setViewPanel(XMLPanel xMLPanel) {
        XMLPanel xMLPanel2 = this.getViewPanel();
        if (xMLPanel2 != null) {
            xMLPanel2.cleanup();
        }
        if (this.displayTitle) {
            XMLElement xMLElement = xMLPanel.getOwner();
            String string = "";
            if (xMLElement != null) {
                string = " " + xMLPanel.getTitle();
            }
            this.title.setText(string);
        }
        this.scrollPane.setViewportView(xMLPanel);
    }

    public XMLPanel getViewPanel() {
        if (this.scrollPane != null) {
            return (XMLPanel)this.scrollPane.getViewport().getView();
        }
        return null;
    }

    public XMLElement getActiveElement() {
        XMLPanel xMLPanel = this.getViewPanel();
        if (xMLPanel != null) {
            XMLElement xMLElement = xMLPanel.getOwner();
            if (xMLElement instanceof SpecialChoiceElement) {
                xMLElement = ((SpecialChoiceElement)xMLElement).getControlledElement();
            } else if (xMLElement instanceof ActivityTypesChoiceElement) {
                xMLElement = ((ActivityTypesChoiceElement)xMLElement).getControlledElement();
            }
            return xMLElement;
        }
        return null;
    }

    public void apply() {
        XMLPanel xMLPanel = this.getViewPanel();
        if (xMLPanel != null) {
            xMLPanel.setElements();
        }
    }

    public boolean canApplyChanges() {
        XMLPanel xMLPanel;
        if (this.getViewPanel() != null && (xMLPanel = this.getViewPanel()).validateEntry()) {
            return JaWEManager.getInstance().getPanelValidator().validatePanel(xMLPanel.getOwner(), xMLPanel);
        }
        return false;
    }

    public boolean validateElement(XMLElement xMLElement) {
        return true;
    }

    public void applySpecial() {
        if (!this.canApplyChanges()) {
            return;
        }
        XMLElement xMLElement = this.getActiveElement();
        this.getJaWEComponent().setUpdateInProgress(true);
        JaWEManager.getInstance().getJaWEController().startUndouableChange();
        this.apply();
        ArrayList<XMLElement> arrayList = new ArrayList<XMLElement>();
        XMLElement xMLElement2 = xMLElement;
        if (xMLElement2 != null) {
            arrayList.add(xMLElement2);
        }
        JaWEManager.getInstance().getJaWEController().endUndouableChange(arrayList);
        this.getJaWEComponent().setUpdateInProgress(false);
        this.validateElement(xMLElement);
        this.setModified(false);
    }

    public void displayParentPanel() {
        XMLElement xMLElement;
        int n;
        if (this.isModified && ((n = this.showModifiedWarning()) == 2 || n == 0 && this.isModified())) {
            return;
        }
        XMLElement xMLElement2 = this.getActiveElement();
        if (xMLElement2 != null && (xMLElement = xMLElement2.getParent()) != null) {
            XMLElement xMLElement3 = null;
            while ((xMLElement3 = XMLUtil.getParentElementByAssignableType(XMLComplexChoice.class, (XMLElement)xMLElement)) != null) {
                xMLElement = xMLElement3.getParent();
            }
            this.setActiveElement(xMLElement);
            JaWEManager.getInstance().getJaWEController().getSelectionManager().setSelection(xMLElement, true);
        }
    }

    public void displayGivenElement(XMLElement xMLElement) {
        int n;
        if (this.isModified && ((n = this.showModifiedWarning()) == 2 || n == 0 && this.isModified())) {
            return;
        }
        if (xMLElement != null) {
            this.setActiveElement(xMLElement);
            JaWEManager.getInstance().getJaWEController().getSelectionManager().setSelection(xMLElement, true);
            if (this.getJaWEComponent() instanceof JDialog && ((JDialog)((Object)this.getJaWEComponent())).isModal()) {
                ((JDialog)((Object)this.getJaWEComponent())).setTitle(JaWEManager.getInstance().getLabelGenerator().getLabel(xMLElement));
            }
        }
    }

    public void displayElement(XMLElement xMLElement) {
        int n;
        Constable constable;
        XMLPanel xMLPanel;
        XMLPanel xMLPanel2 = this.getViewPanel();
        XMLElement xMLElement2 = this.getActiveElement();
        if (xMLPanel2 instanceof XMLTabbedPanel && xMLElement2 != null) {
            xMLPanel = (XMLTabbedPanel)xMLPanel2;
            constable = xMLElement2.getClass();
            n = ((XMLTabbedPanel)xMLPanel).getActiveTab();
            this.lastActiveTabs.put(constable, new Integer(n));
        }
        this.isModified = false;
        xMLPanel = xMLElement != null ? this.panelGenerator.getPanel(xMLElement) : new XMLBasicPanel();
        this.setViewPanel(xMLPanel);
        if (xMLPanel instanceof XMLTabbedPanel && (constable = (Integer)this.lastActiveTabs.get(xMLElement.getClass())) != null) {
            n = (Integer)constable;
            XMLPanel xMLPanel3 = xMLPanel;
            if (((XMLTabbedPanel)xMLPanel3).getTabCount() <= (Integer)constable) {
                n = ((XMLTabbedPanel)xMLPanel3).getTabCount() - 1;
                this.lastActiveTabs.put(xMLElement.getClass(), new Integer(n));
            }
            ((XMLTabbedPanel)xMLPanel3).setActiveTab(n);
        }
        this.getPanelSettings().adjustActions();
    }

    public void setActiveElement(XMLElement xMLElement) {
        if (this.hm != null) {
            XMLElement xMLElement2 = this.getActiveElement();
            this.hm.addToHistory(xMLElement2, xMLElement);
        }
        this.displayElement(xMLElement);
        this.getPanelSettings().adjustActions();
    }

    public void displayPreviousElement() {
        int n;
        if (this.hm == null) {
            return;
        }
        if (this.isModified() && ((n = this.showModifiedWarning()) == 2 || n == 0 && this.isModified())) {
            return;
        }
        if (this.hm.canGoBack()) {
            XMLElement xMLElement = this.hm.getPrevious(this.getActiveElement());
            this.displayElement(xMLElement);
            JaWEManager.getInstance().getJaWEController().getSelectionManager().setSelection(xMLElement, true);
            this.getPanelSettings().adjustActions();
        }
    }

    public void displayNextElement() {
        int n;
        if (this.hm == null) {
            return;
        }
        if (this.isModified() && ((n = this.showModifiedWarning()) == 2 || n == 0 && this.isModified())) {
            return;
        }
        if (this.hm.canGoForward()) {
            XMLElement xMLElement = this.hm.getNext(this.getActiveElement());
            this.displayElement(xMLElement);
            JaWEManager.getInstance().getJaWEController().getSelectionManager().setSelection(xMLElement, true);
            this.getPanelSettings().adjustActions();
        }
    }

    public int showModifiedWarning() {
        if (!this.getPanelSettings().shouldShowModifiedWarning()) {
            return 1;
        }
        int n = JOptionPane.showConfirmDialog(JaWEManager.getInstance().getJaWEController().getJaWEFrame(), this.getPanelSettings().getLanguageDependentString("WarningElementChanged"), this.getPanelSettings().getLanguageDependentString("DialogTitle"), 1);
        if (n == 0) {
            this.applySpecial();
        }
        return n;
    }

    public void setModified(boolean bl) {
        this.isModified = bl;
        this.getPanelSettings().adjustActions();
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void cleanup() {
        if (this.hm != null) {
            this.hm.cleanHistory();
        }
        this.getPanelSettings().adjustActions();
    }

    @Override
    public void panelChanged(XMLPanel xMLPanel, EventObject eventObject) {
        this.isModified = true;
        this.getPanelSettings().adjustActions();
    }

    @Override
    public Settings getSettings() {
        return this.controller.getSettings();
    }

    @Override
    public String getLanguageDependentString(String string) {
        return this.controller.getSettings().getLanguageDependentString(string);
    }

    @Override
    public PanelGenerator getPanelGenerator() {
        return this.panelGenerator;
    }

    @Override
    public LabelGenerator getLabelGenerator() {
        return JaWEManager.getInstance().getLabelGenerator();
    }

    @Override
    public DisplayNameGenerator getDisplayNameGenerator() {
        return JaWEManager.getInstance().getDisplayNameGenerator();
    }

    @Override
    public PanelValidator getPanelValidator() {
        return JaWEManager.getInstance().getPanelValidator();
    }

    @Override
    public TooltipGenerator getTooltipGenerator() {
        return JaWEManager.getInstance().getTooltipGenerator();
    }

    public HistoryManager getHistoryManager() {
        return this.hm;
    }
}

