/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.base.panel.panels;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.base.controller.JaWEController;
import org.enhydra.jawe.base.editor.StandardXPDLElementEditor;
import org.enhydra.jawe.base.panel.InlinePanel;
import org.enhydra.jawe.base.panel.PanelContainer;
import org.enhydra.jawe.base.panel.PanelSettings;
import org.enhydra.jawe.base.panel.panels.PanelUtilities;
import org.enhydra.jawe.base.panel.panels.XMLBasicPanel;
import org.enhydra.jawe.base.panel.panels.XMLElementView;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLElementChangeInfo;
import org.enhydra.jxpdl.XMLElementChangeListener;
import org.enhydra.jxpdl.XMLUtil;

public class XMLBasicListPanel
extends XMLBasicPanel
implements XMLElementChangeListener {
    protected static Dimension minimalDimension = new Dimension(250, 60);
    protected static Dimension listDimension = new Dimension(450, 150);
    protected XMLElementView movingElement;
    protected int movingElementPosition;
    protected int newMovingElementPosition;
    protected boolean dragging = false;
    protected boolean changing = false;
    protected JList allParam;
    protected JPanel toolbox;
    protected InlinePanel ipc;
    protected Action newElementAction = new AbstractAction("New"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Serializable serializable;
            int n;
            JaWEController jaWEController = JaWEManager.getInstance().getJaWEController();
            XMLCollection xMLCollection = (XMLCollection)XMLBasicListPanel.this.getOwner();
            XMLElement xMLElement = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject(xMLCollection, null, false);
            boolean bl = PanelUtilities.isForModalDialog(xMLElement);
            if (!bl && XMLBasicListPanel.this.ipc.isModified() && ((n = XMLBasicListPanel.this.ipc.showModifiedWarning()) == 2 || n == 0 && XMLBasicListPanel.this.ipc.isModified())) {
                return;
            }
            n = 0;
            if (bl) {
                serializable = new StandardXPDLElementEditor();
                ((StandardXPDLElementEditor)serializable).editXPDLElement(xMLElement);
                boolean bl2 = ((StandardXPDLElementEditor)serializable).getStatus() == 0;
                boolean bl3 = true;
                if (bl2) {
                    bl3 = jaWEController.canInsertElement(xMLCollection, xMLElement);
                }
                if (!bl2 || !bl3) {
                    if (!bl3) {
                        jaWEController.message(((StandardXPDLElementEditor)serializable).getLanguageDependentString("WarningCannotInsertElement"), 2);
                    }
                    return;
                }
                n = 1;
            }
            jaWEController.startUndouableChange();
            xMLCollection.add(xMLElement);
            serializable = new ArrayList();
            serializable.add(xMLElement);
            jaWEController.endUndouableChange((List)((Object)serializable));
            if (n != 0) {
                XMLBasicListPanel.this.setSelectedElement(xMLElement);
            }
            XMLBasicListPanel.this.adjustActions();
        }
    };
    protected Action editElementAction = new AbstractAction("EditProperties"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            XMLElement xMLElement = XMLBasicListPanel.this.getSelectedElement();
            if (xMLElement != null) {
                int n;
                if (XMLBasicListPanel.this.ipc.isModified() && ((n = XMLBasicListPanel.this.ipc.showModifiedWarning()) == 2 || n == 0 && XMLBasicListPanel.this.ipc.isModified())) {
                    return;
                }
                JaWEManager.getInstance().getXPDLElementEditor().editXPDLElement(xMLElement);
            }
        }
    };
    protected Action deleteElementAction = new AbstractAction("Delete"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            XMLElement xMLElement = XMLBasicListPanel.this.getSelectedElement();
            if (xMLElement != null) {
                JaWEController jaWEController = JaWEManager.getInstance().getJaWEController();
                ArrayList<XMLElement> arrayList = new ArrayList<XMLElement>();
                arrayList.add(xMLElement.getParent());
                if (jaWEController.confirmDelete(arrayList, xMLElement)) {
                    XMLCollection xMLCollection = (XMLCollection)XMLBasicListPanel.this.getOwner();
                    jaWEController.startUndouableChange();
                    xMLCollection.remove(xMLElement);
                    jaWEController.endUndouableChange(arrayList);
                    XMLBasicListPanel.this.ipc.getPanelSettings().adjustActions();
                    XMLBasicListPanel.this.adjustActions();
                }
            }
        }
    };
    protected Action moveUpAction = new AbstractAction("MoveUp"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            XMLBasicListPanel.this.moveItem(0);
            XMLBasicListPanel.this.adjustActions();
        }
    };
    protected Action moveDownAction = new AbstractAction("MoveDown"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            XMLBasicListPanel.this.moveItem(1);
            XMLBasicListPanel.this.adjustActions();
        }
    };

    public XMLBasicListPanel(InlinePanel inlinePanel, XMLCollection xMLCollection, List list, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(inlinePanel, (XMLElement)xMLCollection, string, true, bl, bl2);
        this.ipc = inlinePanel;
        xMLCollection.addListener((XMLElementChangeListener)this);
        xMLCollection.setNotifyListeners(true);
        this.allParam = this.createList();
        this.setupList(bl3);
        this.fillListContent(list);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setAlignmentX(0.0f);
        jScrollPane.setViewportView(this.allParam);
        if (!bl4) {
            jScrollPane.setPreferredSize(new Dimension(listDimension));
        } else {
            jScrollPane.setPreferredSize(new Dimension(minimalDimension));
        }
        this.toolbox = this.createToolbar();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(jScrollPane);
        this.add(this.toolbox);
        this.add(Box.createVerticalStrut(3));
        this.add(jPanel);
        this.adjustActions();
    }

    public boolean isItemChangingPosition() {
        return this.changing || this.dragging;
    }

    public JList getList() {
        return this.allParam;
    }

    public XMLElement getSelectedElement() {
        if (this.allParam.getSelectedIndex() == -1) {
            return null;
        }
        return ((XMLElementView)this.allParam.getSelectedValue()).getElement();
    }

    public boolean setSelectedElement(XMLElement xMLElement) {
        int n = -1;
        XMLElementView xMLElementView = this.getRow(xMLElement);
        for (int i = 0; i < this.allParam.getModel().getSize(); ++i) {
            XMLElementView xMLElementView2 = (XMLElementView)this.allParam.getModel().getElementAt(i);
            if (!xMLElementView.equals(xMLElementView2)) continue;
            n = i;
            break;
        }
        if (n != -1) {
            this.allParam.setSelectedIndex(n);
        }
        return n != -1;
    }

    protected void moveItem(int n) {
        this.newMovingElementPosition = this.movingElementPosition;
        if (this.newMovingElementPosition == -1) {
            return;
        }
        this.newMovingElementPosition = n == 0 ? --this.newMovingElementPosition : ++this.newMovingElementPosition;
        this.moveItem();
    }

    protected void moveItem() {
        this.changing = true;
        DefaultListModel defaultListModel = (DefaultListModel)this.allParam.getModel();
        XMLCollection xMLCollection = (XMLCollection)this.getOwner();
        int n = defaultListModel.getSize();
        if (this.movingElement == null || this.movingElementPosition == -1 || this.newMovingElementPosition == -1 || this.newMovingElementPosition == this.movingElementPosition || n - 1 < this.movingElementPosition || n - 1 < this.newMovingElementPosition || !xMLCollection.contains(this.movingElement.getElement())) {
            this.changing = false;
            return;
        }
        XMLCollection xMLCollection2 = (XMLCollection)this.getOwner();
        if (JaWEManager.getInstance().getJaWEController().canRepositionElement(xMLCollection2, this.movingElement.getElement())) {
            XMLElement xMLElement = ((XMLElementView)defaultListModel.getElementAt(this.newMovingElementPosition)).getElement();
            int n2 = xMLCollection.indexOf(xMLElement);
            defaultListModel.remove(this.movingElementPosition);
            defaultListModel.add(this.newMovingElementPosition, this.movingElement);
            JaWEController jaWEController = JaWEManager.getInstance().getJaWEController();
            jaWEController.startUndouableChange();
            xMLCollection.reposition(this.movingElement.getElement(), n2);
            ArrayList<XMLElement> arrayList = new ArrayList<XMLElement>();
            arrayList.add(this.movingElement.getElement());
            jaWEController.endUndouableChange(arrayList);
            try {
                this.allParam.setSelectedIndex(this.newMovingElementPosition);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.movingElementPosition = this.newMovingElementPosition;
        }
        this.changing = false;
    }

    protected JList createList() {
        DefaultListModel defaultListModel = new DefaultListModel();
        JList jList = new JList(defaultListModel);
        Color color = new Color(245, 245, 245);
        if (this.ipc.getSettings() instanceof PanelSettings) {
            color = ((PanelSettings)this.ipc.getSettings()).getBackgroundColor();
        }
        jList.setBackground(color);
        return jList;
    }

    protected void setupList(final boolean bl) {
        this.allParam.setSelectionMode(0);
        this.allParam.setAlignmentX(0.0f);
        this.allParam.setAlignmentY(0.0f);
        XMLCollection xMLCollection = (XMLCollection)this.getOwner();
        final boolean bl2 = JaWEManager.getInstance().getJaWEController().canRepositionElement(xMLCollection, null);
        this.allParam.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (bl && mouseEvent.getClickCount() > 1) {
                    XMLBasicListPanel.this.editElementAction.actionPerformed(null);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (!XMLBasicListPanel.this.getOwner().isReadOnly() && bl2) {
                    XMLBasicListPanel.this.dragging = true;
                }
                XMLBasicListPanel.this.movingElement = null;
                XMLBasicListPanel.this.movingElementPosition = -1;
                try {
                    XMLBasicListPanel.this.movingElementPosition = XMLBasicListPanel.this.allParam.getSelectedIndex();
                    if (XMLBasicListPanel.this.movingElementPosition >= 0) {
                        XMLBasicListPanel.this.movingElement = (XMLElementView)XMLBasicListPanel.this.allParam.getSelectedValue();
                        XMLBasicListPanel.this.adjustActions();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (XMLBasicListPanel.this.changing) {
                    XMLBasicListPanel.this.changing = false;
                    return;
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                XMLBasicListPanel.this.dragging = false;
            }
        });
        if (!this.myOwner.isReadOnly() && bl2) {
            this.allParam.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (XMLBasicListPanel.this.dragging && !XMLBasicListPanel.this.changing) {
                        XMLBasicListPanel.this.newMovingElementPosition = -1;
                        try {
                            XMLBasicListPanel.this.newMovingElementPosition = XMLBasicListPanel.this.allParam.getSelectedIndex();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        XMLBasicListPanel.this.moveItem();
                    }
                    XMLBasicListPanel.this.adjustActions();
                }
            });
        }
        if (bl) {
            this.allParam.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0, false), "edit");
            this.allParam.getActionMap().put("edit", this.editElementAction);
            this.allParam.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0, false), "delete");
            this.allParam.getActionMap().put("delete", this.deleteElementAction);
        }
        if (!this.getOwner().isReadOnly() && bl2) {
            this.allParam.setToolTipText(ResourceManager.getLanguageDependentString("MessageDragItemToChangeItsPosition"));
        }
    }

    protected void fillListContent(List list) {
        DefaultListModel defaultListModel = (DefaultListModel)this.allParam.getModel();
        for (XMLElement xMLElement : list) {
            XMLElementView xMLElementView = this.getRow(xMLElement);
            defaultListModel.addElement(xMLElementView);
        }
    }

    protected XMLElementView getRow(XMLElement xMLElement) {
        return new XMLElementView((PanelContainer)this.ipc, xMLElement, 1);
    }

    protected JPanel createToolbar() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JButton jButton = PanelUtilities.createToolbarButton(this.ipc.getSettings(), this.newElementAction);
        jButton.setRolloverEnabled(true);
        JButton jButton2 = PanelUtilities.createToolbarButton(this.ipc.getSettings(), this.editElementAction);
        jButton2.setRolloverEnabled(true);
        JButton jButton3 = PanelUtilities.createToolbarButton(this.ipc.getSettings(), this.deleteElementAction);
        jButton3.setRolloverEnabled(true);
        jPanel.add(jButton);
        jPanel.add(Box.createRigidArea(new Dimension(3, 3)));
        jPanel.add(jButton2);
        jPanel.add(Box.createRigidArea(new Dimension(3, 3)));
        jPanel.add(jButton3);
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    protected JPanel createArrowPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        XMLCollection xMLCollection = (XMLCollection)this.getOwner();
        boolean bl = JaWEManager.getInstance().getJaWEController().canRepositionElement(xMLCollection, null);
        JButton jButton = new JButton();
        jButton.setIcon(this.ipc.getPanelSettings().getArrowUpImageIcon());
        jButton.setPreferredSize(new Dimension(16, 16));
        jButton.setEnabled(!this.myOwner.isReadOnly() && bl);
        jButton.addActionListener(this.moveUpAction);
        JButton jButton2 = new JButton();
        jButton2.setIcon(this.ipc.getPanelSettings().getArrowDownImageIcon());
        jButton2.setPreferredSize(new Dimension(16, 16));
        jButton2.setEnabled(!this.myOwner.isReadOnly() && bl);
        jButton2.addActionListener(this.moveDownAction);
        jPanel.add(jButton);
        jPanel.add(Box.createVerticalGlue());
        jPanel.add(jButton2);
        return jPanel;
    }

    protected void adjustActions() {
        JaWEController jaWEController = JaWEManager.getInstance().getJaWEController();
        XMLElement xMLElement = this.getSelectedElement();
        this.newElementAction.setEnabled(jaWEController.canCreateElement((XMLCollection)this.getOwner()));
        this.editElementAction.setEnabled(xMLElement != null && XMLUtil.getPackage((XMLElement)xMLElement) != null);
        this.deleteElementAction.setEnabled(xMLElement != null && jaWEController.canRemoveElement((XMLCollection)this.getOwner(), xMLElement));
        boolean bl = JaWEManager.getInstance().getJaWEController().canRepositionElement((XMLCollection)this.getOwner(), null);
        this.moveUpAction.setEnabled(xMLElement != null && this.allParam.getSelectedIndex() > 0 && bl);
        this.moveDownAction.setEnabled(xMLElement != null && this.allParam.getSelectedIndex() < this.allParam.getModel().getSize() - 1 && bl);
    }

    public void xmlElementChanged(XMLElementChangeInfo xMLElementChangeInfo) {
        block3: {
            block2: {
                if (xMLElementChangeInfo.getAction() != 5) break block2;
                for (XMLElement xMLElement : xMLElementChangeInfo.getChangedSubElements()) {
                    this.removeElement(xMLElement);
                }
                break block3;
            }
            if (xMLElementChangeInfo.getAction() != 3) break block3;
            for (XMLElement xMLElement : xMLElementChangeInfo.getChangedSubElements()) {
                this.addElement(xMLElement);
            }
        }
    }

    public void addElement(XMLElement xMLElement) {
        DefaultListModel defaultListModel = (DefaultListModel)this.allParam.getModel();
        XMLElementView xMLElementView = this.getRow(xMLElement);
        defaultListModel.addElement(xMLElementView);
    }

    public void removeElement(XMLElement xMLElement) {
        DefaultListModel defaultListModel = (DefaultListModel)this.allParam.getModel();
        XMLElementView xMLElementView = this.getRow(xMLElement);
        if (xMLElementView != null) {
            defaultListModel.removeElement(xMLElementView);
        }
    }

    @Override
    public void cleanup() {
        this.myOwner.removeListener((XMLElementChangeListener)this);
        this.allParam = null;
    }

    @Override
    public boolean isEmpty() {
        return this.allParam.getModel().getSize() == 0;
    }

    @Override
    public boolean validateEntry() {
        if (this.isEmpty() && this.getOwner().isRequired() && !this.getOwner().isReadOnly()) {
            XMLBasicPanel.defaultErrorMessage(this.getWindow(), this.getTitle() + ": ");
            this.allParam.requestFocus();
            return false;
        }
        return true;
    }
}

