/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.graph;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import org.enhydra.jawe.components.graph.GraphUtilities;

public class DefaultCellPanel
extends JPanel {
    public static final int TEXT_POSITION_ALL = 0;
    public static final int TEXT_POSITION_UP = 1;
    public static final int TEXT_POSITION_DOWN = 2;
    public static final int TEXT_POSITION_LEFT = 3;
    public static final int TEXT_POSITION_RIGHT = 4;
    protected int divLocation = 16;
    protected JSplitPane split;
    protected JTextArea name = new JTextArea();
    protected JLabel mainIcon = new JLabel();
    protected int orientation = 0;

    protected DefaultCellPanel() {
        this.name.setText("-");
        this.name.setOpaque(false);
        this.mainIcon.setIcon(null);
        this.mainIcon.setVerticalAlignment(1);
        this.mainIcon.setHorizontalAlignment(0);
        this.mainIcon.setAlignmentX(0.5f);
        this.mainIcon.setAlignmentY(0.0f);
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.split = new JSplitPane(1, this.mainIcon, this.name);
        this.split.setDividerLocation(this.divLocation);
        this.split.setBorder(null);
        this.split.setDividerSize(0);
        this.split.setOpaque(false);
        this.add(this.split);
    }

    public void showIcon(boolean bl) {
        this.mainIcon.setVisible(bl);
    }

    public Icon getMainIcon() {
        return this.mainIcon.getIcon();
    }

    public void setMainIcon(Icon icon) {
        this.mainIcon.setIcon(icon);
    }

    public String getDisplayName() {
        return this.name.getText();
    }

    public void setDisplayName(String string) {
        this.name.setForeground(GraphUtilities.getGraphController().getGraphSettings().getTextColor());
        this.name.setText(string);
    }

    public void wrapName(boolean bl) {
        this.name.setLineWrap(bl);
    }

    public void wrapStyle(boolean bl) {
        this.name.setWrapStyleWord(bl);
    }

    @Override
    public void setFont(Font font) {
        if (this.name != null) {
            this.name.setFont(font);
        }
    }

    public void setTextPosition(int n) {
        this.orientation = n;
        this.arrangeSplit();
    }

    public void arrangeSplit() {
        this.remove(this.split);
        switch (this.orientation) {
            case 0: {
                this.split = new JSplitPane(0, this.mainIcon, this.name);
                this.split.setDividerLocation(0);
                break;
            }
            case 1: {
                this.split = new JSplitPane(0, this.name, this.mainIcon);
                this.split.setDividerLocation(GraphUtilities.getGraphController().getGraphSettings().getActivityHeight() - this.divLocation - 3);
                break;
            }
            case 2: {
                this.split = new JSplitPane(0, this.mainIcon, this.name);
                this.split.setDividerLocation(this.divLocation);
                break;
            }
            case 3: {
                this.split = new JSplitPane(1, this.name, this.mainIcon);
                this.split.setDividerLocation(GraphUtilities.getGraphController().getGraphSettings().getActivityWidth() - this.divLocation - 5);
                break;
            }
            default: {
                this.split = new JSplitPane(1, this.mainIcon, this.name);
                this.split.setDividerLocation(this.divLocation);
            }
        }
        this.split.setBorder(null);
        this.split.setDividerSize(0);
        this.split.setOpaque(false);
        this.add(this.split);
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        super.setBounds(rectangle);
        if (this.split != null) {
            int n = 0;
            if (this.mainIcon.isVisible() && this.mainIcon.getIcon() != null) {
                n = this.mainIcon.getIcon().getIconWidth();
            }
            this.name.setBounds(this.name.getX(), this.name.getY(), rectangle.width, rectangle.height - n - 3);
            this.split.setBounds(rectangle);
        }
    }
}

