/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.graph;

import java.awt.Point;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.tree.MutableTreeNode;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.base.tooltip.TooltipGenerator;
import org.enhydra.jawe.components.graph.GraphArtifactInterface;
import org.enhydra.jawe.components.graph.GraphCommonInterface;
import org.enhydra.jawe.components.graph.GraphPortInterface;
import org.enhydra.jawe.components.graph.GraphTransitionInterface;
import org.enhydra.jawe.components.graph.GraphUtilities;
import org.enhydra.jxpdl.XMLCollectionElement;
import org.enhydra.jxpdl.XMLComplexElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.elements.Artifact;

public class DefaultGraphArtifact
extends GraphArtifactInterface {
    public DefaultGraphArtifact(Artifact artifact) {
        this.setUserObject(artifact);
        this.addAPort();
    }

    protected void addAPort() {
        GraphPortInterface graphPortInterface = GraphUtilities.getGraphController().getGraphObjectFactory().createPort("Center", "DEFAULT");
        this.add((MutableTreeNode)((Object)graphPortInterface));
    }

    @Override
    public String getType() {
        return JaWEManager.getInstance().getJaWEController().getTypeResolver().getJaWEType((XMLElement)((Artifact)this.userObject)).getTypeId();
    }

    @Override
    public GraphPortInterface getPort() {
        Enumeration enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof GraphPortInterface)) continue;
            return (GraphPortInterface)((Object)e);
        }
        return null;
    }

    @Override
    public boolean acceptsSource() {
        return true;
    }

    @Override
    public boolean acceptsTarget() {
        return true;
    }

    @Override
    public XMLComplexElement getPropertyObject() {
        if (this.userObject instanceof XMLComplexElement) {
            return (XMLComplexElement)this.userObject;
        }
        return null;
    }

    @Override
    public String getTooltip() {
        TooltipGenerator tooltipGenerator = JaWEManager.getInstance().getTooltipGenerator();
        if (this.userObject != null && tooltipGenerator != null) {
            return tooltipGenerator.getTooltip((XMLElement)this.getPropertyObject());
        }
        return "";
    }

    public String toString() {
        String string = null;
        if (this.userObject != null) {
            Artifact artifact = (Artifact)this.userObject;
            string = artifact.getArtifactType().equals("Annotation") ? artifact.getTextAnnotation() : artifact.getDataObject().getName();
            if (string == null || "".equals(string)) {
                string = artifact.getName();
            }
            if (string.equals("")) {
                string = artifact.getId();
            }
        }
        return string;
    }

    public Object clone() {
        DefaultGraphArtifact defaultGraphArtifact = (DefaultGraphArtifact)super.clone();
        defaultGraphArtifact.setUserObject(defaultGraphArtifact.userObject);
        return defaultGraphArtifact;
    }

    protected Object cloneUserObject() {
        return ((Artifact)this.userObject).clone();
    }

    @Override
    public Set getReferencingActivities() {
        HashSet<GraphCommonInterface> hashSet = new HashSet<GraphCommonInterface>();
        Iterator iterator = this.getPort().edges();
        while (iterator.hasNext()) {
            GraphTransitionInterface graphTransitionInterface = (GraphTransitionInterface)iterator.next();
            GraphCommonInterface graphCommonInterface = ((GraphPortInterface)((Object)graphTransitionInterface.getTarget())).getActivityOrArtifact();
            if (this != graphCommonInterface) continue;
            hashSet.add(((GraphPortInterface)((Object)graphTransitionInterface.getSource())).getActivityOrArtifact());
        }
        return hashSet;
    }

    @Override
    public Set getReferencedActivities() {
        HashSet<GraphCommonInterface> hashSet = new HashSet<GraphCommonInterface>();
        Iterator iterator = this.getPort().edges();
        while (iterator.hasNext()) {
            GraphTransitionInterface graphTransitionInterface = (GraphTransitionInterface)iterator.next();
            GraphCommonInterface graphCommonInterface = ((GraphPortInterface)((Object)graphTransitionInterface.getSource())).getActivityOrArtifact();
            if (this != graphCommonInterface) continue;
            hashSet.add(((GraphPortInterface)((Object)graphTransitionInterface.getTarget())).getActivityOrArtifact());
        }
        return hashSet;
    }

    @Override
    public Point getOffset() {
        return GraphUtilities.getOffsetPoint((XMLCollectionElement)((Artifact)this.userObject));
    }
}

