/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.graph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.base.controller.JaWEType;
import org.enhydra.jawe.components.graph.FreeTextExpressionParticipant;
import org.enhydra.jawe.components.graph.Graph;
import org.enhydra.jawe.components.graph.GraphSettings;
import org.enhydra.jawe.components.graph.GraphSwimlaneInterface;
import org.enhydra.jawe.components.graph.GraphSwimlaneRendererInterface;
import org.enhydra.jawe.components.graph.GraphUtilities;
import org.enhydra.jawe.components.graph.MultiLinedRenderer;
import org.enhydra.jxpdl.XMLCollectionElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.elements.Lane;
import org.enhydra.jxpdl.elements.NodeGraphicsInfo;
import org.enhydra.jxpdl.elements.Participant;
import org.enhydra.jxpdl.elements.Pool;
import org.enhydra.jxpdl.elements.WorkflowProcess;
import org.jgraph.graph.GraphConstants;

public class DefaultGraphSwimlaneRenderer
extends MultiLinedRenderer
implements GraphSwimlaneRendererInterface {
    @Override
    public void paint(Graphics graphics) {
        Object object;
        boolean bl = GraphUtilities.getGraphOrientation(((Graph)this.graph).getXPDLObject()).equals("VERTICAL");
        int n = GraphUtilities.getGraphController().getGraphSettings().getLaneNameWidth();
        String string = this.graph.convertValueToString(this.view.getCell());
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.view.getBounds().getBounds().getSize();
        graphics2D.setStroke(GraphSettings.DEPARTMENT_STROKE);
        Color color = this.getFillColor();
        this.bordercolor = this.getBorderColor();
        graphics.setColor(this.bordercolor);
        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        Color color2 = new Color(n2, n3, n4, 255);
        Color color3 = new Color(n2, n3, n4, 0);
        Color color4 = new Color(n2, n3, n4, 32);
        if (bl) {
            object = new GradientPaint(0.0f, 0.0f, color2, dimension.width - 3, n - 2, color3);
            graphics2D.setPaint((Paint)object);
            graphics.fillRect(1, 1, dimension.width - 3, n - 2);
            object = new GradientPaint(1.0f, n, color4, dimension.width - 3, dimension.height - 2, color3);
            graphics2D.setPaint((Paint)object);
            graphics.fillRect(1, n, dimension.width - 3, dimension.height - 2);
        } else {
            object = new GradientPaint(1.0f, 1.0f, color2, n - 2, dimension.height - 3, color3);
            graphics2D.setPaint((Paint)object);
            graphics.fillRect(1, 1, n - 2, dimension.height - 3);
            object = new GradientPaint(n, 1.0f, color4, dimension.width - 2, dimension.height - 3, color3);
            graphics2D.setPaint((Paint)object);
            graphics.fillRect(n, 1, dimension.width - 2, dimension.height - 3);
        }
        graphics.setColor(this.bordercolor);
        if (bl) {
            graphics.drawLine(0, n, dimension.width - 1, n);
        } else {
            graphics.drawLine(n, 0, n, dimension.height - 1);
        }
        if (this.selected || this.hasFocus) {
            graphics2D.setStroke(GraphConstants.SELECTION_STROKE);
            graphics.setColor(this.graph.getHighlightColor());
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            if (bl) {
                graphics.drawLine(0, n, dimension.width - 1, n);
            } else {
                graphics.drawLine(n, 0, n, dimension.height - 1);
            }
        }
        if (string != null) {
            if (!this.selected) {
                graphics2D.setStroke(GraphSettings.DEPARTMENT_STROKE);
            }
            Font font = this.getFont();
            int n5 = this.getFontMetrics(font).stringWidth(string);
            if (bl) {
                if (n5 > dimension.width - 20) {
                    n5 = dimension.width - 20;
                }
                n5 = (dimension.width - n5) / 2 - 10;
                object = (Graphics2D)graphics.create(1, 1, dimension.width - 2, n - 3);
                ((Graphics2D)object).translate(n5, 1);
                super.setBounds(new Rectangle(1, 1, dimension.width - 5, n + 12));
            } else {
                if (n5 > dimension.height - 20) {
                    n5 = dimension.height - 20;
                }
                n5 = (dimension.height - n5) / 2 - 10;
                object = (Graphics2D)graphics.create(1, 1, n - 2, dimension.height - 3);
                ((Graphics2D)object).translate(1, dimension.height - n5);
                ((Graphics2D)object).rotate(Math.toRadians(-90.0));
                super.setBounds(new Rectangle(1, 1, dimension.height - 5, n + 12));
            }
            super.paint((Graphics)object);
        }
    }

    @Override
    public ImageIcon getIcon() {
        GraphSwimlaneInterface graphSwimlaneInterface = (GraphSwimlaneInterface)this.view.getCell();
        if (graphSwimlaneInterface.getPropertyObject() instanceof Pool) {
            return ((JaWEType)JaWEManager.getInstance().getJaWEController().getJaWETypes().getTypes(WorkflowProcess.class, null).get(0)).getIcon();
        }
        Object object = this.getParticipantType((XMLElement)graphSwimlaneInterface.getPropertyObject());
        if (object instanceof FreeTextExpressionParticipant) {
            return GraphUtilities.getGraphController().getGraphSettings().getFreeTextLaneIcon();
        }
        if (object instanceof Lane) {
            return GraphUtilities.getGraphController().getGraphSettings().getCommonExpresionLaneIcon();
        }
        return JaWEManager.getInstance().getJaWEController().getTypeResolver().getJaWEType((XMLElement)((Participant)object)).getIcon();
    }

    public Color getBorderColor() {
        GraphSwimlaneInterface graphSwimlaneInterface = (GraphSwimlaneInterface)this.view.getCell();
        NodeGraphicsInfo nodeGraphicsInfo = JaWEManager.getInstance().getXPDLUtils().getNodeGraphicsInfo((XMLCollectionElement)graphSwimlaneInterface.getPropertyObject());
        Color color = null;
        if (nodeGraphicsInfo != null) {
            color = Utils.getColor(nodeGraphicsInfo.getBorderColor());
        }
        if (color == null) {
            color = GraphUtilities.getGraphController().getGraphSettings().getLaneBorderColor();
        }
        return color;
    }

    public Color getFillColor() {
        GraphSwimlaneInterface graphSwimlaneInterface = (GraphSwimlaneInterface)this.view.getCell();
        NodeGraphicsInfo nodeGraphicsInfo = JaWEManager.getInstance().getXPDLUtils().getNodeGraphicsInfo((XMLCollectionElement)graphSwimlaneInterface.getPropertyObject());
        Color color = null;
        if (nodeGraphicsInfo != null) {
            color = Utils.getColor(nodeGraphicsInfo.getFillColor());
        }
        if (color == null) {
            Object object = this.getParticipantType((XMLElement)graphSwimlaneInterface.getPropertyObject());
            color = object instanceof FreeTextExpressionParticipant ? GraphUtilities.getGraphController().getGraphSettings().getLaneFreeTextExpressionColor() : (object instanceof Lane ? GraphUtilities.getGraphController().getGraphSettings().getLaneCommonExpressionColor() : JaWEManager.getInstance().getJaWEController().getTypeResolver().getJaWEType((XMLElement)((Participant)object)).getColor());
        }
        return color;
    }

    protected Object getParticipantType(XMLElement xMLElement) {
        Object object = null;
        if (!(xMLElement instanceof Participant)) {
            Lane lane;
            if (xMLElement instanceof Lane && (object = GraphUtilities.getParticipantForLane(lane = (Lane)xMLElement, null)) == null && lane.getPerformers().size() > 0) {
                object = lane;
            }
            if (object == null) {
                object = FreeTextExpressionParticipant.getInstance();
            }
        } else {
            object = xMLElement;
        }
        return object;
    }
}

