/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.graph;

import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.plaf.FontUIResource;
import javax.swing.tree.DefaultMutableTreeNode;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.components.graph.DefaultGraphActivityView;
import org.enhydra.jawe.components.graph.DefaultGraphArtifactView;
import org.enhydra.jawe.components.graph.DefaultGraphPortView;
import org.enhydra.jawe.components.graph.DefaultGraphSwimlaneView;
import org.enhydra.jawe.components.graph.DefaultGraphTransitionView;
import org.enhydra.jawe.components.graph.GraphActivityInterface;
import org.enhydra.jawe.components.graph.GraphArtifactInterface;
import org.enhydra.jawe.components.graph.GraphController;
import org.enhydra.jawe.components.graph.GraphManager;
import org.enhydra.jawe.components.graph.GraphMarqueeHandler;
import org.enhydra.jawe.components.graph.GraphObjectViewFactory;
import org.enhydra.jawe.components.graph.GraphSettings;
import org.enhydra.jawe.components.graph.GraphSwimlaneInterface;
import org.enhydra.jawe.components.graph.GraphSwimlaneViewInterface;
import org.enhydra.jawe.components.graph.GraphTransitionInterface;
import org.enhydra.jawe.components.graph.GraphUtilities;
import org.enhydra.jawe.components.graph.JaWEGraphModel;
import org.enhydra.jawe.components.graph.JaWEGraphSelectionModel;
import org.enhydra.jawe.components.graph.JaWEGraphUI;
import org.enhydra.jawe.components.graph.WorkflowElement;
import org.enhydra.jxpdl.XMLCollectionElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLUtil;
import org.enhydra.jxpdl.elements.Activity;
import org.enhydra.jxpdl.elements.ActivitySet;
import org.enhydra.jxpdl.elements.Artifact;
import org.enhydra.jxpdl.elements.Association;
import org.enhydra.jxpdl.elements.Lane;
import org.enhydra.jxpdl.elements.Pool;
import org.enhydra.jxpdl.elements.Transition;
import org.enhydra.jxpdl.elements.WorkflowProcess;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.BasicMarqueeHandler;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewFactory;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.Port;
import org.jgraph.plaf.GraphUI;

public class Graph
extends JGraph {
    protected WorkflowProcess wp;
    protected ActivitySet as;
    protected transient GraphManager graphManager;
    protected GraphController graphController;
    protected boolean showTransitionConditions;
    protected boolean showArtifacts;

    public GraphController getGraphController() {
        return this.graphController;
    }

    public Graph(GraphController graphController, GraphModel graphModel, BasicMarqueeHandler basicMarqueeHandler, WorkflowProcess workflowProcess) {
        this.init(graphController, graphModel, basicMarqueeHandler, (XMLCollectionElement)workflowProcess);
        this.graphManager.createWorkflowGraph((XMLCollectionElement)workflowProcess);
    }

    public Graph(GraphController graphController, GraphModel graphModel, BasicMarqueeHandler basicMarqueeHandler, ActivitySet activitySet) {
        this.init(graphController, graphModel, basicMarqueeHandler, (XMLCollectionElement)activitySet);
        this.graphManager.createWorkflowGraph((XMLCollectionElement)activitySet);
    }

    public Graph(GraphModel graphModel, GraphLayoutCache graphLayoutCache) {
        super(graphModel, graphLayoutCache);
        this.setShowTransAndArtsProperties();
    }

    public Graph(Graph graph) {
        super(graph.getModel(), graph.getGraphLayoutCache());
        this.graphController = graph.graphController;
        this.setMarqueeHandler(graph.getMarqueeHandler());
        this.wp = graph.getWorkflowProcess();
        this.as = graph.getActivitySet();
        this.initGraphBehavior();
        this.graphManager = graph.graphManager;
    }

    protected void init(GraphController graphController, GraphModel object, BasicMarqueeHandler basicMarqueeHandler, XMLCollectionElement xMLCollectionElement) {
        this.graphController = graphController;
        this.selectionModel = new JaWEGraphSelectionModel(this);
        this.setLayout(null);
        GraphLayoutCache graphLayoutCache = new GraphLayoutCache(object, (CellViewFactory)new GraphObjectViewFactory());
        this.setGraphLayoutCache(graphLayoutCache);
        this.updateUI();
        if (object == null) {
            object = new JaWEGraphModel();
        }
        this.setModel((GraphModel)object);
        this.setMarqueeHandler(basicMarqueeHandler);
        if (xMLCollectionElement instanceof WorkflowProcess) {
            this.wp = (WorkflowProcess)xMLCollectionElement;
        } else {
            this.as = (ActivitySet)xMLCollectionElement;
            this.wp = XMLUtil.getWorkflowProcess((XMLElement)xMLCollectionElement);
        }
        this.initGraphBehavior();
        this.graphManager = this.createGraphManager();
    }

    protected GraphManager createGraphManager() {
        try {
            String string = this.graphController.getGraphSettings().getGraphManager();
            Constructor<?> constructor = Class.forName(string).getConstructor(Graph.class);
            return (GraphManager)constructor.newInstance(new Object[]{this});
        }
        catch (Exception exception) {
            return null;
        }
    }

    public GraphManager getGraphManager() {
        return this.graphManager;
    }

    public WorkflowProcess getWorkflowProcess() {
        return this.wp;
    }

    public ActivitySet getActivitySet() {
        return this.as;
    }

    public XMLCollectionElement getXPDLObject() {
        if (this.as != null) {
            return this.as;
        }
        return this.wp;
    }

    public WorkflowElement selectActivity(Activity activity, boolean bl) {
        GraphActivityInterface graphActivityInterface = this.getGraphManager().getGraphActivity(activity);
        this.selectElement(graphActivityInterface, bl, true);
        return graphActivityInterface;
    }

    public WorkflowElement selectArtifact(Artifact artifact, boolean bl) {
        GraphArtifactInterface graphArtifactInterface = this.getGraphManager().getGraphArtifact(artifact);
        this.selectElement(graphArtifactInterface, bl, true);
        return graphArtifactInterface;
    }

    public WorkflowElement selectTransition(XMLCollectionElement xMLCollectionElement, boolean bl) {
        GraphTransitionInterface graphTransitionInterface = this.getGraphManager().getGraphTransition(xMLCollectionElement);
        this.selectElement(graphTransitionInterface, bl, true);
        return graphTransitionInterface;
    }

    public WorkflowElement selectParticipant(Object object) {
        GraphSwimlaneInterface graphSwimlaneInterface = this.getGraphManager().getGraphParticipant(object);
        this.selectElement(graphSwimlaneInterface, false, false);
        return graphSwimlaneInterface;
    }

    public void selectElement(WorkflowElement workflowElement, boolean bl, boolean bl2) {
        if (workflowElement != null) {
            if (bl) {
                this.addSelectionCell(workflowElement);
            } else {
                this.setSelectionCell(workflowElement);
            }
            if (bl2) {
                this.getModel().toFront(new Object[]{workflowElement});
            }
        }
    }

    public WorkflowElement getGraphInterface(XMLElement xMLElement) {
        if (xMLElement instanceof Activity) {
            return this.getGraphManager().getGraphActivity((Activity)xMLElement);
        }
        if (xMLElement instanceof Artifact) {
            return this.getGraphManager().getGraphArtifact((Artifact)xMLElement);
        }
        if (xMLElement instanceof Transition) {
            return this.getGraphManager().getGraphTransition((XMLCollectionElement)((Transition)xMLElement));
        }
        if (xMLElement instanceof Association) {
            return this.getGraphManager().getGraphTransition((XMLCollectionElement)((Association)xMLElement));
        }
        if (xMLElement instanceof Lane || xMLElement instanceof Pool) {
            return this.getGraphManager().getGraphParticipant(xMLElement);
        }
        return null;
    }

    public void selectElements(Object[] objectArray, boolean bl, boolean bl2) {
        if (objectArray != null) {
            if (bl) {
                this.addSelectionCells(objectArray);
            } else {
                this.setSelectionCells(objectArray);
            }
            if (bl2) {
                this.getModel().toFront(objectArray);
            }
        }
    }

    public String convertValueToString(Object object) {
        if (object instanceof CellView) {
            object = ((CellView)object).getCell();
        }
        if (object instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)object).getUserObject() != null) {
            Activity activity;
            if (object instanceof GraphTransitionInterface) {
                XMLCollectionElement xMLCollectionElement = (XMLCollectionElement)((GraphTransitionInterface)object).getPropertyObject();
                if (xMLCollectionElement instanceof Transition) {
                    Transition transition = (Transition)xMLCollectionElement;
                    if (this.graphController.getGraphSettings().shouldShowTransitionNameForCondition()) {
                        return transition.getName();
                    }
                    return transition.getCondition().toValue();
                }
                return "";
            }
            if (object instanceof GraphActivityInterface && (activity = (Activity)((GraphActivityInterface)object).getUserObject()).getActivityType() == 0) {
                return "";
            }
            return object.toString();
        }
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    public Object getFirstParticipantForLocation(int n, int n2) {
        n = (int)((double)n / this.scale);
        n2 = (int)((double)n2 / this.scale);
        CellView[] cellViewArray = this.getOrderedAllSelectableCells();
        if (cellViewArray != null) {
            Rectangle rectangle = new Rectangle(n - this.tolerance, n2 - this.tolerance, 2 * this.tolerance, 2 * this.tolerance);
            for (int i = 0; i < cellViewArray.length; ++i) {
                boolean bl;
                if (!(cellViewArray[i] instanceof GraphSwimlaneViewInterface) || !(bl = cellViewArray[i].getBounds().intersects(rectangle))) continue;
                return cellViewArray[i].getCell();
            }
        }
        return null;
    }

    public CellView getNextViewAt(CellView cellView, double d, double d2) {
        CellView[] cellViewArray = this.getOrderedAllSelectableCells();
        CellView cellView2 = this.getNextViewAt(cellViewArray, cellView, d, d2);
        return cellView2;
    }

    public CellView getNextViewAt(CellView[] cellViewArray, CellView cellView, double d, double d2) {
        if (cellViewArray != null) {
            Rectangle rectangle = new Rectangle((int)d - this.tolerance, (int)d2 - this.tolerance, 2 * this.tolerance, 2 * this.tolerance);
            CellView cellView2 = null;
            boolean bl = cellView == null;
            for (int i = 0; i < cellViewArray.length; ++i) {
                boolean bl2 = false;
                boolean bl3 = true;
                GraphMarqueeHandler graphMarqueeHandler = (GraphMarqueeHandler)this.marquee;
                if (graphMarqueeHandler.isSelectButtonSelected() || graphMarqueeHandler.isTransitionButtonSelected() || graphMarqueeHandler.isAssociationButtonSelected()) {
                    bl3 = false;
                }
                if (!(bl2 = cellViewArray[i] instanceof GraphSwimlaneViewInterface && bl3 ? cellViewArray[i].getBounds().intersects(rectangle) : cellViewArray[i].intersects((JGraph)this, (Rectangle2D)rectangle))) continue;
                if (bl) {
                    return cellViewArray[i];
                }
                if (cellView2 == null) {
                    cellView2 = cellViewArray[i];
                }
                bl |= cellViewArray[i] == cellView;
            }
            return cellView2;
        }
        return null;
    }

    private CellView[] getOrderedAllSelectableCells() {
        Object object;
        ArrayList<CellView> arrayList;
        Object object2;
        CellView[] cellViewArray = this.graphLayoutCache.getRoots();
        Stack<CellView> stack = new Stack<CellView>();
        for (int i = 0; i < cellViewArray.length; ++i) {
            stack.add(cellViewArray[i]);
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        while (!stack.isEmpty()) {
            object2 = (CellView)stack.pop();
            arrayList = object2.getCell();
            if (!(arrayList instanceof Port)) {
                arrayList2.add(object2);
            }
            object = object2.getChildViews();
            for (int i = 0; i < ((CellView[])object).length; ++i) {
                stack.add(object[i]);
            }
        }
        object2 = new ArrayList();
        arrayList = new ArrayList<CellView>();
        for (CellView cellView : arrayList2) {
            if (cellView.getCell() instanceof GraphSwimlaneInterface) {
                arrayList.add(cellView);
                continue;
            }
            object2.add(cellView);
        }
        int n = -1;
        int n2 = arrayList.size() + object2.size();
        CellView[] cellViewArray2 = new CellView[n2];
        object = object2.iterator();
        while (object.hasNext()) {
            cellViewArray2[++var7_12] = (CellView)object.next();
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            cellViewArray2[--n2] = (CellView)object.next();
        }
        return cellViewArray2;
    }

    public void printOrderedAllSelectables() {
        CellView[] cellViewArray = this.getOrderedAllSelectableCells();
        for (int i = 0; i < cellViewArray.length; ++i) {
            System.out.println("view" + i + "=" + cellViewArray[i].getCell());
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (mouseEvent != null) {
            GraphMarqueeHandler graphMarqueeHandler = (GraphMarqueeHandler)this.marquee;
            Point point = (Point)this.fromScreen(mouseEvent.getPoint());
            Object object = !graphMarqueeHandler.isSelectButtonSelected() && !graphMarqueeHandler.isTransitionButtonSelected() && !graphMarqueeHandler.isAssociationButtonSelected() ? this.getFirstParticipantForLocation((int)point.getX(), (int)point.getY()) : this.getFirstCellForLocation(point.getX(), point.getY());
            if (object != null) {
                String string = this.convertValueToString(object);
                if (object instanceof WorkflowElement) {
                    string = ((WorkflowElement)object).getTooltip();
                }
                return string;
            }
        }
        return null;
    }

    public boolean validateAgainsXPDLSchema() {
        return true;
    }

    public void initGraphBehavior() {
        this.setHandleSize(4);
        this.setTolerance(4);
        this.setSizeable(false);
        this.setMoveable(!this.getXPDLObject().isReadOnly());
        this.setDisconnectable(true);
        this.setDisconnectOnMove(false);
        this.setAntiAliased(true);
        this.setAutoscrolls(true);
        this.selectionModel.setSelectionMode(4);
        this.refreshGraphConfiguration();
    }

    public void refreshGraphConfiguration() {
        GraphSettings graphSettings = GraphUtilities.getGraphController().getGraphSettings();
        boolean bl = graphSettings.shouldShowGrid();
        this.setGridEnabled(bl);
        this.setGridVisible(bl);
        this.setGridSize(graphSettings.getGridSize());
        this.setBackground(graphSettings.getBackgroundColor());
        this.setHighlightColor(graphSettings.getSelectedActivityColor());
        this.setGridColor(graphSettings.getGridColor());
        this.setHandleColor(graphSettings.getHandleColor());
        this.setMarqueeColor(graphSettings.getMarqueeColor());
        this.setFontSize();
        this.setShowTransAndArtsProperties();
    }

    protected void setShowTransAndArtsProperties() {
        boolean bl = (Boolean)this.graphController.getSettings().getSetting("ShowTransitionCondition");
        this.setShowTransitionConditions(bl);
        bl = (Boolean)this.graphController.getSettings().getSetting("ShowArtifacts");
        this.setShowArtifacts(bl);
    }

    protected void setFontSize() {
        Object object2;
        List list = JaWEGraphModel.getAllCellsInModel(this.getModel());
        if (list == null) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        for (Object object2 : list) {
            if (object2 instanceof Port) continue;
            arrayList.add(object2);
        }
        Object[] objectArray = arrayList.toArray();
        object2 = JaWEManager.getFontName();
        int n = this.graphController.getGraphSettings().getGraphFontSize();
        try {
            FontUIResource fontUIResource;
            try {
                fontUIResource = new FontUIResource((String)object2, 0, n);
            }
            catch (Exception exception) {
                fontUIResource = new FontUIResource("Label.font", 0, n);
            }
            HashMap<Object, AttributeMap> hashMap = new HashMap<Object, AttributeMap>();
            for (int i = 0; i < objectArray.length; ++i) {
                CellView cellView = this.getGraphLayoutCache().getMapping(objectArray[i], false);
                if (cellView == null) continue;
                Font font = GraphConstants.getFont((Map)cellView.getAllAttributes());
                if (font.getSize() == n) {
                    return;
                }
                AttributeMap attributeMap = new AttributeMap();
                GraphConstants.setFont((Map)attributeMap, (Font)fontUIResource.deriveFont(n));
                hashMap.put(objectArray[i], attributeMap);
            }
            ((JaWEGraphModel)this.graphModel).editFonts(hashMap);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addSampleData(GraphModel graphModel) {
    }

    public void updateUI() {
        this.setUI((GraphUI)new JaWEGraphUI());
        this.invalidate();
    }

    public String toString() {
        XMLCollectionElement xMLCollectionElement = this.getXPDLObject();
        if (xMLCollectionElement != null) {
            return JaWEManager.getInstance().getDisplayNameGenerator().getDisplayName((XMLElement)xMLCollectionElement);
        }
        return "";
    }

    public void clearXPDLObjectReferences() {
        DefaultGraphActivityView.renderers.clear();
        DefaultGraphArtifactView.renderers.clear();
        DefaultGraphSwimlaneView.renderers.clear();
        DefaultGraphTransitionView.renderers.clear();
        DefaultGraphPortView.renderers.clear();
    }

    public boolean shouldShowTransitionConditions() {
        return this.showTransitionConditions;
    }

    public void setShowTransitionConditions(boolean bl) {
        this.showTransitionConditions = bl;
    }

    public boolean shouldShowArtifacts() {
        return this.showArtifacts;
    }

    public void setShowArtifacts(boolean bl) {
        this.showArtifacts = bl;
    }
}

