/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.graph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import org.enhydra.jawe.ActionBase;
import org.enhydra.jawe.BarFactory;
import org.enhydra.jawe.JaWEAction;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEComponentView;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.XMLElementChoiceButton;
import org.enhydra.jawe.base.controller.JaWEType;
import org.enhydra.jawe.base.controller.JaWETypes;
import org.enhydra.jawe.components.graph.Graph;
import org.enhydra.jawe.components.graph.GraphController;
import org.enhydra.jawe.components.graph.GraphSettings;
import org.enhydra.jawe.components.graph.GraphSwimlaneInterface;
import org.enhydra.jawe.components.graph.WorkflowElement;
import org.enhydra.jawe.components.graph.actions.SetActivityMode;
import org.enhydra.jawe.components.graph.actions.SetArtifactMode;
import org.enhydra.jawe.components.graph.actions.SetAssociationMode;
import org.enhydra.jawe.components.graph.actions.SetLaneMode;
import org.enhydra.jawe.components.graph.actions.SetLaneModeFreeTextExpression;
import org.enhydra.jawe.components.graph.actions.SetSelectMode;
import org.enhydra.jawe.components.graph.actions.SetTransitionMode;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLUtil;
import org.enhydra.jxpdl.elements.Activity;
import org.enhydra.jxpdl.elements.ActivitySet;
import org.enhydra.jxpdl.elements.Artifact;
import org.enhydra.jxpdl.elements.Association;
import org.enhydra.jxpdl.elements.Lane;
import org.enhydra.jxpdl.elements.Participant;
import org.enhydra.jxpdl.elements.Transition;

public class GraphControllerPanel
extends JPanel
implements JaWEComponentView {
    protected GraphController controller;
    protected JScrollPane graphScrollPane;
    protected JToolBar toolbar;
    protected XMLElementChoiceButton showParticipantChoiceButton;
    protected XMLElementChoiceButton asChoiceButton;
    protected XMLElementChoiceButton showActivityModes;
    protected JPanel toolbars = new JPanel();

    public GraphControllerPanel(GraphController graphController) {
        this.controller = graphController;
    }

    @Override
    public void configure() {
    }

    @Override
    public void init() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.toolbars.setLayout(new BorderLayout());
        this.toolbar = BarFactory.createToolbar("defaultToolbar", this.controller);
        this.toolbar.setFloatable(false);
        ImageIcon imageIcon = this.controller.getGraphSettings().getLanesIcon();
        this.showParticipantChoiceButton = new XMLElementChoiceButton(Participant.class, this.controller, imageIcon, true, new String[]{"Id", "Name", "ParticipantType", "Description"});
        this.showParticipantChoiceButton.setToolTipText(this.controller.getSettings().getLanguageDependentString("InsertExistingParticipantTooltip"));
        imageIcon = this.controller.getGraphSettings().getActivitySetSelectIcon();
        this.asChoiceButton = new XMLElementChoiceButton(ActivitySet.class, this.controller, imageIcon, true, new String[]{"Id"});
        this.asChoiceButton.setToolTipText(this.controller.getSettings().getLanguageDependentString("SelectActivitySetTooltip"));
        JToolBar jToolBar = new JToolBar();
        if (this.controller.getGraphSettings().useLaneChoiceButton()) {
            jToolBar.add(this.showParticipantChoiceButton);
        }
        if (this.controller.getGraphSettings().useActivitySetChoiceButton()) {
            jToolBar.add(this.asChoiceButton);
        }
        if (this.controller.getGraphSettings().useLaneChoiceButton() || this.controller.getGraphSettings().useActivitySetChoiceButton()) {
            this.toolbar.add(jToolBar);
        }
        this.graphScrollPane = this.createWorkingComponent();
        JToolBar jToolBar2 = new JToolBar();
        jToolBar2.setFloatable(false);
        JToolBar jToolBar3 = this.createToolbox();
        jToolBar3.setOrientation(0);
        jToolBar2.add(jToolBar3);
        this.toolbars.add((Component)this.toolbar, "North");
        this.toolbars.add((Component)jToolBar2, "Center");
        this.add((Component)this.toolbars, "North");
        this.add((Component)this.graphScrollPane, "Center");
    }

    @Override
    public JaWEComponent getJaWEComponent() {
        return this.controller;
    }

    @Override
    public JComponent getDisplay() {
        return this;
    }

    protected JToolBar createToolbox() {
        String string = "toolbox";
        String string2 = this.controller.getSettings().getToolbarActionOrder(string);
        JaWETypes jaWETypes = JaWEManager.getInstance().getJaWEController().getJaWETypes();
        JToolBar jToolBar = new JToolBar();
        jToolBar.setRollover(true);
        String[] stringArray = XMLUtil.tokenize((String)string2, (String)" ");
        for (int i = 0; i < stringArray.length; ++i) {
            JButton jButton;
            JaWEAction jaWEAction;
            Object object;
            Object object2;
            Object object3;
            if (stringArray[i].equals("-")) {
                jToolBar.addSeparator();
                continue;
            }
            if (stringArray[i].equals("SetSelectMode")) {
                object3 = new JaWEAction();
                ((JaWEAction)object3).setAction(new SetSelectMode(this.controller));
                ((JaWEAction)object3).setIcon(((GraphSettings)this.controller.getSettings()).getSelectionIcon());
                ((JaWEAction)object3).setLangDepName(this.controller.getSettings().getLanguageDependentString("SelectionKey"));
                object2 = BarFactory.createToolbarButton((JaWEAction)object3, this.controller);
                ((JComponent)object2).setToolTipText(((JaWEAction)object3).getLangDepName());
                jToolBar.add((Component)object2);
                this.controller.getSettings().addAction("SetSelectMode", (JaWEAction)object3);
                continue;
            }
            if (stringArray[i].equals("SetLaneModeCommonExpression")) {
                object3 = new JaWEAction();
                try {
                    object2 = "org.enhydra.jawe.components.graph.actions.SetLaneModeCommonExpression";
                    ActionBase actionBase = (ActionBase)Class.forName((String)object2).getConstructor(GraphController.class).newInstance(this.controller);
                    ((JaWEAction)object3).setAction(actionBase);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ((JaWEAction)object3).setIcon(((GraphSettings)this.controller.getSettings()).getCommonExpresionLaneIcon());
                ((JaWEAction)object3).setLangDepName(this.controller.getSettings().getLanguageDependentString("CommonExpressionParticipantKey"));
                object2 = BarFactory.createToolbarButton((JaWEAction)object3, this.controller);
                ((JComponent)object2).setToolTipText(((JaWEAction)object3).getLangDepName());
                jToolBar.add((Component)object2);
                this.controller.getSettings().addAction("SetLaneModeCommonExpression", (JaWEAction)object3);
                continue;
            }
            if (stringArray[i].equals("SetLaneModeFreeTextExpression")) {
                object3 = new JaWEAction();
                ((JaWEAction)object3).setAction(new SetLaneModeFreeTextExpression(this.controller));
                ((JaWEAction)object3).setIcon(((GraphSettings)this.controller.getSettings()).getFreeTextLaneIcon());
                ((JaWEAction)object3).setLangDepName(this.controller.getSettings().getLanguageDependentString("FreeTextExpressionParticipantKey"));
                object2 = BarFactory.createToolbarButton((JaWEAction)object3, this.controller);
                ((JComponent)object2).setToolTipText(((JaWEAction)object3).getLangDepName());
                jToolBar.add((Component)object2);
                this.controller.getSettings().addAction("SetLaneModeFreeTextExpression", (JaWEAction)object3);
                continue;
            }
            if (stringArray[i].startsWith("SetLaneMode")) {
                object3 = stringArray[i].substring("SetLaneMode".length());
                if (((String)object3).equals("*")) {
                    object2 = jaWETypes.getTypes(Lane.class, null);
                    for (int j = 0; j < object2.size(); ++j) {
                        object = (JaWEType)object2.get(j);
                        jaWEAction = new JaWEAction();
                        jaWEAction.setAction(new SetLaneMode(this.controller, ((JaWEType)object).getTypeId()));
                        jaWEAction.setIcon(((JaWEType)object).getIcon());
                        jaWEAction.setLangDepName(((JaWEType)object).getDisplayName());
                        jButton = BarFactory.createToolbarButton(jaWEAction, this.controller);
                        jButton.setToolTipText(jaWEAction.getLangDepName());
                        jToolBar.add(jButton);
                        this.controller.getSettings().addAction(((JaWEType)object).getTypeId(), jaWEAction);
                    }
                    continue;
                }
                if (((String)object3).equals("SetLaneModeCommonExpression") || ((String)object3).equals("SetLaneModeFreeTextExpression") || (object2 = jaWETypes.getType((String)object3)) == null) continue;
                JaWEAction jaWEAction2 = new JaWEAction();
                jaWEAction2.setAction(new SetLaneMode(this.controller, ((JaWEType)object2).getTypeId()));
                jaWEAction2.setIcon(((JaWEType)object2).getIcon());
                jaWEAction2.setLangDepName(((JaWEType)object2).getDisplayName());
                object = BarFactory.createToolbarButton(jaWEAction2, this.controller);
                ((JComponent)object).setToolTipText(jaWEAction2.getLangDepName());
                jToolBar.add((Component)object);
                this.controller.getSettings().addAction(((JaWEType)object2).getTypeId(), jaWEAction2);
                continue;
            }
            if (stringArray[i].startsWith("SetArtifactMode")) {
                object3 = stringArray[i].substring("SetArtifactMode".length());
                if (!((String)object3).equals("*")) continue;
                object2 = jaWETypes.getTypes(Artifact.class, null);
                for (int j = 0; j < object2.size(); ++j) {
                    object = (JaWEType)object2.get(j);
                    jaWEAction = new JaWEAction();
                    jaWEAction.setAction(new SetArtifactMode(this.controller, ((JaWEType)object).getTypeId()));
                    jaWEAction.setIcon(((JaWEType)object).getIcon());
                    jaWEAction.setLangDepName(((JaWEType)object).getDisplayName());
                    jButton = BarFactory.createToolbarButton(jaWEAction, this.controller);
                    jButton.setToolTipText(jaWEAction.getLangDepName());
                    jToolBar.add(jButton);
                    this.controller.getSettings().addAction(((JaWEType)object).getTypeId(), jaWEAction);
                }
                continue;
            }
            if (stringArray[i].startsWith("SetActivityMode")) {
                object3 = stringArray[i].substring("SetActivityMode".length());
                if (((String)object3).equals("*")) {
                    this.addSetActivityModeComponent(jaWETypes, jToolBar);
                    continue;
                }
                object2 = jaWETypes.getType((String)object3);
                if (object2 == null) continue;
                JaWEAction jaWEAction3 = new JaWEAction();
                jaWEAction3.setAction(new SetActivityMode(this.controller, ((JaWEType)object2).getTypeId()));
                jaWEAction3.setIcon(((JaWEType)object2).getIcon());
                jaWEAction3.setLangDepName(((JaWEType)object2).getDisplayName());
                object = BarFactory.createToolbarButton(jaWEAction3, this.controller);
                ((JComponent)object).setToolTipText(jaWEAction3.getLangDepName());
                jToolBar.add((Component)object);
                this.controller.getSettings().addAction(((JaWEType)object2).getTypeId(), jaWEAction3);
                continue;
            }
            if (stringArray[i].startsWith("SetTransitionMode")) {
                object3 = stringArray[i].substring("SetTransitionMode".length());
                if (((String)object3).equals("*")) {
                    this.addSetTransitionModeComponent(jaWETypes, jToolBar);
                    continue;
                }
                object2 = jaWETypes.getType((String)object3);
                if (object2 == null) continue;
                JaWEAction jaWEAction4 = new JaWEAction();
                jaWEAction4.setAction(new SetTransitionMode(this.controller, ((JaWEType)object2).getTypeId()));
                jaWEAction4.setIcon(((JaWEType)object2).getIcon());
                jaWEAction4.setLangDepName(((JaWEType)object2).getDisplayName());
                object = BarFactory.createToolbarButton(jaWEAction4, this.controller);
                ((JComponent)object).setToolTipText(jaWEAction4.getLangDepName());
                jToolBar.add((Component)object);
                this.controller.getSettings().addAction(((JaWEType)object2).getTypeId(), jaWEAction4);
                continue;
            }
            if (!stringArray[i].startsWith("SetAssociationMode")) continue;
            object3 = stringArray[i].substring("SetAssociationMode".length());
            object2 = jaWETypes.getTypes(Association.class, null);
            for (int j = 0; j < object2.size(); ++j) {
                object = (JaWEType)object2.get(j);
                jaWEAction = new JaWEAction();
                jaWEAction.setAction(new SetAssociationMode(this.controller, ((JaWEType)object).getTypeId()));
                jaWEAction.setIcon(((JaWEType)object).getIcon());
                jaWEAction.setLangDepName(((JaWEType)object).getDisplayName());
                jButton = BarFactory.createToolbarButton(jaWEAction, this.controller);
                jButton.setToolTipText(jaWEAction.getLangDepName());
                jToolBar.add(jButton);
                this.controller.getSettings().addAction(((JaWEType)object).getTypeId(), jaWEAction);
            }
        }
        jToolBar.setName(this.controller.getSettings().getLanguageDependentString(string + "Label"));
        return jToolBar;
    }

    protected void addSetTransitionModeComponent(JaWETypes jaWETypes, JToolBar jToolBar) {
        List list = jaWETypes.getTypes(Transition.class, null);
        for (int i = 0; i < list.size(); ++i) {
            JaWEType jaWEType = (JaWEType)list.get(i);
            JaWEAction jaWEAction = new JaWEAction();
            jaWEAction.setAction(new SetTransitionMode(this.controller, jaWEType.getTypeId()));
            jaWEAction.setIcon(jaWEType.getIcon());
            jaWEAction.setLangDepName(jaWEType.getDisplayName());
            JButton jButton = BarFactory.createToolbarButton(jaWEAction, this.controller);
            jButton.setToolTipText(jaWEAction.getLangDepName());
            jToolBar.add(jButton);
            this.controller.getSettings().addAction(jaWEType.getTypeId(), jaWEAction);
        }
    }

    protected void addSetActivityModeComponent(JaWETypes jaWETypes, JToolBar jToolBar) {
        List list = jaWETypes.getTypes(Activity.class, null);
        JToolBar jToolBar2 = new JToolBar();
        jToolBar2.setFloatable(false);
        JToolBar jToolBar3 = new JToolBar();
        for (int i = 0; i < list.size(); ++i) {
            JaWEType jaWEType = (JaWEType)list.get(i);
            JaWEAction jaWEAction = new JaWEAction();
            jaWEAction.setAction(new SetActivityMode(this.controller, jaWEType.getTypeId()));
            jaWEAction.setIcon(jaWEType.getIcon());
            jaWEAction.setLangDepName(jaWEType.getDisplayName());
            JButton jButton = BarFactory.createToolbarButton(jaWEAction, this.controller);
            jButton.setBorderPainted(false);
            jButton.setToolTipText(jaWEAction.getLangDepName());
            if (this.controller.getGraphSettings().hasAdditionalToolbar() && this.hasAdditionalActivities(jaWEType)) {
                jToolBar3.add(jButton);
                jToolBar3.setOrientation(0);
                jToolBar2.add(jToolBar3);
                this.toolbars.add((Component)jToolBar2, "South");
            } else {
                jToolBar.add(jButton);
            }
            this.controller.getSettings().addAction(jaWEType.getTypeId(), jaWEAction);
        }
    }

    protected boolean hasAdditionalActivities(JaWEType jaWEType) {
        return !jaWEType.getTypeId().equals("ACTIVITY_NO") && !jaWEType.getTypeId().equals("ACTIVITY_TASK_APPLICATION") && !jaWEType.getTypeId().equals("ACTIVITY_TASK_SCRIPT") && !jaWEType.getTypeId().equals("ACTIVITY_BLOCK") && !jaWEType.getTypeId().equals("ACTIVITY_ROUTE_EXCLUSIVE") && !jaWEType.getTypeId().equals("ACTIVITY_ROUTE_PARALLEL") && !jaWEType.getTypeId().equals("ACTIVITY_SUBFLOW");
    }

    protected JScrollPane createWorkingComponent() {
        JScrollPane jScrollPane = new JScrollPane();
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.setScrollMode(1);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(40);
        return jScrollPane;
    }

    public void graphSelected(Graph graph) {
        this.graphScrollPane.setViewportView((Component)((Object)graph));
    }

    public void enableDisableButtons() {
        if (this.controller.getSelectedGraph() != null) {
            if (XMLUtil.getPackage((XMLElement)this.controller.getSelectedGraph().getXPDLObject()) == JaWEManager.getInstance().getJaWEController().getMainPackage()) {
                if (this.controller.getChoices(this.showParticipantChoiceButton).size() != 0) {
                    Object[] objectArray = this.controller.getSelectedGraph().getSelectionCells();
                    if (objectArray != null && objectArray.length > 0 && ((WorkflowElement)objectArray[0]).getPropertyObject() instanceof Lane) {
                        Lane lane = (Lane)((WorkflowElement)objectArray[0]).getPropertyObject();
                        GraphSwimlaneInterface graphSwimlaneInterface = this.controller.getSelectedGraph().getGraphManager().getGraphParticipant(lane);
                        if (graphSwimlaneInterface != null && (graphSwimlaneInterface.howManyChildActivitiesOrArtifacts() > 0 || ((Lane)graphSwimlaneInterface.getPropertyObject()).getPerformers().size() == 0)) {
                            this.showParticipantChoiceButton.setEnabled(false);
                            return;
                        }
                    }
                    this.showParticipantChoiceButton.setEnabled(true);
                } else {
                    this.showParticipantChoiceButton.setEnabled(false);
                }
            } else {
                this.showParticipantChoiceButton.setEnabled(false);
            }
        } else {
            this.showParticipantChoiceButton.setEnabled(false);
        }
        if (this.controller.getChoices(this.asChoiceButton).size() != 0) {
            this.asChoiceButton.setEnabled(true);
        } else {
            this.asChoiceButton.setEnabled(false);
        }
    }
}

