/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.graph;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.base.controller.JaWEController;
import org.enhydra.jawe.components.graph.FreeTextExpressionParticipant;
import org.enhydra.jawe.components.graph.Graph;
import org.enhydra.jawe.components.graph.GraphActivityInterface;
import org.enhydra.jawe.components.graph.GraphArtifactInterface;
import org.enhydra.jawe.components.graph.GraphCommonInterface;
import org.enhydra.jawe.components.graph.GraphController;
import org.enhydra.jawe.components.graph.GraphParticipantComparator;
import org.enhydra.jawe.components.graph.GraphSwimlaneInterface;
import org.enhydra.jawe.components.graph.GraphTransitionInterface;
import org.enhydra.jawe.components.graph.GraphTransitionViewInterface;
import org.enhydra.jawe.components.graph.GraphUtilities;
import org.enhydra.jawe.components.graph.JaWEGraphModel;
import org.enhydra.jawe.components.graph.JaWEParentMap;
import org.enhydra.jawe.components.graph.LaneInfo;
import org.enhydra.jawe.components.graph.NoRouting;
import org.enhydra.jawe.components.graph.WorkflowElement;
import org.enhydra.jxpdl.XMLCollectionElement;
import org.enhydra.jxpdl.XMLComplexElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLUtil;
import org.enhydra.jxpdl.elements.Activities;
import org.enhydra.jxpdl.elements.Activity;
import org.enhydra.jxpdl.elements.ActivitySet;
import org.enhydra.jxpdl.elements.Artifact;
import org.enhydra.jxpdl.elements.Association;
import org.enhydra.jxpdl.elements.Lane;
import org.enhydra.jxpdl.elements.NestedLane;
import org.enhydra.jxpdl.elements.NestedLanes;
import org.enhydra.jxpdl.elements.Participant;
import org.enhydra.jxpdl.elements.Pool;
import org.enhydra.jxpdl.elements.Transition;
import org.enhydra.jxpdl.elements.Transitions;
import org.enhydra.jxpdl.elements.WorkflowProcess;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.ParentMap;
import org.jgraph.graph.Port;

public class GraphManager
implements Serializable {
    private transient Graph graph;
    private int horizontalOffset = 0;
    private int verticalOffset = 0;
    private static int minLaneWidth;
    private static int minLaneHeight;
    private static int defLaneNameWidth;
    private static int defActivityWidth;
    private static int defActivityHeight;
    private boolean creatingGraph = false;
    protected boolean pLoaded = false;

    public void init() {
        if (!this.pLoaded) {
            defActivityWidth = GraphUtilities.getGraphController().getGraphSettings().getActivityWidth();
            defActivityHeight = GraphUtilities.getGraphController().getGraphSettings().getActivityHeight();
            minLaneWidth = GraphUtilities.getGraphController().getGraphSettings().getMinLaneWidth();
            minLaneHeight = GraphUtilities.getGraphController().getGraphSettings().getMinLaneHeight();
            defLaneNameWidth = GraphUtilities.getGraphController().getGraphSettings().getLaneNameWidth();
            this.pLoaded = true;
        }
    }

    public GraphManager(Graph graph) {
        this.graph = graph;
        this.init();
    }

    public Graph getGraph() {
        return this.graph;
    }

    public GraphController getGraphController() {
        return this.graph.getGraphController();
    }

    public JaWEGraphModel graphModel() {
        return (JaWEGraphModel)this.graph.getModel();
    }

    public void createWorkflowGraph(XMLCollectionElement xMLCollectionElement) {
        this.creatingGraph = true;
        Pool pool = JaWEManager.getInstance().getXPDLUtils().getPoolForProcessOrActivitySet(xMLCollectionElement);
        this.insertParticipantAndArrangeParticipants(pool, null);
        List list = GraphUtilities.gatherLanes(xMLCollectionElement);
        for (LaneInfo laneInfo : list) {
            this.insertParticipantAndArrangeParticipants(laneInfo.getLane(), null);
            for (XMLCollectionElement xMLCollectionElement2 : laneInfo.getActivitiesAndArtifacts()) {
                this.insertActivityOrArtifact(xMLCollectionElement2);
            }
        }
        for (LaneInfo laneInfo : ((Transitions)xMLCollectionElement.get("Transitions")).toElements()) {
            this.insertTransitionOrAssociation((XMLCollectionElement)laneInfo);
        }
        for (LaneInfo laneInfo : XMLUtil.getPackage((XMLElement)xMLCollectionElement).getAssociations().toElements()) {
            this.insertTransitionOrAssociation((XMLCollectionElement)laneInfo);
        }
        this.creatingGraph = false;
        try {
            this.graph.setPreferredSize(this.getGraphsPreferredSize());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public XMLCollectionElement getXPDLOwner() {
        return this.graph.getXPDLObject();
    }

    private WorkflowProcess getWorkflowProcess() {
        return this.graph.getWorkflowProcess();
    }

    public List getDisplayedParticipants() {
        ArrayList<Participant> arrayList = new ArrayList<Participant>();
        List list = JaWEGraphModel.getAllParticipantsInModel((GraphModel)this.graphModel());
        if (list != null) {
            for (GraphSwimlaneInterface graphSwimlaneInterface : list) {
                XMLComplexElement xMLComplexElement = graphSwimlaneInterface.getPropertyObject();
                if (xMLComplexElement instanceof Pool) continue;
                Participant participant = GraphUtilities.getParticipantForLane((Lane)xMLComplexElement, FreeTextExpressionParticipant.getInstance());
                arrayList.add(participant);
            }
        }
        return arrayList;
    }

    public boolean doesRootParticipantExist() {
        Set set = JaWEGraphModel.getRootParticipants((GraphModel)this.graphModel());
        return set != null && set.size() > 0;
    }

    public boolean hasLane() {
        Set set = JaWEGraphModel.getRootParticipants((GraphModel)this.graphModel());
        if (set != null && set.size() > 0) {
            GraphSwimlaneInterface graphSwimlaneInterface = (GraphSwimlaneInterface)set.toArray()[0];
            return graphSwimlaneInterface.hasAnySwimlane();
        }
        return false;
    }

    public String getParticipantId(Point point) {
        GraphSwimlaneInterface graphSwimlaneInterface = this.findParentParticipantForLocation(point, null, null);
        if (graphSwimlaneInterface != null) {
            return graphSwimlaneInterface.getPropertyObject().get("Id").toValue();
        }
        return "";
    }

    public GraphCommonInterface insertActivityOrArtifact(XMLCollectionElement xMLCollectionElement) {
        if (xMLCollectionElement instanceof Artifact && !this.getGraph().shouldShowArtifacts()) {
            return null;
        }
        HashMap hashMap = new HashMap();
        GraphSwimlaneInterface graphSwimlaneInterface = this.getGraphParticipant(GraphUtilities.getLaneForActivityOrArtifact(xMLCollectionElement, this.graph.getXPDLObject()));
        if (graphSwimlaneInterface == null) {
            return null;
        }
        Point point = this.getCBounds(graphSwimlaneInterface, null).getBounds().getLocation();
        GraphCommonInterface graphCommonInterface = null;
        graphCommonInterface = xMLCollectionElement instanceof Activity ? this.getGraphController().getGraphObjectFactory().createActivity(hashMap, (Activity)xMLCollectionElement, point) : this.getGraphController().getGraphObjectFactory().createArtifact(hashMap, (Artifact)xMLCollectionElement, point);
        this.updateModelAndArrangeParticipants(new Object[]{graphCommonInterface}, null, null, hashMap, this.getGraphController().getSettings().getLanguageDependentString("MessageInsertingGenericActivity"), null, true);
        return graphCommonInterface;
    }

    public void removeActivityOrArtifact(XMLCollectionElement xMLCollectionElement) {
        Object[] objectArray;
        if (xMLCollectionElement instanceof Artifact && !this.getGraph().shouldShowArtifacts()) {
            return;
        }
        Set set = null;
        GraphCommonInterface graphCommonInterface = null;
        graphCommonInterface = xMLCollectionElement instanceof Activity ? this.getGraphActivity((Activity)xMLCollectionElement) : this.getGraphArtifact((Artifact)xMLCollectionElement);
        if (graphCommonInterface == null) {
            return;
        }
        set = graphCommonInterface.getPort().getEdges();
        Iterator iterator = set.iterator();
        HashSet<Object> hashSet = new HashSet<Object>();
        while (iterator.hasNext()) {
            objectArray = (Object[])iterator.next();
            hashSet.add(objectArray);
        }
        hashSet.add(graphCommonInterface);
        objectArray = hashSet.toArray();
        this.graphModel().removeAndEdit(objectArray, null);
        HashMap hashMap = new HashMap();
        JaWEParentMap jaWEParentMap = new JaWEParentMap();
        this.arrangeParticipants(hashMap, jaWEParentMap);
        this.updateModelAndArrangeParticipants(new Object[0], hashMap, jaWEParentMap, new HashMap(), "an", null, true);
    }

    public void arrangeActivityOrArtifactPosition(XMLCollectionElement xMLCollectionElement) {
        GraphCommonInterface graphCommonInterface = xMLCollectionElement instanceof Activity ? this.getGraphActivity((Activity)xMLCollectionElement) : this.getGraphArtifact((Artifact)xMLCollectionElement);
        GraphSwimlaneInterface graphSwimlaneInterface = this.getGraphParticipant(GraphUtilities.getLaneForActivityOrArtifact(xMLCollectionElement, this.getXPDLOwner()));
        GraphSwimlaneInterface graphSwimlaneInterface2 = (GraphSwimlaneInterface)((Object)graphCommonInterface.getParent());
        JaWEParentMap jaWEParentMap = new JaWEParentMap();
        if (!graphSwimlaneInterface.equals(graphSwimlaneInterface2)) {
            jaWEParentMap.addEntry(graphCommonInterface, graphSwimlaneInterface);
        }
        HashMap hashMap = new HashMap();
        Point point = this.getRealPosition(graphCommonInterface, graphSwimlaneInterface);
        Rectangle rectangle = this.getCBounds(graphCommonInterface, hashMap);
        this.changeBounds(graphCommonInterface, hashMap, new Rectangle(point, new Dimension(rectangle.width, rectangle.height)));
        if (!graphSwimlaneInterface.equals(graphSwimlaneInterface2)) {
            if (this.isGraphRotated()) {
                this.arrangeParticipantHorizontally(graphSwimlaneInterface, hashMap, jaWEParentMap);
                if (graphSwimlaneInterface2 != null) {
                    this.arrangeParticipantHorizontally(graphSwimlaneInterface2, hashMap, jaWEParentMap);
                }
            } else {
                this.arrangeParticipantVertically(graphSwimlaneInterface, hashMap, jaWEParentMap);
                if (graphSwimlaneInterface2 != null) {
                    this.arrangeParticipantVertically(graphSwimlaneInterface2, hashMap, jaWEParentMap);
                }
            }
        }
        this.updateModelAndArrangeParticipants(null, hashMap, jaWEParentMap, null, this.getGraphController().getSettings().getLanguageDependentString("MessageMovingObjects"), null, true);
    }

    public GraphTransitionInterface insertTransitionOrAssociation(XMLCollectionElement xMLCollectionElement) {
        HashMap hashMap = new HashMap();
        List list = GraphUtilities.getBreakpoints(xMLCollectionElement);
        GraphCommonInterface graphCommonInterface = null;
        GraphCommonInterface graphCommonInterface2 = null;
        if (xMLCollectionElement instanceof Transition) {
            graphCommonInterface = this.getGraphActivity(((Transition)xMLCollectionElement).getFrom());
            graphCommonInterface2 = this.getGraphActivity(((Transition)xMLCollectionElement).getTo());
        } else {
            graphCommonInterface = this.getGraphActivity(((Association)xMLCollectionElement).getSource());
            if (graphCommonInterface == null) {
                graphCommonInterface = this.getGraphArtifact(((Association)xMLCollectionElement).getSource());
            }
            if ((graphCommonInterface2 = this.getGraphActivity(((Association)xMLCollectionElement).getTarget())) == null) {
                graphCommonInterface2 = this.getGraphArtifact(((Association)xMLCollectionElement).getTarget());
            }
        }
        if (graphCommonInterface == null || graphCommonInterface2 == null) {
            return null;
        }
        Point point = this.getCenter(graphCommonInterface);
        Point point2 = this.getCenter(graphCommonInterface2);
        Point point3 = (Point)this.graph.fromScreen(new Point(point));
        Point point4 = (Point)this.graph.fromScreen(new Point(point2));
        ArrayList<Point> arrayList = new ArrayList<Point>();
        arrayList.add(point3);
        arrayList.addAll(list);
        arrayList.add(point4);
        GraphTransitionInterface graphTransitionInterface = this.getGraphController().getGraphObjectFactory().createTransition(arrayList, hashMap, xMLCollectionElement);
        Object[] objectArray = new Object[]{graphTransitionInterface};
        ConnectionSet connectionSet = new ConnectionSet();
        connectionSet.connect((Object)graphTransitionInterface, (Object)graphCommonInterface.getPort(), (Object)graphCommonInterface2.getPort());
        this.graphModel().insertAndEdit(objectArray, hashMap, connectionSet, null, null);
        return graphTransitionInterface;
    }

    public void removeTransitionOrAssociation(XMLCollectionElement xMLCollectionElement) {
        GraphTransitionInterface graphTransitionInterface = this.getGraphTransition(xMLCollectionElement);
        this.removeTransition(graphTransitionInterface);
    }

    public void updateTransitionOrAssociation(XMLCollectionElement xMLCollectionElement) {
        GraphTransitionInterface graphTransitionInterface = this.getGraphTransition(xMLCollectionElement);
        if (graphTransitionInterface == null) {
            graphTransitionInterface = this.insertTransitionOrAssociation(xMLCollectionElement);
        } else {
            GraphCommonInterface graphCommonInterface = graphTransitionInterface.getSourceActivityOrArtifact();
            GraphCommonInterface graphCommonInterface2 = graphTransitionInterface.getTargetActivityOrArtifact();
            if (graphCommonInterface == null || graphCommonInterface2 == null) {
                this.removeTransition(graphTransitionInterface);
                graphTransitionInterface = this.insertTransitionOrAssociation(xMLCollectionElement);
                return;
            }
            String string = null;
            String string2 = null;
            if (xMLCollectionElement instanceof Transition) {
                string = ((Transition)xMLCollectionElement).getFrom();
                string2 = ((Transition)xMLCollectionElement).getTo();
            } else {
                string = ((Association)xMLCollectionElement).getSource();
                string2 = ((Association)xMLCollectionElement).getTarget();
            }
            if (!graphCommonInterface.getPropertyObject().get("Id").toValue().equals(string) || !graphCommonInterface2.getPropertyObject().get("Id").toValue().equals(string2)) {
                this.removeTransition(graphTransitionInterface);
                graphTransitionInterface = this.insertTransitionOrAssociation(xMLCollectionElement);
                return;
            }
            HashMap hashMap = new HashMap();
            this.updateBreakPoints(graphTransitionInterface, hashMap);
            this.updateStyle(graphTransitionInterface, hashMap);
            ((JaWEGraphModel)this.graph.getModel()).insertAndEdit(null, hashMap, null, null, null);
        }
    }

    public void updateBreakPoints(GraphTransitionInterface graphTransitionInterface, Map map) {
        List list = GraphUtilities.getBreakpoints((XMLCollectionElement)graphTransitionInterface.getUserObject());
        GraphTransitionViewInterface graphTransitionViewInterface = (GraphTransitionViewInterface)this.getView(graphTransitionInterface);
        if (graphTransitionViewInterface == null) {
            return;
        }
        AttributeMap attributeMap = (AttributeMap)map.get(graphTransitionInterface);
        if (attributeMap == null) {
            attributeMap = new AttributeMap((Map)graphTransitionInterface.getAttributes());
            map.put(graphTransitionInterface, attributeMap);
        }
        int n = graphTransitionViewInterface.getPointCount();
        Point2D point2D = graphTransitionViewInterface.getPoint(0);
        Point2D point2D2 = graphTransitionViewInterface.getPoint(n - 1);
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
        arrayList.add(point2D);
        arrayList.addAll(list);
        arrayList.add(point2D2);
        GraphConstants.setPoints((Map)attributeMap, arrayList);
    }

    public List addOrRemoveBreakPoint(GraphTransitionInterface graphTransitionInterface, Point point, boolean bl) {
        CellView cellView = this.graph.getGraphLayoutCache().getMapping((Object)graphTransitionInterface, false);
        GraphTransitionViewInterface graphTransitionViewInterface = (GraphTransitionViewInterface)cellView;
        if (bl) {
            graphTransitionViewInterface.addPoint(this.graph, point);
        } else {
            graphTransitionViewInterface.removePoint(this.graph, point);
        }
        this.graph.refresh();
        int n = graphTransitionViewInterface.getPointCount();
        ArrayList<Point> arrayList = new ArrayList<Point>();
        for (int i = 1; i < n - 1; ++i) {
            arrayList.add(new Point((int)graphTransitionViewInterface.getPoint(i).getX(), (int)graphTransitionViewInterface.getPoint(i).getY()));
        }
        return arrayList;
    }

    public void updateStyle(GraphTransitionInterface graphTransitionInterface) {
        HashMap hashMap = new HashMap();
        this.updateStyle(graphTransitionInterface, hashMap);
        ((JaWEGraphModel)this.graph.getModel()).insertAndEdit(null, hashMap, null, null, null);
    }

    protected void updateStyle(GraphTransitionInterface graphTransitionInterface, Map map) {
        String string = GraphUtilities.getStyle((XMLCollectionElement)graphTransitionInterface.getUserObject());
        AttributeMap attributeMap = (AttributeMap)map.get(graphTransitionInterface);
        if (attributeMap == null) {
            attributeMap = new AttributeMap((Map)graphTransitionInterface.getAttributes());
            map.put(graphTransitionInterface, attributeMap);
        }
        if (string.equals("NO_ROUTING_BEZIER")) {
            GraphConstants.setRouting((Map)attributeMap, (Edge.Routing)new NoRouting());
            GraphConstants.setLineStyle((Map)attributeMap, (int)12);
        } else if (string.equals("NO_ROUTING_SPLINE")) {
            GraphConstants.setRouting((Map)attributeMap, (Edge.Routing)new NoRouting());
            GraphConstants.setLineStyle((Map)attributeMap, (int)13);
        } else if (string.equals("SIMPLE_ROUTING_BEZIER")) {
            GraphConstants.setRouting((Map)attributeMap, (Edge.Routing)GraphConstants.ROUTING_SIMPLE);
            GraphConstants.setLineStyle((Map)attributeMap, (int)12);
        } else if (string.equals("SIMPLE_ROUTING_ORTHOGONAL")) {
            GraphConstants.setRouting((Map)attributeMap, (Edge.Routing)GraphConstants.ROUTING_SIMPLE);
            GraphConstants.setLineStyle((Map)attributeMap, (int)11);
        } else if (string.equals("SIMPLE_ROUTING_SPLINE")) {
            GraphConstants.setRouting((Map)attributeMap, (Edge.Routing)GraphConstants.ROUTING_SIMPLE);
            GraphConstants.setLineStyle((Map)attributeMap, (int)13);
        } else {
            GraphConstants.setRouting((Map)attributeMap, (Edge.Routing)new NoRouting());
            GraphConstants.setLineStyle((Map)attributeMap, (int)11);
        }
    }

    protected void removeTransition(GraphTransitionInterface graphTransitionInterface) {
        if (graphTransitionInterface == null) {
            return;
        }
        Object[] objectArray = new Object[]{graphTransitionInterface};
        this.graphModel().removeAndEdit(objectArray, null);
        HashMap hashMap = new HashMap();
        JaWEParentMap jaWEParentMap = new JaWEParentMap();
        this.arrangeParticipants(hashMap, jaWEParentMap);
        this.updateModelAndArrangeParticipants(new Object[0], hashMap, jaWEParentMap, new HashMap(), "an", null, true);
    }

    public GraphActivityInterface insertStartOrEndEvent(Activity activity, String string) {
        HashMap hashMap = new HashMap();
        GraphActivityInterface graphActivityInterface = (GraphActivityInterface)this.insertActivityOrArtifact((XMLCollectionElement)activity);
        this.connectStartOrEndEvent(graphActivityInterface, string);
        return graphActivityInterface;
    }

    public GraphTransitionInterface connectStartOrEndEvent(GraphActivityInterface graphActivityInterface, String string) {
        if (string == null) {
            return null;
        }
        GraphActivityInterface graphActivityInterface2 = graphActivityInterface;
        Activity activity = (Activity)graphActivityInterface.getPropertyObject();
        GraphActivityInterface graphActivityInterface3 = this.getGraphActivity(string);
        if (graphActivityInterface2 == null || graphActivityInterface3 == null) {
            return null;
        }
        if (activity.getActivityType() != 6) {
            graphActivityInterface2 = graphActivityInterface3;
            graphActivityInterface3 = graphActivityInterface;
        }
        Transitions transitions = (Transitions)this.getXPDLOwner().get("Transitions");
        Transition transition = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject(transitions, "", true);
        transition.setFrom(graphActivityInterface2.getPropertyObject().get("Id").toValue());
        transition.setTo(graphActivityInterface3.getPropertyObject().get("Id").toValue());
        return this.insertTransitionOrAssociation((XMLCollectionElement)transition);
    }

    public GraphSwimlaneInterface insertParticipantAndArrangeParticipants(Object object, Point point) {
        Object object2;
        GraphSwimlaneInterface graphSwimlaneInterface = this.getParticipantForLocation(point);
        if (object instanceof Lane) {
            object2 = GraphUtilities.getParentLane((Lane)object);
            if (object2 != null) {
                graphSwimlaneInterface = this.getGraphParticipant(object2);
            } else if (graphSwimlaneInterface == null) {
                graphSwimlaneInterface = this.getGraphParticipant(JaWEManager.getInstance().getXPDLUtils().getPoolForProcessOrActivitySet(this.getXPDLOwner()));
            }
        }
        object2 = new HashMap();
        JaWEParentMap jaWEParentMap = new JaWEParentMap();
        HashMap hashMap = null;
        Rectangle rectangle = null;
        if (graphSwimlaneInterface == null) {
            rectangle = this.isGraphRotated() ? new Rectangle(this.getNewRootParXPos(null, null), this.verticalOffset, minLaneHeight, this.getRootParticipantHeight(null, null)) : new Rectangle(this.horizontalOffset, this.getNewRootParYPos(null, null), this.getRootParticipantWidth(null, null), minLaneHeight);
        } else {
            int n = graphSwimlaneInterface.howManyChildSwimlanes();
            int n2 = graphSwimlaneInterface.getLevel();
            if (!this.isGraphRotated()) {
                List list;
                boolean bl = false;
                int n3 = 0;
                Rectangle rectangle2 = this.getCBounds(graphSwimlaneInterface, null);
                int n4 = (1 + n2) * defLaneNameWidth + this.horizontalOffset;
                int n5 = (int)rectangle2.getY();
                int n6 = minLaneHeight;
                if (n > 0) {
                    n5 += (int)rectangle2.getHeight();
                } else {
                    n6 = (int)rectangle2.getHeight();
                }
                int n7 = this.getRootParticipantWidth(null, null) + this.horizontalOffset - n4;
                if (n7 < minLaneWidth) {
                    bl = true;
                    n3 = minLaneWidth - n7;
                    n7 = minLaneWidth;
                }
                rectangle = new Rectangle(n4, n5, n7, n6);
                hashMap = new HashMap();
                if (bl && (list = JaWEGraphModel.getAllParticipantsInModel((GraphModel)this.graphModel())) != null) {
                    this.resize(list.toArray(), hashMap, n3, 0);
                }
                if (n > 0) {
                    this.translateVertically(hashMap, null, n5, minLaneHeight);
                    this.resize(graphSwimlaneInterface.getPath(), hashMap, 0, minLaneHeight);
                }
            } else {
                List list;
                boolean bl = false;
                int n8 = 0;
                Rectangle rectangle3 = this.getCBounds(graphSwimlaneInterface, null);
                int n9 = (1 + n2) * defLaneNameWidth + this.verticalOffset;
                int n10 = (int)rectangle3.getX();
                int n11 = minLaneHeight;
                if (n > 0) {
                    n10 += (int)rectangle3.getWidth();
                } else {
                    n11 = (int)rectangle3.getWidth();
                }
                int n12 = this.getRootParticipantHeight(null, null) + this.verticalOffset - n9;
                if (n12 < minLaneWidth) {
                    bl = true;
                    n8 = minLaneWidth - n12;
                    n12 = minLaneWidth;
                }
                rectangle = new Rectangle(n10, n9, n11, n12);
                hashMap = new HashMap();
                if (bl && (list = JaWEGraphModel.getAllParticipantsInModel((GraphModel)this.graphModel())) != null) {
                    this.resize(list.toArray(), hashMap, 0, n8);
                }
                if (n > 0) {
                    this.translateHorizontally(hashMap, null, n10, minLaneHeight);
                    this.resize(graphSwimlaneInterface.getPath(), hashMap, minLaneHeight, 0);
                }
            }
        }
        GraphSwimlaneInterface graphSwimlaneInterface2 = this.getGraphController().getGraphObjectFactory().createParticipant(rectangle, (Map)object2, object);
        if (graphSwimlaneInterface != null) {
            jaWEParentMap.addEntry(graphSwimlaneInterface2, graphSwimlaneInterface);
            hashMap.putAll(object2);
        } else {
            hashMap = new HashMap(object2);
        }
        Object[] objectArray = new Object[]{graphSwimlaneInterface2};
        this.graphModel().insertAndEdit(objectArray, hashMap, null, jaWEParentMap, null);
        if (!this.creatingGraph) {
            try {
                this.graph.setPreferredSize(this.getGraphsPreferredSize());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return graphSwimlaneInterface2;
    }

    public GraphSwimlaneInterface getParticipantForLocation(Point point) {
        GraphSwimlaneInterface graphSwimlaneInterface = null;
        if (point != null) {
            Object object = this.graph.getFirstCellForLocation(point.x, point.y);
            graphSwimlaneInterface = object == null || !(object instanceof GraphSwimlaneInterface) ? (this.isGraphRotated() ? this.getLeafParticipantForXPos(point.x, null, null) : this.getLeafParticipantForYPos(point.y, null, null)) : (GraphSwimlaneInterface)object;
        }
        return graphSwimlaneInterface;
    }

    public void removeCellsAndArrangeParticipants(Object[] objectArray) {
        HashSet<TreeNode> hashSet = new HashSet<TreeNode>();
        HashMap hashMap = new HashMap();
        JaWEParentMap jaWEParentMap = new JaWEParentMap();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        if (objectArray != null && objectArray.length > 0) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] instanceof GraphSwimlaneInterface) {
                    object4 = (GraphSwimlaneInterface)objectArray[i];
                    object3 = this.getCBounds(object4, hashMap);
                    int n = ((RectangularShape)object3).getBounds().y + ((RectangularShape)object3).getBounds().height - 1;
                    int n2 = ((RectangularShape)object3).getBounds().x + ((RectangularShape)object3).getBounds().width - 1;
                    object2 = (GraphSwimlaneInterface)((Object)object4.getParent());
                    if (object2 != null) {
                        int n3;
                        int n4;
                        if (object2.getChildCount() <= 1 && this.getParticipantHeight(object2, hashMap) <= minLaneHeight) continue;
                        object = object2.getPath();
                        if (!this.isGraphRotated()) {
                            n4 = ((RectangularShape)object3).getBounds().height;
                            n3 = this.getParticipantHeight(object2, hashMap);
                            if (n3 - n4 < minLaneHeight) {
                                n4 = n3 - minLaneHeight;
                            }
                            this.resize((Object[])object, hashMap, 0, -n4);
                            this.translateVertically(hashMap, null, n, -n4);
                            continue;
                        }
                        n4 = ((RectangularShape)object3).getBounds().width;
                        n3 = this.getParticipantWidth(object2, hashMap);
                        if (n3 - n4 < minLaneHeight) {
                            n4 = n3 - minLaneHeight;
                        }
                        this.resize((Object[])object, hashMap, -n4, 0);
                        this.translateHorizontally(hashMap, null, n2, -n4);
                        continue;
                    }
                    if (!this.isGraphRotated()) {
                        this.translateVertically(hashMap, null, n, -((RectangularShape)object3).getBounds().height);
                        continue;
                    }
                    this.translateHorizontally(hashMap, null, n2, -((RectangularShape)object3).getBounds().width);
                    continue;
                }
                if (!(objectArray[i] instanceof Port)) continue;
                hashSet2.add(objectArray[i]);
            }
            HashSet<Object> hashSet3 = new HashSet<Object>(Arrays.asList(objectArray));
            hashSet3.removeAll(hashSet2);
            if (hashSet3.size() == 0) {
                return;
            }
            objectArray = hashSet3.toArray();
            object4 = JaWEGraphModel.getDescendants((GraphModel)this.graphModel(), (Object[])objectArray);
            object3 = JaWEGraphModel.getEdges((GraphModel)this.graphModel(), (Object[])object4.toArray());
            object4.addAll(object3);
            HashSet<Object[]> hashSet4 = new HashSet<Object[]>();
            HashSet<Object[]> hashSet5 = new HashSet<Object[]>();
            object2 = object4.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (object instanceof Edge) {
                    hashSet4.add((Object[])object);
                    continue;
                }
                if (object instanceof Port) continue;
                hashSet5.add((Object[])object);
            }
            objectArray = hashSet5.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                TreeNode treeNode = ((DefaultMutableTreeNode)objectArray[i]).getParent();
                if (treeNode != null && treeNode instanceof GraphSwimlaneInterface && objectArray[i] instanceof GraphActivityInterface) {
                    hashSet.add(treeNode);
                }
                jaWEParentMap.addEntry(objectArray[i], null);
            }
            if (!this.isGraphRotated()) {
                this.resizeAllParticipantsHorizontally(hashMap, jaWEParentMap);
                this.arrangeParticipantsVertically(hashSet.toArray(), hashMap, jaWEParentMap);
            } else {
                this.resizeAllParticipantsVertically(hashMap, jaWEParentMap);
                this.arrangeParticipantsHorizontally(hashSet.toArray(), hashMap, jaWEParentMap);
            }
            this.graphModel().removeAndEdit(object4.toArray(), hashMap);
        }
        try {
            this.graph.setPreferredSize(this.getGraphsPreferredSize());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getHorizontalOffset() {
        return this.horizontalOffset;
    }

    public Point getOffset(GraphCommonInterface graphCommonInterface, Map map) {
        GraphSwimlaneInterface graphSwimlaneInterface;
        if (graphCommonInterface != null && (graphSwimlaneInterface = (GraphSwimlaneInterface)((Object)graphCommonInterface.getParent())) != null) {
            Rectangle rectangle = this.getCBounds(graphSwimlaneInterface, map);
            Rectangle rectangle2 = this.getCBounds(graphCommonInterface, map);
            int n = ((RectangularShape)rectangle2).getBounds().y - ((RectangularShape)rectangle).getBounds().y;
            int n2 = ((RectangularShape)rectangle2).getBounds().x - ((RectangularShape)rectangle).getBounds().x;
            return new Point(n2, n);
        }
        return new Point(0, 0);
    }

    public Point getOffset(Point point) {
        GraphSwimlaneInterface graphSwimlaneInterface;
        if (point != null && (graphSwimlaneInterface = this.findParentParticipantForLocation(point, null, null)) != null) {
            Rectangle rectangle = this.getCBounds(graphSwimlaneInterface, new HashMap());
            int n = point.y - ((RectangularShape)rectangle).getBounds().y;
            int n2 = point.x - ((RectangularShape)rectangle).getBounds().x;
            return new Point(n2, n);
        }
        return new Point(0, 0);
    }

    public Point getRealPosition(GraphCommonInterface graphCommonInterface, GraphSwimlaneInterface graphSwimlaneInterface) {
        if (graphCommonInterface != null && graphSwimlaneInterface != null) {
            CellView cellView = this.getView(graphSwimlaneInterface);
            Rectangle2D rectangle2D = cellView.getBounds();
            Point point = graphCommonInterface.getOffset();
            int n = point.y + rectangle2D.getBounds().y;
            int n2 = point.x + rectangle2D.getBounds().x;
            Point point2 = new Point(n2, n);
            return point2;
        }
        return new Point(0, 0);
    }

    public void updateModelAndArrangeParticipants(Object[] objectArray, Map hashMap, ParentMap parentMap, Map map, String string, ConnectionSet connectionSet, boolean bl) {
        if (hashMap == null && map == null) {
            return;
        }
        if (hashMap == null) {
            hashMap = new HashMap(map);
        }
        if (parentMap == null) {
            parentMap = new JaWEParentMap();
        }
        if (bl) {
            this.arrangeParticipants(hashMap, parentMap);
        } else {
            this.arrangeParticipantRelationsOnly(hashMap, parentMap);
        }
        if (objectArray == null || ((JaWEParentMap)parentMap).entryCount() != objectArray.length) {
            // empty if block
        }
        this.graphModel().insertAndEdit(objectArray, hashMap, connectionSet, parentMap, null);
        Dimension dimension = null;
        if (!this.creatingGraph) {
            try {
                dimension = this.getGraphsPreferredSize();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this.creatingGraph && dimension != null) {
            try {
                this.graph.setPreferredSize(dimension);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void arrangeParticipants(Map map, ParentMap parentMap) {
        HashSet hashSet = new HashSet();
        Object[] objectArray = map.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof GraphCommonInterface)) continue;
            Set set = this.updateParent((GraphCommonInterface)object, map, parentMap);
            hashSet.addAll(set);
        }
        if (this.isGraphRotated()) {
            this.arrangeParticipantsHorizontally(hashSet.toArray(), map, parentMap);
            this.resizeAllParticipantsVertically(map, parentMap);
        } else {
            this.arrangeParticipantsVertically(hashSet.toArray(), map, parentMap);
            this.resizeAllParticipantsHorizontally(map, parentMap);
        }
    }

    protected void arrangeParticipantRelationsOnly(Map map, ParentMap parentMap) {
        HashSet hashSet = new HashSet();
        Object[] objectArray = map.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof GraphActivityInterface) && !(object instanceof GraphArtifactInterface)) continue;
            Set set = this.updateParent((GraphActivityInterface)object, map, parentMap);
            hashSet.addAll(set);
        }
    }

    protected Set updateParent(GraphCommonInterface graphCommonInterface, Map map, ParentMap parentMap) {
        HashSet<GraphSwimlaneInterface> hashSet = new HashSet<GraphSwimlaneInterface>();
        GraphSwimlaneInterface graphSwimlaneInterface = (GraphSwimlaneInterface)((Object)graphCommonInterface.getParent());
        if (graphSwimlaneInterface != null) {
            hashSet.add(graphSwimlaneInterface);
        }
        GraphSwimlaneInterface graphSwimlaneInterface2 = null;
        Rectangle rectangle = this.getCBounds(graphCommonInterface, map);
        Point point = ((RectangularShape)rectangle).getBounds().getLocation();
        Point point2 = new Point(point);
        graphSwimlaneInterface2 = this.findParentParticipantForLocation(point2, map, parentMap);
        if (!point2.equals(point)) {
            Rectangle rectangle2 = new Rectangle(((RectangularShape)rectangle).getBounds());
            rectangle2.setLocation(point2);
            this.changeBounds(graphCommonInterface, map, rectangle2);
        }
        if (graphSwimlaneInterface2 != null) {
            hashSet.add(graphSwimlaneInterface2);
            if (!graphSwimlaneInterface2.equals(graphSwimlaneInterface)) {
                parentMap.addEntry((Object)graphCommonInterface, (Object)graphSwimlaneInterface2);
            }
        }
        return hashSet;
    }

    public GraphSwimlaneInterface findParentParticipantForLocation(Point point) {
        GraphSwimlaneInterface graphSwimlaneInterface = null;
        if (point.y <= 0) {
            point.y = 1;
        }
        if (point.x <= 0) {
            point.x = 1;
        }
        graphSwimlaneInterface = this.isGraphRotated() ? this.getLeafParticipantForXPos(point.x, null, null) : this.getLeafParticipantForYPos(point.y, null, null);
        return graphSwimlaneInterface;
    }

    public GraphSwimlaneInterface findParentParticipantForLocation(Point point, Map map, ParentMap parentMap) {
        GraphSwimlaneInterface graphSwimlaneInterface = null;
        if (point.y <= 0) {
            point.y = 1;
        }
        if (point.x <= 0) {
            point.x = 1;
        }
        if (this.isGraphRotated()) {
            graphSwimlaneInterface = this.getLeafParticipantForXPos(point.x, map, parentMap);
            if (graphSwimlaneInterface == null) {
                graphSwimlaneInterface = this.getLeafParticipantForXPos(this.getNewRootParXPos(map, null) - 10, map, parentMap);
            }
            if (graphSwimlaneInterface != null) {
                Rectangle rectangle = this.getCBounds(graphSwimlaneInterface, map);
                if (((RectangularShape)rectangle).getY() + (double)defLaneNameWidth >= (double)point.y) {
                    point.y = (int)(((RectangularShape)rectangle).getY() + (double)defLaneNameWidth + 1.0);
                }
            } else if (this.verticalOffset >= point.y) {
                point.y = this.horizontalOffset;
            }
        } else {
            graphSwimlaneInterface = this.getLeafParticipantForYPos(point.y, map, parentMap);
            if (graphSwimlaneInterface == null) {
                graphSwimlaneInterface = this.getLeafParticipantForYPos(this.getNewRootParYPos(map, null) - 10, map, parentMap);
            }
            if (graphSwimlaneInterface != null) {
                Rectangle rectangle = this.getCBounds(graphSwimlaneInterface, map);
                if (((RectangularShape)rectangle).getX() + (double)defLaneNameWidth >= (double)point.x) {
                    point.x = (int)((RectangularShape)rectangle).getX() + defLaneNameWidth + 1;
                }
            } else if (this.horizontalOffset >= point.x) {
                point.x = this.horizontalOffset;
            }
        }
        return graphSwimlaneInterface;
    }

    protected void arrangeParticipantsHorizontally(Object[] objectArray, Map map, ParentMap parentMap) {
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            this.arrangeParticipantHorizontally(objectArray[i], map, parentMap);
        }
    }

    protected void arrangeParticipantsVertically(Object[] objectArray, Map map, ParentMap parentMap) {
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            this.arrangeParticipantVertically(objectArray[i], map, parentMap);
        }
    }

    protected void arrangeParticipantHorizontally(Object object, Map map, ParentMap parentMap) {
        int n;
        if (object == null) {
            return;
        }
        if (!(object instanceof GraphSwimlaneInterface)) {
            return;
        }
        GraphSwimlaneInterface graphSwimlaneInterface = (GraphSwimlaneInterface)object;
        if (this.hasAnyParticipant(graphSwimlaneInterface, parentMap)) {
            return;
        }
        ArrayList arrayList = ((JaWEParentMap)parentMap).getRemovedNodes();
        if (arrayList.contains(graphSwimlaneInterface)) {
            return;
        }
        int n2 = this.optimalParticipantWidth(graphSwimlaneInterface, map, parentMap);
        int n3 = n2 - (n = this.getParticipantWidth(graphSwimlaneInterface, map));
        if (n3 != 0) {
            this.translateHorizontally(map, parentMap, this.getCBounds((Object)graphSwimlaneInterface, (Map)map).getBounds().x + n - 1, n3);
            Object[] objectArray = graphSwimlaneInterface.getPath();
            this.resize(objectArray, map, n3, 0);
        }
    }

    protected void arrangeParticipantVertically(Object object, Map map, ParentMap parentMap) {
        int n;
        if (object == null) {
            return;
        }
        if (!(object instanceof GraphSwimlaneInterface)) {
            return;
        }
        GraphSwimlaneInterface graphSwimlaneInterface = (GraphSwimlaneInterface)object;
        if (this.hasAnyParticipant(graphSwimlaneInterface, parentMap)) {
            return;
        }
        ArrayList arrayList = ((JaWEParentMap)parentMap).getRemovedNodes();
        if (arrayList.contains(graphSwimlaneInterface)) {
            return;
        }
        int n2 = this.optimalParticipantHeight(graphSwimlaneInterface, map, parentMap);
        int n3 = n2 - (n = this.getParticipantHeight(graphSwimlaneInterface, map));
        if (n3 != 0) {
            this.translateVertically(map, parentMap, this.getCBounds((Object)graphSwimlaneInterface, (Map)map).getBounds().y + n - 1, n3);
            Object[] objectArray = graphSwimlaneInterface.getPath();
            this.resize(objectArray, map, 0, n3);
        }
    }

    protected void resizeAllParticipantsHorizontally(Map map, ParentMap parentMap) {
        int n;
        int n2;
        List list = JaWEGraphModel.getAllParticipantsInModel((GraphModel)this.graphModel());
        if (parentMap != null && list != null) {
            list.removeAll(((JaWEParentMap)parentMap).getRemovedNodes());
        }
        if ((n2 = this.optimalRootParticipantWidth(list, map, parentMap)) != (n = this.getRootParticipantWidth(map, parentMap))) {
            int n3 = n2 - n;
            if (list != null) {
                this.resize(list.toArray(), map, n3, 0);
            }
        }
    }

    protected void resizeAllParticipantsVertically(Map map, ParentMap parentMap) {
        int n;
        int n2;
        List list = JaWEGraphModel.getAllParticipantsInModel((GraphModel)this.graphModel());
        if (parentMap != null && list != null) {
            list.removeAll(((JaWEParentMap)parentMap).getRemovedNodes());
        }
        if ((n2 = this.optimalRootParticipantHeight(list, map, parentMap)) != (n = this.getRootParticipantHeight(map, parentMap))) {
            int n3 = n2 - n;
            if (list != null) {
                this.resize(list.toArray(), map, 0, n3);
            }
        }
    }

    protected int optimalRootParticipantHeight(List list, Map map, ParentMap parentMap) {
        int n = this.isGraphRotated() ? minLaneWidth : minLaneHeight;
        if (list == null) {
            return n;
        }
        HashSet<GraphSwimlaneInterface> hashSet = new HashSet<GraphSwimlaneInterface>();
        for (GraphSwimlaneInterface graphSwimlaneInterface : list) {
            if (this.hasAnyParticipant(graphSwimlaneInterface, parentMap)) continue;
            hashSet.add(graphSwimlaneInterface);
        }
        Iterator iterator = hashSet.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            GraphSwimlaneInterface graphSwimlaneInterface = (GraphSwimlaneInterface)iterator.next();
            int n3 = 0;
            int n4 = this.isGraphRotated() ? (int)this.getCBounds(graphSwimlaneInterface, map).getY() + minLaneWidth : (int)this.getCBounds(graphSwimlaneInterface, map).getY() + minLaneHeight;
            Rectangle rectangle = this.getBoundsOfParticipantFutureActivitiesAndArtifacts(graphSwimlaneInterface, map, parentMap);
            if (rectangle != null) {
                n3 = rectangle.y + rectangle.height + defLaneNameWidth;
            }
            int n5 = Math.max(n4, n3);
            if (n2 == 0) {
                n2 = n5;
                continue;
            }
            if (n5 <= n2) continue;
            n2 = n5;
        }
        int n6 = n2 - this.verticalOffset;
        if (n6 > minLaneWidth) {
            n = n6;
        }
        return n;
    }

    protected int optimalRootParticipantWidth(List list, Map map, ParentMap parentMap) {
        int n = this.isGraphRotated() ? minLaneHeight : minLaneWidth;
        if (list == null) {
            return n;
        }
        HashSet<GraphSwimlaneInterface> hashSet = new HashSet<GraphSwimlaneInterface>();
        for (GraphSwimlaneInterface graphSwimlaneInterface : list) {
            if (this.hasAnyParticipant(graphSwimlaneInterface, parentMap)) continue;
            hashSet.add(graphSwimlaneInterface);
        }
        Iterator iterator = hashSet.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            GraphSwimlaneInterface graphSwimlaneInterface = (GraphSwimlaneInterface)iterator.next();
            int n3 = 0;
            int n4 = this.isGraphRotated() ? (int)this.getCBounds(graphSwimlaneInterface, map).getX() + minLaneHeight : (int)this.getCBounds(graphSwimlaneInterface, map).getX() + minLaneWidth;
            Rectangle rectangle = this.getBoundsOfParticipantFutureActivitiesAndArtifacts(graphSwimlaneInterface, map, parentMap);
            if (rectangle != null) {
                n3 = rectangle.x + rectangle.width + defLaneNameWidth;
            }
            int n5 = Math.max(n4, n3);
            if (n2 == 0) {
                n2 = n5;
                continue;
            }
            if (n5 <= n2) continue;
            n2 = n5;
        }
        int n6 = n2 - this.horizontalOffset;
        if (n6 > minLaneWidth) {
            n = n6;
        }
        return n;
    }

    protected int optimalParticipantWidth(GraphSwimlaneInterface graphSwimlaneInterface, Map map, ParentMap parentMap) {
        int n = this.isGraphRotated() ? minLaneHeight : minLaneWidth;
        if (!this.hasAnyActivityOrArtifact(graphSwimlaneInterface, parentMap)) {
            return n;
        }
        Rectangle rectangle = this.getCBounds(graphSwimlaneInterface, map);
        Rectangle rectangle2 = this.getBoundsOfParticipantFutureActivitiesAndArtifacts(graphSwimlaneInterface, map, parentMap);
        if (rectangle2 != null) {
            int n2 = rectangle2.x + rectangle2.width - (int)(((RectangularShape)rectangle).getX() + ((RectangularShape)rectangle).getWidth());
            int n3 = (int)((RectangularShape)rectangle).getWidth() + n2 + 10;
            if (n3 > n) {
                n = n3;
            }
        }
        return n;
    }

    protected int optimalParticipantHeight(GraphSwimlaneInterface graphSwimlaneInterface, Map map, ParentMap parentMap) {
        int n = this.isGraphRotated() ? minLaneWidth : minLaneHeight;
        if (!this.hasAnyActivityOrArtifact(graphSwimlaneInterface, parentMap)) {
            return n;
        }
        Rectangle rectangle = this.getCBounds(graphSwimlaneInterface, map);
        Rectangle rectangle2 = this.getBoundsOfParticipantFutureActivitiesAndArtifacts(graphSwimlaneInterface, map, parentMap);
        if (rectangle2 != null) {
            int n2 = rectangle2.y + rectangle2.height - (int)(((RectangularShape)rectangle).getY() + ((RectangularShape)rectangle).getHeight());
            int n3 = (int)((RectangularShape)rectangle).getHeight() + n2 + 10;
            if (n3 > n) {
                n = n3;
            }
        }
        return n;
    }

    protected void resize(Object[] objectArray, Map map, int n, int n2) {
        if (objectArray != null && objectArray.length > 0) {
            for (int i = 0; i < objectArray.length; ++i) {
                Rectangle rectangle = new Rectangle(this.getCBounds(objectArray[i], map).getBounds());
                int n3 = rectangle.width + n;
                int n4 = rectangle.height + n2;
                if (this.isGraphRotated()) {
                    if (n3 < minLaneHeight || n4 < minLaneWidth) {
                        System.err.println("There was an error in calculating size of participant " + objectArray[i] + "!!!");
                        System.err.println("New width=" + n3 + ", new height=" + n4);
                    }
                } else if (n3 < minLaneWidth || n4 < minLaneHeight) {
                    System.err.println("There was an error in calculating size of participant " + objectArray[i] + "!!!");
                    System.err.println("New width=" + n3 + ", new height=" + n4);
                }
                rectangle.setSize(n3, n4);
                this.changeBounds(objectArray[i], map, rectangle);
            }
        }
    }

    protected void translateHorizontally(Map map, ParentMap parentMap, int n, int n2) {
        GraphSwimlaneInterface[] graphSwimlaneInterfaceArray = this.getParticipantsForXPos(n, 0, map, parentMap, true);
        this.translateParticipants(graphSwimlaneInterfaceArray, map, parentMap, n2, 0);
    }

    protected void translateVertically(Map map, ParentMap parentMap, int n, int n2) {
        GraphSwimlaneInterface[] graphSwimlaneInterfaceArray = this.getParticipantsForYPos(n, 0, map, parentMap, true);
        this.translateParticipants(graphSwimlaneInterfaceArray, map, parentMap, 0, n2);
    }

    protected void translateParticipants(GraphSwimlaneInterface[] graphSwimlaneInterfaceArray, Map map, ParentMap parentMap, int n, int n2) {
        if (graphSwimlaneInterfaceArray != null && graphSwimlaneInterfaceArray.length > 0) {
            for (int i = 0; i < graphSwimlaneInterfaceArray.length; ++i) {
                this.translateParticipant(graphSwimlaneInterfaceArray[i], map, parentMap, n, n2, false);
            }
        }
    }

    protected void translateParticipant(GraphSwimlaneInterface graphSwimlaneInterface, Map map, ParentMap parentMap, int n, int n2, boolean bl) {
        HashSet<GraphSwimlaneInterface> hashSet = new HashSet<GraphSwimlaneInterface>();
        hashSet.add(graphSwimlaneInterface);
        Set set = this.getParticipantFutureActivitiesAndArtifacts(graphSwimlaneInterface, parentMap);
        hashSet.addAll(set);
        for (Object e : hashSet) {
            Rectangle rectangle = new Rectangle(this.getCBounds(e, map).getBounds());
            rectangle.translate(n, n2);
            this.changeBounds(e, map, rectangle);
        }
        if (bl) {
            Iterator iterator = GraphManager.getAllChildParticipants(graphSwimlaneInterface).iterator();
            while (iterator.hasNext()) {
                this.translateParticipant((GraphSwimlaneInterface)iterator.next(), map, parentMap, n, n2, true);
            }
        }
    }

    protected Rectangle getBoundsOfParticipantFutureActivitiesAndArtifacts(GraphSwimlaneInterface graphSwimlaneInterface, Map map, ParentMap parentMap) {
        Rectangle[] rectangleArray;
        Set set = this.getParticipantFutureActivitiesAndArtifacts(graphSwimlaneInterface, parentMap);
        HashSet<Rectangle[]> hashSet = new HashSet<Rectangle[]>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            rectangleArray = this.getCBounds(iterator.next(), map).getBounds();
            hashSet.add(rectangleArray);
        }
        rectangleArray = new Rectangle[hashSet.size()];
        hashSet.toArray(rectangleArray);
        Rectangle rectangle = this.getUnionBounds(rectangleArray);
        return rectangle;
    }

    protected Set getParticipantFutureActivitiesAndArtifacts(GraphSwimlaneInterface graphSwimlaneInterface, ParentMap parentMap) {
        if (parentMap == null) {
            return graphSwimlaneInterface.getChildActivitiesAndArtifacts();
        }
        HashSet hashSet = new HashSet();
        ArrayList arrayList = ((JaWEParentMap)parentMap).emptyParentList();
        if (arrayList.contains(graphSwimlaneInterface)) {
            return hashSet;
        }
        Set set = parentMap.getChangedNodes();
        hashSet = new HashSet(graphSwimlaneInterface.getChildActivitiesAndArtifacts());
        Object[] objectArray = hashSet.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!set.contains(objectArray[i])) continue;
            hashSet.remove(objectArray[i]);
        }
        ArrayList arrayList2 = ((JaWEParentMap)parentMap).getNewChildren(graphSwimlaneInterface);
        hashSet.addAll(arrayList2);
        return hashSet;
    }

    protected GraphSwimlaneInterface getLeafParticipantForXPos(int n, Map map, ParentMap parentMap) {
        GraphSwimlaneInterface[] graphSwimlaneInterfaceArray = this.getParticipantsForXPos(n, 2, map, parentMap, true);
        if (graphSwimlaneInterfaceArray == null) {
            return null;
        }
        HashSet<GraphSwimlaneInterface> hashSet = new HashSet<GraphSwimlaneInterface>();
        for (int i = 0; i < graphSwimlaneInterfaceArray.length; ++i) {
            if (this.hasAnyParticipant(graphSwimlaneInterfaceArray[i], parentMap)) continue;
            hashSet.add(graphSwimlaneInterfaceArray[i]);
        }
        if (hashSet.size() == 0) {
            return null;
        }
        Iterator iterator = hashSet.iterator();
        Object e = iterator.next();
        if (hashSet.size() > 1) {
            int n2;
            Rectangle rectangle = this.getCBounds(e, map).getBounds();
            int n3 = n2 = rectangle.getLocation().x;
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                rectangle = this.getCBounds(e2, map).getBounds();
                n2 = rectangle.getLocation().x;
                if (n2 >= n3) continue;
                n3 = n2;
                e = e2;
            }
        }
        return (GraphSwimlaneInterface)e;
    }

    protected GraphSwimlaneInterface getLeafParticipantForYPos(int n, Map map, ParentMap parentMap) {
        GraphSwimlaneInterface[] graphSwimlaneInterfaceArray = this.getParticipantsForYPos(n, 2, map, parentMap, true);
        if (graphSwimlaneInterfaceArray == null) {
            return null;
        }
        HashSet<GraphSwimlaneInterface> hashSet = new HashSet<GraphSwimlaneInterface>();
        for (int i = 0; i < graphSwimlaneInterfaceArray.length; ++i) {
            if (this.hasAnyParticipant(graphSwimlaneInterfaceArray[i], parentMap)) continue;
            hashSet.add(graphSwimlaneInterfaceArray[i]);
        }
        if (hashSet.size() == 0) {
            return null;
        }
        Iterator iterator = hashSet.iterator();
        Object e = iterator.next();
        if (hashSet.size() > 1) {
            int n2;
            Rectangle rectangle = this.getCBounds(e, map).getBounds();
            int n3 = n2 = rectangle.getLocation().y;
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                rectangle = this.getCBounds(e2, map).getBounds();
                n2 = rectangle.getLocation().y;
                if (n2 >= n3) continue;
                n3 = n2;
                e = e2;
            }
        }
        return (GraphSwimlaneInterface)e;
    }

    protected GraphSwimlaneInterface getLeafestParticipantForPos(Point point, Map map, ParentMap parentMap) {
        GraphSwimlaneInterface[] graphSwimlaneInterfaceArray = null;
        graphSwimlaneInterfaceArray = this.isGraphRotated() ? this.getParticipantsForXPos(point.x, 2, map, parentMap, true) : this.getParticipantsForYPos(point.y, 2, map, parentMap, true);
        if (graphSwimlaneInterfaceArray == null) {
            return null;
        }
        HashSet<GraphSwimlaneInterface> hashSet = new HashSet<GraphSwimlaneInterface>();
        HashSet<GraphSwimlaneInterface> hashSet2 = new HashSet<GraphSwimlaneInterface>();
        for (int i = 0; i < graphSwimlaneInterfaceArray.length; ++i) {
            if (!this.hasAnyParticipant(graphSwimlaneInterfaceArray[i], parentMap)) {
                hashSet.add(graphSwimlaneInterfaceArray[i]);
                continue;
            }
            hashSet2.add(graphSwimlaneInterfaceArray[i]);
        }
        if (hashSet.size() == 0) {
            return null;
        }
        Iterator iterator = hashSet.iterator();
        Object e = iterator.next();
        if (hashSet.size() > 1) {
            int n;
            Rectangle rectangle = this.getCBounds(e, map).getBounds();
            int n2 = n = rectangle.getLocation().x;
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                rectangle = this.getCBounds(e2, map).getBounds();
                n = rectangle.getLocation().x;
                if (n >= n2) continue;
                n2 = n;
                e = e2;
            }
        }
        return (GraphSwimlaneInterface)e;
    }

    protected GraphSwimlaneInterface[] getParticipantsForXPos(int n, int n2, Map map, ParentMap parentMap, boolean bl) {
        List list = JaWEGraphModel.getAllParticipantsInModel((GraphModel)this.graphModel());
        if (list == null) {
            return null;
        }
        if (parentMap != null) {
            list.removeAll(((JaWEParentMap)parentMap).getRemovedNodes());
        }
        GraphSwimlaneInterface[] graphSwimlaneInterfaceArray = new GraphSwimlaneInterface[list.size()];
        list.toArray(graphSwimlaneInterfaceArray);
        HashSet<GraphSwimlaneInterface> hashSet = new HashSet<GraphSwimlaneInterface>();
        block5: for (int i = 0; i < graphSwimlaneInterfaceArray.length; ++i) {
            if (graphSwimlaneInterfaceArray[i].getPropertyObject() instanceof Pool && !bl) continue;
            Rectangle rectangle = this.getCBounds(graphSwimlaneInterfaceArray[i], map);
            switch (n2) {
                case 0: {
                    if (!(((RectangularShape)rectangle).getX() >= (double)n)) continue block5;
                    hashSet.add(graphSwimlaneInterfaceArray[i]);
                    continue block5;
                }
                case 1: {
                    if (!(((RectangularShape)rectangle).getX() < (double)n)) continue block5;
                    hashSet.add(graphSwimlaneInterfaceArray[i]);
                    continue block5;
                }
                case 2: {
                    if (!(((RectangularShape)rectangle).getX() <= (double)n) || !(((RectangularShape)rectangle).getX() + ((RectangularShape)rectangle).getWidth() >= (double)n)) continue block5;
                    hashSet.add(graphSwimlaneInterfaceArray[i]);
                }
            }
        }
        if (hashSet.size() > 0) {
            graphSwimlaneInterfaceArray = new GraphSwimlaneInterface[hashSet.size()];
            hashSet.toArray(graphSwimlaneInterfaceArray);
            return graphSwimlaneInterfaceArray;
        }
        return null;
    }

    protected GraphSwimlaneInterface[] getParticipantsForYPos(int n, int n2, Map map, ParentMap parentMap, boolean bl) {
        List list = JaWEGraphModel.getAllParticipantsInModel((GraphModel)this.graphModel());
        if (list == null) {
            return null;
        }
        if (parentMap != null) {
            list.removeAll(((JaWEParentMap)parentMap).getRemovedNodes());
        }
        GraphSwimlaneInterface[] graphSwimlaneInterfaceArray = new GraphSwimlaneInterface[list.size()];
        list.toArray(graphSwimlaneInterfaceArray);
        HashSet<GraphSwimlaneInterface> hashSet = new HashSet<GraphSwimlaneInterface>();
        block5: for (int i = 0; i < graphSwimlaneInterfaceArray.length; ++i) {
            if (graphSwimlaneInterfaceArray[i].getPropertyObject() instanceof Pool && !bl) continue;
            Rectangle rectangle = this.getCBounds(graphSwimlaneInterfaceArray[i], map);
            switch (n2) {
                case 0: {
                    if (!(((RectangularShape)rectangle).getY() >= (double)n)) continue block5;
                    hashSet.add(graphSwimlaneInterfaceArray[i]);
                    continue block5;
                }
                case 1: {
                    if (!(((RectangularShape)rectangle).getY() < (double)n)) continue block5;
                    hashSet.add(graphSwimlaneInterfaceArray[i]);
                    continue block5;
                }
                case 2: {
                    if (!(((RectangularShape)rectangle).getY() <= (double)n) || !(((RectangularShape)rectangle).getY() + ((RectangularShape)rectangle).getHeight() >= (double)n)) continue block5;
                    hashSet.add(graphSwimlaneInterfaceArray[i]);
                }
            }
        }
        if (hashSet.size() > 0) {
            graphSwimlaneInterfaceArray = new GraphSwimlaneInterface[hashSet.size()];
            hashSet.toArray(graphSwimlaneInterfaceArray);
            return graphSwimlaneInterfaceArray;
        }
        return null;
    }

    protected int getNewRootParXPos(Map map, ParentMap parentMap) {
        int n = 0;
        Set set = JaWEGraphModel.getRootParticipants((GraphModel)this.graphModel());
        if (map != null) {
            for (Object object : map.keySet()) {
                if (!(object instanceof GraphSwimlaneInterface) || ((DefaultGraphCell)object).getParent() != null) continue;
                set.add(object);
            }
        }
        if (parentMap != null) {
            set.removeAll(((JaWEParentMap)parentMap).getRemovedNodes());
        }
        if (set == null || set.size() == 0) {
            return n;
        }
        n = minLaneHeight;
        Iterator<Object> iterator = set.iterator();
        while (iterator.hasNext()) {
            Object object;
            object = this.getCBounds(iterator.next(), map);
            if (!(((RectangularShape)object).getX() + ((RectangularShape)object).getWidth() > (double)n)) continue;
            n = (int)(((RectangularShape)object).getX() + ((RectangularShape)object).getWidth());
        }
        return n;
    }

    protected int getNewRootParYPos(Map map, ParentMap parentMap) {
        int n = 0;
        Set set = JaWEGraphModel.getRootParticipants((GraphModel)this.graphModel());
        if (map != null) {
            for (Object object : map.keySet()) {
                if (!(object instanceof GraphSwimlaneInterface) || ((DefaultGraphCell)object).getParent() != null) continue;
                set.add(object);
            }
        }
        if (parentMap != null) {
            set.removeAll(((JaWEParentMap)parentMap).getRemovedNodes());
        }
        if (set == null || set.size() == 0) {
            return n;
        }
        n = minLaneHeight;
        Iterator<Object> iterator = set.iterator();
        while (iterator.hasNext()) {
            Object object;
            object = this.getCBounds(iterator.next(), map).getBounds();
            if (!(((Rectangle)object).getY() + ((Rectangle)object).getHeight() > (double)n)) continue;
            n = (int)(((Rectangle)object).getY() + ((Rectangle)object).getHeight());
        }
        return n;
    }

    protected int getRootParticipantHeight(Map map, ParentMap parentMap) {
        int n = this.isGraphRotated() ? minLaneWidth : minLaneHeight;
        Set set = JaWEGraphModel.getRootParticipants((GraphModel)this.graphModel());
        if (set == null) {
            return n;
        }
        if (parentMap != null) {
            set.removeAll(((JaWEParentMap)parentMap).getRemovedNodes());
        }
        if (set.size() == 0) {
            return n;
        }
        Iterator iterator = set.iterator();
        Object e = iterator.next();
        n = this.getParticipantHeight(e, map);
        return n;
    }

    protected int getRootParticipantWidth(Map map, ParentMap parentMap) {
        int n = this.isGraphRotated() ? minLaneHeight : minLaneWidth;
        Set set = JaWEGraphModel.getRootParticipants((GraphModel)this.graphModel());
        if (set == null) {
            return n;
        }
        if (parentMap != null) {
            set.removeAll(((JaWEParentMap)parentMap).getRemovedNodes());
        }
        if (set.size() == 0) {
            return n;
        }
        Iterator iterator = set.iterator();
        Object e = iterator.next();
        n = this.getParticipantWidth(e, map);
        return n;
    }

    protected boolean hasAnyParticipant(GraphSwimlaneInterface graphSwimlaneInterface, ParentMap parentMap) {
        if (parentMap == null || !parentMap.getChangedNodes().contains(graphSwimlaneInterface)) {
            return graphSwimlaneInterface.hasAnySwimlane();
        }
        return ((JaWEParentMap)parentMap).hasAnyParticipant(graphSwimlaneInterface);
    }

    protected boolean hasAnyActivityOrArtifact(GraphSwimlaneInterface graphSwimlaneInterface, ParentMap parentMap) {
        if (parentMap == null || !parentMap.getChangedNodes().contains(graphSwimlaneInterface)) {
            return graphSwimlaneInterface.hasAnyActivityOrArtifact();
        }
        ArrayList arrayList = ((JaWEParentMap)parentMap).emptyParentList();
        return !arrayList.contains(graphSwimlaneInterface);
    }

    protected Set getStartEvents() {
        HashSet hashSet = new HashSet();
        List list = JaWEGraphModel.getAllActivitiesInModel((GraphModel)this.graphModel());
        if (list != null) {
            for (Object e : list) {
                int n = ((Activity)((GraphActivityInterface)e).getPropertyObject()).getActivityType();
                if (n != 6) continue;
                hashSet.add(e);
            }
        }
        return hashSet;
    }

    protected Set getEndEvents() {
        HashSet hashSet = new HashSet();
        List list = JaWEGraphModel.getAllActivitiesInModel((GraphModel)this.graphModel());
        if (list != null) {
            for (Object e : list) {
                int n = ((Activity)((GraphActivityInterface)e).getPropertyObject()).getActivityType();
                if (n != 7) continue;
                hashSet.add(e);
            }
        }
        return hashSet;
    }

    public CellView getView(Object object) {
        return this.graph.getGraphLayoutCache().getMapping(object, false);
    }

    protected int getParticipantWidth(Object object, Map map) {
        return this.getCBounds((Object)object, (Map)map).getBounds().width;
    }

    protected int getParticipantHeight(Object object, Map map) {
        return this.getCBounds((Object)object, (Map)map).getBounds().height;
    }

    protected void changeBounds(Object object, Map map, Rectangle rectangle) {
        if (map == null || !map.containsKey(object)) {
            AttributeMap attributeMap = new AttributeMap();
            GraphConstants.setBounds((Map)attributeMap, (Rectangle2D)rectangle);
            map.put(object, attributeMap);
        } else {
            AttributeMap attributeMap = (AttributeMap)map.get(object);
            GraphConstants.setBounds((Map)attributeMap, (Rectangle2D)rectangle);
        }
    }

    public Rectangle getCBounds(Object object, Map map) {
        Rectangle2D rectangle2D = null;
        if (map != null && map.containsKey(object)) {
            Map map2 = (Map)map.get(object);
            rectangle2D = GraphConstants.getBounds((Map)map2);
        } else {
            CellView cellView = this.getView(object);
            rectangle2D = cellView.getBounds();
        }
        if (rectangle2D != null) {
            return rectangle2D.getBounds();
        }
        return null;
    }

    public Rectangle getUnionBounds(Rectangle[] rectangleArray) {
        if (rectangleArray != null && rectangleArray.length > 0) {
            Rectangle rectangle = null;
            for (int i = 0; i < rectangleArray.length; ++i) {
                if (rectangle == null) {
                    rectangle = new Rectangle(rectangleArray[i]);
                    continue;
                }
                SwingUtilities.computeUnion(rectangleArray[i].x, rectangleArray[i].y, rectangleArray[i].width, rectangleArray[i].height, rectangle);
            }
            return rectangle;
        }
        return null;
    }

    public Point getCenter(Object object) {
        if (object == null) {
            return null;
        }
        Rectangle rectangle = this.getCBounds(object, null);
        if (!(object instanceof GraphSwimlaneInterface)) {
            return new Point((int)(((RectangularShape)rectangle).getX() + (double)((int)(((RectangularShape)rectangle).getWidth() / 2.0))), (int)(((RectangularShape)rectangle).getY() + (double)((int)(((RectangularShape)rectangle).getHeight() / 2.0))));
        }
        return new Point((int)(((RectangularShape)rectangle).getX() + (double)(defLaneNameWidth / 2)), (int)(((RectangularShape)rectangle).getY() + (double)((int)(((RectangularShape)rectangle).getHeight() / 2.0))));
    }

    public GraphActivityInterface getGraphActivity(String string) {
        List list = JaWEGraphModel.getAllActivitiesInModel((GraphModel)this.graphModel());
        if (list != null) {
            for (GraphActivityInterface graphActivityInterface : list) {
                if (!graphActivityInterface.getPropertyObject().get("Id").toValue().equals(string)) continue;
                return graphActivityInterface;
            }
        }
        return null;
    }

    public GraphActivityInterface getGraphActivity(Activity activity) {
        List list = JaWEGraphModel.getAllActivitiesInModel((GraphModel)this.graphModel());
        if (list != null) {
            for (GraphActivityInterface graphActivityInterface : list) {
                if (graphActivityInterface.getUserObject() != activity) continue;
                return graphActivityInterface;
            }
        }
        return null;
    }

    public GraphArtifactInterface getGraphArtifact(String string) {
        List list = JaWEGraphModel.getAllArtifactsInModel((GraphModel)this.graphModel());
        if (list != null) {
            for (GraphArtifactInterface graphArtifactInterface : list) {
                if (!graphArtifactInterface.getPropertyObject().get("Id").toValue().equals(string)) continue;
                return graphArtifactInterface;
            }
        }
        return null;
    }

    public GraphArtifactInterface getGraphArtifact(Artifact artifact) {
        List list = JaWEGraphModel.getAllArtifactsInModel((GraphModel)this.graphModel());
        if (list != null) {
            for (GraphArtifactInterface graphArtifactInterface : list) {
                if (graphArtifactInterface.getUserObject() != artifact) continue;
                return graphArtifactInterface;
            }
        }
        return null;
    }

    public GraphTransitionInterface getGraphTransition(XMLCollectionElement xMLCollectionElement) {
        List list = JaWEGraphModel.getAllTransitionsInModel((GraphModel)this.graphModel());
        if (list != null) {
            for (GraphTransitionInterface graphTransitionInterface : list) {
                if (graphTransitionInterface.getUserObject() != xMLCollectionElement) continue;
                return graphTransitionInterface;
            }
        }
        return null;
    }

    public GraphSwimlaneInterface getGraphParticipant(String string) {
        List list = JaWEGraphModel.getAllParticipantsInModel((GraphModel)this.graphModel());
        if (list != null) {
            for (GraphSwimlaneInterface graphSwimlaneInterface : list) {
                if (!graphSwimlaneInterface.getPropertyObject().get("Id").toValue().equals(string)) continue;
                return graphSwimlaneInterface;
            }
        }
        return null;
    }

    public GraphSwimlaneInterface getGraphParticipant(Object object) {
        List list = JaWEGraphModel.getAllParticipantsInModel((GraphModel)this.graphModel());
        if (list != null) {
            for (GraphSwimlaneInterface graphSwimlaneInterface : list) {
                if (graphSwimlaneInterface.getUserObject() != object) continue;
                return graphSwimlaneInterface;
            }
        }
        return null;
    }

    public boolean isFreeTextExpressionParticipantShown() {
        List list = JaWEGraphModel.getAllParticipantsInModel((GraphModel)this.graphModel());
        if (list != null) {
            Iterator iterator = list.iterator();
            Lane lane = GraphUtilities.getDefaultLane(JaWEManager.getInstance().getXPDLUtils().getPoolForProcessOrActivitySet(this.getXPDLOwner()));
            if (lane == null) {
                return false;
            }
            while (iterator.hasNext()) {
                GraphSwimlaneInterface graphSwimlaneInterface = (GraphSwimlaneInterface)iterator.next();
                if (graphSwimlaneInterface.getUserObject() != lane) continue;
                return true;
            }
        }
        return false;
    }

    public Object findNearestCell(Object object, int n) {
        List list = JaWEGraphModel.getAllCellsInModel((GraphModel)this.graphModel());
        if (list == null || list.size() == 0) {
            return null;
        }
        Object[] objectArray = list.toArray();
        if (object == null) {
            return objectArray[0];
        }
        Point point = this.getCenter(object);
        if (point == null) {
            return objectArray[0];
        }
        Object object2 = null;
        double d = Double.MAX_VALUE;
        block5: for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == object || objectArray[i] instanceof Port) continue;
            Point point2 = this.getCenter(objectArray[i]);
            Point point3 = new Point(point2.x, point.y);
            double d2 = point.distance(point2);
            double d3 = point2.distance(point3) / point3.distance(point);
            switch (n) {
                case 1: {
                    if (point2.y < point.y || !(d2 < d) || !(d3 >= 1.0)) continue block5;
                    d = d2;
                    object2 = objectArray[i];
                    continue block5;
                }
                case 2: {
                    if (point2.x > point.x || !(d2 < d) || !(d3 <= 1.0)) continue block5;
                    d = d2;
                    object2 = objectArray[i];
                    continue block5;
                }
                case 3: {
                    if (point2.x < point.x || !(d2 < d) || !(d3 <= 1.0)) continue block5;
                    d = d2;
                    object2 = objectArray[i];
                    continue block5;
                }
                default: {
                    if (point2.y > point.y || !(d2 < d) || !(d3 >= 1.0)) continue block5;
                    d = d2;
                    object2 = objectArray[i];
                }
            }
        }
        return object2;
    }

    public boolean moveParticipant(GraphSwimlaneInterface graphSwimlaneInterface, boolean bl, Map map, ParentMap parentMap) {
        Object object;
        boolean bl2 = false;
        Rectangle rectangle = this.getCBounds(graphSwimlaneInterface, map).getBounds();
        Rectangle rectangle2 = new Rectangle(rectangle);
        if (bl) {
            int n = rectangle.y - 1;
            int n2 = rectangle.x - 1;
            if (!this.isGraphRotated()) {
                GraphSwimlaneInterface[] graphSwimlaneInterfaceArray = this.getParticipantsForYPos(n, 2, map, parentMap, false);
                object = GraphManager.getCommonParentParticipant(graphSwimlaneInterfaceArray, graphSwimlaneInterface.getParent());
                if (object != null) {
                    Rectangle rectangle3 = this.getCBounds(object, map);
                    this.translateParticipant(graphSwimlaneInterface, map, parentMap, 0, -rectangle3.height, true);
                    this.translateParticipant((GraphSwimlaneInterface)object, map, parentMap, 0, rectangle.height, true);
                }
            } else {
                GraphSwimlaneInterface[] graphSwimlaneInterfaceArray = this.getParticipantsForXPos(n2, 2, map, parentMap, false);
                object = GraphManager.getCommonParentParticipant(graphSwimlaneInterfaceArray, graphSwimlaneInterface.getParent());
                if (object != null) {
                    Rectangle rectangle4 = this.getCBounds(object, map);
                    this.translateParticipant(graphSwimlaneInterface, map, parentMap, -rectangle4.width, 0, true);
                    this.translateParticipant((GraphSwimlaneInterface)object, map, parentMap, rectangle.width, 0, true);
                }
            }
        } else {
            int n = rectangle.y + rectangle.height + 1;
            int n3 = rectangle.x + rectangle.width + 1;
            if (!this.isGraphRotated()) {
                GraphSwimlaneInterface[] graphSwimlaneInterfaceArray = this.getParticipantsForYPos(n, 2, map, parentMap, false);
                object = GraphManager.getCommonParentParticipant(graphSwimlaneInterfaceArray, graphSwimlaneInterface.getParent());
                if (object != null) {
                    Rectangle rectangle5 = this.getCBounds(object, map);
                    this.translateParticipant(graphSwimlaneInterface, map, parentMap, 0, rectangle5.height, true);
                    this.translateParticipant((GraphSwimlaneInterface)object, map, parentMap, 0, -rectangle.height, true);
                }
            } else {
                GraphSwimlaneInterface[] graphSwimlaneInterfaceArray = this.getParticipantsForXPos(n3, 2, map, parentMap, false);
                object = GraphManager.getCommonParentParticipant(graphSwimlaneInterfaceArray, graphSwimlaneInterface.getParent());
                if (object != null) {
                    Rectangle rectangle6 = this.getCBounds(object, map);
                    this.translateParticipant(graphSwimlaneInterface, map, parentMap, rectangle6.width, 0, true);
                    this.translateParticipant((GraphSwimlaneInterface)object, map, parentMap, -rectangle.width, 0, true);
                }
            }
        }
        object = this.getCBounds(graphSwimlaneInterface, map);
        this.arrangeParticipants(map, parentMap);
        if (!((Rectangle)object).equals(rectangle2)) {
            bl2 = true;
        }
        return bl2;
    }

    public Dimension getGraphsPreferredSize() {
        if (!this.isGraphRotated()) {
            return new Dimension(this.getRootParticipantWidth(null, null) + 50, this.getNewRootParYPos(null, null) + 50);
        }
        return new Dimension(this.getNewRootParXPos(null, null) + 50, this.getRootParticipantHeight(null, null) + 50);
    }

    protected List getPoints(GraphTransitionInterface graphTransitionInterface, Map map) {
        if (map != null && map.containsKey(graphTransitionInterface)) {
            Map map2 = (Map)map.get(graphTransitionInterface);
            List list = GraphConstants.getPoints((Map)map2);
            ArrayList<Point> arrayList = new ArrayList<Point>();
            for (int i = 1; i < list.size() - 1; ++i) {
                Point2D point2D = (Point2D)list.get(i);
                Point point = new Point();
                point.setLocation(point2D);
                arrayList.add(point);
            }
            return arrayList;
        }
        return new ArrayList();
    }

    public boolean isGraphRotated() {
        return GraphUtilities.getGraphOrientation(this.getXPDLOwner()).equals("VERTICAL");
    }

    public void moveCellsAndArrangeParticipants(Map map) {
        if (this.getGraphController().isUpdateInProgress()) {
            Thread.dumpStack();
        }
        JaWEManager.getInstance().getJaWEController().startUndouableChange();
        this.getGraphController().setUpdateInProgress(true);
        this.updateModelAndArrangeParticipants(null, map, null, null, this.getGraphController().getSettings().getLanguageDependentString("MessageMovingObjects"), null, true);
        JaWEManager.getInstance().getJaWEController().endUndouableChange(this.updateXPDLActivitiesAndArtifactsPosition(map));
        this.getGraphController().setUpdateInProgress(false);
    }

    protected List updateXPDLActivitiesAndArtifactsPosition(Map map) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (map == null) {
            return arrayList;
        }
        Object[] objectArray = map.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object;
            Object object2;
            GraphSwimlaneInterface graphSwimlaneInterface;
            WorkflowElement workflowElement;
            Object object3 = objectArray[i];
            if (object3 instanceof GraphCommonInterface) {
                Activity activity;
                int n;
                workflowElement = (GraphCommonInterface)object3;
                graphSwimlaneInterface = (GraphSwimlaneInterface)((Object)workflowElement.getParent());
                object2 = this.getOffset((GraphCommonInterface)workflowElement, map);
                object = (XMLCollectionElement)workflowElement.getPropertyObject();
                if (!GraphUtilities.getOffsetPoint(object).equals(object2)) {
                    GraphUtilities.setOffsetPoint(object, (Point)object2, null);
                    arrayList.add(object);
                }
                Lane lane = (Lane)graphSwimlaneInterface.getPropertyObject();
                if (!(object instanceof Activity) && !(object instanceof Artifact)) continue;
                String string = JaWEManager.getInstance().getXPDLUtils().getLaneId((XMLCollectionElement)object);
                GraphUtilities.setLaneId(object, lane.getId());
                if (!(object instanceof Activity) || (n = (activity = (Activity)object).getActivityType()) != 1 && n != 2 || lane.getId().equals(string)) continue;
                String string2 = GraphUtilities.getLanesFirstPerformer(lane);
                activity.setFirstPerformer(string2 != null ? string2 : "");
                continue;
            }
            if (!(object3 instanceof GraphTransitionInterface) || (graphSwimlaneInterface = (XMLCollectionElement)(workflowElement = (GraphTransitionInterface)object3).getPropertyObject()) == null || (object2 = this.getPoints((GraphTransitionInterface)workflowElement, map)).equals(object = GraphUtilities.getBreakpoints((XMLCollectionElement)graphSwimlaneInterface))) continue;
            GraphUtilities.setBreakpoints((XMLCollectionElement)graphSwimlaneInterface, (List)object2);
            arrayList.add(graphSwimlaneInterface);
        }
        return arrayList;
    }

    public void removeCells(Object[] objectArray) {
        Object object;
        Transitions transitions;
        Object object2;
        Object object3;
        boolean bl = false;
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        HashSet hashSet3 = new HashSet();
        HashSet hashSet4 = new HashSet();
        HashSet hashSet5 = new HashSet();
        if (objectArray != null && objectArray.length > 0) {
            object3 = new HashSet(JaWEGraphModel.getDescendants((GraphModel)this.graphModel(), (Object[])objectArray));
            object2 = new HashSet(JaWEGraphModel.getEdges((GraphModel)this.graphModel(), (Object[])object3.toArray()));
            object3.addAll(object2);
            int n = 0;
            transitions = object3.iterator();
            while (transitions.hasNext()) {
                ++n;
                object = transitions.next();
                if (object instanceof GraphTransitionInterface) {
                    if (((GraphTransitionInterface)object).getPropertyObject() instanceof Transition) {
                        hashSet.add(object);
                        continue;
                    }
                    hashSet2.add(object);
                    continue;
                }
                if (object instanceof GraphActivityInterface) {
                    hashSet3.add(object);
                    continue;
                }
                if (object instanceof GraphArtifactInterface) {
                    hashSet4.add(object);
                    continue;
                }
                if (!(object instanceof GraphSwimlaneInterface)) continue;
                hashSet5.add(object);
            }
        }
        boolean bl2 = bl = bl || hashSet.size() > 0 || hashSet2.size() > 0 || hashSet3.size() > 0 || hashSet4.size() > 0 || hashSet5.size() > 0;
        if (bl) {
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            object3 = this.getGraph().getGraphController();
            object2 = JaWEManager.getInstance().getJaWEController();
            ((GraphController)object3).setUpdateInProgress(true);
            ((JaWEController)object2).startUndouableChange();
            this.removeCellsAndArrangeParticipants(objectArray);
            Iterator iterator = hashSet.iterator();
            transitions = (Transitions)this.getXPDLOwner().get("Transitions");
            while (iterator.hasNext()) {
                object = (GraphTransitionInterface)iterator.next();
                object7 = (Transition)object.getPropertyObject();
                transitions.remove((XMLElement)object7);
            }
            iterator = hashSet2.iterator();
            object = XMLUtil.getPackage((XMLElement)this.getWorkflowProcess()).getAssociations();
            while (iterator.hasNext()) {
                object7 = (GraphTransitionInterface)iterator.next();
                object6 = (Association)object7.getPropertyObject();
                object.remove((XMLElement)object6);
            }
            iterator = hashSet3.iterator();
            object7 = (Activities)this.getXPDLOwner().get("Activities");
            while (iterator.hasNext()) {
                object6 = (GraphActivityInterface)iterator.next();
                object5 = (Activity)object6.getPropertyObject();
                object7.remove((XMLElement)object5);
            }
            iterator = hashSet4.iterator();
            object6 = XMLUtil.getPackage((XMLElement)this.getWorkflowProcess()).getArtifacts();
            while (iterator.hasNext()) {
                object5 = (GraphArtifactInterface)iterator.next();
                object4 = (Artifact)object5.getPropertyObject();
                object6.remove((XMLElement)object4);
            }
            iterator = hashSet5.iterator();
            object5 = JaWEManager.getInstance().getXPDLUtils().getPoolForProcessOrActivitySet(this.getXPDLOwner()).getLanes();
            while (iterator.hasNext()) {
                object4 = (GraphSwimlaneInterface)iterator.next();
                XMLComplexElement xMLComplexElement = object4.getPropertyObject();
                if (!(xMLComplexElement instanceof Lane)) continue;
                object5.remove((XMLElement)((Lane)xMLComplexElement));
            }
            object4 = new ArrayList();
            object4.add(this.getXPDLOwner());
            ((JaWEController)object2).endUndouableChange((List)object4);
            ((GraphController)object3).setUpdateInProgress(false);
        }
    }

    public void moveParticipant(Object object, boolean bl) {
        GraphParticipantComparator graphParticipantComparator = new GraphParticipantComparator(this);
        System.out.println("MOVING PARTICIPANT1");
        if (!(object instanceof GraphSwimlaneInterface) || !(((GraphSwimlaneInterface)object).getPropertyObject() instanceof Lane)) {
            return;
        }
        GraphSwimlaneInterface graphSwimlaneInterface = (GraphSwimlaneInterface)object;
        Lane lane = (Lane)graphSwimlaneInterface.getPropertyObject();
        HashMap hashMap = new HashMap();
        JaWEParentMap jaWEParentMap = new JaWEParentMap();
        boolean bl2 = this.moveParticipant(graphSwimlaneInterface, bl, hashMap, jaWEParentMap);
        if (bl2) {
            Object object2;
            GraphParticipantComparator graphParticipantComparator2;
            this.getGraphController().setUpdateInProgress(true);
            this.graphModel().insertAndEdit(null, hashMap, null, jaWEParentMap, null);
            Pool pool = JaWEManager.getInstance().getXPDLUtils().getPoolForProcessOrActivitySet(this.getXPDLOwner());
            List list = JaWEGraphModel.getAllParticipantsInModel(this.graph.getModel());
            list.remove(this.getGraphParticipant(pool));
            if (list != null) {
                graphParticipantComparator2 = new GraphParticipantComparator(this);
                Collections.sort(list, graphParticipantComparator2);
            }
            JaWEManager.getInstance().getJaWEController().startUndouableChange();
            graphParticipantComparator2 = ((GraphSwimlaneInterface)((Object)graphSwimlaneInterface.getParent())).getPropertyObject();
            if (graphParticipantComparator2 instanceof Pool) {
                object2 = pool.getLanes();
                int n = object2.indexOf((XMLElement)lane);
                n = bl ? --n : ++n;
                object2.reposition((XMLElement)lane, n);
            } else {
                object2 = (Lane)graphParticipantComparator2;
                NestedLanes nestedLanes = object2.getNestedLanes();
                NestedLane nestedLane = nestedLanes.getNestedLane(lane.getId());
                int n = nestedLanes.indexOf((XMLElement)nestedLane);
                n = bl ? --n : ++n;
                nestedLanes.reposition((XMLElement)nestedLane, n);
            }
            object2 = new ArrayList();
            object2.add(lane);
            JaWEManager.getInstance().getJaWEController().endUndouableChange((List)object2);
            this.getGraphController().adjustActions();
            this.getGraphController().setUpdateInProgress(false);
        }
    }

    public void removeStartAndEndEvents() {
        XMLCollectionElement xMLCollectionElement = this.getXPDLOwner();
        Set set = XMLUtil.getStartingActivities((XMLCollectionElement)xMLCollectionElement);
        set.addAll(XMLUtil.getEndingActivities((XMLCollectionElement)xMLCollectionElement));
        ArrayList<Activity> arrayList = new ArrayList<Activity>();
        if (set.size() > 0) {
            Activity activity2;
            this.getGraphController().setUpdateInProgress(true);
            for (Activity activity2 : set) {
                if (activity2.getActivityType() != 6 && activity2.getActivityType() != 7) continue;
                this.removeActivityOrArtifact((XMLCollectionElement)activity2);
                if (arrayList.contains(activity2)) continue;
                arrayList.add(activity2);
            }
            JaWEManager.getInstance().getJaWEController().startUndouableChange();
            Iterator iterator = arrayList.iterator();
            activity2 = (Activities)xMLCollectionElement.get("Activities");
            while (iterator.hasNext()) {
                activity2.remove((XMLElement)((Activity)iterator.next()));
            }
            ArrayList<XMLCollectionElement> arrayList2 = new ArrayList<XMLCollectionElement>();
            arrayList2.add(xMLCollectionElement);
            JaWEManager.getInstance().getJaWEController().endUndouableChange(arrayList2);
            this.getGraphController().setUpdateInProgress(false);
        }
    }

    public void insertMissingStartAndEndEvents() {
        Point point;
        Activity activity;
        GraphActivityInterface graphActivityInterface;
        Set set;
        XMLCollectionElement xMLCollectionElement = this.getXPDLOwner();
        WorkflowProcess workflowProcess = this.getWorkflowProcess();
        String string = null;
        if (xMLCollectionElement instanceof ActivitySet) {
            string = xMLCollectionElement.getId();
        }
        GraphController graphController = this.getGraphController();
        Dimension dimension = new Dimension(graphController.getGraphSettings().getActivityWidth(), graphController.getGraphSettings().getActivityHeight());
        Set set2 = XMLUtil.getStartingActivities((XMLCollectionElement)xMLCollectionElement);
        Set set3 = XMLUtil.getEndingActivities((XMLCollectionElement)xMLCollectionElement);
        ArrayList arrayList = new ArrayList();
        Iterator iterator = set2.iterator();
        int n = graphController.getGraphSettings().getActivityHeight();
        int n2 = graphController.getGraphSettings().getActivityWidth();
        while (iterator.hasNext()) {
            Activity activity2 = (Activity)iterator.next();
            if (activity2.getActivityType() == 6 || activity2.getActivityType() == 7 || GraphManager.containsStartOrEndEvent(set = (graphActivityInterface = this.getGraphActivity(activity2)).getReferencingActivities(), true)) continue;
            activity = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject((Activities)xMLCollectionElement.get("Activities"), "ACTIVITY_START", true);
            point = GraphManager.getStartOrEndEventOffsetPointForInsertion(GraphUtilities.getOffsetPoint(activity2), true, dimension, this.isGraphRotated());
            point.x = (int)((double)point.x + ((double)n2 - 0.6 * (double)n) / 2.0);
            point.y += n / 5;
            GraphUtilities.createNodeGraphicsInfo((XMLCollectionElement)activity, point, JaWEManager.getInstance().getXPDLUtils().getLaneId((XMLCollectionElement)activity2), true);
            this.insertStartOrEndEvent(activity, activity2.getId());
        }
        for (Activity activity2 : set3) {
            if (activity2.getActivityType() == 6 || activity2.getActivityType() == 7 || GraphManager.containsStartOrEndEvent(set = (graphActivityInterface = this.getGraphActivity(activity2)).getReferencedActivities(), false) || XMLUtil.hasCircularTransitions((Set)XMLUtil.getNonExceptionalOutgoingTransitions((Activity)activity2))) continue;
            activity = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject((Activities)xMLCollectionElement.get("Activities"), "ACTIVITY_END", true);
            point = GraphManager.getStartOrEndEventOffsetPointForInsertion(GraphUtilities.getOffsetPoint(activity2), false, dimension, this.isGraphRotated());
            point.x = (int)((double)point.x + ((double)n2 - 0.6 * (double)n) / 2.0);
            point.y += n / 5;
            GraphUtilities.createNodeGraphicsInfo((XMLCollectionElement)activity, point, JaWEManager.getInstance().getXPDLUtils().getLaneId((XMLCollectionElement)activity2), true);
            this.insertStartOrEndEvent(activity, activity2.getId());
        }
    }

    protected static boolean containsStartOrEndEvent(Set set, boolean bl) {
        for (GraphActivityInterface graphActivityInterface : set) {
            Activity activity = (Activity)graphActivityInterface.getPropertyObject();
            if ((!bl || activity.getActivityType() != 6) && (bl || activity.getActivityType() != 7)) continue;
            return true;
        }
        return false;
    }

    protected static Point getStartOrEndEventOffsetPointForInsertion(Point point, boolean bl, Dimension dimension, boolean bl2) {
        Point point2 = new Point(point);
        if (bl) {
            if (!bl2) {
                point2.x = (int)((double)point2.x - (double)dimension.width * 1.5);
            } else {
                point2.y = (int)((double)point2.y - (double)dimension.height * 1.5);
            }
        } else if (!bl2) {
            point2.x = (int)((double)point2.x + (double)dimension.width * 1.5);
        } else {
            point2.y = (int)((double)point2.y + (double)dimension.height * 1.5);
        }
        if (!bl2) {
            if (point2.x < 0) {
                point2.x = 0;
            }
        } else if (point2.y < 0) {
            point2.y = 0;
        }
        return point2;
    }

    protected static List getAllChildParticipants(GraphSwimlaneInterface graphSwimlaneInterface) {
        ArrayList arrayList = new ArrayList();
        Set set = graphSwimlaneInterface.getChildSwimlanes();
        arrayList.addAll(set);
        for (GraphSwimlaneInterface graphSwimlaneInterface2 : set) {
            arrayList.addAll(graphSwimlaneInterface2.getChildSwimlanes());
        }
        return arrayList;
    }

    protected static GraphSwimlaneInterface getCommonParentParticipant(GraphSwimlaneInterface[] graphSwimlaneInterfaceArray, Object object) {
        if (graphSwimlaneInterfaceArray != null) {
            for (int i = 0; i < graphSwimlaneInterfaceArray.length; ++i) {
                if (graphSwimlaneInterfaceArray[i].getParent() != object) continue;
                return graphSwimlaneInterfaceArray[i];
            }
        }
        return null;
    }

    public void showArtifacts(boolean bl) {
        Set set = GraphUtilities.getArtifacts(this.getXPDLOwner());
        Set set2 = GraphUtilities.getAssociations(this.getXPDLOwner());
        for (Artifact artifact : set) {
            if (bl) {
                this.insertActivityOrArtifact((XMLCollectionElement)artifact);
                continue;
            }
            this.removeActivityOrArtifact((XMLCollectionElement)artifact);
        }
        for (Artifact artifact : set2) {
            if (bl) {
                this.insertTransitionOrAssociation((XMLCollectionElement)artifact);
                continue;
            }
            this.removeTransitionOrAssociation((XMLCollectionElement)artifact);
        }
    }
}

