/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.graph;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.components.graph.CommonExpressionParticipant;
import org.enhydra.jawe.components.graph.FreeTextExpressionParticipant;
import org.enhydra.jawe.components.graph.Graph;
import org.enhydra.jawe.components.graph.GraphActivityRendererInterface;
import org.enhydra.jawe.components.graph.GraphActivityViewInterface;
import org.enhydra.jawe.components.graph.GraphController;
import org.enhydra.jawe.components.graph.GraphManager;
import org.enhydra.jawe.components.graph.GraphMarqueeHandler;
import org.enhydra.jawe.components.graph.GraphPortInterface;
import org.enhydra.jawe.components.graph.GraphPortViewInterface;
import org.enhydra.jawe.components.graph.GraphSwimlaneInterface;
import org.enhydra.jawe.components.graph.GraphUtilities;
import org.enhydra.jawe.components.graph.JaWEGraphModel;
import org.enhydra.jawe.components.graph.WorkflowElement;
import org.enhydra.jxpdl.XMLCollectionElement;
import org.enhydra.jxpdl.XMLComplexElement;
import org.enhydra.jxpdl.XMLInterface;
import org.enhydra.jxpdl.XMLUtil;
import org.enhydra.jxpdl.elements.Activity;
import org.jgraph.JGraph;
import org.jgraph.event.GraphLayoutCacheEvent;
import org.jgraph.event.GraphLayoutCacheListener;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.plaf.basic.BasicGraphUI;

public class JaWEGraphUI
extends BasicGraphUI {
    public static final int SELECTION = 0;
    public static final int MULTIPLE_SELECTION = 1;
    public static final int INSERT_ELEMENT = 2;
    public static final int INSERT_PARTICIPANT = 3;
    public static final int INSERT_SPEC_ELEMENT = 4;
    public static final int INSERT_TRANSITION_START = 5;
    public static final int INSERT_TRANSITION_POINTS = 6;
    public static final int INSERT_ASSOCIATION_START = 7;
    public static final int INSERT_ASSOCIATION_POINTS = 8;
    protected int status;
    protected boolean aborted = false;
    protected boolean selectOnRelease = false;

    public Graph getGraph() {
        return (Graph)this.graph;
    }

    public GraphController getGraphController() {
        return ((GraphMarqueeHandler)this.marquee).getGraphController();
    }

    protected void paintBackground(Graphics graphics) {
        Rectangle rectangle = new Rectangle(0, 0, this.graph.getWidth(), this.graph.getHeight());
        if (this.graph.isGridVisible()) {
            this.paintGrid(this.graph.getGridSize(), graphics, rectangle);
        }
    }

    protected boolean startEditing(Object object, MouseEvent mouseEvent) {
        if (object instanceof WorkflowElement) {
            XMLComplexElement xMLComplexElement = ((WorkflowElement)object).getPropertyObject();
            if (xMLComplexElement instanceof FreeTextExpressionParticipant || xMLComplexElement instanceof CommonExpressionParticipant) {
                return true;
            }
            JaWEManager.getInstance().getJaWEController().getJaWEActions().getAction("EditProperties").actionPerformed(null);
            return true;
        }
        return false;
    }

    public void startEditingAtCell(JGraph jGraph, Object object) {
        if (object != null) {
            this.startEditing(object, null);
        }
    }

    protected MouseListener createMouseListener() {
        return new PEMouseHandler();
    }

    public CellHandle createHandle(GraphContext graphContext) {
        if (graphContext != null && !graphContext.isEmpty() && this.graph.isEnabled()) {
            return new PERootHandle(graphContext);
        }
        return null;
    }

    protected GraphLayoutCacheListener createGraphLayoutCacheListener() {
        return new PEGraphLayoutCacheHandler();
    }

    public void reset() {
        this.status = ((GraphMarqueeHandler)this.marquee).getStatus();
    }

    protected KeyListener createKeyListener() {
        return new PEKeyHandler();
    }

    public class PEKeyHandler
    extends KeyAdapter
    implements Serializable {
        protected Action repeatKeyAction;
        protected boolean isKeyDown;

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers());
            if (keyStroke.getKeyCode() == 27) {
                if (JaWEGraphUI.this.marquee != null) {
                    JaWEGraphUI.this.marquee.mouseReleased(null);
                }
                ((GraphMarqueeHandler)JaWEGraphUI.this.marquee).setSelectionMode();
                JaWEGraphUI.this.aborted = true;
            } else if (keyEvent.isControlDown() && keyStroke.getKeyCode() == 65) {
                keyEvent.consume();
                Graph graph = ((GraphMarqueeHandler)JaWEGraphUI.this.marquee).getGraph();
                List list = JaWEGraphModel.getAllCellsInModel(graph.getModel());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof GraphSwimlaneInterface) && !(e instanceof GraphPortInterface)) continue;
                    iterator.remove();
                }
                graph.clearSelection();
                graph.selectElements(list.toArray(), false, false);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    }

    public class PEGraphModelHandler
    implements GraphModelListener,
    Serializable {
        public void graphChanged(GraphModelEvent graphModelEvent) {
            int n;
            Object[] objectArray = graphModelEvent.getChange().getRemoved();
            if (objectArray != null && objectArray.length > 0) {
                for (int i = 0; i < objectArray.length && JaWEGraphUI.this.focus != null; ++i) {
                    if (objectArray[i] != JaWEGraphUI.this.focus.getCell()) continue;
                    JaWEGraphUI.this.focus = null;
                    break;
                }
                JaWEGraphUI.this.graph.getSelectionModel().removeSelectionCells(objectArray);
            }
            if (JaWEGraphUI.this.graphLayoutCache != null) {
                JaWEGraphUI.this.graphLayoutCache.graphChanged(graphModelEvent.getChange());
            }
            Object[] objectArray2 = graphModelEvent.getChange().getInserted();
            Object[] objectArray3 = graphModelEvent.getChange().getChanged();
            if (objectArray2 != null && objectArray2.length > 0) {
                JaWEGraphUI.this.focus = JaWEGraphUI.this.graphLayoutCache.getMapping(objectArray2[0], false);
                for (n = 0; n < objectArray2.length; ++n) {
                    JaWEGraphUI.this.graph.updateAutoSize(JaWEGraphUI.this.graphLayoutCache.getMapping(objectArray2[n], false));
                }
            }
            if (objectArray3 != null && objectArray3.length > 0) {
                for (n = 0; n < objectArray3.length; ++n) {
                    JaWEGraphUI.this.graph.updateAutoSize(JaWEGraphUI.this.graphLayoutCache.getMapping(objectArray3[n], false));
                }
            }
            if (!JaWEGraphUI.this.graphLayoutCache.isPartial() && JaWEGraphUI.this.graphLayoutCache.isSelectsAllInsertedCells() && JaWEGraphUI.this.graph.isEnabled()) {
                JaWEGraphUI.this.graph.setSelectionCells(objectArray2);
            }
            JaWEGraphUI.this.updateSize();
        }
    }

    public class PEGraphLayoutCacheHandler
    extends BasicGraphUI.GraphLayoutCacheHandler {
        public PEGraphLayoutCacheHandler() {
            super((BasicGraphUI)JaWEGraphUI.this);
        }

        public void graphLayoutCacheChanged(GraphLayoutCacheEvent graphLayoutCacheEvent) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = graphLayoutCacheEvent.getChange().getChanged();
            if (objectArray3 != null && objectArray3.length > 0) {
                for (int i = 0; i < objectArray3.length; ++i) {
                    JaWEGraphUI.this.graph.updateAutoSize(JaWEGraphUI.this.graphLayoutCache.getMapping(objectArray3[i], false));
                }
            }
            if ((objectArray2 = graphLayoutCacheEvent.getChange().getInserted()) != null && objectArray2.length > 0 && JaWEGraphUI.this.graphLayoutCache.isSelectsLocalInsertedCells() && (!JaWEGraphUI.this.graphLayoutCache.isSelectsAllInsertedCells() || JaWEGraphUI.this.graphLayoutCache.isPartial()) && JaWEGraphUI.this.graph.isEnabled() && (objectArray = DefaultGraphModel.getRoots((GraphModel)JaWEGraphUI.this.graphModel, (Object[])objectArray2)) != null && objectArray.length > 0) {
                JaWEGraphUI.this.focus = JaWEGraphUI.this.graphLayoutCache.getMapping(objectArray[0], false);
                JaWEGraphUI.this.graph.setSelectionCells(objectArray);
            }
            JaWEGraphUI.this.updateSize();
        }
    }

    public class PERootHandle
    extends BasicGraphUI.RootHandle {
        public PERootHandle(GraphContext graphContext) {
            super((BasicGraphUI)JaWEGraphUI.this, graphContext);
        }

        protected Point2D getInitialLocation(Object[] objectArray) {
            try {
                return super.getInitialLocation(objectArray);
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent != null && !mouseEvent.isConsumed()) {
                if (this.activeHandle != null) {
                    this.activeHandle.mouseReleased(mouseEvent);
                    this.activeHandle = null;
                } else if (this.isMoving && !mouseEvent.getPoint().equals(this.start)) {
                    Object object;
                    if (this.cachedBounds != null) {
                        int n = mouseEvent.getX() - (int)this.start.getX();
                        int n2 = mouseEvent.getY() - (int)this.start.getY();
                        object = JaWEGraphUI.this.graph.fromScreen((Point2D)new Point(n, n2));
                        GraphLayoutCache.translateViews((CellView[])this.views, (double)((Point2D)object).getX(), (double)((Point2D)object).getY());
                    }
                    if (GraphUtilities.getGraphController().getGraphSettings().shouldShowGrid() && (this.views[0] instanceof GraphActivityViewInterface || this.views[0] instanceof GraphActivityRendererInterface)) {
                        CellView cellView = this.views[0];
                        Rectangle2D rectangle2D = cellView.getBounds();
                        int n = 0;
                        int n3 = 0;
                        int n4 = GraphUtilities.getGraphController().getGraphSettings().getGridSize();
                        int n5 = (int)rectangle2D.getX() % n4;
                        int n6 = (int)rectangle2D.getY() % n4;
                        int n7 = n4 / 2;
                        n = n5 > n7 ? (n += n4 - n5) : (n -= n5);
                        n3 = n6 > n7 ? (n3 += n4 - n6) : (n3 -= n6);
                        Point2D point2D = JaWEGraphUI.this.graph.fromScreen((Point2D)new Point(n, n3));
                        GraphLayoutCache.translateViews((CellView[])this.views, (double)point2D.getX(), (double)point2D.getY());
                    }
                    Object[] objectArray = JaWEGraphUI.this.graphLayoutCache.getAllDescendants(this.views);
                    if (JaWEGraphUI.this.graph.isMoveable()) {
                        Map map = GraphConstants.createAttributes((Object[])objectArray, null);
                        object = JaWEGraphUI.this.getGraph().getGraphManager();
                        ((GraphManager)object).moveCellsAndArrangeParticipants(map);
                    }
                    mouseEvent.consume();
                }
            }
            this.start = null;
        }
    }

    public class PEMouseHandler
    extends BasicGraphUI.MouseHandler {
        public PEMouseHandler() {
            super((BasicGraphUI)JaWEGraphUI.this);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!JaWEGraphUI.this.graph.hasFocus()) {
                JaWEGraphUI.this.graph.requestFocus();
            }
            JaWEGraphUI.this.aborted = false;
            JaWEGraphUI.this.selectOnRelease = false;
            if (JaWEGraphUI.this.status == 0 && JaWEGraphUI.this.graph.isSelectionEnabled()) {
                int n = JaWEGraphUI.this.graph.getTolerance();
                Rectangle2D rectangle2D = JaWEGraphUI.this.graph.fromScreen((Rectangle2D)new Rectangle(mouseEvent.getX() - n, mouseEvent.getY() - n, 2 * n, 2 * n));
                JaWEGraphUI.this.focus = JaWEGraphUI.this.focus != null && JaWEGraphUI.this.focus.intersects(JaWEGraphUI.this.graph, rectangle2D) ? JaWEGraphUI.this.focus : null;
                Point2D point2D = JaWEGraphUI.this.graph.fromScreen((Point2D)new Point(mouseEvent.getPoint()));
                if (JaWEGraphUI.this.focus == null) {
                    this.cell = JaWEGraphUI.this.graph.getNextViewAt(JaWEGraphUI.this.focus, point2D.getX(), point2D.getY());
                    JaWEGraphUI.this.focus = this.cell;
                } else {
                    this.cell = JaWEGraphUI.this.focus;
                }
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    if (this.cell != null) {
                        if (!JaWEGraphUI.this.graph.isCellSelected(this.cell.getCell())) {
                            JaWEGraphUI.this.selectCellForEvent(this.cell.getCell(), mouseEvent);
                        }
                    } else {
                        JaWEGraphUI.this.graph.clearSelection();
                    }
                    ((GraphMarqueeHandler)JaWEGraphUI.this.marquee).popupMenu(mouseEvent.getPoint());
                } else if (this.cell != null) {
                    if (mouseEvent.getClickCount() == 2) {
                        JaWEGraphUI.this.startEditing(this.cell.getCell(), mouseEvent);
                    } else {
                        XMLComplexElement xMLComplexElement;
                        if (JaWEGraphUI.this.graph.isCellSelected(this.cell.getCell()) && !mouseEvent.isControlDown() && JaWEGraphUI.this.graph.getSelectionCells().length > 1) {
                            JaWEGraphUI.this.selectOnRelease = true;
                        } else if (!JaWEGraphUI.this.graph.isCellSelected(this.cell.getCell()) || mouseEvent.isControlDown()) {
                            JaWEGraphUI.this.selectCellForEvent(this.cell.getCell(), mouseEvent);
                        }
                        if (this.cell.getCell() instanceof WorkflowElement && (xMLComplexElement = ((WorkflowElement)this.cell.getCell()).getPropertyObject()) instanceof Activity) {
                            Point point;
                            Activity activity = (Activity)xMLComplexElement;
                            boolean bl = false;
                            if (activity.getActivityType() == 3 || activity.getActivityType() == 4) {
                                Rectangle rectangle;
                                point = mouseEvent.getPoint();
                                Graph graph = ((GraphMarqueeHandler)JaWEGraphUI.this.marquee).getGraph();
                                Rectangle rectangle2 = graph.getGraphManager().getCBounds(this.cell.getCell(), null);
                                Rectangle rectangle3 = new Rectangle((int)(rectangle2.getMinX() + rectangle2.getWidth() / 2.0 - 7.0), (int)(rectangle2.getMaxY() - 16.0), 15, 15);
                                if (SwingUtilities.isRectangleContainingRectangle(rectangle3, rectangle = new Rectangle(point))) {
                                    bl = true;
                                }
                            }
                            if (bl && activity.getActivityType() == 3) {
                                point = XMLUtil.getSubflowProcess((XMLInterface)JaWEManager.getInstance().getXPDLHandler(), (Activity)activity);
                                if (point != null) {
                                    JaWEGraphUI.this.getGraphController().selectGraphForElement((XMLCollectionElement)point);
                                }
                            } else if (bl && activity.getActivityType() == 4 && (point = XMLUtil.getBlockActivitySet((Activity)activity)) != null) {
                                JaWEGraphUI.this.getGraphController().selectGraphForElement((XMLCollectionElement)point);
                            }
                        }
                        if (JaWEGraphUI.this.handle != null) {
                            JaWEGraphUI.this.handle.mousePressed(mouseEvent);
                        }
                    }
                } else {
                    JaWEGraphUI.this.marquee.mousePressed(mouseEvent);
                    JaWEGraphUI.this.status = 1;
                }
            }
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                if (JaWEGraphUI.this.status == 6) {
                    JaWEGraphUI.this.status = 5;
                    ((GraphMarqueeHandler)JaWEGraphUI.this.marquee).reset();
                } else if (JaWEGraphUI.this.status == 8) {
                    JaWEGraphUI.this.status = 7;
                    ((GraphMarqueeHandler)JaWEGraphUI.this.marquee).reset();
                } else {
                    ((GraphMarqueeHandler)JaWEGraphUI.this.marquee).setSelectionMode();
                    JaWEGraphUI.this.status = 0;
                }
            } else if (JaWEGraphUI.this.graph.isEditable()) {
                if (JaWEGraphUI.this.status == 3) {
                    ((GraphMarqueeHandler)JaWEGraphUI.this.marquee).insertParticipant((Point)JaWEGraphUI.this.getGraph().fromScreen(mouseEvent.getPoint()));
                } else if (JaWEGraphUI.this.status == 4) {
                    ((GraphMarqueeHandler)JaWEGraphUI.this.marquee).insertSpecialElement();
                } else if (JaWEGraphUI.this.status == 2) {
                    ((GraphMarqueeHandler)JaWEGraphUI.this.marquee).insertElement((Point)JaWEGraphUI.this.getGraph().fromScreen(mouseEvent.getPoint()));
                } else if (JaWEGraphUI.this.status == 5) {
                    GraphPortViewInterface graphPortViewInterface = (GraphPortViewInterface)JaWEGraphUI.this.graph.getPortViewAt((double)mouseEvent.getX(), (double)mouseEvent.getY());
                    if (graphPortViewInterface != null && ((GraphMarqueeHandler)JaWEGraphUI.this.marquee).insertTransitionFirstPort(graphPortViewInterface)) {
                        JaWEGraphUI.this.status = 6;
                    }
                } else if (JaWEGraphUI.this.status == 7) {
                    GraphPortViewInterface graphPortViewInterface = (GraphPortViewInterface)JaWEGraphUI.this.graph.getPortViewAt((double)mouseEvent.getX(), (double)mouseEvent.getY());
                    if (graphPortViewInterface != null && ((GraphMarqueeHandler)JaWEGraphUI.this.marquee).insertTransitionFirstPort(graphPortViewInterface)) {
                        JaWEGraphUI.this.status = 8;
                    }
                } else if (JaWEGraphUI.this.status == 6) {
                    GraphPortViewInterface graphPortViewInterface = (GraphPortViewInterface)JaWEGraphUI.this.graph.getPortViewAt((double)mouseEvent.getX(), (double)mouseEvent.getY());
                    if (graphPortViewInterface == null) {
                        ((GraphMarqueeHandler)JaWEGraphUI.this.marquee).addPoint(mouseEvent.getPoint());
                        ((GraphMarqueeHandler)JaWEGraphUI.this.marquee).drawTransition(mouseEvent);
                    } else if (((GraphMarqueeHandler)JaWEGraphUI.this.marquee).insertTransitionSecondPort(graphPortViewInterface)) {
                        JaWEGraphUI.this.status = 5;
                        ((GraphMarqueeHandler)JaWEGraphUI.this.marquee).reset();
                    }
                } else if (JaWEGraphUI.this.status == 8) {
                    GraphPortViewInterface graphPortViewInterface = (GraphPortViewInterface)JaWEGraphUI.this.graph.getPortViewAt((double)mouseEvent.getX(), (double)mouseEvent.getY());
                    if (graphPortViewInterface == null) {
                        ((GraphMarqueeHandler)JaWEGraphUI.this.marquee).addPoint(mouseEvent.getPoint());
                        ((GraphMarqueeHandler)JaWEGraphUI.this.marquee).drawTransition(mouseEvent);
                    } else if (((GraphMarqueeHandler)JaWEGraphUI.this.marquee).insertTransitionSecondPort(graphPortViewInterface)) {
                        JaWEGraphUI.this.status = 7;
                        ((GraphMarqueeHandler)JaWEGraphUI.this.marquee).reset();
                    }
                }
            }
            mouseEvent.consume();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (JaWEGraphUI.this.status == 5 || JaWEGraphUI.this.status == 6 || JaWEGraphUI.this.status == 7 || JaWEGraphUI.this.status == 8) {
                ((GraphMarqueeHandler)JaWEGraphUI.this.marquee).drawTransition(mouseEvent);
            }
            mouseEvent.consume();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (JaWEGraphUI.this.status == 0 && !JaWEGraphUI.this.aborted) {
                Object[] objectArray = JaWEGraphUI.this.graph.getSelectionCells();
                if (objectArray != null) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (!(objectArray[i] instanceof GraphSwimlaneInterface)) continue;
                        mouseEvent.consume();
                        return;
                    }
                }
                JaWEGraphUI.this.selectOnRelease = false;
                BasicGraphUI.autoscroll((JGraph)JaWEGraphUI.this.graph, (Point)mouseEvent.getPoint());
                if (JaWEGraphUI.this.handle != null) {
                    JaWEGraphUI.this.handle.mouseDragged(mouseEvent);
                }
            } else if (JaWEGraphUI.this.status == 1 && !JaWEGraphUI.this.aborted) {
                JaWEGraphUI.this.marquee.mouseDragged(mouseEvent);
            }
            mouseEvent.consume();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (JaWEGraphUI.this.status == 0) {
                if (JaWEGraphUI.this.handle != null && !JaWEGraphUI.this.aborted) {
                    JaWEGraphUI.this.handle.mouseReleased(mouseEvent);
                }
                if (JaWEGraphUI.this.selectOnRelease) {
                    JaWEGraphUI.this.selectCellForEvent(this.cell.getCell(), mouseEvent);
                }
            } else if (JaWEGraphUI.this.status == 1 && JaWEGraphUI.this.graph.isSelectionEnabled() && !JaWEGraphUI.this.aborted) {
                JaWEGraphUI.this.marquee.mouseReleased(mouseEvent);
                JaWEGraphUI.this.status = 0;
            }
            mouseEvent.consume();
        }
    }
}

