/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.graph.actions;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.Serializable;
import javax.imageio.ImageIO;
import org.enhydra.jawe.ActionBase;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.components.graph.Graph;
import org.enhydra.jawe.components.graph.GraphController;
import org.enhydra.jxpdl.XMLElement;

public class SaveAsJPG
extends ActionBase {
    public SaveAsJPG(JaWEComponent jaWEComponent) {
        super(jaWEComponent);
    }

    @Override
    public void enableDisableAction() {
        GraphController graphController = (GraphController)this.jawecomponent;
        if (graphController.getSelectedGraph() != null) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string = JaWEManager.getInstance().getJaWEController().saveDialog(ResourceManager.getLanguageDependentString("SaveAsJPGLabel"), 1, JaWEManager.getInstance().getDisplayNameGenerator().getDisplayName((XMLElement)((GraphController)this.jawecomponent).getSelectedGraph().getXPDLObject()));
            if (string != null && string.length() > 0) {
                SaveAsJPG.saveGraphAsJPG(string, ((GraphController)this.jawecomponent).getSelectedGraph());
            }
        }
        catch (Exception exception) {
            String string = ResourceManager.getLanguageDependentString("ErrorJPGSavingFailed");
            JaWEManager.getInstance().getJaWEController().message(string, 2);
        }
    }

    public static void saveGraphAsJPG(String string, Graph graph) throws Exception {
        Serializable serializable;
        BufferedImage bufferedImage = null;
        Object[] objectArray = graph.getRoots();
        if (objectArray.length > 0) {
            serializable = graph.getCellBounds(objectArray).getBounds();
            graph.toScreen((Rectangle2D)((Object)serializable));
            Dimension dimension = ((Rectangle)serializable).getSize();
            bufferedImage = new BufferedImage(dimension.width, dimension.height, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graph.paint(graphics2D);
        }
        serializable = new File(string);
        ImageIO.write(bufferedImage, "JPEG", (File)serializable);
    }
}

