/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.ldap;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.enhydra.jawe.BarFactory;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEComponentView;
import org.enhydra.jawe.base.panel.panels.XMLRadioPanel;
import org.enhydra.jawe.base.panel.panels.XMLTextPanel;
import org.enhydra.jawe.components.ldap.LDAPController;
import org.enhydra.jawe.components.ldap.LDAPSettings;
import org.enhydra.jawe.components.ldap.LDAPTablePanel;
import org.enhydra.jxpdl.XMLAttribute;
import org.enhydra.jxpdl.XMLElement;

public class LDAPPanel
extends JPanel
implements JaWEComponentView {
    protected JToolBar toolbar;
    protected JPanel innerPanel = new JPanel();
    protected JLabel ldapInfo = new JLabel();
    protected LDAPTablePanel tablePanel;
    protected JScrollPane scrollPane;
    protected XMLRadioPanel objectFilterPanel;
    protected XMLTextPanel searchCriteria;
    protected LDAPController controller;

    public LDAPPanel(LDAPController lDAPController) {
        this.controller = lDAPController;
    }

    public void configure() {
        this.init();
    }

    public void init() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.toolbar = BarFactory.createToolbar((String)"defaultToolbar", (JaWEComponent)this.controller);
        this.toolbar.setFloatable(false);
        if (this.toolbar.getComponentCount() > 0) {
            this.add((Component)this.toolbar, "North");
        }
        XMLAttribute xMLAttribute = new XMLAttribute(null, "UniqueAttributeSearchCriteria", true);
        XMLAttribute xMLAttribute2 = new XMLAttribute(null, "ObjectClassFilter", true, ((LDAPSettings)this.controller.getSettings()).getLDAPObjectClassFilterChoices(), 0){

            public void setValue(String string) {
                if (!this.choices.contains(string)) {
                    this.choices.add(string);
                }
                this.value = string;
            }
        };
        xMLAttribute2.setValue(((LDAPSettings)this.controller.getSettings()).getLDAPObjectClassFilter());
        this.objectFilterPanel = new XMLRadioPanel(null, (XMLElement)xMLAttribute2, "", false, false, false, true);
        this.searchCriteria = new XMLTextPanel(null, (XMLElement)xMLAttribute, false, false, true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add((Component)this.searchCriteria);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add((Component)this.objectFilterPanel);
        this.tablePanel = new LDAPTablePanel(this.controller);
        this.innerPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)this.ldapInfo, "Center");
        String string = " 0 " + this.controller.getSettings().getLanguageDependentString("EntriesKey");
        this.ldapInfo.setText(string);
        this.innerPanel.add((Component)jPanel2, "North");
        this.innerPanel.add((Component)this.tablePanel, "Center");
        this.add((Component)this.innerPanel, "Center");
    }

    public String getSearchCriteria() {
        return this.searchCriteria.getText();
    }

    public String getSelectedObjectClass() {
        return (String)this.objectFilterPanel.getSelectedItem();
    }

    public boolean hasSelectedEntries() {
        return this.tablePanel.getTable().getSelectedRows().length > 0;
    }

    public int howManyEntries() {
        return this.tablePanel.getTable().getRowCount();
    }

    public List getSelectedEntries() {
        return this.tablePanel.getSelectedElements();
    }

    public List getAllEntries() {
        return this.tablePanel.getAllElements();
    }

    public void refreshPanel(List list) {
        this.tablePanel.cleanup();
        String string = " " + list.size() + " " + this.controller.getSettings().getLanguageDependentString("EntriesKey");
        this.ldapInfo.setText(string);
        this.tablePanel.fillTableContent(list);
    }

    public JaWEComponent getJaWEComponent() {
        return this.controller;
    }

    public JComponent getDisplay() {
        return this;
    }
}

