/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.ldap;

import java.awt.BorderLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.enhydra.jawe.components.ldap.LDAPController;
import org.enhydra.jawe.components.ldap.LDAPEntryInfo;
import org.enhydra.jawe.components.ldap.LDAPEntryInfoEditor;
import org.enhydra.jawe.components.ldap.LDAPSettings;
import org.enhydra.jawe.components.ldap.LDAPTableCellRenderer;
import org.enhydra.jxpdl.XMLElement;

public class LDAPTablePanel
extends JPanel {
    protected JTable allItems;
    protected Vector columnNames;
    protected LDAPController controller;
    protected Action editElementAction = new AbstractAction("EditProperties"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LDAPEntryInfo lDAPEntryInfo;
            List list = LDAPTablePanel.this.getSelectedElements();
            if (list.size() > 0 && (lDAPEntryInfo = (LDAPEntryInfo)((Object)LDAPTablePanel.this.getSelectedElements().get(0))) != null) {
                new LDAPEntryInfoEditor(lDAPEntryInfo);
            }
        }
    };

    public LDAPTablePanel(LDAPController lDAPController) {
        this.controller = lDAPController;
        this.setLayout(new BorderLayout());
        this.columnNames = this.getColumnNames();
        this.allItems = this.createTable();
        this.setupTable();
        this.add(this.createScrollPane());
    }

    public JTable getTable() {
        return this.allItems;
    }

    public List getSelectedElements() {
        ArrayList<LDAPEntryInfo> arrayList = new ArrayList<LDAPEntryInfo>();
        int[] nArray = this.allItems.getSelectedRows();
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                arrayList.add((LDAPEntryInfo)((Object)this.allItems.getValueAt(nArray[i], 0)));
            }
        }
        return arrayList;
    }

    public List getAllElements() {
        ArrayList<LDAPEntryInfo> arrayList = new ArrayList<LDAPEntryInfo>();
        for (int i = 0; i < this.allItems.getRowCount(); ++i) {
            arrayList.add((LDAPEntryInfo)((Object)this.allItems.getValueAt(i, 0)));
        }
        return arrayList;
    }

    public boolean setSelectedElement(Object object) {
        try {
            int n = this.allItems.getRowCount();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    if (object != this.allItems.getValueAt(i, 0)) continue;
                    this.allItems.setRowSelectionInterval(i, i);
                    JViewport jViewport = (JViewport)this.allItems.getParent();
                    Rectangle rectangle = this.allItems.getCellRect(i, 0, true);
                    Point point = jViewport.getViewPosition();
                    rectangle.setLocation(rectangle.x - point.x, rectangle.y - point.y);
                    jViewport.scrollRectToVisible(rectangle);
                    this.scrollRectToVisible(rectangle);
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void addRow(LDAPEntryInfo lDAPEntryInfo) {
        int n = this.allItems.getRowCount();
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.allItems.getModel();
        Vector vector = this.getRow(lDAPEntryInfo);
        defaultTableModel.insertRow(n, vector);
    }

    public void removeRow(int n) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.allItems.getModel();
        defaultTableModel.removeRow(n);
    }

    public void updateRow(int n) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.allItems.getModel();
        LDAPEntryInfo lDAPEntryInfo = (LDAPEntryInfo)((Object)defaultTableModel.getValueAt(n, 0));
        for (int i = 0; i < lDAPEntryInfo.toElements().size(); ++i) {
            defaultTableModel.setValueAt(lDAPEntryInfo.get(i).toValue(), n, i + 1);
        }
    }

    protected JTable createTable() {
        return new JTable(new Vector(), this.columnNames){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                int n3 = this.convertColumnIndexToModel(n2);
                DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
                String string = null;
                try {
                    string = defaultTableModel.getValueAt(n, n3).toString();
                }
                catch (Exception exception) {
                    string = super.getToolTipText(mouseEvent);
                }
                return string;
            }
        };
    }

    protected void setupTable() {
        TableColumn tableColumn = this.allItems.getColumnModel().getColumn(0);
        tableColumn.setMinWidth(0);
        tableColumn.setMaxWidth(0);
        tableColumn.setPreferredWidth(0);
        tableColumn.setResizable(false);
        tableColumn = this.allItems.getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(new LDAPTableCellRenderer());
        tableColumn.setMinWidth(20);
        tableColumn.setMaxWidth(20);
        tableColumn.setPreferredWidth(20);
        tableColumn.setResizable(false);
        this.allItems.setColumnSelectionAllowed(false);
        this.allItems.setRowSelectionAllowed(true);
        this.allItems.setSelectionMode(2);
        this.allItems.getTableHeader().setReorderingAllowed(false);
        this.allItems.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    LDAPTablePanel.this.editElementAction.actionPerformed(null);
                }
            }
        });
        this.allItems.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0, false), "edit");
        this.allItems.getActionMap().put("edit", this.editElementAction);
    }

    protected Vector getColumnNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("Object");
        vector.add("");
        vector.add(this.controller.getSettings().getLanguageDependentString("IdKey"));
        vector.add(this.controller.getSettings().getLanguageDependentString("NameKey"));
        vector.add(this.controller.getSettings().getLanguageDependentString("DescriptionKey"));
        return vector;
    }

    public void fillTableContent(List list) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.allItems.getModel();
        for (LDAPEntryInfo lDAPEntryInfo : list) {
            Vector vector = this.getRow(lDAPEntryInfo);
            defaultTableModel.addRow(vector);
        }
    }

    protected Vector getRow(LDAPEntryInfo lDAPEntryInfo) {
        Vector<Object> vector = new Vector<Object>();
        vector.add((Object)lDAPEntryInfo);
        if (lDAPEntryInfo.getType().equals("HUMAN")) {
            vector.add(((LDAPSettings)this.controller.getSettings()).getUserIcon());
        } else if (lDAPEntryInfo.getType().equals("ORGANIZATIONAL_UNIT")) {
            vector.add(((LDAPSettings)this.controller.getSettings()).getGroupIcon());
        } else {
            vector.add(((LDAPSettings)this.controller.getSettings()).getRoleIcon());
        }
        vector.add(lDAPEntryInfo.getId());
        vector.add(lDAPEntryInfo.getName());
        vector.add(lDAPEntryInfo.getDescription());
        return vector;
    }

    protected JScrollPane createScrollPane() {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setViewportView(this.allItems);
        return jScrollPane;
    }

    protected int getElementRow(XMLElement xMLElement) {
        int n = -1;
        for (int i = 0; i < this.allItems.getRowCount(); ++i) {
            XMLElement xMLElement2 = (XMLElement)this.allItems.getValueAt(i, 0);
            if (xMLElement != xMLElement2) continue;
            n = i;
            break;
        }
        return n;
    }

    public void cleanup() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.allItems.getModel();
        for (int i = defaultTableModel.getRowCount() - 1; i >= 0; --i) {
            defaultTableModel.removeRow(i);
        }
    }
}

