/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jxpdl.elements;

import java.util.ArrayList;
import java.util.Collection;
import org.enhydra.jxpdl.XMLAttribute;
import org.enhydra.jxpdl.XMLComplexElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLElementChangeInfo;
import org.enhydra.jxpdl.elements.Activity;
import org.enhydra.jxpdl.elements.ActivitySet;
import org.enhydra.jxpdl.elements.Application;
import org.enhydra.jxpdl.elements.Applications;
import org.enhydra.jxpdl.elements.Artifact;
import org.enhydra.jxpdl.elements.Artifacts;
import org.enhydra.jxpdl.elements.Association;
import org.enhydra.jxpdl.elements.Associations;
import org.enhydra.jxpdl.elements.ConformanceClass;
import org.enhydra.jxpdl.elements.DataField;
import org.enhydra.jxpdl.elements.DataFields;
import org.enhydra.jxpdl.elements.ExtendedAttributes;
import org.enhydra.jxpdl.elements.ExternalPackage;
import org.enhydra.jxpdl.elements.ExternalPackages;
import org.enhydra.jxpdl.elements.Namespaces;
import org.enhydra.jxpdl.elements.PackageHeader;
import org.enhydra.jxpdl.elements.Participant;
import org.enhydra.jxpdl.elements.Participants;
import org.enhydra.jxpdl.elements.Pool;
import org.enhydra.jxpdl.elements.Pools;
import org.enhydra.jxpdl.elements.RedefinableHeader;
import org.enhydra.jxpdl.elements.Script;
import org.enhydra.jxpdl.elements.TypeDeclaration;
import org.enhydra.jxpdl.elements.TypeDeclarations;
import org.enhydra.jxpdl.elements.WorkflowProcess;
import org.enhydra.jxpdl.elements.WorkflowProcesses;
import org.enhydra.jxpdl.utilities.SequencedHashMap;

public class Package
extends XMLComplexElement {
    protected Namespaces namespaces;
    protected String internalVersion = "-1";
    protected boolean isTransient = false;
    protected SequencedHashMap extPkgRefsToIds = new SequencedHashMap();

    public Package() {
        super(null, true);
        this.namespaces = new Namespaces(this);
    }

    @Override
    public void makeAs(XMLElement xMLElement) {
        super.makeAs(xMLElement);
        this.namespaces.makeAs(((Package)xMLElement).namespaces);
        this.extPkgRefsToIds = new SequencedHashMap(((Package)xMLElement).extPkgRefsToIds);
        this.isTransient = ((Package)xMLElement).isTransient;
    }

    @Override
    protected void fillStructure() {
        XMLAttribute xMLAttribute = new XMLAttribute((XMLElement)this, "Id", true);
        XMLAttribute xMLAttribute2 = new XMLAttribute((XMLElement)this, "Name", false);
        PackageHeader packageHeader = new PackageHeader(this);
        RedefinableHeader redefinableHeader = new RedefinableHeader(this);
        ConformanceClass conformanceClass = new ConformanceClass(this);
        Script script = new Script(this);
        ExternalPackages externalPackages = new ExternalPackages(this);
        TypeDeclarations typeDeclarations = new TypeDeclarations(this);
        Participants participants = new Participants(this);
        Applications applications = new Applications(this);
        DataFields dataFields = new DataFields(this);
        Pools pools = new Pools(this);
        Associations associations = new Associations(this);
        Artifacts artifacts = new Artifacts(this);
        WorkflowProcesses workflowProcesses = new WorkflowProcesses(this);
        ExtendedAttributes extendedAttributes = new ExtendedAttributes(this);
        this.add(xMLAttribute);
        this.add(xMLAttribute2);
        this.add(packageHeader);
        this.add(redefinableHeader);
        this.add(conformanceClass);
        this.add(script);
        this.add(externalPackages);
        this.add(typeDeclarations);
        this.add(participants);
        this.add(applications);
        this.add(dataFields);
        this.add(pools);
        this.add(associations);
        this.add(artifacts);
        this.add(workflowProcesses);
        this.add(extendedAttributes);
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean bl) {
        this.isTransient = bl;
    }

    public String getInternalVersion() {
        return this.internalVersion;
    }

    public void setInternalVersion(String string) {
        this.internalVersion = string;
    }

    public void addExternalPackageMapping(String string, String string2) {
        this.extPkgRefsToIds.put(string, string2);
    }

    public void removeExternalPackageMapping(String string) {
        this.extPkgRefsToIds.remove(string);
    }

    public String getExternalPackageId(String string) {
        return (String)this.extPkgRefsToIds.get(string);
    }

    public Collection getExternalPackageIds() {
        return new ArrayList(this.extPkgRefsToIds.values());
    }

    public ExternalPackage getExternalPackage(String string) {
        ExternalPackage externalPackage = null;
        for (ExternalPackage externalPackage2 : this.getExternalPackages().toElements()) {
            String string2 = externalPackage2.getId();
            if (string2.equals("")) {
                String string3 = externalPackage2.getHref();
                string2 = this.getExternalPackageId(string3);
            }
            if (string2 == null || !string2.equals(string)) continue;
            externalPackage = externalPackage2;
            break;
        }
        return externalPackage;
    }

    public Artifact getArtifact(String string) {
        return this.getArtifacts().getArtifact(string);
    }

    public Association getAssociation(String string) {
        return this.getAssociations().getAssociation(string);
    }

    public Pool getPool(String string) {
        return this.getPools().getPool(string);
    }

    public WorkflowProcess getWorkflowProcess(String string) {
        return this.getWorkflowProcesses().getWorkflowProcess(string);
    }

    public ActivitySet getActivitySet(String string) {
        for (WorkflowProcess workflowProcess : this.getWorkflowProcesses().toElements()) {
            ActivitySet activitySet = workflowProcess.getActivitySet(string);
            if (activitySet == null) continue;
            return activitySet;
        }
        return null;
    }

    public Activity getActivity(String string) {
        for (WorkflowProcess workflowProcess : this.getWorkflowProcesses().toElements()) {
            Activity activity = workflowProcess.getActivity(string);
            if (activity == null) continue;
            return activity;
        }
        return null;
    }

    public Application getApplication(String string) {
        return this.getApplications().getApplication(string);
    }

    public Participant getParticipant(String string) {
        return this.getParticipants().getParticipant(string);
    }

    public DataField getDataField(String string) {
        return this.getDataFields().getDataField(string);
    }

    public TypeDeclaration getTypeDeclaration(String string) {
        return this.getTypeDeclarations().getTypeDeclaration(string);
    }

    public String getId() {
        return this.get("Id").toValue();
    }

    public void setId(String string) {
        this.set("Id", string);
    }

    public String getName() {
        return this.get("Name").toValue();
    }

    public void setName(String string) {
        this.set("Name", string);
    }

    public Applications getApplications() {
        return (Applications)this.get("Applications");
    }

    public ConformanceClass getConformanceClass() {
        return (ConformanceClass)this.get("ConformanceClass");
    }

    public DataFields getDataFields() {
        return (DataFields)this.get("DataFields");
    }

    public ExtendedAttributes getExtendedAttributes() {
        return (ExtendedAttributes)this.get("ExtendedAttributes");
    }

    public ExternalPackages getExternalPackages() {
        return (ExternalPackages)this.get("ExternalPackages");
    }

    public PackageHeader getPackageHeader() {
        return (PackageHeader)this.get("PackageHeader");
    }

    public Participants getParticipants() {
        return (Participants)this.get("Participants");
    }

    public RedefinableHeader getRedefinableHeader() {
        return (RedefinableHeader)this.get("RedefinableHeader");
    }

    public Script getScript() {
        return (Script)this.get("Script");
    }

    public TypeDeclarations getTypeDeclarations() {
        return (TypeDeclarations)this.get("TypeDeclarations");
    }

    public Associations getAssociations() {
        return (Associations)this.get("Associations");
    }

    public Artifacts getArtifacts() {
        return (Artifacts)this.get("Artifacts");
    }

    public WorkflowProcesses getWorkflowProcesses() {
        return (WorkflowProcesses)this.get("WorkflowProcesses");
    }

    public Pools getPools() {
        return (Pools)this.get("Pools");
    }

    public Namespaces getNamespaces() {
        return this.namespaces;
    }

    @Override
    public void setNotifyMainListeners(boolean bl) {
        super.setNotifyMainListeners(bl);
        this.namespaces.setNotifyMainListeners(bl);
    }

    @Override
    public void removeXPDL1Support() {
        super.removeXPDL1Support();
        this.namespaces.removeXPDL1Support();
    }

    @Override
    public void setReadOnly(boolean bl) {
        super.setReadOnly(bl);
        this.namespaces.setReadOnly(bl);
    }

    @Override
    public Object clone() {
        Package package_ = (Package)super.clone();
        package_.namespaces = (Namespaces)this.namespaces.clone();
        package_.namespaces.setParent(package_);
        package_.extPkgRefsToIds = new SequencedHashMap(this.extPkgRefsToIds);
        package_.isTransient = this.isTransient;
        package_.clearCaches();
        return package_;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = super.equals(object);
        if (bl) {
            Package package_ = (Package)object;
            bl = this.namespaces.equals(package_.namespaces) && this.internalVersion.equals(package_.internalVersion);
        }
        return bl;
    }

    @Override
    protected boolean isMainElement() {
        return true;
    }

    @Override
    protected void notifyMainListeners(XMLElementChangeInfo xMLElementChangeInfo) {
        if (this.parent == null) {
            return;
        }
        super.notifyMainListeners(xMLElementChangeInfo);
    }
}

