/*
 * Decompiled with CFR 0.152.
 */
package com.textflex.jarajar.common;

import com.textflex.jarajar.packager.Packager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JTextField;

public class FileOpenAction
extends AbstractAction {
    private JFrame owner;
    private Object textFld = null;
    private int fileSelectionMode = 0;
    private boolean multi = false;
    private static JFileChooser chooser = new JFileChooser();

    public FileOpenAction(JFrame jFrame, String string, Icon icon, Object object) {
        this.owner = jFrame;
        this.putValue("Name", string);
        this.putValue("SmallIcon", icon);
        this.textFld = object;
    }

    public FileOpenAction(JFrame jFrame, String string, Icon icon, Object object, int n, boolean bl) {
        this(jFrame, string, icon, object);
        if (n != -1) {
            this.fileSelectionMode = n;
        }
        this.multi = bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        chooser.setFileSelectionMode(this.fileSelectionMode);
        if (this.multi) {
            chooser.setMultiSelectionEnabled(true);
        }
        if ((n = chooser.showDialog(this.owner, "Location")) == 0) {
            try {
                if (this.textFld instanceof JTextField) {
                    int n2;
                    JTextField jTextField = (JTextField)this.textFld;
                    String string = chooser.getSelectedFile().getCanonicalPath();
                    File file = new File(string);
                    if (!file.exists() && (n2 = string.lastIndexOf(File.separator)) != -1) {
                        string = string.substring(0, n2);
                    }
                    jTextField.setText(string);
                } else if (this.textFld instanceof DefaultListModel) {
                    DefaultListModel defaultListModel = (DefaultListModel)this.textFld;
                    File[] fileArray = chooser.getSelectedFiles();
                    int n3 = fileArray.length;
                    for (int i = 0; i < n3; ++i) {
                        defaultListModel.addElement(fileArray[i].getCanonicalPath());
                    }
                } else if (this.owner instanceof Packager) {
                    Packager packager = (Packager)this.owner;
                    packager.loadBuildFile(chooser.getSelectedFile());
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void setChooserDirectory(String string) {
        File file = new File(string);
        if (file.exists()) {
            chooser.setCurrentDirectory(file);
        }
    }
}

