/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bufferset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.bufferset.BufferSetListener;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class BufferSet {
    private final List<Buffer> buffers;
    private final EventListenerList listeners;
    private static final Comparator<Buffer> nameSorter = new NameSorter();
    private static final Comparator<Buffer> pathSorter = new PathSorter();
    private Comparator<Buffer> sorter;

    public BufferSet(BufferSet source) {
        this.buffers = source == null ? Collections.synchronizedList(new ArrayList()) : Collections.synchronizedList(new ArrayList<Buffer>(source.buffers));
        this.listeners = new EventListenerList();
        if (jEdit.getBooleanProperty("sortBuffers")) {
            this.sorter = jEdit.getBooleanProperty("sortByName") ? nameSorter : pathSorter;
        }
    }

    public void addBuffer(Buffer buffer) {
        this.addBufferAt(buffer, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBufferAt(Buffer buffer, int position) {
        Log.log(1, this, this.hashCode() + " addBufferAt(" + buffer + ',' + position + ')');
        Buffer untitledBuffer = null;
        List<Buffer> list = this.buffers;
        synchronized (list) {
            Buffer buf;
            if (this.buffers.size() == 1 && (buf = this.buffers.get(0)).isUntitled() && !buf.isDirty()) {
                untitledBuffer = buf;
            }
            if (this.sorter != null) {
                if (this.buffers.contains(buffer)) {
                    return;
                }
                this.buffers.add(buffer);
                Collections.sort(this.buffers, this.sorter);
                position = this.buffers.indexOf(buffer);
            } else {
                int oldPos = this.buffers.indexOf(buffer);
                if (oldPos != -1) {
                    if (position == -1) {
                        return;
                    }
                    this.moveBuffer(oldPos, position);
                    return;
                }
                int size = this.buffers.size();
                if (position == -1 || position > size) {
                    position = size;
                }
                this.buffers.add(position, buffer);
            }
        }
        BufferSetListener[] listeners = (BufferSetListener[])this.listeners.getListeners(BufferSetListener.class);
        Log.log(1, this, this.hashCode() + ": Buffer added " + buffer + " at " + position);
        for (BufferSetListener listener : listeners) {
            listener.bufferAdded(buffer, position);
        }
        if (untitledBuffer != null) {
            jEdit.getBufferSetManager().removeBuffer(this, untitledBuffer);
        }
    }

    public Buffer getBuffer(int index) {
        return this.buffers.get(index);
    }

    public Buffer getPreviousBuffer(int index) {
        if (this.buffers.isEmpty()) {
            return null;
        }
        if (this.buffers.size() < 2) {
            return this.buffers.get(0);
        }
        if (index <= 0) {
            return this.buffers.get(this.buffers.size() - 1);
        }
        return this.buffers.get(index - 1);
    }

    public Buffer getNextBuffer(int index) {
        if (this.buffers.isEmpty()) {
            return null;
        }
        if (this.buffers.size() < 2) {
            return this.buffers.get(this.buffers.size() - 1);
        }
        if (index >= this.buffers.size() - 1) {
            return this.buffers.get(0);
        }
        return this.buffers.get(index + 1);
    }

    public int indexOf(Buffer buffer) {
        return this.buffers.indexOf(buffer);
    }

    public int size() {
        return this.buffers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAllBuffers(BufferSetListener listener) {
        List<Buffer> list = this.buffers;
        synchronized (list) {
            for (int i = 0; i < this.buffers.size(); ++i) {
                Buffer buffer = this.buffers.get(i);
                Log.log(1, this, this.hashCode() + ": Buffer added " + buffer + " at " + i);
                listener.bufferAdded(buffer, i);
            }
        }
    }

    public Buffer[] getAllBuffers() {
        Buffer[] buffers = new Buffer[this.buffers.size()];
        return this.buffers.toArray(buffers);
    }

    public void addBufferSetListener(BufferSetListener listener) {
        Log.log(1, this, this.hashCode() + ": addBufferSetListener " + listener);
        this.listeners.add(BufferSetListener.class, listener);
    }

    public void removeBufferSetListener(BufferSetListener listener) {
        Log.log(1, this, this.hashCode() + ": removeBufferSetListener " + listener);
        this.listeners.remove(BufferSetListener.class, listener);
    }

    public String toString() {
        return "BufferSet[nbBuffers=" + this.size() + ']';
    }

    public void sort() {
        BufferSetListener[] listeners;
        if (this.sorter == null) {
            return;
        }
        Collections.sort(this.buffers, this.sorter);
        for (BufferSetListener listener : listeners = (BufferSetListener[])this.listeners.getListeners(BufferSetListener.class)) {
            listener.bufferSetSorted();
        }
    }

    void propertiesChanged() {
        if (jEdit.getBooleanProperty("sortBuffers")) {
            this.sorter = jEdit.getBooleanProperty("sortByName") ? nameSorter : pathSorter;
            this.sort();
        } else {
            this.sorter = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveBuffer(int oldPosition, int newPosition) {
        Buffer buffer;
        if (this.sorter != null) {
            return;
        }
        List<Buffer> list = this.buffers;
        synchronized (list) {
            buffer = this.buffers.remove(oldPosition);
            int size = this.buffers.size();
            if (newPosition == -1 || newPosition > size) {
                newPosition = size;
            }
            this.buffers.add(newPosition, buffer);
        }
        BufferSetListener[] listeners = (BufferSetListener[])this.listeners.getListeners(BufferSetListener.class);
        Log.log(1, this, this.hashCode() + ": Buffer moved " + buffer + " from " + oldPosition + " to " + newPosition);
        for (BufferSetListener listener : listeners) {
            listener.bufferMoved(buffer, oldPosition, newPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBuffer(Buffer buffer) {
        int index;
        List<Buffer> list = this.buffers;
        synchronized (list) {
            index = this.buffers.indexOf(buffer);
            if (index == -1) {
                return;
            }
            this.buffers.remove(index);
        }
        BufferSetListener[] listeners = (BufferSetListener[])this.listeners.getListeners(BufferSetListener.class);
        Log.log(1, this, this.hashCode() + ": Buffer removed " + buffer);
        for (BufferSetListener listener : listeners) {
            listener.bufferRemoved(buffer, index);
        }
    }

    private static class PathSorter
    implements Comparator<Buffer> {
        private PathSorter() {
        }

        @Override
        public int compare(Buffer o1, Buffer o2) {
            return StandardUtilities.compareStrings(o1.getPath(), o2.getPath(), true);
        }
    }

    private static class NameSorter
    implements Comparator<Buffer> {
        private NameSorter() {
        }

        @Override
        public int compare(Buffer o1, Buffer o2) {
            int ret = StandardUtilities.compareStrings(o1.getName(), o2.getName(), true);
            if (ret == 0) {
                ret = StandardUtilities.compareStrings(o1.getPath(), o2.getPath(), true);
            }
            return ret;
        }
    }

    public static enum Scope {
        editpane,
        view,
        global;

    }
}

