/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Dialog;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.FontSelectorDialog;
import org.gjt.sp.jedit.jEdit;

public class FontSelector
extends JButton {
    private boolean antiAlias;

    public FontSelector(Font font) {
        this(font, false);
    }

    public FontSelector(Font font, boolean antiAlias) {
        this.setFont(font);
        this.antiAlias = antiAlias;
        this.updateText();
        this.setRequestFocusEnabled(false);
        this.addActionListener(new ActionHandler());
    }

    @Override
    public void paintComponent(Graphics g) {
        this.setAntiAliasEnabled(g);
        super.paintComponent(g);
    }

    public boolean isAntiAliasEnabled() {
        return this.antiAlias;
    }

    public void setAntiAliasEnabled(boolean antiAlias) {
        this.antiAlias = antiAlias;
    }

    private void updateText() {
        String styleString;
        Font font = this.getFont();
        switch (font.getStyle()) {
            case 0: {
                styleString = jEdit.getProperty("font-selector.plain");
                break;
            }
            case 1: {
                styleString = jEdit.getProperty("font-selector.bold");
                break;
            }
            case 2: {
                styleString = jEdit.getProperty("font-selector.italic");
                break;
            }
            case 3: {
                styleString = jEdit.getProperty("font-selector.bolditalic");
                break;
            }
            default: {
                styleString = "UNKNOWN!!!???";
            }
        }
        this.setText(font.getName() + ' ' + font.getSize() + ' ' + styleString);
    }

    void setAntiAliasEnabled(Graphics g) {
        if (this.antiAlias) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JDialog dialog = GUIUtilities.getParentDialog(FontSelector.this);
            Font font = dialog == null ? new FontSelectorDialog(JOptionPane.getFrameForComponent(FontSelector.this), FontSelector.this.getFont(), FontSelector.this).getSelectedFont() : new FontSelectorDialog((Dialog)dialog, FontSelector.this.getFont(), FontSelector.this).getSelectedFont();
            if (font != null) {
                FontSelector.this.setFont(font);
                FontSelector.this.updateText();
            }
        }
    }
}

